/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget.fps;

import android.annotation.TargetApi;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.net.TrafficStats;
import android.os.Build;
import android.os.Environment;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.RadioGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.plugin.pluginunionmain.R;
import com.yy.mobile.util.CommonUtils;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.SafeDispatchHandler;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.TelephonyUtils;
import com.yy.mobile.util.VersionUtil;
import com.yy.mobile.util.asynctask.ScheduledTask;
import com.yy.mobile.util.log.MLog;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.lang.ref.SoftReference;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

public class FpsView
extends LinearLayout {
    static final byte[] lock = new byte[0];
    public static long endTime;
    public static String testScene;
    public static SoftReference<FpsView> instance;
    private static boolean isBatteryReveiver;
    public float mTouchStartX;
    public float mTouchStartY;
    public float x;
    public float y;
    private Paint p;
    private int w = 0;
    private int h = 0;
    private float currCpu;
    private float currMem;
    private float maxCpu;
    private float maxMem;
    private ArrayList<Float> cpuArray;
    private ArrayList<Float> memArray;
    private int max = 30;
    private Path path;
    private Path pathFill;
    private TextView tf;
    public SafeDispatchHandler handler = new SafeDispatchHandler(Looper.getMainLooper());
    private File testData;
    private String testVersion = "V1";
    public int batteryLevel = 0;
    public double batteryCapacity = 0.0;
    private String fileName = "perTest";
    private String fileAppend = ".txt";
    private String tempPath;
    private int pid;
    private String packageName = "com.duowan.mobile";
    private WindowManager wm = (WindowManager)this.getContext().getApplicationContext().getSystemService("window");
    private WindowManager.LayoutParams wmParams = new WindowManager.LayoutParams();
    private File file;
    private HandlerThread mDrawLineThread;
    public Handler mDrawLineHandler;
    public Runnable getLineDataRunnable = new Runnable(){

        @Override
        public void run() {
            FpsView.this.drawLine();
            FpsView.this.mDrawLineHandler.postDelayed(FpsView.this.getLineDataRunnable, 1000L);
        }
    };
    public Runnable setTextRunnable = new Runnable(){

        @Override
        public void run() {
            if (Looper.myLooper() == Looper.getMainLooper()) {
                FpsView.this.setText();
            }
        }
    };
    public Runnable drawLineRunnable = new Runnable(){

        @Override
        public void run() {
            if (Looper.myLooper() == Looper.getMainLooper()) {
                FpsView.this.handler.removeCallbacks(FpsView.this.setTextRunnable);
                FpsView.this.handler.post(FpsView.this.setTextRunnable);
                FpsView.this.postInvalidate();
            }
            FpsView.this.handler.postDelayed(FpsView.this.drawLineRunnable, 1100L);
        }
    };
    public Runnable showFPSRunable = new Runnable(){

        @Override
        public void run() {
            FpsView.this.setVisibility(0);
        }
    };
    private BroadcastReceiver batteryReveiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action;
            if (intent != null && "android.intent.action.BATTERY_CHANGED".equals(action = intent.getAction())) {
                FpsView.this.batteryLevel = intent.getIntExtra("level", 0);
            }
        }
    };
    public Runnable beginTestRunnable = new Runnable(){

        @Override
        public void run() {
            float cpu = FpsView.this.getCpuUsage();
            float mem = (float)FpsView.this.getUsedMemorySize() / 1048576.0f;
            float[] kBytes = FpsView.this.getStreamBytes();
            String temperature = FpsView.this.getTemperature();
            double power = (double)FpsView.this.batteryLevel * FpsView.this.batteryCapacity / 100.0;
            FpsView.this.writeToUpLoadFile(String.format("%.1f", Float.valueOf(cpu)), String.format("%.1f", Float.valueOf(mem)), String.format("%.1f", Float.valueOf(kBytes[0])), String.format("%.1f", Float.valueOf(kBytes[1])), temperature, String.format("%.1f", power));
            long curTime = System.currentTimeMillis();
            if (curTime < endTime) {
                FpsView.this.mDrawLineHandler.postDelayed(FpsView.this.beginTestRunnable, 1000L);
            } else {
                FpsView.this.handler.post(FpsView.this.showFPSRunable);
                FpsView.this.start();
                ScheduledTask.getInstance().scheduledDelayed(new Runnable(){

                    @Override
                    public void run() {
                        FpsView.this.showTheResult();
                    }
                }, 0L);
                FpsView.this.mDrawLineHandler.removeCallbacks(FpsView.this.beginTestRunnable);
                FpsView.this.unregisterBatteryReveiver();
            }
        }
    };

    private FpsView(Context context, String packageName) {
        super(context);
        this.setBackgroundColor(-7829368);
        this.getBackground().setAlpha(200);
        this.packageName = packageName;
        this.pid = android.os.Process.myPid();
        this.tf = new TextView(context);
        this.tf.setTextSize(12.0f);
        this.addView((View)this.tf);
        this.path = new Path();
        this.pathFill = new Path();
        this.cpuArray = new ArrayList();
        this.memArray = new ArrayList();
        this.p = new Paint();
        this.wmParams.x = 0;
        this.wmParams.y = 0;
        this.wmParams.width = 200;
        this.wmParams.height = 100;
        this.mDrawLineThread = new HandlerThread("FPS_DRAWLINE");
        this.mDrawLineThread.start();
        this.mDrawLineHandler = new Handler(this.mDrawLineThread.getLooper());
        this.file = new File(Environment.getExternalStorageDirectory(), "fpsInfo.txt");
        if (this.file.exists()) {
            this.file.delete();
        }
        if (!this.file.exists()) {
            if (MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)"TestFile", (String)"Create the file: fpsInfo.txt", (Object[])new Object[0]);
            }
            try {
                this.file.createNewFile();
            }
            catch (Throwable throwable) {
                MLog.error((Object)"FpsView", (Throwable)throwable);
            }
        }
        this.addListener();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FpsView instance(final Context context, String packageName) {
        if (instance == null || instance.get() == null) {
            byte[] byArray = lock;
            synchronized (lock) {
                FpsView fpsView = new FpsView(context, packageName);
                fpsView.setOnLongClickListener(new View.OnLongClickListener(){

                    public boolean onLongClick(View v) {
                        try {
                            final WindowManager wManager = (WindowManager)context.getSystemService("window");
                            WindowManager.LayoutParams params = new WindowManager.LayoutParams();
                            params.gravity = 17;
                            params.type = 2002;
                            params.format = 1;
                            params.width = -2;
                            params.height = -2;
                            params.softInputMode = 16;
                            if (v.getTag() == null) {
                                ViewGroup viewGroup = (ViewGroup)LayoutInflater.from((Context)context).inflate(R.layout.layout_ok_cancel_fps_dialog, null);
                                final RelativeLayout dialogLayout = new RelativeLayout(context);
                                viewGroup.setClickable(true);
                                RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
                                layoutParams.addRule(13);
                                dialogLayout.addView((View)viewGroup, (ViewGroup.LayoutParams)layoutParams);
                                dialogLayout.setOnClickListener(new View.OnClickListener(){

                                    public void onClick(View v) {
                                        wManager.removeViewImmediate((View)dialogLayout);
                                    }
                                });
                                RadioGroup radioGroup = (RadioGroup)viewGroup.findViewById(R.id.fps_radio_group);
                                final EditText editText = (EditText)viewGroup.findViewById(R.id.edt_time);
                                editText.setText((CharSequence)"20");
                                editText.setSelection(2);
                                testScene = "guankan";
                                radioGroup.setOnCheckedChangeListener(new RadioGroup.OnCheckedChangeListener(){

                                    public void onCheckedChanged(RadioGroup group, int checkedId) {
                                        if (checkedId == R.id.fps_radio_btn_kb) {
                                            editText.setText((CharSequence)"30");
                                            testScene = "kaibo";
                                        } else {
                                            editText.setText((CharSequence)"20");
                                            testScene = "guankan";
                                        }
                                        editText.setSelection(2);
                                    }
                                });
                                viewGroup.findViewById(R.id.btn_cancel).setOnClickListener(new View.OnClickListener(){

                                    public void onClick(View v) {
                                        wManager.removeViewImmediate((View)dialogLayout);
                                    }
                                });
                                viewGroup.findViewById(R.id.btn_ok).setOnClickListener(new View.OnClickListener(){

                                    public void onClick(View v) {
                                        String txt = editText.getText().toString();
                                        long beginTime = System.currentTimeMillis();
                                        long duration = FP.empty((CharSequence)txt) ? 0L : Long.valueOf(txt);
                                        endTime = beginTime + (duration *= 60000L);
                                        ((InputMethodManager)context.getSystemService("input_method")).hideSoftInputFromWindow(editText.getWindowToken(), 2);
                                        FpsView view = instance.get();
                                        if (view != null) {
                                            view.startTest();
                                        }
                                        wManager.removeViewImmediate((View)dialogLayout);
                                    }
                                });
                                wManager.addView((View)dialogLayout, (ViewGroup.LayoutParams)params);
                            } else {
                                wManager.addView((View)v.getTag(), (ViewGroup.LayoutParams)params);
                            }
                        }
                        catch (Throwable t) {
                            MLog.error((Object)"FpsView", (String)("onclick error=" + t), (Object[])new Object[0]);
                        }
                        return true;
                    }
                });
                instance = new SoftReference<FpsView>(fpsView);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return instance.get();
            }
        }
        return instance.get();
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void removeFormStage() {
        try {
            if (this.getParent() != null) {
                this.wm.removeViewImmediate((View)this);
            }
        }
        catch (Throwable t) {
            MLog.error((Object)"FpsView", (Throwable)t);
        }
        this.onDestroy();
    }

    private void stop() {
        this.handler.removeCallbacks(this.drawLineRunnable);
        this.mDrawLineHandler.removeCallbacks(this.getLineDataRunnable);
    }

    public void start() {
        this.mDrawLineHandler.removeCallbacks(this.getLineDataRunnable);
        this.mDrawLineHandler.postDelayed(this.getLineDataRunnable, 1000L);
        this.handler.removeCallbacks(this.drawLineRunnable);
        this.handler.postDelayed(this.drawLineRunnable, 1100L);
    }

    private void addListener() {
        this.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                FpsView.this.x = event.getRawX();
                FpsView.this.y = event.getRawY() - 50.0f;
                switch (event.getAction()) {
                    case 0: {
                        FpsView.this.mTouchStartX = event.getX();
                        FpsView.this.mTouchStartY = event.getY();
                        break;
                    }
                    case 2: {
                        FpsView.this.updateViewPosition();
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                return false;
            }
        });
    }

    @TargetApi(value=11)
    public void addToStage(final int x, final int y, final int width, final int height) {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            this.addToWindow(x, y, width, height);
        } else {
            this.handler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    FpsView.this.addToWindow(x, y, width, height);
                }
            }, 2000L);
        }
    }

    public void addToWindow(int x, int y, int width, int height) {
        WindowManager wm = (WindowManager)this.getContext().getSystemService("window");
        WindowManager.LayoutParams wmParams = this.wmParams;
        wmParams.type = 2002;
        wmParams.format = 1;
        wmParams.flags = 40;
        wmParams.x = x;
        wmParams.y = y;
        wmParams.width = width;
        wmParams.height = height;
        this.w = width;
        this.h = height;
        wmParams.gravity = 51;
        if (this.getParent() != null) {
            wm.removeView((View)this);
        }
        wm.addView((View)this, (ViewGroup.LayoutParams)wmParams);
        this.start();
    }

    public void setText() {
        String c = "cpu:" + String.format("%.1f", Float.valueOf(this.currCpu)) + "%";
        String m = "mem:" + String.format("%.1f", Float.valueOf(this.currMem / 1024.0f / 1024.0f)) + "m";
        this.tf.setText((CharSequence)(c + "\n" + m));
    }

    public void updateViewPosition() {
        this.wmParams.x = (int)(this.x - this.mTouchStartX);
        this.wmParams.y = (int)(this.y - this.mTouchStartY);
        this.wm.updateViewLayout((View)this, (ViewGroup.LayoutParams)this.wmParams);
    }

    public void drawLine() {
        this.currCpu = this.getCpuUsage();
        this.currMem = this.getUsedMemorySize();
        this.maxCpu = 100.0f;
        this.maxMem = this.currMem > this.maxMem ? this.currMem : this.maxMem;
        this.cpuArray.add(0, Float.valueOf(this.currCpu));
        if (this.cpuArray.size() > this.max) {
            this.cpuArray.remove(this.cpuArray.size() - 1);
        }
        this.memArray.add(0, Float.valueOf(this.currMem));
        if (this.memArray.size() > this.max) {
            this.memArray.remove(this.memArray.size() - 1);
        }
        float mem = this.currMem / 1024.0f / 1024.0f;
        String c = "cpu:" + String.format("%.1f", Float.valueOf(this.currCpu)) + "%";
        String m = "mem:" + String.format("%.1f", Float.valueOf(mem)) + "m";
        String c1 = "cpu," + String.format("%.1f", Float.valueOf(this.currCpu)) + "%";
        String m1 = ",mem," + String.format("%.1f", Float.valueOf(mem));
        this.writeToFile(c1, m1);
    }

    private void writeToFile(String c, String m) {
        try {
            SimpleDateFormat format = CommonUtils.getSimpleDateFormat((String)"yyyy-MM-dd-HH:mm:ss,");
            String t = format.format(new Date());
            FileOutputStream fos = new FileOutputStream(this.file, true);
            String info = t + " " + c + " " + m + "\n";
            fos.write(info.getBytes());
            fos.close();
        }
        catch (Throwable throwable) {
            MLog.error((Object)"FpsView", (Throwable)throwable);
        }
    }

    @TargetApi(value=11)
    protected void onDraw(Canvas canvas) {
        int i;
        float vx = 0.0f;
        float vy = 0.0f;
        this.path.reset();
        this.path.moveTo(0.0f, (float)this.h);
        this.pathFill.reset();
        this.pathFill.moveTo(0.0f, (float)this.h);
        this.p.reset();
        for (i = 0; i < this.cpuArray.size(); ++i) {
            if (this.max == 0 || this.maxCpu == 0.0f) {
                vx = 0.0f;
                vy = 0.0f;
            } else {
                vx = (float)this.w * (Float.valueOf(i).floatValue() / (float)(this.max - 1));
                vy = (float)this.h - (float)this.h * (this.cpuArray.get(i).floatValue() / this.maxCpu);
            }
            this.path.lineTo(vx, vy);
            this.pathFill.lineTo(vx, vy);
        }
        this.path.lineTo(vx, (float)this.h);
        this.pathFill.lineTo(vx, (float)this.h);
        this.p.setARGB(50, 178, 0, 0);
        this.p.setStrokeWidth(1.0f);
        this.p.setStyle(Paint.Style.FILL);
        canvas.drawPath(this.pathFill, this.p);
        this.p.setARGB(178, 255, 0, 0);
        this.p.setStyle(Paint.Style.STROKE);
        canvas.drawPath(this.path, this.p);
        this.path.reset();
        this.path.moveTo(0.0f, (float)this.h);
        this.pathFill.reset();
        this.pathFill.moveTo(0.0f, (float)this.h);
        for (i = 0; i < this.memArray.size(); ++i) {
            if (this.max == 0 || this.maxMem == 0.0f) {
                vx = 0.0f;
                vy = 0.0f;
            } else {
                vx = (float)this.w * (Float.valueOf(i).floatValue() / (float)(this.max - 1));
                if (i < this.memArray.size()) {
                    vy = (float)this.h - (float)this.h * (this.memArray.get(i).floatValue() / this.maxMem);
                }
            }
            this.path.lineTo(vx, vy);
            this.pathFill.lineTo(vx, vy);
        }
        this.path.lineTo(vx, (float)this.h);
        this.pathFill.lineTo(vx, (float)this.h);
        this.p.setARGB(50, 0, 0, 178);
        this.p.setStrokeWidth(1.0f);
        this.p.setStyle(Paint.Style.FILL);
        canvas.drawPath(this.pathFill, this.p);
        this.p.setARGB(178, 0, 0, 255);
        this.p.setStyle(Paint.Style.STROKE);
        canvas.drawPath(this.path, this.p);
        super.onDraw(canvas);
    }

    protected void onDetachedFromWindow() {
        try {
            super.onDetachedFromWindow();
            this.onDestroy();
        }
        catch (Throwable throwable) {
            MLog.error((Object)"FpsView", (Throwable)throwable);
        }
    }

    private void onDestroy() {
        try {
            this.handler.removeCallbacks(this.drawLineRunnable);
            this.handler.removeCallbacks(this.setTextRunnable);
            this.mDrawLineHandler.removeCallbacks(this.beginTestRunnable);
            this.mDrawLineHandler.removeCallbacks(this.getLineDataRunnable);
            this.unregisterBatteryReveiver();
        }
        catch (Throwable throwable) {
            MLog.error((Object)"FpsView", (Throwable)throwable);
        }
    }

    public long getUsedMemorySize() {
        long freeSize = 0L;
        long totalSize = 0L;
        long usedSize = -1L;
        long maxSize = 0L;
        try {
            Runtime info = Runtime.getRuntime();
            freeSize = info.freeMemory();
            totalSize = info.totalMemory();
            usedSize = totalSize - freeSize;
            maxSize = info.maxMemory();
        }
        catch (Throwable throwable) {
            MLog.error((Object)"FpsView", (Throwable)throwable);
        }
        return usedSize;
    }

    public float getCpuUsage() {
        return this.getCpuUsageStatistic()[2];
    }

    private int[] getCpuUsageStatistic() {
        String tempString = this.executeTop();
        tempString = tempString.replaceAll(",", "");
        tempString = tempString.replaceAll("User", "");
        tempString = tempString.replaceAll("System", "");
        tempString = tempString.replaceAll("IOW", "");
        tempString = tempString.replaceAll("IRQ", "");
        tempString = tempString.replaceAll("%", "");
        for (int i = 0; i < 10; ++i) {
            tempString = tempString.replaceAll("  ", " ");
        }
        tempString = tempString.trim();
        String[] myString = tempString.split(" ");
        int[] cpuUsageAsInt = new int[3];
        for (int i = 0; i < 3; ++i) {
            myString[i] = myString[i].trim();
            cpuUsageAsInt[i] = StringUtils.safeParseInt((String)myString[i]);
        }
        return cpuUsageAsInt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String executeTop() {
        Process p = null;
        BufferedReader in = null;
        String returnString = "0 0 0 0 0 0 0 0 0 0";
        try {
            p = Runtime.getRuntime().exec("top -d 0.5 -n 1");
            in = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while (!((returnString = in.readLine()) == null || returnString.contains(this.packageName) && returnString.contains(String.valueOf(this.pid)))) {
            }
            if (returnString == null) {
                returnString = "0 0 0 0 0 0 0 0 0 0";
            }
        }
        catch (Throwable throwable) {
            MLog.error((Object)"FpsView", (Throwable)throwable);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Throwable throwable) {
                MLog.error((Object)"FpsView", (Throwable)throwable);
            }
        }
        return returnString;
    }

    public float[] getStreamBytes() {
        float[] res = new float[]{-1.0f, -1.0f};
        PackageManager pm = this.getContext().getPackageManager();
        try {
            ApplicationInfo info = pm.getApplicationInfo(this.packageName, 1);
            int pUid = info.uid;
            res[0] = (float)TrafficStats.getUidTxBytes((int)pUid) / 1024.0f;
            res[1] = (float)TrafficStats.getUidRxBytes((int)pUid) / 1024.0f;
        }
        catch (PackageManager.NameNotFoundException e) {
            MLog.error((Object)"FpsView", (Throwable)e);
        }
        return res;
    }

    public String getTemperature() {
        if (this.tempPath != null) {
            try {
                File tFile = new File(this.tempPath);
                if (tFile.exists()) {
                    FileReader fileReader = new FileReader(tFile);
                    BufferedReader in = new BufferedReader(fileReader);
                    String s = in.readLine();
                    in.close();
                    fileReader.close();
                    return s;
                }
            }
            catch (Throwable throwable) {
                MLog.error((Object)"FpsView", (Throwable)throwable);
            }
        }
        return "-1";
    }

    private void getBatteryCapacity() {
        try {
            Class<?> mPowerProfile = Class.forName("com.android.internal.os.PowerProfile");
            Object instance = mPowerProfile.getConstructor(Context.class).newInstance(this.getContext());
            Method getBatteryCapacity = mPowerProfile.getDeclaredMethod("getBatteryCapacity", new Class[0]);
            this.batteryCapacity = (Double)getBatteryCapacity.invoke(instance, new Object[0]);
        }
        catch (Throwable throwable) {
            MLog.error((Object)"FpsView", (Throwable)throwable);
        }
    }

    public void startTest() {
        this.setVisibility(8);
        this.stop();
        this.getBatteryCapacity();
        this.registerBatteryReveiver();
        this.createTestFile();
        this.getTemperaturePath("/sys/class/thermal", "/thermal_zone", "/type", "/temp");
        if (this.tempPath == null) {
            this.getTemperaturePath("/sys/class/hwmon", "/hwmon", "/name", "/temp1_input");
        }
        this.mDrawLineHandler.removeCallbacks(this.beginTestRunnable);
        this.mDrawLineHandler.postDelayed(this.beginTestRunnable, 1000L);
    }

    private void createTestFile() {
        SimpleDateFormat format = CommonUtils.getSimpleDateFormat((String)"yyyyMMddHHmmss");
        this.fileAppend = format.format(new Date()) + ".txt";
        this.testData = new File(Environment.getExternalStorageDirectory(), this.fileName + this.fileAppend);
        if (this.testData.exists()) {
            this.testData.delete();
        }
        if (!this.testData.exists()) {
            try {
                this.testData.createNewFile();
                this.writeUpLoadMetaInfo();
            }
            catch (Throwable throwable) {
                MLog.error((Object)"FpsView", (Throwable)throwable);
            }
        }
    }

    private void getTemperaturePath(String path, String appd, String appd1, String appd2) {
        try {
            String sensor0 = "tsens_tz_sensor0";
            Object[] files = new File(path).listFiles();
            this.tempPath = null;
            if (!FP.empty((Object[])files)) {
                int size = files.length;
                InputStreamReader fileReader = null;
                BufferedReader in = null;
                for (int i = 0; i < size; ++i) {
                    String type;
                    File tFile = new File(path + appd + i + appd1);
                    if (!tFile.exists() || !sensor0.equals(type = (in = new BufferedReader(fileReader = new FileReader(tFile))).readLine())) continue;
                    this.tempPath = path + appd + i + appd2;
                    break;
                }
                in.close();
                fileReader.close();
            }
        }
        catch (Throwable throwable) {
            MLog.error((Object)"FpsView", (Throwable)throwable);
        }
    }

    private void writeUpLoadMetaInfo() {
        try {
            FileOutputStream fos = new FileOutputStream(this.testData, false);
            String screenState = 1 == this.getContext().getResources().getConfiguration().orientation ? "L" : "X";
            StringBuffer sb = new StringBuffer();
            sb.append(this.testVersion).append("`").append(Build.MODEL).append("`").append("android").append("`").append(Build.VERSION.RELEASE).append("`").append(TelephonyUtils.getImei((Context)BasicConfig.getInstance().getAppContext())).append("`").append("YY").append("`").append(VersionUtil.getLocalVer((Context)BasicConfig.getInstance().getAppContext()).getVersionNameWithoutSnapshot()).append("`").append(VersionUtil.getVersionCode((Context)BasicConfig.getInstance().getAppContext())).append("`").append(screenState).append("`").append(testScene).append("`").append(LoginUtil.getUid()).append("\n");
            fos.write(sb.toString().getBytes());
            fos.close();
        }
        catch (Throwable throwable) {
            MLog.error((Object)"FpsView", (Throwable)throwable);
        }
    }

    public void writeToUpLoadFile(String c, String m, String up, String down, String te, String po) {
        try {
            SimpleDateFormat format = CommonUtils.getSimpleDateFormat((String)"yyyy-MM-dd-HH:mm:ss`");
            String t = format.format(new Date());
            FileOutputStream fos = new FileOutputStream(this.testData, true);
            StringBuffer sb = new StringBuffer();
            sb.append(t).append(c).append("`").append(m).append("`").append(up).append("`").append(down).append("`").append(po).append("`").append(te).append("\n");
            fos.write(sb.toString().getBytes());
            fos.close();
        }
        catch (Throwable throwable) {
            MLog.error((Object)"FpsView", (Throwable)throwable);
        }
    }

    public void showTheResult() {
        try {
            String[] line;
            Context context = this.getContext();
            final WindowManager wManager = (WindowManager)context.getSystemService("window");
            WindowManager.LayoutParams params = new WindowManager.LayoutParams();
            params.gravity = 17;
            params.type = 2002;
            params.format = 1;
            params.flags = 40;
            params.width = -2;
            params.height = -2;
            ViewGroup viewGroup = (ViewGroup)LayoutInflater.from((Context)context).inflate(R.layout.layout_ok_content_fps_dialog, null);
            final RelativeLayout dialogLayout = new RelativeLayout(context);
            final TextView btnOk = (TextView)viewGroup.findViewById(R.id.btn_ok);
            final TextView message = (TextView)viewGroup.findViewById(R.id.message_content);
            btnOk.setEnabled(false);
            viewGroup.setClickable(true);
            RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
            layoutParams.addRule(13);
            dialogLayout.addView((View)viewGroup, (ViewGroup.LayoutParams)layoutParams);
            dialogLayout.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    wManager.removeViewImmediate((View)dialogLayout);
                }
            });
            btnOk.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    wManager.removeViewImmediate((View)dialogLayout);
                }
            });
            FileReader fpsInfoFileReader = new FileReader(Environment.getExternalStorageDirectory() + "/" + this.fileName + this.fileAppend);
            BufferedReader in = new BufferedReader(fpsInfoFileReader);
            String version = "";
            String buidNo = "";
            String sTime = "";
            float sPower = 0.0f;
            float sUpBytes = 0.0f;
            float sDownBytes = 0.0f;
            String sTemperature = "";
            float allMem = 0.0f;
            float allCpu = 0.0f;
            int num = 0;
            String[] data = new String[7];
            String returnString = in.readLine();
            if (returnString != null && (line = returnString.split("`")) != null) {
                version = line[6];
                buidNo = line[7];
            }
            if ((returnString = in.readLine()) != null && (data = returnString.split("`")) != null) {
                sTime = data[0];
                sPower = Float.valueOf(data[5]).floatValue();
                sUpBytes = Float.valueOf(data[3]).floatValue();
                sDownBytes = Float.valueOf(data[4]).floatValue();
                sTemperature = data[6];
                allCpu += Float.valueOf(data[1]).floatValue();
                allMem += Float.valueOf(data[2]).floatValue();
                ++num;
            }
            while ((returnString = in.readLine()) != null) {
                data = returnString.split("`");
                if (data == null) continue;
                allCpu += Float.valueOf(data[1]).floatValue();
                allMem += Float.valueOf(data[2]).floatValue();
                ++num;
            }
            in.close();
            fpsInfoFileReader.close();
            final String resInfo = String.format("\u7248\u672c\u53f7\uff1a%s\n\u6784\u5efa\u53f7\uff1a%s\n\u5f00\u59cb\u65f6\u95f4\uff1a%s\n\u7ed3\u675f\u65f6\u95f4\uff1a%s\n\u5e73\u5747CPU\uff1a%.1f%%\n\u5e73\u5747\u5185\u5b58\uff1a%.1fM\n\u6d88\u8017\u7535\u91cf\uff1a%.1fmAh\n\u4e0a\u884c\u6d41\u91cf\uff1a%.1fKB\n\u4e0b\u884c\u6d41\u91cf\uff1a%.1fKB\n\u8d77\u59cb\u6e29\u5ea6\uff1a%s\u2103\n\u7ed3\u675f\u6e29\u5ea6\uff1a%s\u2103\n", version, buidNo, sTime, data[0], Float.valueOf(allCpu / (float)num), Float.valueOf(allMem / (float)num), Float.valueOf(sPower - Float.valueOf(data[5]).floatValue()), Float.valueOf(Float.valueOf(data[3]).floatValue() - sUpBytes), Float.valueOf(Float.valueOf(data[4]).floatValue() - sDownBytes), sTemperature, data[6]);
            SafeDispatchHandler handle = new SafeDispatchHandler(Looper.getMainLooper());
            handle.post(new Runnable(){

                @Override
                public void run() {
                    if (message != null) {
                        message.setText((CharSequence)resInfo);
                    }
                    btnOk.setEnabled(true);
                }
            });
            wManager.addView((View)dialogLayout, (ViewGroup.LayoutParams)params);
        }
        catch (Throwable t) {
            MLog.error((Object)"FpsView", (String)("showTheResult error=" + t), (Object[])new Object[0]);
        }
    }

    public void unregisterBatteryReveiver() {
        try {
            if (isBatteryReveiver) {
                this.getContext().unregisterReceiver(this.batteryReveiver);
                isBatteryReveiver = false;
            }
        }
        catch (Throwable throwable) {
            MLog.error((Object)"FpsView", (Throwable)throwable);
        }
    }

    private void registerBatteryReveiver() {
        try {
            if (!isBatteryReveiver) {
                this.getContext().registerReceiver(this.batteryReveiver, new IntentFilter("android.intent.action.BATTERY_CHANGED"));
                isBatteryReveiver = true;
            }
        }
        catch (Throwable throwable) {
            MLog.error((Object)"FpsView", (Throwable)throwable);
        }
    }

    static {
        isBatteryReveiver = false;
    }
}

