/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget.corner;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.ColorFilter;
import android.graphics.Shader;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.net.Uri;
import android.support.annotation.ColorInt;
import android.support.annotation.DimenRes;
import android.support.annotation.DrawableRes;
import android.util.AttributeSet;
import android.util.Log;
import android.widget.ImageView;
import com.yy.mobile.plugin.pluginunionmain.R;
import com.yy.mobile.ui.widget.corner.RoundedDrawable;

public class RoundedImageView
extends ImageView {
    public static final Shader.TileMode DEFAULT_TILE_MODE = Shader.TileMode.CLAMP;
    private static final ImageView.ScaleType[] SCALE_TYPES = new ImageView.ScaleType[]{ImageView.ScaleType.MATRIX, ImageView.ScaleType.FIT_XY, ImageView.ScaleType.FIT_START, ImageView.ScaleType.FIT_CENTER, ImageView.ScaleType.FIT_END, ImageView.ScaleType.CENTER, ImageView.ScaleType.CENTER_CROP, ImageView.ScaleType.CENTER_INSIDE};
    private final float[] mCornerRadii = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
    private Drawable mBackgroundDrawable;
    private ColorStateList mBorderColor = ColorStateList.valueOf((int)-16777216);
    private float mBorderWidth = 0.0f;
    private ColorFilter mColorFilter = null;
    private boolean mColorMod = false;
    private Drawable mDrawable;
    private boolean mHasColorFilter = false;
    private boolean mIsOval = false;
    private boolean mMutateBackground = false;
    private int mResource;
    private int mBackgroundResource;
    private ImageView.ScaleType mScaleType;
    private Shader.TileMode mTileModeX = DEFAULT_TILE_MODE;
    private Shader.TileMode mTileModeY = DEFAULT_TILE_MODE;

    public RoundedImageView(Context context) {
        super(context);
    }

    public RoundedImageView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public RoundedImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        int tileModeY;
        int tileModeX;
        int i;
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.RIV_RoundedImageView, defStyle, 0);
        int index = a.getInt(R.styleable.RIV_RoundedImageView_android_scaleType, -1);
        if (index >= 0) {
            this.setScaleType(SCALE_TYPES[index]);
        } else {
            this.setScaleType(ImageView.ScaleType.FIT_CENTER);
        }
        float cornerRadiusOverride = a.getDimensionPixelSize(R.styleable.RIV_RoundedImageView_riv_corner_radius, -1);
        this.mCornerRadii[0] = a.getDimensionPixelSize(R.styleable.RIV_RoundedImageView_riv_corner_radius_top_left, -1);
        this.mCornerRadii[1] = a.getDimensionPixelSize(R.styleable.RIV_RoundedImageView_riv_corner_radius_top_right, -1);
        this.mCornerRadii[2] = a.getDimensionPixelSize(R.styleable.RIV_RoundedImageView_riv_corner_radius_bottom_right, -1);
        this.mCornerRadii[3] = a.getDimensionPixelSize(R.styleable.RIV_RoundedImageView_riv_corner_radius_bottom_left, -1);
        boolean any = false;
        int len = this.mCornerRadii.length;
        for (i = 0; i < len; ++i) {
            if (this.mCornerRadii[i] < 0.0f) {
                this.mCornerRadii[i] = 0.0f;
                continue;
            }
            any = true;
        }
        if (!any) {
            if (cornerRadiusOverride < 0.0f) {
                cornerRadiusOverride = 0.0f;
            }
            len = this.mCornerRadii.length;
            for (i = 0; i < len; ++i) {
                this.mCornerRadii[i] = cornerRadiusOverride;
            }
        }
        this.mBorderWidth = a.getDimensionPixelSize(R.styleable.RIV_RoundedImageView_riv_border_width, -1);
        if (this.mBorderWidth < 0.0f) {
            this.mBorderWidth = 0.0f;
        }
        this.mBorderColor = a.getColorStateList(R.styleable.RIV_RoundedImageView_riv_border_color);
        if (this.mBorderColor == null) {
            this.mBorderColor = ColorStateList.valueOf((int)-16777216);
        }
        this.mMutateBackground = a.getBoolean(R.styleable.RIV_RoundedImageView_riv_mutate_background, false);
        this.mIsOval = a.getBoolean(R.styleable.RIV_RoundedImageView_riv_oval, false);
        int tileMode = a.getInt(R.styleable.RIV_RoundedImageView_riv_tile_mode, -2);
        if (tileMode != -2) {
            this.setTileModeX(RoundedImageView.parseTileMode(tileMode));
            this.setTileModeY(RoundedImageView.parseTileMode(tileMode));
        }
        if ((tileModeX = a.getInt(R.styleable.RIV_RoundedImageView_riv_tile_mode_x, -2)) != -2) {
            this.setTileModeX(RoundedImageView.parseTileMode(tileModeX));
        }
        if ((tileModeY = a.getInt(R.styleable.RIV_RoundedImageView_riv_tile_mode_y, -2)) != -2) {
            this.setTileModeY(RoundedImageView.parseTileMode(tileModeY));
        }
        this.updateDrawableAttrs();
        this.updateBackgroundDrawableAttrs(true);
        if (this.mMutateBackground) {
            super.setBackgroundDrawable(this.mBackgroundDrawable);
        }
        a.recycle();
    }

    private static Shader.TileMode parseTileMode(int tileMode) {
        switch (tileMode) {
            case 0: {
                return Shader.TileMode.CLAMP;
            }
            case 1: {
                return Shader.TileMode.REPEAT;
            }
            case 2: {
                return Shader.TileMode.MIRROR;
            }
        }
        return null;
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        this.invalidate();
    }

    public ImageView.ScaleType getScaleType() {
        return this.mScaleType;
    }

    public void setScaleType(ImageView.ScaleType scaleType) {
        assert (scaleType != null);
        if (this.mScaleType != scaleType) {
            this.mScaleType = scaleType;
            switch (scaleType) {
                case CENTER: 
                case CENTER_CROP: 
                case CENTER_INSIDE: 
                case FIT_CENTER: 
                case FIT_START: 
                case FIT_END: 
                case FIT_XY: {
                    super.setScaleType(ImageView.ScaleType.FIT_XY);
                    break;
                }
                default: {
                    super.setScaleType(scaleType);
                }
            }
            this.updateDrawableAttrs();
            this.updateBackgroundDrawableAttrs(false);
            this.invalidate();
        }
    }

    public void setImageDrawable(Drawable drawable2) {
        this.mResource = 0;
        this.mDrawable = RoundedDrawable.fromDrawable(drawable2);
        this.updateDrawableAttrs();
        super.setImageDrawable(this.mDrawable);
    }

    public void setImageBitmap(Bitmap bm) {
        this.mResource = 0;
        this.mDrawable = RoundedDrawable.fromBitmap(bm);
        this.updateDrawableAttrs();
        super.setImageDrawable(this.mDrawable);
    }

    public void setImageResource(@DrawableRes int resId) {
        if (this.mResource != resId) {
            this.mResource = resId;
            this.mDrawable = this.resolveResource();
            this.updateDrawableAttrs();
            super.setImageDrawable(this.mDrawable);
        }
    }

    public void setImageURI(Uri uri) {
        super.setImageURI(uri);
        this.setImageDrawable(this.getDrawable());
    }

    private Drawable resolveResource() {
        Resources rsrc = this.getResources();
        if (rsrc == null) {
            return null;
        }
        Drawable d = null;
        if (this.mResource != 0) {
            try {
                d = rsrc.getDrawable(this.mResource);
            }
            catch (Exception e) {
                Log.w((String)"RoundedImageView", (String)("Unable to find resource: " + this.mResource), (Throwable)e);
                this.mResource = 0;
            }
        }
        return RoundedDrawable.fromDrawable(d);
    }

    public void setBackground(Drawable background) {
        this.setBackgroundDrawable(background);
    }

    public void setBackgroundResource(@DrawableRes int resId) {
        if (this.mBackgroundResource != resId) {
            this.mBackgroundResource = resId;
            this.mBackgroundDrawable = this.resolveBackgroundResource();
            this.setBackgroundDrawable(this.mBackgroundDrawable);
        }
    }

    public void setBackgroundColor(int color2) {
        this.mBackgroundDrawable = new ColorDrawable(color2);
        this.setBackgroundDrawable(this.mBackgroundDrawable);
    }

    private Drawable resolveBackgroundResource() {
        Resources rsrc = this.getResources();
        if (rsrc == null) {
            return null;
        }
        Drawable d = null;
        if (this.mBackgroundResource != 0) {
            try {
                d = rsrc.getDrawable(this.mBackgroundResource);
            }
            catch (Exception e) {
                Log.w((String)"RoundedImageView", (String)("Unable to find resource: " + this.mBackgroundResource), (Throwable)e);
                this.mBackgroundResource = 0;
            }
        }
        return RoundedDrawable.fromDrawable(d);
    }

    private void updateDrawableAttrs() {
        this.updateAttrs(this.mDrawable, this.mScaleType);
    }

    private void updateBackgroundDrawableAttrs(boolean convert) {
        if (this.mMutateBackground) {
            if (convert) {
                this.mBackgroundDrawable = RoundedDrawable.fromDrawable(this.mBackgroundDrawable);
            }
            this.updateAttrs(this.mBackgroundDrawable, ImageView.ScaleType.FIT_XY);
        }
    }

    public void setColorFilter(ColorFilter cf) {
        if (this.mColorFilter != cf) {
            this.mColorFilter = cf;
            this.mHasColorFilter = true;
            this.mColorMod = true;
            this.applyColorMod();
            this.invalidate();
        }
    }

    private void applyColorMod() {
        if (this.mDrawable != null && this.mColorMod) {
            this.mDrawable = this.mDrawable.mutate();
            if (this.mHasColorFilter) {
                this.mDrawable.setColorFilter(this.mColorFilter);
            }
        }
    }

    private void updateAttrs(Drawable drawable2, ImageView.ScaleType scaleType) {
        if (drawable2 == null) {
            return;
        }
        if (drawable2 instanceof RoundedDrawable) {
            ((RoundedDrawable)drawable2).setScaleType(scaleType).setBorderWidth(this.mBorderWidth).setBorderColor(this.mBorderColor).setOval(this.mIsOval).setTileModeX(this.mTileModeX).setTileModeY(this.mTileModeY);
            if (this.mCornerRadii != null) {
                ((RoundedDrawable)drawable2).setCornerRadius(this.mCornerRadii[0], this.mCornerRadii[1], this.mCornerRadii[2], this.mCornerRadii[3]);
            }
            this.applyColorMod();
        } else if (drawable2 instanceof LayerDrawable) {
            LayerDrawable ld = (LayerDrawable)drawable2;
            int layers = ld.getNumberOfLayers();
            for (int i = 0; i < layers; ++i) {
                this.updateAttrs(ld.getDrawable(i), scaleType);
            }
        }
    }

    @Deprecated
    public void setBackgroundDrawable(Drawable background) {
        this.mBackgroundDrawable = background;
        this.updateBackgroundDrawableAttrs(true);
        super.setBackgroundDrawable(this.mBackgroundDrawable);
    }

    public float getCornerRadius() {
        return this.getMaxCornerRadius();
    }

    public void setCornerRadius(float radius) {
        this.setCornerRadius(radius, radius, radius, radius);
    }

    public float getMaxCornerRadius() {
        float maxRadius = 0.0f;
        for (float r : this.mCornerRadii) {
            maxRadius = Math.max(r, maxRadius);
        }
        return maxRadius;
    }

    public float getCornerRadius(int corner) {
        return this.mCornerRadii[corner];
    }

    public void setCornerRadiusDimen(@DimenRes int resId) {
        float radius = this.getResources().getDimension(resId);
        this.setCornerRadius(radius, radius, radius, radius);
    }

    public void setCornerRadiusDimen(int corner, @DimenRes int resId) {
        this.setCornerRadius(corner, this.getResources().getDimensionPixelSize(resId));
    }

    public void setCornerRadius(int corner, float radius) {
        if (this.mCornerRadii[corner] == radius) {
            return;
        }
        this.mCornerRadii[corner] = radius;
        this.updateDrawableAttrs();
        this.updateBackgroundDrawableAttrs(false);
        this.invalidate();
    }

    public void setCornerRadius(float topLeft, float topRight, float bottomLeft, float bottomRight) {
        if (this.mCornerRadii[0] == topLeft && this.mCornerRadii[1] == topRight && this.mCornerRadii[2] == bottomRight && this.mCornerRadii[3] == bottomLeft) {
            return;
        }
        this.mCornerRadii[0] = topLeft;
        this.mCornerRadii[1] = topRight;
        this.mCornerRadii[3] = bottomLeft;
        this.mCornerRadii[2] = bottomRight;
        this.updateDrawableAttrs();
        this.updateBackgroundDrawableAttrs(false);
        this.invalidate();
    }

    public float getBorderWidth() {
        return this.mBorderWidth;
    }

    public void setBorderWidth(@DimenRes int resId) {
        this.setBorderWidth(this.getResources().getDimension(resId));
    }

    public void setBorderWidth(float width) {
        if (this.mBorderWidth == width) {
            return;
        }
        this.mBorderWidth = width;
        this.updateDrawableAttrs();
        this.updateBackgroundDrawableAttrs(false);
        this.invalidate();
    }

    @ColorInt
    public int getBorderColor() {
        return this.mBorderColor.getDefaultColor();
    }

    public void setBorderColor(@ColorInt int color2) {
        this.setBorderColor(ColorStateList.valueOf((int)color2));
    }

    public void setBorderColor(ColorStateList colors) {
        if (this.mBorderColor.equals(colors)) {
            return;
        }
        this.mBorderColor = colors != null ? colors : ColorStateList.valueOf((int)-16777216);
        this.updateDrawableAttrs();
        this.updateBackgroundDrawableAttrs(false);
        if (this.mBorderWidth > 0.0f) {
            this.invalidate();
        }
    }

    public ColorStateList getBorderColors() {
        return this.mBorderColor;
    }

    public boolean isOval() {
        return this.mIsOval;
    }

    public void setOval(boolean oval) {
        this.mIsOval = oval;
        this.updateDrawableAttrs();
        this.updateBackgroundDrawableAttrs(false);
        this.invalidate();
    }

    public Shader.TileMode getTileModeX() {
        return this.mTileModeX;
    }

    public void setTileModeX(Shader.TileMode tileModeX) {
        if (this.mTileModeX == tileModeX) {
            return;
        }
        this.mTileModeX = tileModeX;
        this.updateDrawableAttrs();
        this.updateBackgroundDrawableAttrs(false);
        this.invalidate();
    }

    public Shader.TileMode getTileModeY() {
        return this.mTileModeY;
    }

    public void setTileModeY(Shader.TileMode tileModeY) {
        if (this.mTileModeY == tileModeY) {
            return;
        }
        this.mTileModeY = tileModeY;
        this.updateDrawableAttrs();
        this.updateBackgroundDrawableAttrs(false);
        this.invalidate();
    }

    public boolean mutatesBackground() {
        return this.mMutateBackground;
    }

    public void mutateBackground(boolean mutate) {
        if (this.mMutateBackground == mutate) {
            return;
        }
        this.mMutateBackground = mutate;
        this.updateBackgroundDrawableAttrs(true);
        this.invalidate();
    }
}

