/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.utils.rest;

import android.app.Activity;
import android.content.Context;
import android.net.Uri;
import com.yy.mobile.baseapi.model.store.YYStore;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.model.ReqAction;
import com.yy.mobile.ui.utils.NavigationUtils;
import com.yy.mobile.ui.utils.rest.base.INavParam;
import com.yy.mobile.ui.utils.rest.base.IRestApiEx;
import com.yy.mobile.ui.utils.rest.base.IRestApiList;
import com.yy.mobile.ui.utils.rest.base.NavRestApi;
import com.yy.mobile.util.RxUtils;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.im.request.IsMyFriendAction;
import io.reactivex.annotations.NonNull;
import io.reactivex.functions.Consumer;
import java.util.ArrayList;
import java.util.List;

public class PersonalCenterApiList
implements IRestApiList {
    public List<IRestApiEx> getList() {
        ArrayList<IRestApiEx> list = new ArrayList<IRestApiEx>();
        list.add(this.gotoPersonalCenter());
        list.add(this.gotoPersonalCenterAndOpenTab());
        list.add(this.tiebaGotoPersonalCenter());
        return list;
    }

    public IRestApiEx gotoPersonalCenter() {
        return new NavRestApi(){

            public String getAuthority() {
                return "PersonalCenter";
            }

            public String getPath() {
                return "*";
            }

            public void run() {
                INavParam param = (INavParam)this.getParam();
                final Activity context = param.context;
                Uri uri = param.uri;
                String uidStr = (String)uri.getPathSegments().get(0);
                final long uid = Long.valueOf(uidStr);
                param.context.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (uid == 0L) {
                            if (LoginUtil.isLogined()) {
                                NavigationUtils.toMainTab(context, "/Me/Home");
                            } else {
                                PersonalCenterApiList.this.showLoginDialog(context);
                            }
                        } else {
                            NavigationUtils.toPersonPage((Context)context, uid);
                        }
                    }
                });
            }
        };
    }

    public IRestApiEx gotoPersonalCenterAndOpenTab() {
        return new NavRestApi(){

            public String getAuthority() {
                return "PersonalCenter";
            }

            public String getPath() {
                return "*/*";
            }

            public void run() {
                INavParam param = (INavParam)this.getParam();
                final Activity context = param.context;
                Uri uri = param.uri;
                String uidStr = (String)uri.getPathSegments().get(0);
                final long uid = StringUtils.safeParseLong((String)uidStr);
                String tabIdStr = (String)uri.getPathSegments().get(1);
                final int tabId = StringUtils.safeParseInt((String)tabIdStr);
                param.context.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (uid == 0L) {
                            if (LoginUtil.isLogined()) {
                                NavigationUtils.toMainTab(context, "/Me/Home");
                            } else {
                                PersonalCenterApiList.this.showLoginDialog(context);
                            }
                        } else {
                            NavigationUtils.toPersonPage((Context)context, uid, tabId);
                        }
                    }
                });
            }
        };
    }

    public IRestApiEx tiebaGotoPersonalCenter() {
        return new NavRestApi(){

            public String getAuthority() {
                return "PersonalCenter";
            }

            public String getPath() {
                return "*/*/*/*/*";
            }

            public void run() {
                INavParam param = (INavParam)this.getParam();
                final Activity context = param.context;
                Uri uri = param.uri;
                String uidStr = (String)uri.getPathSegments().get(1);
                final String isAnchor = (String)uri.getPathSegments().get(2);
                String tiebaAnchorId = (String)uri.getPathSegments().get(3);
                String tiebaId = (String)uri.getPathSegments().get(4);
                final long uid = Long.valueOf(uidStr);
                if (!MLog.isLogLevelAboveVerbose()) {
                    MLog.verbose((Object)"hsj", (String)("tiebaGotoPersonalCenter uid=" + uid), (Object[])new Object[0]);
                }
                param.context.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (uid == 0L) {
                            if (LoginUtil.isLogined()) {
                                NavigationUtils.toMainTab(context, "/Me/Home");
                            } else {
                                PersonalCenterApiList.this.showLoginDialog(context);
                            }
                        } else if (isAnchor != null && !isAnchor.equals("0")) {
                            NavigationUtils.toPersonPage((Context)context, uid);
                        } else {
                            YYStore.INSTANCE.dispatch((ReqAction)new IsMyFriendAction(uid)).subscribe((Consumer)new Consumer<Boolean>(){

                                public void accept(@NonNull Boolean isFriend) throws Exception {
                                    if (isFriend.booleanValue()) {
                                        NavigationUtils.toProfile((Context)context, uid);
                                    } else {
                                        NavigationUtils.toUserInfo((Context)context, uid);
                                    }
                                }
                            }, RxUtils.errorConsumer((String)"PersonalCenterApiList"));
                        }
                    }
                });
            }
        };
    }

    public void showLoginDialog(Activity context) {
        LoginUtil.showLoginDialog((Context)context);
    }
}

