/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.shenqu.tanmu;

import com.yy.mobile.ui.shenqu.tanmu.GunPowder;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicBoolean;

public class ShellQueue {
    private AtomicBoolean mShellLocker = new AtomicBoolean(false);
    private Deque<GunPowder> mShells = new LinkedList<GunPowder>();

    public synchronized void offer(GunPowder item) {
        if (!this.mShellLocker.get()) {
            this.mShellLocker.set(true);
            if (this.mShells.size() >= 30) {
                ArrayList<GunPowder> high = new ArrayList<GunPowder>();
                for (int i = 0; i < 20; ++i) {
                    GunPowder p = this.mShells.poll();
                    if (GunPowder.EXPLOSIVE_HIGH > p.mExplosive) continue;
                    high.add(p);
                }
                if (this.mShells.size() >= 30) {
                    this.mShells.clear();
                } else if (high.size() > 0) {
                    for (GunPowder p : high) {
                        this.mShells.offerFirst(p);
                    }
                }
            }
            if (GunPowder.EXPLOSIVE_HIGH <= item.mExplosive) {
                this.mShells.offerFirst(item);
            } else {
                this.mShells.offer(item);
            }
            this.mShellLocker.set(false);
        }
    }

    public synchronized GunPowder poll() {
        GunPowder shell = null;
        if (!this.mShellLocker.get()) {
            this.mShellLocker.set(true);
            shell = this.mShells.poll();
            this.mShellLocker.set(false);
        }
        return shell;
    }

    public synchronized void clear() {
        if (!this.mShellLocker.get()) {
            this.mShellLocker.set(true);
            this.mShells.clear();
            this.mShellLocker.set(false);
        }
    }
}

