/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.sharpgirls;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import com.yy.mobile.imageloader.ImageUtil;
import com.yy.mobile.util.Base64Utils;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.log.MLog;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class WebViewUtils {
    public static String handleImageToBase64JsonStr(String[] clipPaths) {
        if (clipPaths != null && clipPaths.length > 0) {
            JSONArray bitmapJsonArray = new JSONArray();
            for (int i = 0; i < clipPaths.length; ++i) {
                JSONObject jsonObject = WebViewUtils.handleImageToBase64(clipPaths[i], 1280, 720);
                if (jsonObject == null) continue;
                bitmapJsonArray.put((Object)jsonObject);
            }
            if (bitmapJsonArray.length() > 0) {
                MLog.info((Object)"handleImageToBase64JsonStr", (String)("[handleImageToBase64JsonStr].imgSizes=" + bitmapJsonArray.length()), (Object[])new Object[0]);
                return bitmapJsonArray.toString();
            }
        }
        return "";
    }

    public static String handleImageToBase64JsonStr(List<String> clipPaths) {
        return WebViewUtils.handleImageToBase64JsonStrWithCompress(clipPaths, 1280, 720);
    }

    public static String handleImageToBase64JsonStrWithCompress(List<String> clipPaths, int reqWidth, int reqHeight) {
        if (clipPaths != null && clipPaths.size() > 0) {
            JSONArray bitmapJsonArray = new JSONArray();
            for (int i = 0; i < clipPaths.size(); ++i) {
                JSONObject jsonObject = WebViewUtils.handleImageToBase64(clipPaths.get(i), reqWidth, reqHeight);
                if (jsonObject == null) continue;
                bitmapJsonArray.put((Object)jsonObject);
            }
            if (bitmapJsonArray.length() > 0) {
                MLog.info((Object)"handleImageToBase64JsonStr", (String)("[handleImageToBase64JsonStr].imgSizes=" + bitmapJsonArray.length()), (Object[])new Object[0]);
                return bitmapJsonArray.toString();
            }
        }
        return "";
    }

    public static JSONObject handleImageToBase64(String imgPath, int reqWidth, int reqHeight) {
        if (FP.empty((CharSequence)imgPath)) {
            MLog.warn((Object)"handleImageToBase64", (String)"[handleImageToBase64].imgPath is null", (Object[])new Object[0]);
            return null;
        }
        JSONObject bitmapJsonObject = null;
        OutputStream baos = null;
        Bitmap bitmap = null;
        try {
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            bitmap = BitmapFactory.decodeFile((String)imgPath, (BitmapFactory.Options)options);
            options.inJustDecodeBounds = false;
            options.inSampleSize = ImageUtil.calculateInSampleSize((BitmapFactory.Options)options, (int)reqWidth, (int)reqHeight);
            MLog.info((Object)"handleImageToBase64", (String)("[handleImageToBase64].Img origin  w=" + options.outWidth + ",h=" + options.outHeight + ",reqw=" + reqWidth + ",reqh=" + reqHeight + ",simple=" + options.inSampleSize), (Object[])new Object[0]);
            baos = new ByteArrayOutputStream();
            bitmap = BitmapFactory.decodeFile((String)imgPath, (BitmapFactory.Options)options);
            int pos = imgPath.lastIndexOf(".");
            String suffix = null;
            if (pos + 1 < imgPath.length()) {
                suffix = imgPath.substring(pos + 1, imgPath.length());
            }
            if (!FP.empty(suffix) && (suffix.equalsIgnoreCase("jpg") || suffix.equalsIgnoreCase("jpeg"))) {
                bitmap.compress(Bitmap.CompressFormat.JPEG, 80, baos);
            } else {
                bitmap.compress(Bitmap.CompressFormat.PNG, 80, baos);
            }
            String base64Img = Base64Utils.encodeToString((byte[])((ByteArrayOutputStream)baos).toByteArray(), (int)2);
            MLog.info((Object)"handleImageToBase64", (String)("[handleImageToBase64].Img now w=" + options.outWidth + ",h=" + options.outHeight + ",inSampleSize=" + options.inSampleSize + ",base64Img.size=" + base64Img.length() + ",base64Img=" + base64Img.substring(0, 50)), (Object[])new Object[0]);
            bitmapJsonObject = new JSONObject();
            bitmapJsonObject.put("thumbnail", (Object)base64Img);
            bitmapJsonObject.put("localFileName", (Object)imgPath);
            ((ByteArrayOutputStream)baos).close();
            bitmap.recycle();
            bitmap = null;
            baos = null;
        }
        catch (Throwable t) {
            if (baos != null) {
                try {
                    baos.flush();
                    ((ByteArrayOutputStream)baos).close();
                }
                catch (IOException e) {
                    MLog.error((Object)"handleImageToBase64", (String)("[handleImageToBase64].IOException=" + e.getMessage()), (Object[])new Object[0]);
                }
            }
            if (bitmap != null) {
                bitmap.recycle();
            }
            MLog.error((Object)"handleImageToBase64", (String)("[handleImageToBase64].e=" + t + ",imgs=" + imgPath), (Object[])new Object[0]);
        }
        return bitmapJsonObject;
    }
}

