/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.setting.adpater;

import android.content.Context;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.text.style.ForegroundColorSpan;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.TextView;
import com.yy.mobile.plugin.pluginunionmain.R;
import com.yy.mobile.util.log.MLog;
import java.util.ArrayList;
import java.util.List;

public class LogAdapter
extends BaseAdapter {
    private Context mContext;
    private List<String> mLogList = new ArrayList<String>();
    private List<SpannableStringBuilder> mSpannableList = new ArrayList<SpannableStringBuilder>();

    public LogAdapter(Context context) {
        this.mContext = context;
    }

    public void setLogList(List<String> list) {
        this.mLogList = list;
        this.notifyDataSetChanged();
    }

    public void setSpannableList(List<SpannableStringBuilder> list) {
        this.mSpannableList = list;
        this.notifyDataSetChanged();
    }

    public int getCount() {
        return this.mLogList.size();
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        if (convertView == null) {
            convertView = ViewGroup.inflate((Context)this.mContext, (int)R.layout.layout_log_item, null);
        }
        TextView logTextView = (TextView)convertView.findViewById(R.id.log_textview);
        this.updateContent(position, logTextView);
        return convertView;
    }

    public Object getItem(int position) {
        if (position >= 0 && position < this.mLogList.size()) {
            return this.mLogList.get(position);
        }
        return null;
    }

    public long getItemId(int position) {
        return 0L;
    }

    public void updateContent(int position, TextView logTextView) {
        String log2 = (String)this.getItem(position);
        if (log2 != null) {
            logTextView.setText((CharSequence)log2);
            MLog.info((Object)"logadapter", (String)("linecount:" + logTextView.getLineCount()), (Object[])new Object[0]);
        }
        if (position >= 0 && position < this.mSpannableList.size()) {
            SpannableStringBuilder spannableStringBuilder = this.mSpannableList.get(position);
            if (spannableStringBuilder != null) {
                logTextView.setText((CharSequence)spannableStringBuilder);
            } else {
                this.resetTextView(log2, logTextView);
            }
        } else {
            this.resetTextView(log2, logTextView);
        }
    }

    public void resetTextView(String log2, TextView logTextView) {
        if (TextUtils.isEmpty((CharSequence)log2) || logTextView == null) {
            return;
        }
        SpannableStringBuilder spannableStringBuilder = new SpannableStringBuilder((CharSequence)log2);
        ForegroundColorSpan span = new ForegroundColorSpan(-16777216);
        spannableStringBuilder.setSpan((Object)span, 0, log2.length(), 33);
        logTextView.setText((CharSequence)spannableStringBuilder);
    }
}

