/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.report;

import android.text.TextUtils;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.annotation.sneak.DartsRegister;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.android.sniper.api.event.EventCompat;
import com.yy.mobile.RxBus;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.http.DefaultRequestParam;
import com.yy.mobile.http.RequestError;
import com.yy.mobile.http.RequestManager;
import com.yy.mobile.http.RequestParam;
import com.yy.mobile.http.ResponseErrorListener;
import com.yy.mobile.http.ResponseListener;
import com.yy.mobile.plugin.main.events.IEntClient_onReceive_EventArgs;
import com.yy.mobile.plugin.main.events.IReportClient_onReport_EventArgs;
import com.yy.mobile.plugin.main.events.IReportUploadClient_onUploadFail_EventArgs;
import com.yy.mobile.plugin.main.events.IReportUploadClient_onUploadSuccess_EventArgs;
import com.yy.mobile.sdkwrapper.login.LoginProtocol;
import com.yy.mobile.ui.report.ReportCoreImpl$$EventBinder;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.yyprotocol.core.Uint32;
import com.yymobile.core.AbstractBaseCore;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.LinkUriProvider;
import com.yymobile.core.ent.protos.IEntProtocol;
import com.yymobile.core.report.IReportCore;
import com.yymobile.core.report.ReportProtocol;
import io.reactivex.Single;
import io.reactivex.SingleEmitter;
import io.reactivex.SingleOnSubscribe;
import java.io.File;
import java.util.Map;
import org.json.JSONObject;

@DartsRegister(dependent=IReportCore.class)
public class ReportCoreImpl
extends AbstractBaseCore
implements EventCompat,
IReportCore {
    private EventBinder mReportCoreImplSniperEventBinder;

    public void onEventBind() {
        super.onEventBind();
        if (this.mReportCoreImplSniperEventBinder == null) {
            this.mReportCoreImplSniperEventBinder = new ReportCoreImpl$$EventBinder();
        }
        this.mReportCoreImplSniperEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        super.onEventUnBind();
        if (this.mReportCoreImplSniperEventBinder != null) {
            this.mReportCoreImplSniperEventBinder.unBindEvent();
        }
    }

    public ReportCoreImpl() {
        ICoreManagerBase.addClient((Object)((Object)this));
        ReportProtocol.registerProtocols();
    }

    public void sendReport(int type, long chid, int style2, long suid, String content, String extParUrlEncoder, String extProductorParm, Map<String, String> extendInfo) {
        ReportProtocol.ReportReq req2 = new ReportProtocol.ReportReq();
        req2.type = Uint32.toUInt((int)type);
        req2.chid = Uint32.toUInt((long)chid);
        req2.style = Uint32.toUInt((int)style2);
        req2.suid = Uint32.toUInt((long)suid);
        if (content != null) {
            req2.content = content;
        }
        if (extParUrlEncoder != null) {
            req2.extParUrlEncoder = extParUrlEncoder;
        }
        if (extProductorParm != null) {
            req2.extProductorParm = extProductorParm;
        }
        if (extendInfo != null) {
            req2.extendInfo = extendInfo;
        }
        MLog.info((Object)"ReportCoreImpl", (String)"sendReport %s", (Object[])new Object[]{req2});
        this.sendEntRequest((IEntProtocol)req2);
    }

    @BusEvent
    public void onReceive(IEntClient_onReceive_EventArgs busEventArgs) {
        IEntProtocol entProtocol = busEventArgs.getProtocol();
        if (ReportProtocol.MsgMaxType.ACTIVITY_MAX.equals((Object)entProtocol.getMaxType()) && ReportProtocol.ReportResp.sMinType.equals((Object)entProtocol.getMinType())) {
            this.onReportRespond((ReportProtocol.ReportResp)entProtocol);
        }
    }

    private void onReportRespond(ReportProtocol.ReportResp entProtocol) {
        int code = entProtocol.code;
        RxBus.getDefault().post((Object)new IReportClient_onReport_EventArgs(code, entProtocol.mData));
    }

    public void uploadScreenshot(String filepath, final int style2, final String title, final String context) {
        if (TextUtils.isEmpty((CharSequence)filepath)) {
            MLog.info((Object)"ReportCoreImpl", (String)"[uploadScreenshot TextUtils.isEmpty(filepath)]", (Object[])new Object[0]);
            RxBus.getDefault().post((Object)new IReportUploadClient_onUploadFail_EventArgs(context));
            return;
        }
        File mScreenShot = new File(filepath);
        if (!mScreenShot.exists()) {
            MLog.info((Object)"ReportCoreImpl", (String)"[uploadScreenshot !mScreenShot.exists()]", (Object[])new Object[0]);
            RxBus.getDefault().post((Object)new IReportUploadClient_onUploadFail_EventArgs(context));
            return;
        }
        String url = LinkUriProvider.REPORT_PIC_UPLOAD;
        String bucketName = "fansorder";
        String token = LoginProtocol.Factory.get().getWebToken();
        String uid = "" + LoginUtil.getUid();
        ResponseListener<String> successListener = new ResponseListener<String>(){

            public void onResponse(String response) {
                if (MLog.isLogLevelAboveDebug()) {
                    MLog.debug((Object)"ReportCoreImpl", (String)("uploadScreenshot upload pic success:" + response), (Object[])new Object[0]);
                }
                try {
                    String url;
                    JSONObject jData;
                    JSONObject jResult = new JSONObject(response);
                    int result = jResult.optInt("result");
                    if (result == 0 && (jData = jResult.getJSONObject("data")).has("url") && !TextUtils.isEmpty((CharSequence)(url = jData.getString("url")))) {
                        RxBus.getDefault().post((Object)new IReportUploadClient_onUploadSuccess_EventArgs(url, style2, title, context));
                        return;
                    }
                    MLog.info((Object)"ReportCoreImpl", (String)"[uploadScreenshot.IReportUploadClient_onUploadFail_EventArgs]", (Object[])new Object[0]);
                    RxBus.getDefault().post((Object)new IReportUploadClient_onUploadFail_EventArgs(context));
                }
                catch (Exception e) {
                    MLog.info((Object)"ReportCoreImpl", (String)"[uploadScreenshot.Exception IReportUploadClient_onUploadFail_EventArgs]", (Object[])new Object[0]);
                    RxBus.getDefault().post((Object)new IReportUploadClient_onUploadFail_EventArgs(context));
                    MLog.error((Object)"ReportCoreImpl", (Throwable)e);
                }
            }
        };
        ResponseErrorListener errorListener = new ResponseErrorListener(){

            public void onErrorResponse(RequestError error) {
                if (MLog.isLogLevelAboveDebug()) {
                    MLog.debug(ReportCoreImpl.class, (String)"upload pic fail", (Object[])new Object[0]);
                }
                RxBus.getDefault().post((Object)new IReportUploadClient_onUploadFail_EventArgs(context));
            }
        };
        DefaultRequestParam params = new DefaultRequestParam();
        params.put("bucketName", bucketName);
        params.put("uid", uid);
        params.put("token", token);
        params.put("photoUrl", new RequestParam.FileWrapper(mScreenShot, "upload.jpg"));
        RequestManager.instance().submitMultipartPostRequest(url, (RequestParam)params, (ResponseListener)successListener, errorListener, true);
    }

    public Single<IReportCore.UploadResult> uploadScreenShotFlowableRx(final String filepath, final int style2, final String title) {
        return Single.create((SingleOnSubscribe)new SingleOnSubscribe<IReportCore.UploadResult>(){

            public void subscribe(final SingleEmitter<IReportCore.UploadResult> emitter) throws Exception {
                File mScreenShot;
                if (TextUtils.isEmpty((CharSequence)filepath)) {
                    MLog.info((Object)"ReportCoreImpl", (String)"[uploadScreenshot TextUtils.isEmpty(filepath)]", (Object[])new Object[0]);
                    emitter.onError((Throwable)new Exception("TextUtils.isEmpty(filepath)"));
                }
                if (!(mScreenShot = new File(filepath)).exists()) {
                    MLog.info((Object)"ReportCoreImpl", (String)"[uploadScreenshot !mScreenShot.exists()]", (Object[])new Object[0]);
                    emitter.onError((Throwable)new Exception("!mScreenShot.exists()"));
                }
                String url = LinkUriProvider.REPORT_PIC_UPLOAD;
                String bucketName = "fansorder";
                String token = LoginProtocol.Factory.get().getWebToken();
                String uid = "" + LoginUtil.getUid();
                ResponseListener<String> successListener = new ResponseListener<String>(){

                    public void onResponse(String response) {
                        if (MLog.isLogLevelAboveDebug()) {
                            MLog.debug((Object)"ReportCoreImpl", (String)("uploadScreenshot upload pic success:" + response), (Object[])new Object[0]);
                        }
                        try {
                            String url;
                            JSONObject jData;
                            JSONObject jResult = new JSONObject(response);
                            int result = jResult.optInt("result");
                            if (result == 0 && (jData = jResult.getJSONObject("data")).has("url") && !TextUtils.isEmpty((CharSequence)(url = jData.getString("url")))) {
                                emitter.onSuccess((Object)new IReportCore.UploadResult(url, title, style2));
                                return;
                            }
                            MLog.info((Object)"ReportCoreImpl", (String)"[uploadScreenshot.IReportUploadClient_onUploadFail_EventArgs]", (Object[])new Object[0]);
                            emitter.onError((Throwable)new Exception("uploadScreenshot.IReportUploadClient_onUploadFail_EventArgs"));
                        }
                        catch (Exception e) {
                            MLog.error((Object)"ReportCoreImpl", (Throwable)e);
                            emitter.onError((Throwable)e);
                        }
                    }
                };
                ResponseErrorListener errorListener = new ResponseErrorListener(){

                    public void onErrorResponse(RequestError error) {
                        if (MLog.isLogLevelAboveDebug()) {
                            MLog.debug(ReportCoreImpl.class, (String)"upload pic fail", (Object[])new Object[0]);
                        }
                        emitter.onError((Throwable)error);
                    }
                };
                DefaultRequestParam params = new DefaultRequestParam();
                params.put("bucketName", bucketName);
                params.put("uid", uid);
                params.put("token", token);
                params.put("photoUrl", new RequestParam.FileWrapper(mScreenShot, "upload.jpg"));
                RequestManager.instance().submitMultipartPostRequest(url, (RequestParam)params, (ResponseListener)successListener, errorListener, true);
            }
        });
    }
}

