/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.profile.takephoto;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewTreeObserver;
import android.widget.ImageView;
import android.widget.TextView;
import com.yy.mobile.image.ImageConfig;
import com.yy.mobile.imageloader.ImageUtil;
import com.yy.mobile.plugin.pluginunionmain.R;
import com.yy.mobile.ui.profile.takephoto.PictureTakerActivity;
import com.yy.mobile.ui.widget.cropper.CropImageView;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.TimeUtils;
import com.yy.mobile.util.YYFileUtils;
import com.yy.mobile.util.log.MLog;
import java.io.File;

public class PhotoEditController
implements PictureTakerActivity.IController {
    public PictureTakerActivity mAct;
    private boolean mEnableClip;
    public CropImageView mEditView;
    private String bmpTmpPath;
    private int mFrom;
    private View.OnClickListener mRetakeClick = new View.OnClickListener(){

        public void onClick(View v) {
            PhotoEditController.this.mAct.takePhoto();
            PhotoEditController.this.deleteTempImage();
        }
    };
    private View.OnClickListener mOkClick = new View.OnClickListener(){

        public void onClick(View v) {
            try {
                Bitmap bitmap = PhotoEditController.this.mEditView.getCroppedImage();
                if (bitmap != null) {
                    File clipTemp = YYFileUtils.getTempFile((Context)PhotoEditController.this.mAct, (String)("photo_clip_temp" + TimeUtils.curSec() + ".jpg"));
                    YYFileUtils.saveBitmapToJPG((Bitmap)bitmap, (String)clipTemp.getPath());
                    PhotoEditController.this.deleteTempImage();
                    Intent data = new Intent();
                    data.putExtra("portrait_clip_key", clipTemp.getPath());
                    PhotoEditController.this.mAct.setResult(-1, data);
                } else {
                    PhotoEditController.this.mAct.setResult(2);
                }
            }
            catch (Exception e) {
                MLog.error((Object)"PhotoEditController", (Throwable)e);
                PhotoEditController.this.mAct.setResult(2);
            }
            PhotoEditController.this.mAct.finish();
        }
    };
    private View.OnClickListener mRotateClick = new View.OnClickListener(){

        public void onClick(View v) {
            PhotoEditController.this.mEditView.rotateImage(90);
        }
    };

    public PhotoEditController(PictureTakerActivity act, int from) {
        this.mAct = act;
        this.mFrom = from;
    }

    public void enableClipPortrait(boolean enable) {
        this.mEnableClip = enable;
        if (this.mEditView != null) {
            this.mEditView.setEnabled(enable);
        }
    }

    @Override
    public View getContentView() {
        View v = LayoutInflater.from((Context)this.mAct).inflate(R.layout.mn_im_photo_edit, null);
        this.mEditView = (CropImageView)v.findViewById(R.id.photo_edit);
        this.mEditView.setEnabled(this.mEnableClip);
        this.mEditView.setFixedAspectRatio(true);
        v.findViewById(R.id.btn_use).setOnClickListener(this.mOkClick);
        v.findViewById(R.id.btn_retake).setOnClickListener(this.mRetakeClick);
        String retakeText = "\u91cd\u62cd";
        if (this.mFrom == 2 || this.mFrom == 3) {
            retakeText = "\u91cd\u9009";
        }
        ((TextView)v.findViewById(R.id.btn_retake)).setText((CharSequence)retakeText);
        this.initTitleButton(v, R.id.btn_rotate, this.mRotateClick);
        v.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                PhotoEditController.this.mEditView.setAspectRatio(1, 1);
            }
        });
        return v;
    }

    private void initTitleButton(View v, int viewId, View.OnClickListener listener2) {
        ImageView button = (ImageView)v.findViewById(viewId);
        button.setOnClickListener(listener2);
    }

    private void finish() {
        if (this.mAct != null) {
            this.mAct.finish();
        }
    }

    @Override
    public void onResult(String[] paths, int requestCode) {
        String bmpPath = null;
        if (paths.length > 0) {
            bmpPath = paths[0];
        }
        MLog.info((Object)"PhotoEditController", (String)("xuwakao : PhotoEditCtrl onresult, bmpPath = " + bmpPath), (Object[])new Object[0]);
        if (FP.empty((CharSequence)bmpPath) || bmpPath.lastIndexOf(".") == -1) {
            MLog.error((Object)"PhotoEditController", (String)"onResult bmtppath is NULL", (Object[])new Object[0]);
            this.finish();
            return;
        }
        File tempFile = YYFileUtils.getTempFile((Context)this.mAct, (String)("bmp_temp_name" + TimeUtils.curSec() + bmpPath.substring(bmpPath.lastIndexOf("."))));
        String tmpPath = tempFile.getAbsolutePath();
        boolean copySucc = YYFileUtils.copyFile((String)bmpPath, (String)tmpPath);
        if (copySucc) {
            this.bmpTmpPath = tmpPath;
            Bitmap bitmap = ImageUtil.decodeSampledBitmapFile((String)this.bmpTmpPath, (ImageConfig)ImageConfig.defaultImageConfig(), (boolean)true);
            if (bitmap == null) {
                MLog.error((Object)"PhotoEditController", (String)("decodeSampledBitmapFile not successful, onResult bmpPath = " + bmpPath), (Object[])new Object[0]);
                this.finish();
                return;
            }
            this.mEditView.setImageBitmap(bitmap);
        } else {
            MLog.error((Object)"PhotoEditController", (String)("copy file not successful, onResult bmpPath = " + bmpPath), (Object[])new Object[0]);
            this.finish();
        }
    }

    @Override
    public void onCancel() {
        this.deleteTempImage();
        this.mAct.setResult(0);
    }

    public void deleteTempImage() {
        if (this.bmpTmpPath != null) {
            if (MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)"PhotoEditController", (String)("deleteTempImage path=" + this.bmpTmpPath), (Object[])new Object[0]);
            }
            YYFileUtils.removeFile((String)this.bmpTmpPath);
            this.bmpTmpPath = null;
        }
    }
}

