/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.task;

import android.app.ActivityManager;
import android.content.Context;
import android.os.Build;
import android.os.Environment;
import com.yy.mobile.YYMobileApp;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.memoryrecycle.drawablerecycle.DrawableRecycler;
import com.yy.mobile.richtext.media.ImCacheSetting;
import com.yy.mobile.ui.setting.DownLoadNotification;
import com.yy.mobile.ui.subscribebroadcast.ISubscribeBroadcastCore;
import com.yy.mobile.ui.widget.fps.FpsView;
import com.yy.mobile.ui.widget.reportbug.ReportBugView;
import com.yy.mobile.util.ResolutionUtils;
import com.yy.mobile.util.SystemUtils;
import com.yy.mobile.util.VersionUtil;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.util.pref.CommonPref;
import com.yy.mobile.util.taskexecutor.YYTaskExecutor;
import com.yymobile.core.AppConstants;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.CoreManager;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.artist.IArtistCore;
import com.yymobile.core.broadcastgroup.PComSubBcGroupCore;
import com.yymobile.core.livepush.ILivePushCore;
import com.yymobile.core.mobilelive.ILivePluginCore;
import com.yymobile.core.mobilelive.IMobileLiveReplayCore;
import com.yymobile.core.performancemonitor.PerformanceMonitorSwitchController;
import com.yymobile.core.sensitivewords.ISensitiveWordsCore;
import com.yymobile.core.setting.ISettingCore;
import com.yymobile.core.statistic.IHiidoStatisticCore;
import java.io.File;
import java.util.HashMap;

public class LazyRun
implements Runnable {
    public static final String IM_IMG_CACHE_DIR = AppConstants.IM_IMG_CACHE_DIR;
    public static final String IM_VOICE_CACHE_DIR = AppConstants.IM_VOICE_CACHE_DIR;
    private Context mContext;

    LazyRun(Context context) {
        this.mContext = context;
    }

    @Override
    public void run() {
        long startTime = System.currentTimeMillis();
        DownLoadNotification.instance().init(this.mContext);
        BasicConfig.getInstance().setTurnTableDir(CoreManager.YYMOBILE_DIR_NAME + File.separator + "turntable");
        BasicConfig.getInstance().setBigGiftEffectDir(CoreManager.YYMOBILE_DIR_NAME + File.separator + "bigGiftEffect");
        BasicConfig.getInstance().setGiftAnimationDir(CoreManager.YYMOBILE_DIR_NAME + File.separator + "giftanimation");
        this.setPhoneType();
        this.coreManagerInit();
        if (BasicConfig.getInstance().isDebuggable() && CommonPref.instance().getBoolean("PRE_SETTING_JUMP_TO_FPS", false)) {
            FpsView.instance(this.mContext, this.mContext.getPackageName()).addToStage(0, (int)ResolutionUtils.convertDpToPixel((float)50.0f, (Context)this.mContext), (int)ResolutionUtils.convertDpToPixel((float)100.0f, (Context)this.mContext), (int)ResolutionUtils.convertDpToPixel((float)50.0f, (Context)this.mContext));
        }
        if (BasicConfig.getInstance().isDebuggable() && CommonPref.instance().getBoolean("PRE_SETTING_JUMP_TO_REPORT_BUG", false)) {
            ReportBugView.instance((Context)YYMobileApp.gContext, YYMobileApp.gContext.getPackageName()).addToStage(0, (int)ResolutionUtils.convertDpToPixel((float)50.0f, (Context)this.mContext), (int)ResolutionUtils.convertDpToPixel((float)100.0f, (Context)this.mContext), (int)ResolutionUtils.convertDpToPixel((float)50.0f, (Context)this.mContext));
        }
        if (BasicConfig.getInstance().isDebuggable() && CommonPref.instance().getBoolean("PRE_SETTING_JUMP_TO_CHANNELVIEW", false)) {
            ((ILivePluginCore)ICoreManagerBase.getCore(ILivePluginCore.class)).addToStage();
        }
        SystemUtils.fixMediaSessionLegacyHelper();
        this.logInfo();
        ImCacheSetting.instance().init(IM_IMG_CACHE_DIR, IM_VOICE_CACHE_DIR);
        this.statisAppStart();
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                PerformanceMonitorSwitchController.onStartupFinished();
            }
        }, (long)5000L);
        long cost = System.currentTimeMillis() - startTime;
        MLog.info((Object)"LazyRun", (String)("LazyRun cost : " + cost), (Object[])new Object[0]);
        DrawableRecycler.updateSwitch((boolean)PerformanceMonitorSwitchController.isAutoRecycleDrawableSwitchOn());
        this.initAutoRecycleDrawableTestSwitch();
    }

    private void initAutoRecycleDrawableTestSwitch() {
        if (BasicConfig.getInstance().isDebuggable()) {
            YYTaskExecutor.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    File colseFlagFile = new File(Environment.getExternalStorageDirectory().getPath() + File.separator + "autorecycleclose.txt");
                    if (colseFlagFile.exists()) {
                        DrawableRecycler.updateSwitch((boolean)false);
                    }
                }
            }, (long)600L);
        }
    }

    private void logInfo() {
        MLog.info((Object)"LazyRun", (String)("YYVersion:" + VersionUtil.getLocalVer((Context)BasicConfig.getInstance().getAppContext()).aboutDisplayName(BasicConfig.getInstance().getAppContext())), (Object[])new Object[0]);
    }

    private void statisAppStart() {
        HashMap<String, String> map = new HashMap<String, String>(1);
        map.put("key1", "START");
        long userId = LoginUtil.getUid();
        ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic(userId, "52002", "0001", map);
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)"LazyRun", (String)"EVENT_ID_PERF_MONITOR, app start,userId=%d ", (Object[])new Object[]{userId});
        }
    }

    private void setPhoneType() {
        ActivityManager am = (ActivityManager)this.mContext.getSystemService("activity");
        final ActivityManager.MemoryInfo mi = new ActivityManager.MemoryInfo();
        am.getMemoryInfo(mi);
        int memoryOneG = 0x40000000;
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (-1 == BasicConfig.getInstance().defaultPhoneType) {
                    try {
                        int sdkVer = Build.VERSION.SDK_INT;
                        if (sdkVer < 18) {
                            BasicConfig.getInstance().setPhoneType(0);
                        } else if (sdkVer == 18) {
                            BasicConfig.getInstance().setPhoneType(mi.totalMem <= 0x40000000L ? 0 : 1);
                        } else if (sdkVer > 18) {
                            if (Build.MANUFACTURER.equals("Xiaomi")) {
                                BasicConfig.getInstance().setPhoneType(mi.totalMem <= 0x40000000L ? 0 : 2);
                            } else {
                                BasicConfig.getInstance().setPhoneType(mi.totalMem <= 0x40000000L ? 1 : 2);
                            }
                        }
                        if (sdkVer < 18) {
                            MLog.info((Object)"LazyRun", (String)("=api" + sdkVer + " the phone type is:" + BasicConfig.getInstance().phoneType), (Object[])new Object[0]);
                        } else {
                            MLog.info((Object)"LazyRun", (String)("=api" + sdkVer + " the phone type is:" + BasicConfig.getInstance().phoneType + ":" + mi.totalMem), (Object[])new Object[0]);
                        }
                    }
                    catch (Exception e) {
                        MLog.error((Object)"LazyRun", (Throwable)e);
                        BasicConfig.getInstance().setPhoneType(0);
                    }
                }
            }
        });
    }

    private void coreManagerInit() {
        CoreFactory.getCore(ISettingCore.class);
        CoreFactory.getCore(ISubscribeBroadcastCore.class);
        ((ISettingCore)CoreManager.getCore(ISettingCore.class)).delayCacheShrink();
        CoreManager.getCore(IArtistCore.class);
        CoreFactory.getCore(ILivePushCore.class);
        CoreManager.getCore(ISensitiveWordsCore.class);
        CoreManager.getCore(IMobileLiveReplayCore.class);
        CoreManager.getCore(PComSubBcGroupCore.class);
    }
}

