/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.common;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Looper;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.ui.widget.dialog.ReportPopupDialog;
import com.yy.mobile.util.SafeDispatchHandler;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.ylink.bridge.CoreApiManager;
import com.yy.mobile.ylink.bridge.coreapi.BaseFragmentApi;
import java.util.Map;

public class ReportManager {
    public static final SafeDispatchHandler hanlder = new SafeDispatchHandler(Looper.getMainLooper());

    public static void showReportDialog(final Activity activity, final int type, final long child, final long suid, final String content, final String extParUrlEncoder, final String extProductorParm, final Map<String, String> extendInfo, final ReportPopupDialog.OnReportItemClickListener mOnReportItemClickListener, final DialogInterface.OnDismissListener dismissListener) {
        hanlder.post(new Runnable(){

            @Override
            public void run() {
                if (!ReportManager.checkActivityValid(activity)) {
                    return;
                }
                if (LoginUtil.isLogined()) {
                    this.showReportPopupDialog(activity, type, child, suid, content, extParUrlEncoder, extProductorParm, extendInfo, mOnReportItemClickListener, dismissListener);
                } else {
                    ((BaseFragmentApi)CoreApiManager.getInstance().getApi(BaseFragmentApi.class)).showLoginDialog(activity);
                }
            }

            private void showReportPopupDialog(Activity activity2, int type2, long chid, long suid2, String content2, String extParUrlEncoder2, String extProductorParm2, Map<String, String> extendInfo2, ReportPopupDialog.OnReportItemClickListener mOnReportItemClickListener2, DialogInterface.OnDismissListener dismissListner) {
                ReportPopupDialog mDialog = new ReportPopupDialog((Context)activity2, type2, chid, suid2, content2, extParUrlEncoder2, extProductorParm2, extendInfo2, mOnReportItemClickListener2);
                mDialog.setCancelable(true);
                mDialog.setCanceledOnTouchOutside(true);
                mDialog.setOnDismissListener(dismissListner);
                mDialog.show();
            }
        });
    }

    @TargetApi(value=17)
    public static boolean checkActivityValid(Activity act) {
        if (act == null) {
            MLog.warn((Object)"ReportManager", (String)" not attached to Activity", (Object[])new Object[0]);
            return false;
        }
        if (act.isFinishing()) {
            MLog.warn((Object)"ReportManager", (String)"activity is finishing", (Object[])new Object[0]);
            return false;
        }
        if (act.isDestroyed()) {
            MLog.warn((Object)"ReportManager", (String)"activity is isDestroyed", (Object[])new Object[0]);
            return false;
        }
        return true;
    }
}

