/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.report;

import android.content.Context;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.EditText;
import com.yy.hiidostatis.defs.obj.Property;
import com.yy.mobile.RxBus;
import com.yy.mobile.baseapi.model.store.YYStore;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.model.ReqAction;
import com.yy.mobile.plugin.pluginunionmain.R;
import com.yy.mobile.ui.report.ReportPagerFragment;
import com.yy.mobile.ui.report.listener.ReportViewPageChangedListener;
import com.yy.mobile.util.ImeUtil;
import com.yy.mobile.util.RxUtils;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.im.event.IsInBlackListByServerEventArgs;
import com.yymobile.core.im.request.IsInBalckByServerAction;
import com.yymobile.core.statistic.IHiidoStatisticCore;
import io.reactivex.annotations.NonNull;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class ReportSubmitFragment
extends ReportPagerFragment {
    private static final String TAG = "ReportSubmitFragment";
    public static final String REPORT_USER_ID = "report_user_id";
    private View mRootView;
    private View mBlackListlayout;
    private CheckBox mCheckBox;
    private EditText mEditText;
    private ReportViewPageChangedListener mListener;
    private boolean mRequested = false;
    private boolean mIsShielding = false;
    private long mUserId;
    private List<Disposable> mEventDisposable = new ArrayList<Disposable>();

    public static ReportSubmitFragment newInstance(long userId) {
        ReportSubmitFragment submitFragment = new ReportSubmitFragment();
        Bundle bundle = new Bundle();
        bundle.putLong(REPORT_USER_ID, userId);
        submitFragment.setArguments(bundle);
        return submitFragment;
    }

    @Override
    public void setReportViewPageChangedListener(ReportViewPageChangedListener listener2) {
        this.mListener = listener2;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.registerEvent();
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        if (this.getArguments() != null) {
            this.mUserId = this.getArguments().getLong(REPORT_USER_ID, 0L);
        }
        this.mRootView = inflater.inflate(R.layout.fragment_report_submit, container, false);
        this.mRootView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ReportSubmitFragment.this.hideImeKeyboard();
            }
        });
        this.mEditText = (EditText)this.mRootView.findViewById(R.id.report_submit_edit);
        this.mBlackListlayout = this.mRootView.findViewById(R.id.report_submit_radio_layout);
        this.mCheckBox = (CheckBox)this.mRootView.findViewById(R.id.report_submit_check);
        this.mCheckBox.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                ReportSubmitFragment.this.mIsShielding = isChecked;
                ReportSubmitFragment.this.hideImeKeyboard();
            }
        });
        this.mRootView.findViewById(R.id.report_submit_btn).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (ReportSubmitFragment.this.mListener != null) {
                    ReportSubmitFragment.this.hideImeKeyboard();
                    String strDesc = "";
                    if (ReportSubmitFragment.this.mEditText != null && ReportSubmitFragment.this.mEditText.getText() != null) {
                        strDesc = ReportSubmitFragment.this.mEditText.getText().toString();
                    }
                    if (ReportSubmitFragment.this.mBlackListlayout.getVisibility() == 0) {
                        ReportSubmitFragment.this.mIsShielding = ReportSubmitFragment.this.mCheckBox.isChecked();
                    } else {
                        ReportSubmitFragment.this.mIsShielding = false;
                    }
                    Property property = new Property();
                    property.putString("key1", String.valueOf(ReportSubmitFragment.this.mUserId));
                    if (ReportSubmitFragment.this.mIsShielding) {
                        property.putString("key2", "1");
                    } else {
                        property.putString("key2", "0");
                    }
                    ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "52601", "0003", (Serializable)property);
                    if (ReportSubmitFragment.this.checkNetToast()) {
                        ReportSubmitFragment.this.mListener.onReportViewPageSubmited(2, ReportSubmitFragment.this.mIsShielding, strDesc);
                    }
                }
            }
        });
        return this.mRootView;
    }

    public void onResume() {
        super.onResume();
        if (!this.mRequested) {
            this.mRequested = true;
            YYStore.INSTANCE.dispatch((ReqAction)new IsInBalckByServerAction(this.mUserId));
        }
    }

    public void onDestroy() {
        this.unregisterEvent();
        super.onDestroy();
    }

    private void registerEvent() {
        Disposable item = RxBus.getDefault().register(IsInBlackListByServerEventArgs.class, (Object)this).subscribe((Consumer)new Consumer<IsInBlackListByServerEventArgs>(){

            public void accept(@NonNull IsInBlackListByServerEventArgs eventArgs) throws Exception {
                MLog.info((Object)ReportSubmitFragment.TAG, (String)("IsInBlackListByServerEventArgs bid = " + eventArgs.getUid() + " mUserId = " + ReportSubmitFragment.this.mUserId + " isBlack:" + eventArgs.isBlack()), (Object[])new Object[0]);
                if (ReportSubmitFragment.this.mRequested && eventArgs.getResCode() == 200 && eventArgs.getUid() == ReportSubmitFragment.this.mUserId) {
                    ReportSubmitFragment.this.mRequested = false;
                    if (ReportSubmitFragment.this.mBlackListlayout != null) {
                        ReportSubmitFragment.this.mBlackListlayout.setVisibility(eventArgs.isBlack() ? 8 : 0);
                    }
                }
            }
        }, RxUtils.errorConsumer((String)TAG));
        this.mEventDisposable.add(item);
    }

    private void unregisterEvent() {
        if (this.mEventDisposable != null) {
            for (Disposable disposable : this.mEventDisposable) {
                if (disposable == null || disposable.isDisposed()) continue;
                disposable.dispose();
            }
            this.mEventDisposable.clear();
        }
    }

    private void hideImeKeyboard() {
        if (this.mEditText != null) {
            this.mEditText.clearFocus();
            ImeUtil.hideIME((Context)this.getActivity(), (View)this.mEditText);
        }
    }
}

