/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.notify;

import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import android.provider.CalendarContract;
import android.text.TextUtils;
import java.util.Calendar;
import java.util.TimeZone;

public class CalenderUtils {
    private static String CALANDER_URL = "content://com.android.calendar/calendars";
    private static String CALANDER_EVENT_URL = "content://com.android.calendar/events";
    private static String CALANDER_REMIDER_URL = "content://com.android.calendar/reminders";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int checkCalendarAccount(Context context) {
        try (Cursor userCursor = context.getContentResolver().query(Uri.parse((String)CALANDER_URL), null, null, null, null);){
            if (userCursor == null) {
                int n = -1;
                return n;
            }
            System.out.println("Count: " + userCursor.getCount());
            userCursor.moveToFirst();
            if (!userCursor.isAfterLast()) {
                int ret = userCursor.getInt(userCursor.getColumnIndex("_id"));
                System.out.println("name: " + ret);
                int n = ret;
                return n;
            }
        }
        return -1;
    }

    private static int addCalendarAccount(Context context) {
        TimeZone timeZone = TimeZone.getDefault();
        ContentValues value = new ContentValues();
        value.put("name", "yy");
        value.put("account_name", "yyandroid@yy.com");
        value.put("account_type", "com.android.exchange");
        value.put("calendar_displayName", "myYY");
        value.put("visible", Integer.valueOf(1));
        value.put("calendar_color", Integer.valueOf(-256));
        value.put("calendar_access_level", Integer.valueOf(700));
        value.put("sync_events", Integer.valueOf(1));
        value.put("calendar_timezone", timeZone.getID());
        value.put("ownerAccount", "yyandroid@yy.com");
        value.put("canOrganizerRespond", Integer.valueOf(0));
        Uri calendarUri = CalendarContract.Calendars.CONTENT_URI;
        calendarUri = calendarUri.buildUpon().appendQueryParameter("caller_is_syncadapter", "true").appendQueryParameter("account_name", "mygmailaddress@gmail.com").appendQueryParameter("account_type", "com.android.exchange").build();
        context.getContentResolver().insert(calendarUri, value);
        return 1;
    }

    private static int checkAndAddCalendarAccount(Context context) {
        int oldId = CalenderUtils.checkCalendarAccount(context);
        if (oldId >= 0) {
            return oldId;
        }
        long addId = CalenderUtils.addCalendarAccount(context);
        if (addId >= 0L) {
            return CalenderUtils.checkCalendarAccount(context);
        }
        return -1;
    }

    public static void addCalendarEvent(Context context, String title, String description, long beginTime) {
        int calId = CalenderUtils.checkAndAddCalendarAccount(context);
        if (calId < 0) {
            return;
        }
        ContentValues event = new ContentValues();
        event.put("title", title);
        event.put("description", description);
        event.put("calendar_id", Integer.valueOf(calId));
        Calendar mCalendar = Calendar.getInstance();
        mCalendar.setTimeInMillis(beginTime);
        long start = mCalendar.getTime().getTime();
        mCalendar.setTimeInMillis(start + 60000L);
        long end = mCalendar.getTime().getTime();
        event.put("dtstart", Long.valueOf(start));
        event.put("dtend", Long.valueOf(end));
        event.put("hasAlarm", Integer.valueOf(1));
        event.put("eventTimezone", "Asia/Shanghai");
        Uri newEvent = context.getContentResolver().insert(Uri.parse((String)CALANDER_EVENT_URL), event);
        if (newEvent == null) {
            return;
        }
        ContentValues values = new ContentValues();
        values.put("event_id", Long.valueOf(ContentUris.parseId((Uri)newEvent)));
        values.put("minutes", Integer.valueOf(5));
        values.put("method", Integer.valueOf(1));
        Uri uri = context.getContentResolver().insert(Uri.parse((String)CALANDER_REMIDER_URL), values);
        if (uri == null) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteCalendarEvent(Context context, String title) {
        try (Cursor eventCursor = context.getContentResolver().query(Uri.parse((String)CALANDER_EVENT_URL), null, null, null, null);){
            if (eventCursor == null) {
                return;
            }
            if (eventCursor.getCount() > 0) {
                eventCursor.moveToFirst();
                while (!eventCursor.isAfterLast()) {
                    String eventTitle = eventCursor.getString(eventCursor.getColumnIndex("title"));
                    if (!TextUtils.isEmpty((CharSequence)title) && title.equals(eventTitle)) {
                        int id2 = eventCursor.getInt(eventCursor.getColumnIndex("_id"));
                        Uri deleteUri = ContentUris.withAppendedId((Uri)Uri.parse((String)CALANDER_EVENT_URL), (long)id2);
                        int rows = context.getContentResolver().delete(deleteUri, null, null);
                        if (rows == -1) {
                            return;
                        }
                    }
                    eventCursor.moveToNext();
                }
            }
        }
    }

    public static void addEventByIntent(Context context) {
        Calendar beginTime = Calendar.getInstance();
        beginTime.set(2012, 0, 19, 7, 30);
        Calendar endTime = Calendar.getInstance();
        endTime.set(2012, 0, 19, 8, 30);
        Intent intent = new Intent("android.intent.action.INSERT").setData(CalendarContract.Events.CONTENT_URI).putExtra("beginTime", beginTime.getTimeInMillis()).putExtra("endTime", endTime.getTimeInMillis()).putExtra("title", "Yoga").putExtra("description", "Group class").putExtra("eventLocation", "The gym").putExtra("availability", 0).putExtra("android.intent.extra.EMAIL", "rowan@example.com,trevor@example.com");
        context.startActivity(intent);
    }

    static Uri asSyncAdapter(Uri uri, String account, String accountType) {
        return uri.buildUpon().appendQueryParameter("caller_is_syncadapter", "true").appendQueryParameter("account_name", account).appendQueryParameter("account_type", accountType).build();
    }
}

