/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.Interpolator;
import android.view.animation.ScaleAnimation;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.image.ImageConfig;
import com.yy.mobile.imageloader.ImageLoader;
import com.yy.mobile.plugin.pluginunionmain.R;
import com.yy.mobile.ui.utils.DensityUtil;
import com.yy.mobile.util.DimenConverter;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.YYImageUtils;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.live.gson.RightBtnInfo;

public class CommTitleUICreator {
    public static void startCustomAnimation(final TextView v, int currentNum, int resultNum) {
        int addNum;
        int mod;
        if (currentNum == resultNum) {
            return;
        }
        if (currentNum > resultNum) {
            v.setText((CharSequence)String.valueOf(resultNum));
            return;
        }
        int diffValue = resultNum - currentNum;
        int repeatCount = 0;
        final int nowNums = currentNum;
        if (diffValue > 0) {
            if (diffValue == 1) {
                repeatCount = 2;
                mod = 0;
                addNum = 1;
            } else if (diffValue == 2) {
                repeatCount = 4;
                mod = 0;
                addNum = 1;
            } else {
                repeatCount = 6;
                mod = diffValue % 3;
                addNum = diffValue / 3;
            }
        } else {
            mod = 0;
            addNum = 0;
        }
        ScaleAnimation scaleAnimation = new ScaleAnimation(1.0f, 1.2f, 1.0f, 1.2f, 1, 0.5f, 1, 0.5f);
        scaleAnimation.setInterpolator((Interpolator)new AccelerateInterpolator());
        scaleAnimation.setDuration(100L);
        scaleAnimation.setAnimationListener(new Animation.AnimationListener(){
            int mCurrentNum;
            int mCurrentTimes;
            {
                this.mCurrentNum = nowNums;
                this.mCurrentTimes = 0;
            }

            public void onAnimationStart(Animation animation) {
                ViewParent parent = v.getParent();
                if (parent != null && parent instanceof ViewGroup) {
                    ((ViewGroup)parent).setBackgroundResource(R.drawable.bg_corner_highlight);
                }
                this.mCurrentNum += addNum + mod;
                v.setText((CharSequence)String.valueOf(this.mCurrentNum));
                ++this.mCurrentTimes;
            }

            public void onAnimationEnd(Animation animation) {
                ViewParent parent = v.getParent();
                if (parent != null && parent instanceof ViewGroup) {
                    ((ViewGroup)parent).setBackgroundResource(R.drawable.bg_corner_gray);
                }
            }

            public void onAnimationRepeat(Animation animation) {
                ++this.mCurrentTimes;
                if (this.mCurrentTimes % 2 == 1) {
                    this.mCurrentNum += addNum;
                    v.setText((CharSequence)String.valueOf(this.mCurrentNum));
                }
            }
        });
        scaleAnimation.setRepeatCount(repeatCount - 1);
        scaleAnimation.setRepeatMode(2);
        AnimationSet animatorSet = new AnimationSet(true);
        animatorSet.addAnimation((Animation)scaleAnimation);
        v.startAnimation((Animation)animatorSet);
    }

    public static void initIcon(final Context context, final String imgUrl, final TextView textView) {
        if (context == null || textView == null) {
            return;
        }
        if (!StringUtils.isNullOrEmpty((String)imgUrl)) {
            final ImageConfig imageConfig = ImageConfig.defaultImageConfig();
            BitmapDrawable drawable2 = ImageLoader.getBitmapFromCache((String)imgUrl, (ImageConfig)imageConfig);
            int drawableWidth = DensityUtil.dip2px((Context)context, (float)16.0f);
            if (null != drawable2) {
                Bitmap bitmap = YYImageUtils.resize((Bitmap)drawable2.getBitmap(), (int)drawableWidth, (int)drawableWidth);
                if (null != bitmap) {
                    BitmapDrawable bigDrawable = new BitmapDrawable(context.getResources(), bitmap);
                    bigDrawable.setBounds(0, 0, drawableWidth, drawableWidth);
                    textView.setCompoundDrawables((Drawable)bigDrawable, null, null, null);
                }
            } else {
                ImageLoader.loadBitmap((Context)BasicConfig.getInstance().getAppContext(), (String)imgUrl, (ImageLoader.BitmapLoadListener)new ImageLoader.BitmapLoadListener(){

                    public void onLoadFailed(Exception e) {
                        MLog.error((Object)"webview rightitem", (String)"load img error", (Object[])new Object[0]);
                    }

                    public void onResourceReady(Bitmap bitmap) {
                        if (bitmap != null) {
                            ImageLoader.addBitmapToCache((String)imgUrl, (BitmapDrawable)new BitmapDrawable(context.getResources(), bitmap), (ImageConfig)imageConfig);
                            int drawableWidth = DensityUtil.dip2px((Context)context, (float)16.0f);
                            Bitmap bitmap2 = YYImageUtils.resize((Bitmap)bitmap, (int)drawableWidth, (int)drawableWidth);
                            if (null != bitmap2) {
                                BitmapDrawable bigDrawable = new BitmapDrawable(context.getResources(), bitmap2);
                                bigDrawable.setBounds(0, 0, drawableWidth, drawableWidth);
                                textView.setCompoundDrawables((Drawable)bigDrawable, null, null, null);
                            }
                        }
                    }
                });
            }
        }
    }

    public static void createTaskRightView(Context context, RightBtnInfo info, ViewGroup containView, View.OnClickListener listener2) {
        if (context == null || info == null || containView == null) {
            return;
        }
        RelativeLayout wrapLayout = new RelativeLayout(context);
        wrapLayout.setOnClickListener(listener2);
        if (info.hidden) {
            wrapLayout.setVisibility(8);
        } else {
            wrapLayout.setVisibility(0);
        }
        TextView textView = new TextView(context);
        textView.setTextSize(15.0f);
        textView.setGravity(17);
        textView.setText((CharSequence)String.valueOf(info.title));
        if (info.enable) {
            textView.setTextColor(Color.parseColor((String)"#333333"));
            wrapLayout.setEnabled(true);
        } else {
            textView.setTextColor(Color.parseColor((String)"#cccccc"));
            wrapLayout.setEnabled(false);
        }
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
        int margin = DimenConverter.dip2px((Context)context, (float)8.0f);
        CommTitleUICreator.initIcon(context, info.img, textView);
        textView.setPadding(margin, 0, margin, 0);
        wrapLayout.addView((View)textView, (ViewGroup.LayoutParams)layoutParams);
        wrapLayout.setBackgroundResource(R.drawable.bg_corner_gray);
        wrapLayout.setGravity(17);
        containView.addView((View)wrapLayout);
        Object diamondNum = containView.getTag();
        int currentNum = 0;
        int resultNum = 0;
        try {
            resultNum = Integer.valueOf(info.title);
            if (diamondNum != null) {
                currentNum = Integer.valueOf(diamondNum.toString());
            }
        }
        catch (Throwable t) {
            MLog.error((Object)"CommTitleUICreator", (String)t.getMessage(), (Object[])new Object[0]);
        }
        containView.setTag((Object)info.title);
        if (diamondNum == null || info.style.equalsIgnoreCase(RightBtnInfo.STYLE_TASK_DEFAULT)) {
            textView.setText((CharSequence)info.title);
        } else {
            CommTitleUICreator.startCustomAnimation(textView, currentNum, resultNum);
        }
    }
}

