/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.sharpgirls;

import android.app.Activity;
import android.content.Context;
import android.content.res.Configuration;
import android.media.AudioManager;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.text.SpannableString;
import android.text.style.ForegroundColorSpan;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.SeekBar;
import android.widget.TextView;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.mobile.android.arouter.facade.annotation.Autowired;
import com.yy.mobile.android.arouter.facade.annotation.AutowiredDoc;
import com.yy.mobile.plugin.main.events.IConnectivityClient_onConnectivityChange_EventArgs;
import com.yy.mobile.plugin.pluginunionmain.R;
import com.yy.mobile.sdkwrapper.player.vod.PlayerCallback;
import com.yy.mobile.sdkwrapper.player.vod.SmallVideoPlayer;
import com.yy.mobile.sdkwrapper.player.vod.SmallVideoPlayerManager;
import com.yy.mobile.sdkwrapper.yylive.utils.ConstantsWrapper;
import com.yy.mobile.ui.BaseFragment;
import com.yy.mobile.ui.sharpgirls.VLCVideoSimpleFragment$$EventBinder;
import com.yy.mobile.ui.utils.DurationUtils;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.ImeUtil;
import com.yy.mobile.util.NetworkUtils;
import com.yy.mobile.util.ResolutionUtils;
import com.yy.mobile.util.SafeDispatchHandler;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.util.pref.CommonPref;
import com.yymobile.core.utils.IConnectivityCore;
import java.lang.ref.WeakReference;

public class VLCVideoSimpleFragment
extends BaseFragment
implements SeekBar.OnSeekBarChangeListener,
View.OnClickListener,
PlayerCallback {
    private static final String TAG = "VLCVideoSimpleFragment";
    public static final String FRAGMENT_TAG = "com.yy.yyent.tag.yyplayVideoFragment";
    public static final String PARAM_ANCHOR_NAME = "param_anchor_name";
    public static final String PARAM_VIDEOID = "param_videoid";
    public static final String PARAM_ANCHOR_UID = "param_uid";
    public static final String PARAM_COMMENT_QUANTITY = "param_comment_quantity";
    public static final String PARAM_COMEFROM = "param_comfrom";
    public static final String PARAM_VIDEO_URL = "param_video_url";
    public static final String PARAM_VIDEO_FULL = "param_video_full";
    public static final String PARAM_VISITCOUNT = "param_visitCount";
    public static final String PARAM_CREATE_TIME = "param_create_time";
    public static final String PARAM_PIC_URL = "param_pic_url";
    public static final String PARAM_PORTRAIT_FULLSCREEN = "param_portrait_fullscreen";
    private static int GESTURE_FLAG = 0;
    private static final int GESTURE_CHANNEL_CLOSE = 1;
    private static final int GESTURE_MODIFY_VOLUME = 2;
    private static final float GESTURE_STEP_VOLUME = 10.0f;
    private static final float GESTURE_STEP_CLOSE = 50.0f;
    private static final int FLAG_PLAYING = 1;
    private static final int FLAG_PAUSE = 2;
    private static final int FLAG_STOP = 64;
    private static final int DEFAULT_HIDE_TIME = 5000;
    private int mStateFlag = 64;
    private SmallVideoPlayer mYYPlayer;
    private static final int START_PLAY_VIDEO = 100;
    private static final int STOP_PLAY_VIDEO = 101;
    private static final int HANDLER_TANMU = 102;
    private String mFilePath;
    private boolean isCurrentPortrait = true;
    private int lastPlayTime = 0;
    private int cacheProgress;
    private int totalLength;
    private static final int MAX_RETRY = 5;
    private int errorCount = 0;
    private View mRootView;
    private TextView totalTime;
    private ImageView btnPlayPause;
    private SeekBar seekBar;
    private ImageView btnTanmu;
    private ImageView btnFullScreen;
    private View videoCtrl;
    private RelativeLayout vlcVideoContainer;
    private View mBack;
    private ProgressBar mVideoBufferingPBar;
    private boolean beginTongJi = true;
    private int openVideoTimes = 1;
    private float mStepVolumePX;
    private float mTouchClosePX;
    private static final String CHANNEL_VIDEO_CURRENT_VOLUME = "channel_video_current_volume";
    private AudioManager mAudioManager;
    private int mMaxVolume;
    private int mCurrentVolume;
    private int mScreenWidth;
    private int mMinFlingVelocit;
    private int mMaxFlingVelocit;
    private VelocityTracker mVelocityTracker;
    private int mFlingSlop;
    public boolean mShareBtnClick = false;
    public boolean mIsClearTime = false;
    private boolean ifFromChannel = false;
    @AutowiredDoc(desc="\u7ad6\u5c4f\u64ad\u653e\u7684\u65f6\u5019\uff0c\u662f\u5426\u89c6\u9891\u5168\u5c4f\uff0c\u9ed8\u8ba4\u4e3afalse\uff0c\u7ad6\u5c4f\u89c6\u9891\u89c6\u56fe\u5bbd\u9ad8\u6bd44\uff1a3", eg="true", minVer="7.9")
    @Autowired(name="param_portrait_fullscreen")
    boolean isPortraitFullscreen = false;
    private static final String PREF_MONTHLY_TRAFFIC_SHENQU_SHOW_RELOAD_MSG = "pref_monthly_traffic_shenqu_show_reload_msg";
    private static final String PREF_MONTHLY_TRAFFIC_SHENQU_SHOW_FREE_TEXT_DAY = "pref_monthly_traffic_shenqu_show_free_text_day";
    private static final int ORIENTATION_LANDSCAPE_OFFSET = 251;
    private static final int ORIENTATION_PORTRAIT_OFFSET = 143;
    private boolean isProxyEnabled = false;
    private View mTrafficFreeImage;
    private View mTrafficFreeTv;
    private Handler mEventHandler = new MyHandler(this);
    private Runnable hideVideoCtrlRunnable = new Runnable(){

        @Override
        public void run() {
            VLCVideoSimpleFragment.this.videoCtrl.setVisibility(8);
            if (VLCVideoSimpleFragment.this.mTrafficFreeImage != null) {
                VLCVideoSimpleFragment.this.mTrafficFreeImage.setVisibility(8);
            }
        }
    };
    private static int oldTime = -1;
    private Runnable progressUpdateRunnable = new Runnable(){

        @Override
        public void run() {
            if (VLCVideoSimpleFragment.this.mYYPlayer != null) {
                int currentTime;
                VLCVideoSimpleFragment.this.seekBar.setProgress((int)VLCVideoSimpleFragment.this.mYYPlayer.getTime());
                if (MLog.isLogLevelAboveDebug()) {
                    MLog.debug((Object)VLCVideoSimpleFragment.TAG, (String)"progressUpdateRunnable total=%d,current=%d", (Object[])new Object[]{VLCVideoSimpleFragment.this.mYYPlayer.getLength(), VLCVideoSimpleFragment.this.mYYPlayer.getTime()});
                }
                try {
                    VLCVideoSimpleFragment.this.totalTime.setText((CharSequence)(DurationUtils.intToDurationString((int)((int)VLCVideoSimpleFragment.this.mYYPlayer.getTime() / 1000)) + "/" + DurationUtils.intToDurationString((int)((int)VLCVideoSimpleFragment.this.mYYPlayer.getLength() / 1000))));
                    VLCVideoSimpleFragment.this.changeTextColor();
                }
                catch (Exception e) {
                    MLog.error((Object)VLCVideoSimpleFragment.TAG, (String)e.toString(), (Object[])new Object[0]);
                }
                if (VLCVideoSimpleFragment.this.mEventHandler != null && (currentTime = (int)(VLCVideoSimpleFragment.this.mYYPlayer.getTime() / 1000L)) != oldTime) {
                    oldTime = currentTime;
                    Message message = VLCVideoSimpleFragment.this.mEventHandler.obtainMessage();
                    message.arg1 = currentTime;
                    message.what = 102;
                    VLCVideoSimpleFragment.this.mEventHandler.sendMessage(message);
                }
            }
        }
    };
    private FullScrennClickListener mFullScrennClickListener;
    private EventBinder mVLCVideoSimpleFragmentSniperEventBinder;

    public static VLCVideoSimpleFragment newInstance(String url, boolean full) {
        VLCVideoSimpleFragment fragment = new VLCVideoSimpleFragment();
        Bundle bundle = new Bundle();
        bundle.putString(PARAM_VIDEO_URL, url);
        bundle.putBoolean(PARAM_VIDEO_FULL, full);
        fragment.setArguments(bundle);
        return fragment;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        String rawUrl = this.getArguments().getString(PARAM_VIDEO_URL);
        this.ifFromChannel = this.getArguments().getBoolean(PARAM_VIDEO_FULL);
        this.mFilePath = rawUrl;
        this.isCurrentPortrait = this.ifFromChannel;
        MLog.info((Object)TAG, (String)"onCreate isCurrentPortrait = %b, video url mFilePath=%s", (Object[])new Object[]{this.isCurrentPortrait, this.mFilePath});
        oldTime = -1;
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.mRootView = inflater.inflate(R.layout.view_comm_video_control, container, false);
        this.initCrtlView(this.mRootView);
        this.mYYPlayer = (SmallVideoPlayer)this.mRootView.findViewById(R.id.surface);
        this.mYYPlayer.setPlayerCallback((PlayerCallback)this);
        this.initGestureCtrl();
        this.initScreenDirection();
        return this.mRootView;
    }

    private void initScreenDirection() {
        if (this.isCurrentPortrait) {
            this.lockPortrait();
        } else {
            this.lockLandscape();
        }
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putString(PARAM_VIDEO_URL, this.mFilePath);
    }

    public void onResume() {
        super.onResume();
        MLog.info((Object)TAG, (String)"onResume", (Object[])new Object[0]);
        this.addInteractive();
        if (this.mShareBtnClick) {
            this.mShareBtnClick = false;
        }
        this.startPlayVideo();
    }

    public void onPause() {
        super.onPause();
        MLog.info((Object)TAG, (String)"onPause", (Object[])new Object[0]);
        this.removeInteractive();
    }

    public void onStop() {
        super.onStop();
        MLog.info((Object)TAG, (String)"onStop", (Object[])new Object[0]);
        this.pauseVideo();
    }

    public void onDestroy() {
        super.onDestroy();
        MLog.info((Object)TAG, (String)"onDestroy", (Object[])new Object[0]);
        if (this.mEventHandler != null) {
            this.mEventHandler.removeCallbacksAndMessages(null);
        }
        this.releasePlayer();
    }

    private void releasePlayer() {
        if (this.mYYPlayer != null) {
            this.mYYPlayer.releasePlayer();
            SmallVideoPlayerManager.INSTANCE.releasePlayer();
        }
    }

    public void onDestroyView() {
        MLog.info((Object)TAG, (String)"onDestroyView", (Object[])new Object[0]);
        this.forceLockProtrait();
        super.onDestroyView();
        Object var2_1 = null;
        if (this.mVLCVideoSimpleFragmentSniperEventBinder != null) {
            this.mVLCVideoSimpleFragmentSniperEventBinder.unBindEvent();
        }
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if (2 == newConfig.orientation) {
            this.isCurrentPortrait = true;
            this.switchSrceenDirection();
        } else if (1 == newConfig.orientation) {
            this.isCurrentPortrait = false;
            this.switchSrceenDirection();
        }
    }

    public void onBackPressed() {
        MLog.info((Object)TAG, (String)"VLCVideoFragment onBackPressed", (Object[])new Object[0]);
        if (!this.isCurrentPortrait) {
            this.switchSrceenDirection();
            this.btnFullScreen.setImageResource(R.drawable.button_fangda);
            if (this.mFullScrennClickListener != null) {
                this.mFullScrennClickListener.showCommentInput();
            }
        } else {
            this.stopVideo();
            this.releasePlayer();
            this.getActivity().finish();
        }
    }

    @BusEvent(sync=true)
    public void onConnectivityChange(IConnectivityClient_onConnectivityChange_EventArgs busEventArgs) {
        IConnectivityCore.ConnectivityState previousState = busEventArgs.getPreviousState();
        IConnectivityCore.ConnectivityState currentState = busEventArgs.getCurrentState();
        if (currentState == IConnectivityCore.ConnectivityState.NetworkUnavailable) {
            if (this.getResources().getConfiguration().orientation == 1) {
                this.checkNetToast();
            } else {
                this.getActivity().setRequestedOrientation(1);
            }
        }
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
    }

    private void initGestureCtrl() {
        this.mAudioManager = (AudioManager)this.getContext().getSystemService("audio");
        this.mMaxVolume = this.mAudioManager.getStreamMaxVolume(3);
        this.mCurrentVolume = this.mAudioManager.getStreamVolume(3);
        CommonPref.instance().putInt(CHANNEL_VIDEO_CURRENT_VOLUME, this.mCurrentVolume);
        this.mStepVolumePX = ResolutionUtils.convertDpToPixel((float)10.0f, (Context)this.getActivity());
        this.mTouchClosePX = ResolutionUtils.convertDpToPixel((float)50.0f, (Context)this.getActivity());
        this.mScreenWidth = this.getActivity().getWindowManager().getDefaultDisplay().getWidth();
        ViewConfiguration vc = ViewConfiguration.get((Context)this.getActivity());
        this.mFlingSlop = vc.getScaledTouchSlop();
        this.mMinFlingVelocit = vc.getScaledMinimumFlingVelocity();
        this.mMaxFlingVelocit = vc.getScaledMaximumFlingVelocity();
        this.mVideoBufferingPBar = (ProgressBar)this.mRootView.findViewById(R.id.buffering_bar);
        if (this.mVideoBufferingPBar != null) {
            this.mVideoBufferingPBar.setVisibility(8);
        }
        this.mYYPlayer.setOnTouchListener(new View.OnTouchListener(){
            float x;
            float y;
            float deltaX;
            float deltaY;
            int pointerId;

            public boolean onTouch(View v, MotionEvent event) {
                switch (event.getAction()) {
                    case 0: {
                        this.x = event.getX();
                        this.y = event.getY();
                        this.pointerId = event.getPointerId(0);
                        GESTURE_FLAG = 0;
                        VLCVideoSimpleFragment.this.addVelocityTracker(event);
                        break;
                    }
                    case 2: {
                        this.deltaX = event.getX() - this.x;
                        this.deltaY = event.getY() - this.y;
                        float absPrecisionX = Math.abs(this.deltaX);
                        float absPrecisionY = Math.abs(this.deltaY);
                        VLCVideoSimpleFragment.this.addVelocityTracker(event);
                        VLCVideoSimpleFragment.this.mVelocityTracker.computeCurrentVelocity(1000, Float.MAX_VALUE);
                        float velocityX = Math.abs(VLCVideoSimpleFragment.this.mVelocityTracker.getXVelocity(this.pointerId));
                        float velocityY = Math.abs(VLCVideoSimpleFragment.this.mVelocityTracker.getYVelocity(this.pointerId));
                        if (absPrecisionY > absPrecisionX && GESTURE_FLAG != 1 && absPrecisionY >= VLCVideoSimpleFragment.this.mStepVolumePX && absPrecisionY > (float)VLCVideoSimpleFragment.this.mFlingSlop && velocityY <= (float)VLCVideoSimpleFragment.this.mMaxFlingVelocit && velocityY >= (float)VLCVideoSimpleFragment.this.mMinFlingVelocit) {
                            GESTURE_FLAG = 2;
                            float deltaVolume = -(this.deltaY / (float)VLCVideoSimpleFragment.this.mScreenWidth * (float)VLCVideoSimpleFragment.this.mMaxVolume);
                            if ((float)VLCVideoSimpleFragment.this.mCurrentVolume + deltaVolume <= 0.0f) {
                                VLCVideoSimpleFragment.this.mAudioManager.setStreamVolume(3, 0, 0);
                            } else {
                                VLCVideoSimpleFragment.this.mAudioManager.setStreamVolume(3, (int)((float)VLCVideoSimpleFragment.this.mCurrentVolume + deltaVolume), 0);
                            }
                            if (deltaVolume < 0.0f) {
                                VLCVideoSimpleFragment.this.mAudioManager.adjustStreamVolume(3, -1, 1);
                                break;
                            }
                            VLCVideoSimpleFragment.this.mAudioManager.adjustStreamVolume(3, 1, 1);
                            break;
                        }
                        if (!(absPrecisionY < absPrecisionX / 2.0f) || GESTURE_FLAG == 2 || !(this.deltaX > VLCVideoSimpleFragment.this.mTouchClosePX) || !(absPrecisionX > (float)VLCVideoSimpleFragment.this.mFlingSlop) || !(velocityX <= (float)VLCVideoSimpleFragment.this.mMaxFlingVelocit) || !(velocityX >= (float)VLCVideoSimpleFragment.this.mMinFlingVelocit)) break;
                        GESTURE_FLAG = 1;
                        break;
                    }
                    case 1: {
                        this.x = 0.0f;
                        this.y = 0.0f;
                        GESTURE_FLAG = 0;
                        VLCVideoSimpleFragment.this.mCurrentVolume = VLCVideoSimpleFragment.this.mAudioManager.getStreamVolume(3);
                        VLCVideoSimpleFragment.this.mYYPlayer.setFocusable(true);
                        VLCVideoSimpleFragment.this.mYYPlayer.setFocusableInTouchMode(true);
                        VLCVideoSimpleFragment.this.mYYPlayer.requestFocus();
                        VLCVideoSimpleFragment.this.recycleVelocityTracker();
                        break;
                    }
                    case 3: {
                        VLCVideoSimpleFragment.this.recycleVelocityTracker();
                        break;
                    }
                }
                return false;
            }
        });
    }

    private void initCrtlView(View view) {
        this.btnPlayPause = (ImageView)view.findViewById(R.id.btn_play_pause);
        this.totalTime = (TextView)view.findViewById(R.id.time);
        this.seekBar = (SeekBar)view.findViewById(R.id.mediacontroller_progress);
        this.btnFullScreen = (ImageView)view.findViewById(R.id.fullscreen);
        this.videoCtrl = view.findViewById(R.id.video_ctrl);
        this.vlcVideoContainer = (RelativeLayout)this.getActivity().findViewById(R.id.video_view_container);
        this.vlcVideoContainer.setLayoutParams(this.getProtraitLayoutParam());
        this.mBack = view.findViewById(R.id.btn_back_channel);
        this.mBack.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                MLog.debug((Object)VLCVideoSimpleFragment.TAG, (String)"BackBtnClick,ifFromChannel=%b,isCurrentPortrait=%b", (Object[])new Object[]{VLCVideoSimpleFragment.this.ifFromChannel, VLCVideoSimpleFragment.this.isCurrentPortrait});
                if (VLCVideoSimpleFragment.this.ifFromChannel) {
                    if (!VLCVideoSimpleFragment.this.isCurrentPortrait) {
                        VLCVideoSimpleFragment.this.btnFullScreen.setImageResource(R.drawable.button_fangda);
                        VLCVideoSimpleFragment.this.switchSrceenDirection();
                        if (VLCVideoSimpleFragment.this.mFullScrennClickListener != null) {
                            VLCVideoSimpleFragment.this.mFullScrennClickListener.showCommentInput();
                        }
                    } else {
                        VLCVideoSimpleFragment.this.stopVideo();
                        VLCVideoSimpleFragment.this.releasePlayer();
                        VLCVideoSimpleFragment.this.getActivity().finish();
                    }
                } else {
                    VLCVideoSimpleFragment.this.stopVideo();
                    VLCVideoSimpleFragment.this.releasePlayer();
                    VLCVideoSimpleFragment.this.getActivity().finish();
                }
            }
        });
    }

    public void startPlayVideo() {
        if (this.mEventHandler != null) {
            this.mEventHandler.sendEmptyMessageDelayed(100, 10L);
        }
    }

    private void play() {
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"startPlay  mFilePath=%s, NetworkType=%d,(1:wifi 2:net_2G 3:net_3G 4:net_legacy 5:unknow)", (Object[])new Object[]{this.mFilePath, NetworkUtils.getNetworkType((Context)this.getContext())});
        }
        if (!this.checkNetToast()) {
            return;
        }
        if (!FP.empty((CharSequence)this.mFilePath) && this.mYYPlayer != null) {
            if (this.mStateFlag == 64) {
                this.mStateFlag = 1;
                this.mYYPlayer.play(this.mFilePath.trim());
                this.mYYPlayer.setScaleMode(ConstantsWrapper.ScaleMode.AspectFit);
                if (this.lastPlayTime > 0) {
                    this.mYYPlayer.seekTo((long)this.lastPlayTime);
                    if (MLog.isLogLevelAboveDebug()) {
                        MLog.debug((Object)TAG, (String)"YYPlayer setTime  time=%d ", (Object[])new Object[]{this.lastPlayTime});
                    }
                }
            } else if (this.mStateFlag == 2) {
                this.mStateFlag = 1;
                this.mYYPlayer.resumePlayer();
                if (MLog.isLogLevelAboveDebug()) {
                    MLog.debug((Object)TAG, (String)"play  pause", (Object[])new Object[0]);
                }
            }
        }
    }

    public int getCurrentTime() {
        if (this.mYYPlayer != null) {
            return (int)(this.mYYPlayer.getTime() / 1000L);
        }
        return -1;
    }

    private void stopVideo() {
        MLog.debug((Object)TAG, (String)"stopVideo()", (Object[])new Object[0]);
        if (this.mYYPlayer != null) {
            if (this.mIsClearTime) {
                this.lastPlayTime = 0;
            }
            this.mStateFlag = 64;
            this.mYYPlayer.stopPlayer();
        }
        oldTime = 0;
    }

    private void pauseVideo() {
        MLog.debug((Object)TAG, (String)"pauseVideo()", (Object[])new Object[0]);
        if (this.mYYPlayer != null) {
            this.mStateFlag = 2;
            this.mYYPlayer.pausePlayer();
        }
    }

    private void addVelocityTracker(MotionEvent event) {
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        this.mVelocityTracker.addMovement(event);
    }

    private void recycleVelocityTracker() {
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.clear();
            this.mVelocityTracker.recycle();
            this.mVelocityTracker = null;
        }
    }

    private ViewGroup.LayoutParams getProtraitLayoutParam() {
        ViewGroup.LayoutParams params = this.vlcVideoContainer.getLayoutParams();
        if (this.isPortraitFullscreen) {
            params.height = -1;
            params.width = -1;
        } else {
            int h;
            int w = ResolutionUtils.getScreenWidth((Context)this.getActivity());
            params.height = h = (int)((float)w / 4.0f * 3.0f);
            params.width = w;
        }
        return params;
    }

    private ViewGroup.LayoutParams getLandscapeLayoutParam() {
        ViewGroup.LayoutParams params = this.vlcVideoContainer.getLayoutParams();
        params.height = -1;
        params.width = -1;
        return params;
    }

    public void setShare(boolean showShare) {
        this.mShareBtnClick = true;
    }

    public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
        if (fromUser) {
            this.lastPlayTime = progress;
            this.updateProgressState(this.totalLength, progress, this.cacheProgress);
        }
    }

    public void onStartTrackingTouch(SeekBar seekBar) {
    }

    public void onStopTrackingTouch(SeekBar seekBar) {
        if (this.mYYPlayer != null && this.checkNetToast()) {
            this.cacheProgress = 0;
            this.lastPlayTime = seekBar.getProgress();
            this.updateProgressState(this.totalLength, this.lastPlayTime, this.cacheProgress);
            this.mYYPlayer.seekTo((long)this.lastPlayTime);
            MLog.debug((Object)TAG, (String)"onProgressChanged seekTo=%d", (Object[])new Object[]{this.lastPlayTime});
        }
    }

    public void onClick(View v) {
        ImeUtil.hideIME((Activity)this.getActivity());
        if (v == this.btnFullScreen) {
            MLog.debug((Object)TAG, (String)"onClick isCurrentPortrait=%b", (Object[])new Object[]{this.isCurrentPortrait});
            if (this.isCurrentPortrait) {
                this.btnFullScreen.setImageResource(R.drawable.button_suoxiao);
                if (this.mFullScrennClickListener != null) {
                    this.mFullScrennClickListener.hideCommentInput();
                }
                this.switchSrceenDirection();
            } else {
                this.btnFullScreen.setImageResource(R.drawable.button_fangda);
                if (this.mFullScrennClickListener != null) {
                    this.mFullScrennClickListener.showCommentInput();
                }
                this.switchSrceenDirection();
            }
        } else if (v == this.btnPlayPause) {
            if (this.mYYPlayer != null) {
                if (this.mYYPlayer.isPlaying()) {
                    this.mYYPlayer.pausePlayer();
                    this.mStateFlag = 2;
                } else if (this.mStateFlag == 2) {
                    this.mStateFlag = 1;
                    this.mYYPlayer.resumePlayer();
                } else if (this.mStateFlag == 64) {
                    this.play();
                }
            }
            this.updatePlayButtonState();
        } else if (v == this.mYYPlayer) {
            this.showAndDelayHideVideoCtrl();
        }
    }

    private void showAndDelayHideVideoCtrl() {
        if (this.videoCtrl.getVisibility() == 0) {
            this.mEventHandler.removeCallbacks(this.hideVideoCtrlRunnable);
            this.videoCtrl.setVisibility(8);
        } else {
            this.videoCtrl.setVisibility(0);
            this.mEventHandler.removeCallbacks(this.hideVideoCtrlRunnable);
            this.mEventHandler.postDelayed(this.hideVideoCtrlRunnable, 5000L);
        }
    }

    private void switchSrceenDirection() {
        if (this.isCurrentPortrait) {
            this.lockLandscape();
        } else {
            this.lockPortrait();
        }
    }

    private void updateProgressState(int total, int current, int cache) {
        if (this.mYYPlayer != null) {
            this.seekBar.setMax(total);
            this.seekBar.setProgress(current);
            this.totalTime.setText((CharSequence)(DurationUtils.intToDurationString((int)(current / 1000)) + "/" + DurationUtils.intToDurationString((int)(total / 1000))));
            if (MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)TAG, (String)"updateProgressState time=%s", (Object[])new Object[]{this.totalTime.getText()});
            }
            this.changeTextColor();
        }
    }

    private void updatePlayButtonState() {
        if (this.mStateFlag == 1) {
            this.btnPlayPause.setImageResource(R.drawable.mn_video_btn_pause);
        } else {
            this.btnPlayPause.setImageResource(R.drawable.mn_video_btn_play);
        }
    }

    private void safelyUnflag(int flag) {
        if ((this.mStateFlag & flag) == flag) {
            this.mStateFlag &= ~flag;
        }
    }

    public void onVideoLoadStart() {
        MLog.debug((Object)TAG, (String)"onVideoLoadStart", (Object[])new Object[0]);
        this.mVideoBufferingPBar.setVisibility(0);
    }

    public void onVideoLoadFinished() {
        MLog.debug((Object)TAG, (String)"onVideoLoadFinished", (Object[])new Object[0]);
        this.mVideoBufferingPBar.setVisibility(8);
    }

    public void onVideoPlayerPosition(int left, int top, int right, int bottom) {
        MLog.debug((Object)TAG, (String)"onVideoPlayerPosition", (Object[])new Object[0]);
    }

    public void onVideoPlayStart() {
        MLog.info((Object)TAG, (String)"onPlayerEvent onVideoPlayStart", (Object[])new Object[0]);
        this.mStateFlag = 1;
        this.updatePlayButtonState();
    }

    public void onTotalTime(int totalLength) {
        MLog.debug((Object)TAG, (String)("onTotalTime: " + totalLength), (Object[])new Object[0]);
    }

    public void onProgressUpdate(int totalLength, int playProgress) {
        this.totalLength = totalLength;
        this.lastPlayTime = playProgress;
        this.updateProgressState(totalLength, playProgress, this.cacheProgress);
    }

    public void onBuffering() {
        MLog.info((Object)TAG, (String)"onBuffering", (Object[])new Object[0]);
        this.mVideoBufferingPBar.setVisibility(0);
    }

    public void onCacheUpdate(int progress) {
        MLog.debug((Object)TAG, (String)"onCacheUpdate", (Object[])new Object[0]);
        this.cacheProgress = progress;
        this.updateProgressState(this.totalLength, this.lastPlayTime, this.cacheProgress);
    }

    public void onError(int errorCode) {
        MLog.info((Object)TAG, (String)"onError errorCode=%d, errorCount=%d", (Object[])new Object[]{errorCode, errorCode});
        this.stopVideo();
        this.mStateFlag = 64;
        this.updatePlayButtonState();
        if (this.errorCount++ < 5) {
            this.play();
        }
    }

    public void onRepeatlyPlayVideo(long resId) {
        MLog.info((Object)TAG, (String)"onRepeatlyPlayVideo", (Object[])new Object[0]);
    }

    public void onPlayEnd() {
        MLog.info((Object)TAG, (String)"onPlayEnd", (Object[])new Object[0]);
        this.mVideoBufferingPBar.setVisibility(8);
        this.mStateFlag = 64;
        this.lastPlayTime = 0;
        this.mIsClearTime = true;
        this.updatePlayButtonState();
        this.videoCtrl.setVisibility(0);
    }

    public void onVideoPlayPause() {
        this.mStateFlag = 2;
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"onPlayerEvent  onVideoPlayPause", (Object[])new Object[0]);
        }
        this.updatePlayButtonState();
    }

    public void onPlayVideoSize(float width, float height) {
        MLog.info((Object)TAG, (String)"onPlayVideoSize", (Object[])new Object[0]);
    }

    public void onVideoPlayStop() {
        MLog.info((Object)TAG, (String)"onVideoPlayStop", (Object[])new Object[0]);
        this.mStateFlag = 64;
        this.updatePlayButtonState();
    }

    public void onVideoPlaying() {
        MLog.info((Object)TAG, (String)"onVideoPlaying", (Object[])new Object[0]);
        this.mStateFlag = 1;
        this.updatePlayButtonState();
        this.showAndDelayHideVideoCtrl();
    }

    private void addInteractive() {
        this.seekBar.setOnSeekBarChangeListener((SeekBar.OnSeekBarChangeListener)this);
        this.btnPlayPause.setOnClickListener((View.OnClickListener)this);
        this.btnFullScreen.setOnClickListener((View.OnClickListener)this);
        this.mYYPlayer.setOnClickListener((View.OnClickListener)this);
    }

    private void removeInteractive() {
        this.seekBar.setOnSeekBarChangeListener(null);
        this.btnPlayPause.setOnClickListener(null);
        this.btnFullScreen.setOnClickListener(null);
        this.mYYPlayer.setOnClickListener(null);
    }

    public void lockPortrait() {
        if (this.getActivity() == null) {
            return;
        }
        if (this.getResources().getConfiguration().orientation == 2) {
            this.getActivity().setRequestedOrientation(1);
        }
        this.applyPortrait();
    }

    private void applyPortrait() {
        this.resumeStatusBarAndActionBar();
        try {
            this.vlcVideoContainer.setLayoutParams(this.getProtraitLayoutParam());
            this.isCurrentPortrait = true;
            this.btnFullScreen.setImageResource(R.drawable.button_fangda);
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (Throwable)e);
        }
    }

    public void forceLockProtrait() {
        if (this.getActivity() == null) {
            MLog.error((Object)TAG, (String)"Video force lock protrait fail.", (Object[])new Object[0]);
            return;
        }
        if (!this.isCurrentPortrait) {
            this.switchSrceenDirection();
            this.getActivity().setRequestedOrientation(1);
        }
    }

    public void lockLandscape() {
        if (this.getActivity() == null) {
            return;
        }
        if (this.getResources().getConfiguration().orientation == 1) {
            this.getActivity().setRequestedOrientation(0);
        }
        this.applyLandscape();
    }

    private void applyLandscape() {
        this.noStatusBarAndActionBar();
        try {
            this.vlcVideoContainer.setLayoutParams(this.getLandscapeLayoutParam());
            this.isCurrentPortrait = false;
            this.btnFullScreen.setImageResource(R.drawable.button_suoxiao);
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (Throwable)e);
        }
    }

    private void noStatusBarAndActionBar() {
        this.getActivity().getWindow().setFlags(1024, 1024);
    }

    private void resumeStatusBarAndActionBar() {
        WindowManager.LayoutParams attrs = this.getActivity().getWindow().getAttributes();
        attrs.flags &= 0xFFFFFBFF;
        this.getActivity().getWindow().setAttributes(attrs);
        this.getActivity().getWindow().clearFlags(512);
    }

    private void changeTextColor() {
        if (this.totalTime != null) {
            String str = this.totalTime.getText().toString();
            SpannableString ss = new SpannableString((CharSequence)str);
            int startIndex = str.indexOf("/");
            try {
                if (startIndex != 0) {
                    ss.setSpan((Object)new ForegroundColorSpan(this.getResources().getColor(R.color.common_color_11)), 0, startIndex, 33);
                }
                ss.setSpan((Object)new ForegroundColorSpan(this.getResources().getColor(R.color.common_color_10)), startIndex, str.length(), 33);
            }
            catch (Exception e) {
                MLog.error((Object)TAG, (String)e.toString(), (Object[])new Object[0]);
            }
            this.totalTime.setText((CharSequence)ss);
        }
    }

    public void setFullScrennClickListener(FullScrennClickListener listener2) {
        this.mFullScrennClickListener = listener2;
    }

    protected void onViewCreated(View view, Bundle bundle) {
        if (this.mVLCVideoSimpleFragmentSniperEventBinder == null) {
            this.mVLCVideoSimpleFragmentSniperEventBinder = new VLCVideoSimpleFragment$$EventBinder();
        }
        this.mVLCVideoSimpleFragmentSniperEventBinder.bindEvent((Object)this);
        super.onViewCreated(view, bundle);
    }

    public static interface FullScrennClickListener {
        public void showCommentInput();

        public void hideCommentInput();
    }

    private static class MyHandler
    extends SafeDispatchHandler {
        WeakReference<VLCVideoSimpleFragment> mFragment;

        MyHandler(VLCVideoSimpleFragment fragment) {
            this.mFragment = new WeakReference<VLCVideoSimpleFragment>(fragment);
        }

        public void handleMessage(Message msg) {
            VLCVideoSimpleFragment fragment = (VLCVideoSimpleFragment)((Object)this.mFragment.get());
            if (fragment == null) {
                return;
            }
            switch (msg.what) {
                case 100: {
                    if (fragment.checkNetToast()) {
                        if (fragment.openVideoTimes == 1 && !NetworkUtils.isWifiActive((Context)fragment.getContext())) {
                            fragment.play();
                        } else {
                            fragment.play();
                        }
                    }
                    return;
                }
            }
        }
    }
}

