/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.dialog;

import android.app.Dialog;
import android.text.TextUtils;
import android.view.View;
import android.view.Window;
import android.widget.TextView;
import com.yy.mobile.plugin.pluginunionmain.R;
import com.yy.mobile.ui.utils.dialog.BaseDialog;
import com.yy.mobile.ui.utils.dialog.OkCancelDialogListener;

public class OkCancelTitleDialog
implements BaseDialog {
    private final CharSequence mMessage;
    private final CharSequence mTips;
    private final CharSequence mOkLabel;
    private final int mOkLabelColor;
    private final CharSequence mCancelLabel;
    private final int mCancelLabelColor;
    private final boolean mCancelable;
    private final OkCancelDialogListener mL;

    public OkCancelTitleDialog(CharSequence message, CharSequence tips, CharSequence okLabel, int okLabelColor, CharSequence cancelLabel, int cancelLabelColor, boolean cancelable, OkCancelDialogListener l) {
        this.mMessage = message;
        this.mTips = tips;
        this.mOkLabel = okLabel;
        this.mOkLabelColor = okLabelColor;
        this.mCancelLabel = cancelLabel;
        this.mCancelLabelColor = cancelLabelColor;
        this.mCancelable = cancelable;
        this.mL = l;
    }

    public void init(final Dialog dialog2) {
        dialog2.setCancelable(this.mCancelable);
        dialog2.setCanceledOnTouchOutside(this.mCancelable);
        dialog2.show();
        Window window = dialog2.getWindow();
        window.setContentView(this.getLayoutResId());
        TextView tip = (TextView)window.findViewById(R.id.message);
        if (!TextUtils.isEmpty((CharSequence)this.mMessage)) {
            tip.setText(this.mMessage);
        }
        TextView messageTips = (TextView)window.findViewById(R.id.message_content);
        if (!TextUtils.isEmpty((CharSequence)this.mTips)) {
            messageTips.setText(this.mTips);
        }
        TextView ok = (TextView)window.findViewById(R.id.btn_ok);
        if (this.mOkLabelColor != 0) {
            ok.setTextColor(this.mOkLabelColor);
        }
        if (!TextUtils.isEmpty((CharSequence)this.mOkLabel)) {
            ok.setText(this.mOkLabel);
        }
        ok.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                dialog2.dismiss();
                if (OkCancelTitleDialog.this.mL != null) {
                    OkCancelTitleDialog.this.mL.onOk();
                }
            }
        });
        TextView cancel = (TextView)window.findViewById(R.id.btn_cancel);
        if (this.mCancelLabelColor != 0) {
            cancel.setTextColor(this.mCancelLabelColor);
        }
        if (!TextUtils.isEmpty((CharSequence)this.mCancelLabel)) {
            cancel.setText(this.mCancelLabel);
        }
        cancel.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                dialog2.dismiss();
                if (OkCancelTitleDialog.this.mL != null) {
                    OkCancelTitleDialog.this.mL.onCancel();
                }
            }
        });
    }

    public int getLayoutResId() {
        return R.layout.layout_title_ok_cancel_dialog;
    }
}

