/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.profile.takephoto;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.os.AsyncTask;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import com.yy.mobile.image.ImageConfig;
import com.yy.mobile.imageloader.ImageUtil;
import com.yy.mobile.plugin.pluginunionmain.R;
import com.yy.mobile.ui.profile.takephoto.PictureTakerActivity;
import com.yy.mobile.ui.utils.dialog.BaseDialog;
import com.yy.mobile.ui.utils.dialog.DialogLinkManager;
import com.yy.mobile.ui.utils.dialog.ProgressDialog;
import com.yy.mobile.util.BasicFileUtils;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.MD5Utils;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.YYFileUtils;
import com.yy.mobile.util.YYImageUtils;
import com.yy.mobile.util.log.MLog;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class TakePhotoController
implements PictureTakerActivity.IController {
    private static final String TAG = "TakePhotoController";
    public static final int IMAGE_SCALE_WIDTH = 800;
    public static final int IMAGE_SCALE_HEIGHT = 800;
    private PictureTakerActivity mAct;
    private View mContentView;
    private ImageView ivPhoto;
    private TextView titleView;
    private TextView okView;
    private String[] imageUrls;
    private DialogLinkManager mDialogLinkManager;
    boolean mCompress = true;
    private List<File> mDeleteList = new ArrayList<File>();

    public TakePhotoController(PictureTakerActivity act, boolean compress) {
        this.mAct = act;
        this.mCompress = compress;
    }

    @Override
    public View getContentView() {
        this.mContentView = LayoutInflater.from((Context)this.mAct).inflate(R.layout.mn_im_take_photo, null);
        this.ivPhoto = (ImageView)this.mContentView.findViewById(R.id.iv_photo);
        this.okView = (TextView)this.mContentView.findViewById(R.id.btn_ok);
        this.titleView = (TextView)this.mContentView.findViewById(R.id.title);
        this.okView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                String imageUrl;
                TakePhotoController.this.removeTempFiles();
                if (TakePhotoController.this.imageUrls != null && TakePhotoController.this.imageUrls.length > 0 && !TextUtils.isEmpty((CharSequence)(imageUrl = TakePhotoController.this.imageUrls[0]))) {
                    Intent data = new Intent();
                    data.putExtra("portrait_clip_key", imageUrl);
                    TakePhotoController.this.mAct.setResult(-1, data);
                    TakePhotoController.this.mAct.finish();
                }
            }
        });
        this.mContentView.findViewById(R.id.btn_cancel).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                TakePhotoController.this.onCancel();
                TakePhotoController.this.mAct.finish();
            }
        });
        return this.mContentView;
    }

    public void setContentViewTitle(String title) {
        this.titleView.setText((CharSequence)title);
    }

    public void setContentViewOkText(String okText) {
        this.okView.setText((CharSequence)okText);
    }

    private void showUploadDialog() {
        if (this.mDialogLinkManager == null) {
            this.mDialogLinkManager = new DialogLinkManager((Context)this.mAct);
        }
        this.mDialogLinkManager.showDialog((BaseDialog)new ProgressDialog(this.mAct.getString(R.string.str_tips_processing), true, true, 0, null));
    }

    private void hideUploadDialog() {
        if (this.mDialogLinkManager != null) {
            this.mDialogLinkManager.dismissDialog();
        }
        this.mDialogLinkManager = null;
    }

    @Override
    public void onResult(String[] paths, int requestCode) {
        new CompressImageAsyncTask(requestCode).execute((Object[])new String[][]{paths});
    }

    private boolean validateImages(String[] paths) {
        for (int i = 0; i < paths.length; ++i) {
            String path = paths[i];
            if (YYImageUtils.isImage((String)path)) continue;
            return false;
        }
        return true;
    }

    private String copyFileToImageDir(String path) {
        String dstDir;
        String dstPath = YYFileUtils.getYYImageFileLocalPath((String)path);
        String dir = BasicFileUtils.getDirOfFilePath((String)path);
        if (!StringUtils.equal((String)dir, (String)(dstDir = BasicFileUtils.getDirOfFilePath((String)dstPath))) && !YYFileUtils.copyFile((String)path, (String)dstPath)) {
            dstPath = path;
        }
        File file = new File(dstPath);
        String md5FileName = this.createMd5FileName(file.length(), dstPath);
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)"hjinw", (String)("md5 = " + md5FileName + ";destPath = " + dstPath), (Object[])new Object[0]);
        }
        dstPath = YYFileUtils.getDirOfFilePath((String)dstPath) + File.separator + md5FileName + YYFileUtils.getFileExtension((String)path);
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)"hjinw", (String)("path = " + dstPath), (Object[])new Object[0]);
        }
        File newDst = new File(dstPath);
        file.renameTo(newDst);
        if (YYFileUtils.isTempFile((Context)this.mAct, (String)path)) {
            this.mDeleteList.add(new File(path));
        }
        return dstPath;
    }

    private String createMd5FileName(long length, String path) {
        String fileMd5 = "";
        try {
            fileMd5 = MD5Utils.getFileMd5String((String)path);
        }
        catch (Exception e) {
            MLog.info((Object)TAG, (String)"get file [%s] md5 failed", (Object[])new Object[]{path});
        }
        return length + "-" + fileMd5;
    }

    private void removeTempFiles() {
        for (File file : this.mDeleteList) {
            file.delete();
        }
    }

    @Override
    public void onCancel() {
        this.removeTempFiles();
        this.mAct.setResult(0);
    }

    static /* synthetic */ String[] access$102(TakePhotoController x0, String[] x1) {
        x0.imageUrls = x1;
        return x1;
    }

    private class CompressImageAsyncTask
    extends AsyncTask<String[], Integer, String[]> {
        private int requestCode;

        CompressImageAsyncTask(int request2) {
            this.requestCode = request2;
        }

        protected String[] doInBackground(String[] ... params) {
            String[] paths = params[0];
            if (!TakePhotoController.this.validateImages(paths)) {
                return null;
            }
            String[] localImageUrls = new String[paths.length];
            for (int i = 0; i < paths.length; ++i) {
                String tempPath;
                String bmpPath = paths[i];
                String extension = YYFileUtils.getFileExtension((String)bmpPath);
                if (extension != null && extension.equalsIgnoreCase(".gif")) {
                    localImageUrls[i] = TakePhotoController.this.copyFileToImageDir(bmpPath);
                    continue;
                }
                if (TakePhotoController.this.mCompress) {
                    String tempName = "resize_" + System.currentTimeMillis() + "_" + i + YYFileUtils.getFileName((String)bmpPath);
                    File temp = YYFileUtils.getTempFile((Context)TakePhotoController.this.mAct, (String)tempName);
                    tempPath = temp.getPath();
                    YYFileUtils.copyFile((String)bmpPath, (String)tempPath);
                    ImageConfig imageConfig = null;
                    imageConfig = !FP.empty((CharSequence)bmpPath) && bmpPath.endsWith(".png") ? new ImageConfig(ImageConfig.ImagePrecision.Big, ImageConfig.ImageTransparency.ARGB_8888) : new ImageConfig(ImageConfig.ImagePrecision.Middle, ImageConfig.ImageTransparency.ARGB_8888);
                    Rect r = YYImageUtils.decodeBmpSize((String)bmpPath);
                    if (r.width() > 800 || r.height() > 800) {
                        YYImageUtils.fixPictureOrientation((String)tempPath, (boolean)true, (ImageConfig)imageConfig, (int)60);
                    } else {
                        YYImageUtils.fixPictureOrientation((String)tempPath, (boolean)true, (ImageConfig)imageConfig, (int)85);
                    }
                } else {
                    int rotate = YYImageUtils.getCameraPhotoOrientation((String)bmpPath);
                    if (rotate > 0) {
                        String tempName2 = "resize_" + System.currentTimeMillis() + "_" + i + YYFileUtils.getFileName((String)bmpPath);
                        File temp2 = YYFileUtils.getTempFile((Context)TakePhotoController.this.mAct, (String)tempName2);
                        tempPath = temp2.getPath();
                        YYFileUtils.copyFile((String)bmpPath, (String)tempPath);
                        ImageConfig imageConfig = null;
                        imageConfig = new ImageConfig(ImageConfig.ImagePrecision.Full, ImageConfig.ImageTransparency.ARGB_8888);
                        YYImageUtils.fixPictureOrientation((String)tempPath, (boolean)true, (ImageConfig)imageConfig, (int)85);
                    } else {
                        tempPath = bmpPath;
                    }
                }
                localImageUrls[i] = TakePhotoController.this.copyFileToImageDir(tempPath);
            }
            return localImageUrls;
        }

        protected void onPreExecute() {
            TakePhotoController.this.mContentView.setVisibility(4);
            TakePhotoController.this.showUploadDialog();
        }

        protected void onPostExecute(String[] strings) {
            TakePhotoController.this.hideUploadDialog();
            TakePhotoController.access$102(TakePhotoController.this, strings);
            if (this.requestCode == 1) {
                TakePhotoController.this.removeTempFiles();
                if (strings != null && strings.length > 0) {
                    String imageUrl = strings[0];
                    if (!TextUtils.isEmpty((CharSequence)imageUrl)) {
                        Intent data = new Intent();
                        data.putExtra("portrait_clip_key", new String[]{imageUrl});
                        TakePhotoController.this.mAct.setResult(-1, data);
                    } else {
                        TakePhotoController.this.mAct.setResult(0);
                    }
                }
                TakePhotoController.this.mAct.finish();
            } else if (this.requestCode == 3) {
                TakePhotoController.this.removeTempFiles();
                if (strings != null && strings.length > 0) {
                    Intent data = new Intent();
                    data.putExtra("portrait_clip_key", strings);
                    TakePhotoController.this.mAct.setResult(-1, data);
                } else {
                    TakePhotoController.this.mAct.setResult(0);
                }
                TakePhotoController.this.mAct.finish();
            } else {
                String imageUrl = strings[0];
                Bitmap bitmap = ImageUtil.decodeSampledBitmapFile((String)imageUrl, (ImageConfig)ImageConfig.defaultImageConfig(), (boolean)true);
                TakePhotoController.this.ivPhoto.setImageBitmap(bitmap);
                TakePhotoController.this.mContentView.setVisibility(0);
            }
        }
    }
}

