/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.text.TextUtils;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import com.yy.mobile.RxBus;
import com.yy.mobile.android.arouter.launcher.ARouter;
import com.yy.mobile.baseapi.common.YYAppInfoHolder;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.mvp.MvpPresenter;
import com.yy.mobile.mvp.MvpView;
import com.yy.mobile.plugin.main.events.IHomeKeyEventReceiverClient_onHomePressed_EventArgs;
import com.yy.mobile.plugin.pluginunionmain.R;
import com.yy.mobile.ui.DialogBaseActivity;
import com.yy.mobile.ui.IDataStatus;
import com.yy.mobile.ui.common.IStatusFragment;
import com.yy.mobile.ui.common.LoadingFragment;
import com.yy.mobile.ui.common.NetworkErrorFragment;
import com.yy.mobile.ui.common.NoDataFragment;
import com.yy.mobile.ui.common.NoMobileLiveFragment;
import com.yy.mobile.ui.common.ReloadFragment;
import com.yy.mobile.ui.utils.SingleToastUtil;
import com.yy.mobile.ui.widget.StatusLayout;
import com.yy.mobile.ui.widget.toast.Toast;
import com.yy.mobile.util.NetworkUtils;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.ylink.bridge.CoreApiManager;
import com.yy.mobile.ylink.bridge.coreapi.BaseActivityApi;
import com.yymobile.core.ICoreManagerBase;

public class BaseActivity<P extends MvpPresenter<V>, V extends MvpView>
extends DialogBaseActivity
implements IDataStatus {
    private static final String TAG = "BaseActivity";
    private Context mContext;
    private boolean isResume;
    private Toast mToast;
    protected String autoFinish = "";
    public static final String TO_LOGIN_AGAIN = "to_login_again";
    public static final int UREASON_COM_KICKOFF = 10;
    public static final int UREASON_CPW_KICKOFF = 12;
    public static final int UREASON_MOBILE_KICKOFF = 11;
    public static final int UREASON_FJ_KICKOFF = 13;
    private static final String STATUS_TAG = "STATUS_TAG";
    private boolean mHomeKeyEventRegisterReceiver = false;
    public BroadcastReceiver mHomeKeyEventReceiver = new BroadcastReceiver(){
        static final String SYSTEM_REASON = "reason";
        static final String SYSTEM_HOME_KEY = "homekey";
        static final String SYSTEM_HOME_KEY_LONG = "recentapps";

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (action.equals("android.intent.action.CLOSE_SYSTEM_DIALOGS")) {
                String reason = intent.getStringExtra(SYSTEM_REASON);
                if (TextUtils.equals((CharSequence)reason, (CharSequence)SYSTEM_HOME_KEY)) {
                    RxBus.getDefault().post((Object)new IHomeKeyEventReceiverClient_onHomePressed_EventArgs());
                } else if (TextUtils.equals((CharSequence)reason, (CharSequence)SYSTEM_HOME_KEY_LONG)) {
                    // empty if block
                }
            }
        }
    };

    protected void onCreate(Bundle savedInstanceState) {
        this.mContext = this;
        super.onCreate(savedInstanceState);
        MLog.info((Object)TAG, (String)"activity onCreate: %s", (Object[])new Object[]{this});
        ICoreManagerBase.addClient((Object)((Object)this));
        ARouter.getInstance().inject((Object)this);
    }

    public Context getContext() {
        return this.mContext;
    }

    protected void onResume() {
        try {
            super.onResume();
        }
        catch (Throwable th) {
            MLog.error((Object)TAG, (String)"super.onResume()", (Throwable)th, (Object[])new Object[0]);
        }
        this.isResume = true;
    }

    protected void onPause() {
        super.onPause();
        this.isResume = false;
        if (this.mToast != null) {
            this.mToast.cancel();
        }
    }

    public static boolean isForeground() {
        return YYAppInfoHolder.isForeground();
    }

    protected boolean isResume() {
        return this.isResume;
    }

    protected void onStart() {
        try {
            super.onStart();
            if (!this.mHomeKeyEventRegisterReceiver) {
                this.mHomeKeyEventRegisterReceiver = true;
                if (this.mHomeKeyEventReceiver != null) {
                    this.registerReceiver(this.mHomeKeyEventReceiver, new IntentFilter("android.intent.action.CLOSE_SYSTEM_DIALOGS"));
                }
            }
        }
        catch (Throwable e) {
            MLog.error((Object)TAG, (String)("mHomeKeyEventReceiver is registerReceiver e = " + e), (Object[])new Object[0]);
        }
    }

    protected void onStop() {
        try {
            super.onStop();
            if (this.mHomeKeyEventRegisterReceiver) {
                if (this.mHomeKeyEventReceiver != null) {
                    this.unregisterReceiver(this.mHomeKeyEventReceiver);
                }
                this.mHomeKeyEventRegisterReceiver = false;
            }
        }
        catch (Throwable e) {
            MLog.error((Object)TAG, (String)("mHomeKeyEventReceiver is unregisterReceiver e = " + e), (Object[])new Object[0]);
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        MLog.info((Object)TAG, (String)"activity onDestroy: %s", (Object[])new Object[]{this});
        ICoreManagerBase.removeClient((Object)((Object)this));
        if (this.mContext != null) {
            this.mContext = null;
        }
    }

    protected void onRestoreInstanceState(Bundle savedInstanceState) {
        super.onRestoreInstanceState(savedInstanceState);
        if (savedInstanceState != null) {
            Fragment fragment = this.getSupportFragmentManager().findFragmentByTag(STATUS_TAG);
            if (fragment != null && fragment instanceof NoMobileLiveFragment) {
                ((NoMobileLiveFragment)fragment).setListener(this.getNoMobileLiveDataListener());
            } else if (fragment != null && fragment instanceof IStatusFragment) {
                ((IStatusFragment)fragment).setListener(this.getLoadListener());
            }
        }
    }

    public void onBackPressed() {
        try {
            super.onBackPressed();
        }
        catch (Exception ex) {
            MLog.error((Object)TAG, (Throwable)ex);
        }
    }

    public void showLoginDialog() {
        if (this.checkActivityValid()) {
            ((BaseActivityApi)CoreApiManager.getInstance().getApi(BaseActivityApi.class)).showLoginDialog((Activity)this.mContext);
        }
    }

    public boolean isLogined() {
        return LoginUtil.isLogined();
    }

    protected boolean isActivityOnTop(Activity activity) {
        if (activity == null) {
            return false;
        }
        return this.isResume();
    }

    public View.OnClickListener getLoadListener() {
        return null;
    }

    public View.OnClickListener getNoMobileLiveDataListener() {
        return null;
    }

    public View.OnClickListener getLoadMoreListener() {
        return null;
    }

    public void showLoading() {
        this.showLoading(0, 0);
    }

    public void showLoading(View view) {
        this.showLoading(view, 0, 0);
    }

    public void showReload() {
        this.showReload(0, 0);
    }

    public void showNoData() {
        this.showNoData(0, 0);
    }

    public void showNoData(View view, int drawable2, CharSequence charSequence, View.OnClickListener onClickListener) {
    }

    public void showNoData(int drawable2, CharSequence charSequence) {
    }

    public void showNoData(View view, int drawable2, CharSequence charSequence) {
    }

    public void showNoDataWithBtn(int drawable2, String tips, String btnText, View.OnClickListener btnClickListener) {
    }

    public void showFragment(Fragment fragment) {
    }

    public void showLoading(int drawable2, int tips) {
        if (!this.checkActivityValid()) {
            return;
        }
        View status = this.findViewById(R.id.status_layout);
        if (status == null || status.getId() <= 0) {
            MLog.error((Object)TAG, (String)"xuwakao, had not set layout id ", (Object[])new Object[0]);
            return;
        }
        LoadingFragment fragment = LoadingFragment.newInstance((int)drawable2, (int)tips);
        this.getSupportFragmentManager().beginTransaction().replace(status.getId(), (Fragment)fragment, STATUS_TAG).commitAllowingStateLoss();
    }

    public void showLoading(View view, int drawable2, int tips) {
    }

    public void showReload(int drawable2, int tips) {
        if (!this.checkActivityValid()) {
            return;
        }
        View status = this.findViewById(R.id.status_layout);
        if (status == null || status.getId() <= 0) {
            MLog.error((Object)TAG, (String)"xuwakao, had not set layout id ", (Object[])new Object[0]);
            return;
        }
        ReloadFragment fragment = ReloadFragment.newInstance((int)drawable2, (int)tips);
        fragment.setListener(this.getLoadListener());
        this.getSupportFragmentManager().beginTransaction().replace(status.getId(), (Fragment)fragment, STATUS_TAG).commitAllowingStateLoss();
    }

    public void showReload(View view, int drawable2, int tips) {
    }

    public void showNoData(int drawable2, int tips) {
        if (!this.checkActivityValid()) {
            return;
        }
        View status = this.findViewById(R.id.status_layout);
        if (status == null || status.getId() <= 0) {
            MLog.error((Object)TAG, (String)"xuwakao, had not set layout id ", (Object[])new Object[0]);
            return;
        }
        NoDataFragment fragment = null;
        fragment = tips <= 0 ? NoDataFragment.newInstance() : NoDataFragment.newInstance((int)drawable2, (CharSequence)this.getString(tips));
        fragment.setListener(this.getLoadListener());
        this.getSupportFragmentManager().beginTransaction().replace(status.getId(), (Fragment)fragment, STATUS_TAG).commitAllowingStateLoss();
    }

    public void showNoData(View view, int drawable2, int tips) {
    }

    public void showNetworkErr() {
        if (!this.checkActivityValid()) {
            return;
        }
        View status = this.findViewById(R.id.status_layout);
        if (status == null || status.getId() <= 0) {
            MLog.error((Object)TAG, (String)"xuwakao, had not set layout id ", (Object[])new Object[0]);
            return;
        }
        NetworkErrorFragment fragment = NetworkErrorFragment.newInstance();
        fragment.setListener(this.getLoadListener());
        this.getSupportFragmentManager().beginTransaction().replace(status.getId(), (Fragment)fragment, STATUS_TAG).commitAllowingStateLoss();
    }

    public void showNoMobileLiveData() {
        if (!this.checkActivityValid()) {
            return;
        }
        View status = this.findViewById(R.id.status_layout);
        if (status == null || status.getId() <= 0) {
            MLog.error((Object)TAG, (String)"xuwakao, had not set layout id ", (Object[])new Object[0]);
            return;
        }
        NoMobileLiveFragment fragment = NoMobileLiveFragment.newInstance();
        fragment.setListener(this.getNoMobileLiveDataListener());
        this.getSupportFragmentManager().beginTransaction().replace(status.getId(), (Fragment)fragment, STATUS_TAG).commitAllowingStateLoss();
    }

    public void hideStatus() {
        Fragment fragment = this.getSupportFragmentManager().findFragmentByTag(STATUS_TAG);
        if (fragment != null) {
            this.getSupportFragmentManager().beginTransaction().remove(fragment).commitAllowingStateLoss();
        }
    }

    public void showPageError(int tips) {
        if (!this.checkActivityValid()) {
            return;
        }
        View more = this.findViewById(R.id.loading_more);
        if (more == null) {
            MLog.error((Object)TAG, (String)"xuwakao, showReload more is NULL", (Object[])new Object[0]);
            return;
        }
        StatusLayout statusLayout = (StatusLayout)more.getParent();
        statusLayout.showErrorPage(tips, this.getLoadMoreListener());
    }

    public void showPageError(View view, int tips) {
    }

    public void showPageLoading() {
        if (!this.checkActivityValid()) {
            return;
        }
        View more = this.findViewById(R.id.loading_more);
        if (more == null) {
            MLog.error((Object)TAG, (String)"xuwakao, showReload more is NULL", (Object[])new Object[0]);
            return;
        }
        StatusLayout statusLayout = (StatusLayout)more.getParent();
        statusLayout.showLoadMore();
    }

    @TargetApi(value=17)
    public boolean checkActivityValid() {
        if (this.isFinishing()) {
            return false;
        }
        return Build.VERSION.SDK_INT < 17 || !this.isDestroyed();
    }

    public boolean isNetworkAvailable() {
        return NetworkUtils.isNetworkStrictlyAvailable((Context)this);
    }

    public boolean checkNetToast() {
        boolean falg = this.isNetworkAvailable();
        if (!falg) {
            SingleToastUtil.showToast((Context)this.getContext(), (int)R.string.str_network_not_capable);
        }
        return falg;
    }

    public void hideIME() {
        View v = this.getCurrentFocus();
        if (null != v) {
            this.hideIME(v);
        }
    }

    public void hideIME(View v) {
        InputMethodManager imm = (InputMethodManager)this.getSystemService("input_method");
        imm.hideSoftInputFromWindow(v.getWindowToken(), 0);
    }

    public void showIME(View vv) {
        View v = vv;
        if (null == v && null == (v = this.getCurrentFocus())) {
            return;
        }
        ((InputMethodManager)this.getSystemService("input_method")).showSoftInput(v, 2);
    }

    public void toast(int resId) {
        this.toast(resId, 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void toast(int resId, int length) {
        if (this.mToast == null) {
            if (this.getContext() == null) return;
            this.mToast = Toast.makeText((Context)this.getContext(), (int)resId, (int)length);
        } else {
            this.mToast = Toast.makeText((Context)this.getContext(), (int)resId, (int)length);
        }
        this.mToast.show();
    }

    public void toast(String message) {
        this.toast(message, 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void toast(String message, int length) {
        if (this.mToast == null) {
            if (this.getContext() == null) return;
            this.mToast = Toast.makeText((Context)this.getContext(), (CharSequence)message, (int)length);
        } else {
            this.mToast = Toast.makeText((Context)this.getContext(), (CharSequence)message, (int)length);
        }
        this.mToast.show();
    }

    public <T> T findFragmentById(int id2, Class<T> clazz) {
        Fragment f = this.getSupportFragmentManager().findFragmentById(id2);
        return (T)f;
    }

    public <T> T findFragmentByTag(String tag, Class<T> clazz) {
        Fragment f = this.getSupportFragmentManager().findFragmentByTag(tag);
        return (T)f;
    }
}

