/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.utils;

import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.android.sniper.api.event.EventCompat;
import com.yy.mobile.plugin.main.events.IProfileClient_onRequestProfile_EventArgs;
import com.yy.mobile.plugin.main.events.IUserClient_onRequestDetailUserInfo_EventArgs;
import com.yy.mobile.ui.utils.PersonInfoHandler$$EventBinder;
import com.yy.mobile.ui.utils.dialog.BaseDialog;
import com.yy.mobile.ui.utils.dialog.DialogLinkManager;
import com.yy.mobile.ui.utils.dialog.ProgressDialog;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.ylink.bridge.coreapi.PersonInfoHandlerApi;
import com.yymobile.core.CoreError;
import com.yymobile.core.CoreManager;
import com.yymobile.core.profile.EntUserInfo;
import com.yymobile.core.profile.IProfileCore;
import com.yymobile.core.user.UserInfo;
import java.lang.ref.WeakReference;

public class PersonInfoHandler
implements EventCompat {
    private static final String TAG = "PersonInfoHandler";
    private WeakReference<PersonInfoHandlerApi.EntInfoListener> mEntInfoListenerRef;
    private WeakReference<PersonInfoHandlerApi.UserInfoListener> mUserInfoListenerRef;
    private EntUserInfo mEntInfo;
    private UserInfo mUserInfo;
    private WeakReference<DialogLinkManager> mDialogManagerRef;
    private long mUid;
    private EventBinder mPersonInfoHandlerSniperEventBinder;

    public void onEventBind() {
        if (this.mPersonInfoHandlerSniperEventBinder == null) {
            this.mPersonInfoHandlerSniperEventBinder = new PersonInfoHandler$$EventBinder();
        }
        this.mPersonInfoHandlerSniperEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        if (this.mPersonInfoHandlerSniperEventBinder != null) {
            this.mPersonInfoHandlerSniperEventBinder.unBindEvent();
        }
    }

    private PersonInfoHandler() {
        CoreManager.addClient((Object)this);
    }

    public static PersonInfoHandler newInstance() {
        return new PersonInfoHandler();
    }

    public void requestEntUserInfo(long uid, PersonInfoHandlerApi.EntInfoListener listener) {
        this.requestEntUserInfo(null, false, uid, listener);
    }

    public void requestEntUserInfo(DialogLinkManager dialogLinkManager, boolean showLoading, long uid, PersonInfoHandlerApi.EntInfoListener listener) {
        MLog.info((Object)TAG, (String)("requestEntUserInfo() called , uid : " + uid), (Object[])new Object[0]);
        if (showLoading && dialogLinkManager != null) {
            dialogLinkManager.showDialog((BaseDialog)new ProgressDialog());
            this.mDialogManagerRef = new WeakReference<DialogLinkManager>(dialogLinkManager);
        }
        this.mUid = uid;
        this.mEntInfoListenerRef = new WeakReference<PersonInfoHandlerApi.EntInfoListener>(listener);
        this.mEntInfo = ((IProfileCore)CoreManager.getCore(IProfileCore.class)).getCachedProfileInfo(uid);
        if (this.mEntInfo == null) {
            ((IProfileCore)CoreManager.getCore(IProfileCore.class)).requestProfile(uid);
        } else {
            listener.onRetrieve(this.mEntInfo);
            CoreManager.removeClient((Object)this);
            DialogLinkManager manager = null;
            if (this.mDialogManagerRef != null) {
                manager = (DialogLinkManager)this.mDialogManagerRef.get();
            }
            if (this.mDialogManagerRef != null && manager != null) {
                manager.dismissDialog();
            }
        }
    }

    public void requestUserInfo(long uid, PersonInfoHandlerApi.UserInfoListener listener) {
        MLog.info((Object)TAG, (String)("requestUserInfo() called , uid : " + uid), (Object[])new Object[0]);
        this.mUid = uid;
        this.mUserInfoListenerRef = new WeakReference<PersonInfoHandlerApi.UserInfoListener>(listener);
        this.mUserInfo = CoreManager.getUserCore().getCacheUserInfoByUid(uid);
        if (this.mUserInfo == null) {
            MLog.info((Object)TAG, (String)"requestUserInfo() getDataFromCache", (Object[])new Object[0]);
            CoreManager.getUserCore().requestDetailUserInfo(uid, true);
        } else {
            listener.onRetrieve(this.mUserInfo);
            CoreManager.removeClient((Object)this);
        }
    }

    @BusEvent
    public void onRequestDetailUserInfo(IUserClient_onRequestDetailUserInfo_EventArgs busEventArgs) {
        long userId = busEventArgs.getUserId();
        UserInfo info = busEventArgs.getInfo();
        boolean isLocalData = busEventArgs.getIsLocalData();
        CoreError error = busEventArgs.getError();
        this.onRequestDetailUserInfo(userId, info, isLocalData, error);
    }

    public void onRequestDetailUserInfo(long userId, UserInfo info, boolean isLocalData, CoreError error) {
        PersonInfoHandlerApi.UserInfoListener listener = null;
        if (this.mUserInfoListenerRef != null) {
            listener = (PersonInfoHandlerApi.UserInfoListener)this.mUserInfoListenerRef.get();
        }
        if (error == null && info != null && info.userId == this.mUid && this.mUserInfoListenerRef != null && listener != null) {
            MLog.info((Object)TAG, (String)("onRequestDetailUserInfo() : " + info.toString()), (Object[])new Object[0]);
            if (listener != null) {
                listener.onRetrieve(info);
            }
            CoreManager.removeClient((Object)this);
        } else {
            MLog.info((Object)TAG, (String)"onRequestDetailUserInfo() : CoreError or uid not matches or info==null or mUserInfoListener == null", (Object[])new Object[0]);
        }
    }

    @BusEvent
    public void onRequestProfile(IProfileClient_onRequestProfile_EventArgs busEventArgs) {
        EntUserInfo info = busEventArgs.getInfo();
        this.onRequestProfile(info);
    }

    public void onRequestProfile(EntUserInfo info) {
        if (info.uid == this.mUid && this.mEntInfoListenerRef != null && this.mEntInfoListenerRef.get() != null) {
            MLog.info((Object)TAG, (String)("onRequestProfile() : " + info.toString()), (Object[])new Object[0]);
            try {
                ((PersonInfoHandlerApi.EntInfoListener)this.mEntInfoListenerRef.get()).onRetrieve(info);
            }
            catch (Throwable ex) {
                MLog.error((Object)TAG, (String)"Attempt to invoke interface method onRetrieve() on a null object reference!", (Throwable)ex, (Object[])new Object[0]);
            }
            CoreManager.removeClient((Object)this);
        } else {
            MLog.info((Object)TAG, (String)"onRequestProfile() : uid not matches or info==null", (Object[])new Object[0]);
        }
        DialogLinkManager manager = null;
        if (this.mDialogManagerRef != null) {
            manager = (DialogLinkManager)this.mDialogManagerRef.get();
        }
        if (this.mDialogManagerRef != null && manager != null) {
            manager.dismissDialog();
        }
    }
}

