/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.setting;

import android.app.Activity;
import android.content.Context;
import android.graphics.Color;
import android.os.Bundle;
import android.text.TextPaint;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.android.sniper.api.event.EventCompat;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.event.ParentsModeEvent;
import com.yy.mobile.image.RecycleImageView;
import com.yy.mobile.plugin.pluginunionmain.R;
import com.yy.mobile.sdkwrapper.login.LoginProtocol;
import com.yy.mobile.ui.BaseActivity;
import com.yy.mobile.ui.setting.ParentsModeActivity$$EventBinder;
import com.yy.mobile.ui.widget.SimpleTitleBar;
import com.yy.mobile.ui.widget.toast.Toast;
import com.yy.mobile.util.ResolutionUtils;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.ylink.bridge.CoreApiManager;
import com.yy.mobile.ylink.bridge.coreapi.NavigationUtilApi;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.Proxy.ILivePluginProxy;
import com.yymobile.core.UriProvider;
import com.yymobile.core.statistic.IHiidoStatisticCore;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONException;
import org.json.JSONObject;

public class ParentsModeActivity
extends BaseActivity
implements EventCompat {
    public static final String BundleKey = "IsParentsModeOpen";
    private int titleBarHeight = (int)ResolutionUtils.convertDpToPixel((float)48.0f, (Context)BasicConfig.getInstance().getAppContext());
    private int iconSizeW = (int)ResolutionUtils.convertDpToPixel((float)94.0f, (Context)BasicConfig.getInstance().getAppContext());
    private int iconSizeH = (int)ResolutionUtils.convertDpToPixel((float)90.0f, (Context)BasicConfig.getInstance().getAppContext());
    private int btnH = (int)ResolutionUtils.convertDpToPixel((float)44.0f, (Context)BasicConfig.getInstance().getAppContext());
    private int btnMargin = (int)ResolutionUtils.convertDpToPixel((float)30.0f, (Context)BasicConfig.getInstance().getAppContext());
    private RelativeLayout parentContainer;
    private SimpleTitleBar simpleTitleBar;
    private boolean isParentsModeOpen = false;
    private String reg = "[^\\s]*=[^\\s]*";
    private Pattern pattern;
    StringBuilder sb = new StringBuilder();
    private TextView parentsModeBtn;
    private TextView parentModeStateTv;
    private EventBinder mParentsModeActivitySniperEventBinder;

    public void onEventBind() {
        if (this.mParentsModeActivitySniperEventBinder == null) {
            this.mParentsModeActivitySniperEventBinder = new ParentsModeActivity$$EventBinder();
        }
        this.mParentsModeActivitySniperEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        if (this.mParentsModeActivitySniperEventBinder != null) {
            this.mParentsModeActivitySniperEventBinder.unBindEvent();
        }
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.onEventBind();
        Bundle bundle = this.getIntent().getExtras();
        if (bundle != null) {
            this.isParentsModeOpen = bundle.getBoolean(BundleKey, false);
        }
        this.parentContainer = new RelativeLayout(this.getContext());
        RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(-1, -1);
        this.addContentView((View)this.parentContainer, (ViewGroup.LayoutParams)lp);
        this.pattern = Pattern.compile(this.reg);
        this.initContentInfo();
        this.initTitileBar();
        this.initContainer();
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        this.onEventUnBind();
    }

    private void initTitileBar() {
        this.simpleTitleBar = new SimpleTitleBar(this.getContext(), null);
        RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(-1, this.titleBarHeight);
        this.simpleTitleBar.setTitlte("\u5bb6\u957f\u6a21\u5f0f");
        this.simpleTitleBar.setLeftBtn(R.drawable.icon_nav_back, new View.OnClickListener(){

            public void onClick(View v) {
                ParentsModeActivity.this.finish();
            }
        });
        this.parentContainer.addView((View)this.simpleTitleBar, (ViewGroup.LayoutParams)lp);
    }

    private void initContainer() {
        RecycleImageView recycleImageView = new RecycleImageView(this.getContext());
        RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(this.iconSizeW, this.iconSizeH);
        recycleImageView.setImageDrawable(this.getContext().getResources().getDrawable(R.drawable.parents_mode_icon));
        lp.topMargin = (int)ResolutionUtils.convertDpToPixel((float)108.0f, (Context)BasicConfig.getInstance().getAppContext());
        lp.addRule(14);
        this.parentContainer.addView((View)recycleImageView, (ViewGroup.LayoutParams)lp);
        this.parentModeStateTv = new TextView(this.getContext());
        RelativeLayout.LayoutParams lpPmts = new RelativeLayout.LayoutParams(-2, -2);
        this.parentModeStateTv.setTextSize(20.0f);
        this.parentModeStateTv.setTextColor(Color.parseColor((String)"#1d1d1d"));
        TextPaint paint = this.parentModeStateTv.getPaint();
        paint.setFakeBoldText(true);
        String context = this.isParentsModeOpen ? "\u5bb6\u957f\u6a21\u5f0f\u5df2\u5f00\u542f" : "\u5bb6\u957f\u6a21\u5f0f\u672a\u5f00\u542f";
        this.parentModeStateTv.setText((CharSequence)context);
        lpPmts.topMargin = (int)ResolutionUtils.convertDpToPixel((float)232.0f, (Context)BasicConfig.getInstance().getAppContext());
        lpPmts.addRule(14);
        this.parentModeStateTv.setSingleLine();
        this.parentContainer.addView((View)this.parentModeStateTv, (ViewGroup.LayoutParams)lpPmts);
        TextView parentModeContentTv = new TextView(this.getContext());
        RelativeLayout.LayoutParams lpPmct = new RelativeLayout.LayoutParams(-2, -2);
        parentModeContentTv.setTextSize(13.0f);
        parentModeContentTv.setTextColor(Color.parseColor((String)"#1d1d1d"));
        parentModeContentTv.setText((CharSequence)context);
        lpPmct.topMargin = (int)ResolutionUtils.convertDpToPixel((float)292.0f, (Context)BasicConfig.getInstance().getAppContext());
        lpPmct.addRule(14);
        parentModeContentTv.setLines(4);
        parentModeContentTv.setText((CharSequence)this.sb.toString());
        this.parentContainer.addView((View)parentModeContentTv, (ViewGroup.LayoutParams)lpPmct);
        this.parentsModeBtn = new TextView(this.getContext());
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, this.btnH);
        layoutParams.addRule(12);
        layoutParams.bottomMargin = (int)ResolutionUtils.convertDpToPixel((float)60.0f, (Context)BasicConfig.getInstance().getAppContext());
        layoutParams.leftMargin = this.btnMargin;
        layoutParams.rightMargin = this.btnMargin;
        this.parentsModeBtn.setBackgroundDrawable(this.getContext().getResources().getDrawable(R.drawable.bg_parents_mode_btn));
        String btnTxt = this.isParentsModeOpen ? "\u5173\u95ed\u5bb6\u957f\u6a21\u5f0f" : "\u6253\u5f00\u5bb6\u957f\u6a21\u5f0f";
        this.parentsModeBtn.setText((CharSequence)btnTxt);
        this.parentsModeBtn.setGravity(17);
        this.parentsModeBtn.setTextColor(-1);
        this.parentsModeBtn.setTextSize(15.0f);
        TextPaint textPaint = this.parentsModeBtn.getPaint();
        textPaint.setFakeBoldText(true);
        this.parentsModeBtn.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.parentsModeBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                String url = ParentsModeActivity.this.createVerifyUrl();
                ((NavigationUtilApi)CoreApiManager.getInstance().getApi(NavigationUtilApi.class)).toJSSupportedWebView((Activity)ParentsModeActivity.this, url);
            }
        });
        this.parentContainer.addView((View)this.parentsModeBtn, (ViewGroup.LayoutParams)layoutParams);
    }

    private void initContentInfo() {
        this.sb.append("\u8be5\u6a21\u5f0f\u7528\u4e8e\u6307\u5f15\u672a\u6210\u5e74\u4eba\u6b63\u786e\u4f7f\u7528\u76f4\u64ad\u5de5\u5177\uff0c\u5f62\u6210\u6b63\n");
        this.sb.append("\u786e\u4ef7\u503c\u89c2\u3002\u5728\u5bb6\u957f\u6a21\u5f0f\u5f00\u542f\u540e\uff0c\u65e0\u6cd5\u4f7f\u7528\u6d88\u8d39\u76f8\u5173\u7684\n");
        this.sb.append("\u670d\u52a1\uff0c\u5982\u9001\u793c\u7269\u3001\u5145\u503c\u3001\u63d0\u73b0\u3001\u5151\u6362\u3001\u501f\u8d37\u7b49\u76f8\u5173\u64cd\n");
        this.sb.append("\u4f5c\u3002");
    }

    private String createVerifyUrl() {
        StringBuilder sb = new StringBuilder();
        sb.append(UriProvider.PARENTSMODE_VERIFY_PSW_URL).append("?");
        sb.append("appid=6055&");
        sb.append("ticketType=1&");
        sb.append("methods=536870912&");
        sb.append("purpose=parentmode&");
        sb.append("endType=android&");
        sb.append("yyuid=").append(LoginUtil.getUid()).append("&");
        sb.append("ticket=").append(LoginProtocol.Factory.get().getOTP("yymand")).append("&");
        sb.append("ticketAppid=").append("yymand").append("&");
        sb.append("devid=").append(LoginProtocol.Factory.get().getDeviceData()).append("&");
        sb.append("state=").append(LoginProtocol.Factory.get().getDeviceData()).append("&");
        sb.append("callbackUrl=");
        sb.append(UriProvider.PARENTSMODE_VERIFY_PSW_CALLBACK);
        return sb.toString();
    }

    @BusEvent
    public void onVerifyPwsResult(ParentsModeEvent parentsModeEvent) {
        if (parentsModeEvent == null) {
            return;
        }
        if (parentsModeEvent.getState() == ParentsModeEvent.WebCallBackType) {
            UrlEntity entity = this.parserUrlConfig(parentsModeEvent.getUrlCallbackInfo());
            if (StringUtils.safeParseInt((String)entity.code) == 0) {
                ((ILivePluginProxy)ICoreManagerBase.getCore(ILivePluginProxy.class)).operatorByCmd("cmdQueryParentsModeState", new Object[]{entity.toString()});
            } else {
                Toast.makeText((Context)this.getContext(), (CharSequence)entity.msg, (int)0).show();
            }
        } else if (parentsModeEvent.getState() == ParentsModeEvent.QueryModeStateType) {
            String tipTxt;
            int result = parentsModeEvent.getModeResult();
            if (result == 0) {
                ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "51412", "0002");
            } else {
                ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "51412", "0003");
            }
            String btnTxt = result == 0 ? "\u5173\u95ed\u5bb6\u957f\u6a21\u5f0f" : "\u6253\u5f00\u5bb6\u957f\u6a21\u5f0f";
            String string2 = tipTxt = result == 0 ? "\u5bb6\u957f\u6a21\u5f0f\u5df2\u5f00\u542f" : "\u5bb6\u957f\u6a21\u5f0f\u672a\u5f00\u542f";
            if (this.parentsModeBtn != null) {
                this.parentsModeBtn.setText((CharSequence)btnTxt);
            }
            if (this.parentModeStateTv != null) {
                this.parentModeStateTv.setText((CharSequence)tipTxt);
            }
        }
    }

    private UrlEntity parserUrlConfig(String url) {
        int index;
        UrlEntity entity = new UrlEntity();
        String[] infos = url.split("[?]");
        if (infos != null && infos.length > 0 && (index = 1) < infos.length) {
            String[] extendsInfo;
            for (String extInfo : extendsInfo = infos[index].split("&")) {
                Matcher matcher = this.pattern.matcher(extInfo);
                if (!matcher.matches()) continue;
                String[] keyValue = extInfo.split("=");
                if (keyValue[0].equals("resCode")) {
                    entity.code = keyValue[1];
                    continue;
                }
                if (keyValue[0].equals("resMsg")) {
                    entity.msg = keyValue[1];
                    continue;
                }
                if (!keyValue[0].equals("token")) continue;
                entity.token = keyValue[1];
            }
        }
        return entity;
    }

    private static class UrlEntity {
        public String code = "-1";
        public String msg = "\u8bbe\u7f6e\u5931\u8d25";
        public String token;

        private UrlEntity() {
        }

        public String toString() {
            String ret = "";
            try {
                JSONObject object = new JSONObject();
                object.put("code", (Object)this.code);
                object.put("msg", (Object)this.msg);
                object.put("token", (Object)this.token);
                ret = object.toString();
            }
            catch (JSONException e) {
                MLog.info((Object)this, (String)"create jsonString error!", (Object[])new Object[0]);
            }
            return ret;
        }
    }
}

