/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.profile.takephoto;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewTreeObserver;
import android.widget.ImageView;
import com.yy.mobile.image.ImageConfig;
import com.yy.mobile.imageloader.ImageUtil;
import com.yy.mobile.plugin.pluginunionmain.R;
import com.yy.mobile.ui.profile.takephoto.PictureTakerActivity;
import com.yy.mobile.ui.widget.cropper.CropImageView;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.TimeUtils;
import com.yy.mobile.util.YYFileUtils;
import com.yy.mobile.util.log.MLog;
import java.io.File;

public class PhotoEditController
implements PictureTakerActivity.IController {
    private static final String TAG = "PhotoEditController";
    private static final String CLIP_NAME = "photo_clip_temp";
    private static final String BMP_TEMP_NAME = "bmp_temp_name";
    private static final String JPG_EXT = ".jpg";
    private PictureTakerActivity mAct;
    private boolean mEnableClip;
    private CropImageView mEditView;
    private String bmpTmpPath;
    private View.OnClickListener mRetakeClick = new View.OnClickListener(){

        public void onClick(View v) {
            PhotoEditController.this.mAct.takePhoto();
            PhotoEditController.this.deleteTempImage();
        }
    };
    private View.OnClickListener mOkClick = new View.OnClickListener(){

        public void onClick(View v) {
            try {
                Bitmap bitmap = PhotoEditController.this.mEditView.getCroppedImage();
                if (bitmap != null) {
                    File clipTemp = YYFileUtils.getTempFile((Context)PhotoEditController.this.mAct, (String)(PhotoEditController.CLIP_NAME + TimeUtils.curSec() + PhotoEditController.JPG_EXT));
                    YYFileUtils.saveBitmapToJPG((Bitmap)bitmap, (String)clipTemp.getPath());
                    PhotoEditController.this.deleteTempImage();
                    Intent data = new Intent();
                    data.putExtra("portrait_clip_key", clipTemp.getPath());
                    PhotoEditController.this.mAct.setResult(-1, data);
                } else {
                    PhotoEditController.this.mAct.setResult(2);
                }
            }
            catch (Exception e) {
                MLog.error((Object)PhotoEditController.TAG, (Throwable)e);
                PhotoEditController.this.mAct.setResult(2);
            }
            PhotoEditController.this.mAct.finish();
        }
    };
    private View.OnClickListener mRotateClick = new View.OnClickListener(){

        public void onClick(View v) {
            PhotoEditController.this.mEditView.rotateImage(90);
        }
    };

    public PhotoEditController(PictureTakerActivity act) {
        this.mAct = act;
    }

    public void enableClipPortrait(boolean enable) {
        this.mEnableClip = enable;
        if (this.mEditView != null) {
            this.mEditView.setEnabled(enable);
        }
    }

    @Override
    public View getContentView() {
        View v = LayoutInflater.from((Context)this.mAct).inflate(R.layout.mn_im_photo_edit, null);
        this.mEditView = (CropImageView)v.findViewById(R.id.photo_edit);
        this.mEditView.setEnabled(this.mEnableClip);
        this.mEditView.setFixedAspectRatio(true);
        v.findViewById(R.id.btn_use).setOnClickListener(this.mOkClick);
        v.findViewById(R.id.btn_retake).setOnClickListener(this.mRetakeClick);
        this.initTitleButton(v, R.id.btn_rotate, this.mRotateClick);
        v.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                PhotoEditController.this.mEditView.setAspectRatio(1, 1);
            }
        });
        return v;
    }

    private void initTitleButton(View v, int viewId, View.OnClickListener listener) {
        ImageView button = (ImageView)v.findViewById(viewId);
        button.setOnClickListener(listener);
    }

    private void finish() {
        if (this.mAct != null) {
            this.mAct.finish();
        }
    }

    @Override
    public void onResult(String[] paths, int requestCode) {
        String bmpPath = null;
        if (paths.length > 0) {
            bmpPath = paths[0];
        }
        MLog.info((Object)TAG, (String)("xuwakao : PhotoEditCtrl onresult, bmpPath = " + bmpPath), (Object[])new Object[0]);
        if (FP.empty((CharSequence)bmpPath) || bmpPath.lastIndexOf(".") == -1) {
            MLog.error((Object)TAG, (String)"onResult bmtppath is NULL", (Object[])new Object[0]);
            this.finish();
            return;
        }
        File tempFile = YYFileUtils.getTempFile((Context)this.mAct, (String)(BMP_TEMP_NAME + TimeUtils.curSec() + bmpPath.substring(bmpPath.lastIndexOf("."))));
        String tmpPath = tempFile.getAbsolutePath();
        boolean copySucc = YYFileUtils.copyFile((String)bmpPath, (String)tmpPath);
        if (copySucc) {
            this.bmpTmpPath = tmpPath;
            Bitmap bitmap = ImageUtil.decodeSampledBitmapFile((String)this.bmpTmpPath, (ImageConfig)ImageConfig.defaultImageConfig(), (boolean)true);
            if (bitmap == null) {
                MLog.error((Object)TAG, (String)("decodeSampledBitmapFile not successful, onResult bmpPath = " + bmpPath), (Object[])new Object[0]);
                this.finish();
                return;
            }
            this.mEditView.setImageBitmap(bitmap);
        } else {
            MLog.error((Object)TAG, (String)("copy file not successful, onResult bmpPath = " + bmpPath), (Object[])new Object[0]);
            this.finish();
        }
    }

    @Override
    public void onCancel() {
        this.deleteTempImage();
        this.mAct.setResult(0);
    }

    public void deleteTempImage() {
        if (this.bmpTmpPath != null) {
            if (MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)TAG, (String)("deleteTempImage path=" + this.bmpTmpPath), (Object[])new Object[0]);
            }
            YYFileUtils.removeFile((String)this.bmpTmpPath);
            this.bmpTmpPath = null;
        }
    }
}

