/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.router.service;

import android.app.Activity;
import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import com.alibaba.android.arouter.facade.Postcard;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.alibaba.android.arouter.facade.service.DegradeService;
import com.yy.mobile.router.service.DegradeInterceptor;
import com.yy.mobile.ui.utils.NavigationUtils;
import com.yy.mobile.ui.utils.js.exception.RestAPINotSupportException;
import com.yy.mobile.ui.utils.rest.NavRestHandler;
import com.yy.mobile.util.log.MLog;
import java.util.ArrayList;
import java.util.List;

@Route(path="/arouter/service/degrade")
public class GlobalDegradeService
implements DegradeService {
    private static final String TAG = "GlobalDegradeService";
    private static List<DegradeInterceptor> interceptors = new ArrayList<DegradeInterceptor>();

    public boolean onLost(Context context, Postcard postcard) {
        MLog.info((Object)TAG, (String)"this uri jump is too cheap!!!", (Object[])new Object[0]);
        for (DegradeInterceptor interceptor : interceptors) {
            if (!interceptor.intercept(context, postcard)) continue;
            MLog.info((Object)TAG, (String)("this url is intercepted by " + interceptor), (Object[])new Object[0]);
            return true;
        }
        Uri uri = postcard.getUri();
        if (!MLog.isLogLevelAboveVerbose()) {
            MLog.verbose((Object)TAG, (String)("shobal  gotouri=" + uri), (Object[])new Object[0]);
        }
        if (uri != null) {
            Uri.Builder reBuilder = uri.buildUpon();
            Bundle bundle = postcard.getExtras();
            for (String s : bundle.keySet()) {
                Object o = bundle.get(s);
                if (o == null) continue;
                reBuilder.appendQueryParameter(s, o.toString());
            }
            uri = reBuilder.build();
            try {
                String schema = uri.getScheme();
                if (schema == null || schema.isEmpty()) {
                    return false;
                }
                switch (schema) {
                    case "http": 
                    case "https": {
                        NavigationUtils.toJSSupportedWebView((Activity)context, uri.toString());
                        break;
                    }
                    case "yymelon": 
                    case "yymobile": {
                        NavRestHandler.getInstance().handleNavgationString((Activity)context, uri.toString(), (Object)true);
                        break;
                    }
                    default: {
                        MLog.error((Object)TAG, (String)"error uri!!!", (Object[])new Object[0]);
                        return false;
                    }
                }
                return true;
            }
            catch (RestAPINotSupportException e) {
                return false;
            }
        }
        return false;
    }

    public void init(Context context) {
    }

    public static void addDegradeInterceptor(DegradeInterceptor interceptor) {
        interceptors.add(interceptor);
    }
}

