/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget.dialog;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Bitmap;
import android.text.TextUtils;
import android.view.KeyEvent;
import android.view.View;
import android.view.Window;
import android.widget.EditText;
import android.widget.TextView;
import com.yy.mobile.image.RecycleImageView;
import com.yy.mobile.plugin.pluginunionmain.R;
import com.yy.mobile.ui.utils.SingleToastUtil;
import com.yy.mobile.ui.utils.dialog.BaseDialog;
import com.yy.mobile.util.NetworkUtils;
import com.yy.mobile.util.log.MLog;

public class PicLoginDialog
implements BaseDialog {
    private static final String TAG = "PicLoginDialog";
    private String mTitle;
    private String mOkLabel;
    private String mCancelLabel;
    private boolean mShowErrorTip;
    private Bitmap mCodeBitmap;
    private PicLoginDialogListener mListener;
    private DialogInterface.OnDismissListener mDismissListener;
    private Dialog mDialog;
    private TextView mErrorTips;
    private RecycleImageView mPicCode;

    public PicLoginDialog(String title, String okLabel, String cancelLabel, boolean showErrorTip, Bitmap codeBitmap, PicLoginDialogListener listener, DialogInterface.OnDismissListener dismissListener) {
        this.mTitle = title;
        this.mOkLabel = okLabel;
        this.mCancelLabel = cancelLabel;
        this.mShowErrorTip = showErrorTip;
        this.mCodeBitmap = codeBitmap;
        this.mListener = listener;
        this.mDismissListener = dismissListener;
    }

    public void init(Dialog dialog2) {
        this.mDialog = dialog2;
        this.mDialog.setCanceledOnTouchOutside(false);
        Window window = this.mDialog.getWindow();
        if (window == null) {
            MLog.info((Object)TAG, (String)"show PicLoginDialog error for window is null", (Object[])new Object[0]);
            return;
        }
        window.setContentView(this.getLayoutResId());
        TextView titleView = (TextView)window.findViewById(R.id.pic_login_title);
        final EditText input = (EditText)window.findViewById(R.id.pic_login_input);
        this.mErrorTips = (TextView)window.findViewById(R.id.pic_login_fail_msg);
        this.mPicCode = (RecycleImageView)window.findViewById(R.id.pic_login_image);
        TextView change = (TextView)window.findViewById(R.id.pic_login_change);
        TextView confirm = (TextView)window.findViewById(R.id.btn_ok);
        TextView cancel = (TextView)window.findViewById(R.id.btn_cancel);
        window.clearFlags(131072);
        window.setSoftInputMode(5);
        if (!TextUtils.isEmpty((CharSequence)this.mTitle)) {
            titleView.setText((CharSequence)this.mTitle);
        }
        if (!TextUtils.isEmpty((CharSequence)this.mCancelLabel)) {
            cancel.setText((CharSequence)this.mCancelLabel);
        }
        if (!TextUtils.isEmpty((CharSequence)this.mOkLabel)) {
            confirm.setText((CharSequence)this.mOkLabel);
        }
        this.mErrorTips.setVisibility(this.mShowErrorTip ? 0 : 4);
        MLog.info((Object)TAG, (String)"pic dialog init", (Object[])new Object[0]);
        if (this.mCodeBitmap != null) {
            this.mPicCode.setImageBitmap(this.mCodeBitmap);
        }
        change.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (!PicLoginDialog.this.checkNetToast()) {
                    return;
                }
                if (PicLoginDialog.this.mListener != null) {
                    PicLoginDialog.this.mListener.onChangePic(PicLoginDialog.this.mDialog);
                    input.setText((CharSequence)"");
                }
            }
        });
        confirm.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (PicLoginDialog.this.mListener != null) {
                    if (!PicLoginDialog.this.checkNetToast()) {
                        return;
                    }
                    PicLoginDialog.this.mListener.onConfirm(PicLoginDialog.this.mDialog, input);
                }
            }
        });
        cancel.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PicLoginDialog.this.mDialog.dismiss();
                if (PicLoginDialog.this.mListener != null) {
                    PicLoginDialog.this.mListener.onCancel();
                }
            }
        });
        input.setOnKeyListener(new View.OnKeyListener(){

            public boolean onKey(View v, int keyCode, KeyEvent event) {
                if (66 == keyCode && event.getAction() == 0) {
                    if (PicLoginDialog.this.mListener != null) {
                        if (!PicLoginDialog.this.checkNetToast()) {
                            return true;
                        }
                        PicLoginDialog.this.mListener.onConfirm(PicLoginDialog.this.mDialog, input);
                    }
                    MLog.info((Object)PicLoginDialog.TAG, (String)"enter to confirm", (Object[])new Object[0]);
                    return true;
                }
                return false;
            }
        });
        this.mDialog.setOnDismissListener(new DialogInterface.OnDismissListener(){

            public void onDismiss(DialogInterface dialog2) {
                if (PicLoginDialog.this.mDismissListener != null) {
                    PicLoginDialog.this.mDismissListener.onDismiss(dialog2);
                }
                PicLoginDialog.this.mCodeBitmap = null;
            }
        });
    }

    public int getLayoutResId() {
        return R.layout.layout_pic_login_dialog;
    }

    public boolean refreshPicLoginDialog(Bitmap codeBitmap, boolean showErrorTip) {
        this.mCodeBitmap = codeBitmap;
        this.mShowErrorTip = showErrorTip;
        if (this.mDialog != null && this.mDialog.isShowing()) {
            if (this.mPicCode != null && codeBitmap != null) {
                this.mPicCode.setImageBitmap(codeBitmap);
            }
            if (this.mErrorTips != null) {
                this.mErrorTips.setVisibility(showErrorTip ? 0 : 4);
            }
            return this.mPicCode != null && this.mErrorTips != null;
        }
        return false;
    }

    private boolean checkNetToast() {
        boolean falg = NetworkUtils.isNetworkStrictlyAvailable((Context)this.mDialog.getContext());
        if (!falg) {
            SingleToastUtil.showToast((int)R.string.str_network_not_capable);
        }
        return falg;
    }

    public void dismiss() {
        if (this.mDialog != null && this.mDialog.isShowing()) {
            this.mDialog.dismiss();
        }
        this.mCodeBitmap = null;
        this.mListener = null;
        this.mDismissListener = null;
    }

    public static interface PicLoginDialogListener {
        public void onConfirm(Dialog var1, EditText var2);

        public void onCancel();

        public void onChangePic(Dialog var1);
    }
}

