/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.TextView;
import com.yy.mobile.plugin.pluginunionmain.R;
import com.yy.mobile.util.log.MLog;

public class YYStrokeTextView
extends TextView {
    private static final String TAG = "StrokeTextView";
    private TextView borderText = null;
    int borderColor;
    int borderWidth;

    public YYStrokeTextView(Context context) {
        super(context);
        this.borderText = new TextView(context);
        this.init();
    }

    public YYStrokeTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.borderText = new TextView(context, attrs);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.YYStrokeTextView);
        this.borderColor = a.getColor(R.styleable.YYStrokeTextView_yystrokeColor, -16777216);
        this.borderWidth = a.getInt(R.styleable.YYStrokeTextView_yystrokeBorderWidth, 1);
        a.recycle();
        this.init();
    }

    public YYStrokeTextView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.borderText = new TextView(context, attrs, defStyle);
        this.init();
    }

    public void init() {
        TextPaint tp1 = this.borderText.getPaint();
        tp1.setStrokeWidth((float)this.borderWidth);
        tp1.setStyle(Paint.Style.STROKE);
        this.borderText.setTextColor(this.borderColor);
        this.borderText.setGravity(this.getGravity());
    }

    public void setLayoutParams(ViewGroup.LayoutParams params) {
        super.setLayoutParams(params);
        this.borderText.setLayoutParams(params);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        CharSequence tt = this.borderText.getText();
        if (tt == null || !tt.equals(this.getText())) {
            this.borderText.setText(this.getText());
            this.postInvalidate();
        }
        try {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            this.borderText.measure(widthMeasureSpec, heightMeasureSpec);
        }
        catch (Throwable throwable) {
            MLog.error((Object)TAG, (String)("onMeasure error " + throwable), (Object[])new Object[0]);
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.borderText.layout(left, top, right, bottom);
    }

    protected void onDraw(Canvas canvas) {
        this.borderText.draw(canvas);
        super.onDraw(canvas);
    }
}

