/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.utils;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.support.v4.app.ActivityCompat;
import android.text.TextUtils;
import com.alibaba.android.arouter.launcher.ARouter;
import com.yy.android.small.Small;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.http.httpsparser.HttpsParser;
import com.yy.mobile.model.store.HostState;
import com.yy.mobile.model.store.HostStore;
import com.yy.mobile.sdkwrapper.login.LoginProtocol;
import com.yy.mobile.ui.activity.GlobalActivityManager;
import com.yy.mobile.ui.channel.SignDetailsActivity;
import com.yy.mobile.ui.common.JsSupportWebAcitivity;
import com.yy.mobile.ui.profile.anchor.AnchorWorksDetailActivity;
import com.yy.mobile.ui.setting.MsgNoticeActivity;
import com.yy.mobile.ui.sharpgirls.SharpGirlDisplayActivity;
import com.yy.mobile.ui.utils.SingleToastUtil;
import com.yy.mobile.ui.utils.rest.NavRestHandler;
import com.yy.mobile.ui.widget.toast.Toast;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.ylink.bridge.CoreApiManager;
import com.yy.mobile.ylink.bridge.coreapi.NavigationUtilApi;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.LinkUriProvider;
import com.yymobile.core.UriProvider;
import com.yymobile.core.domain.DomainManager;
import com.yymobile.core.moment.MomentCategory;
import com.yymobile.core.moment.request.MomentFrom;
import com.yymobile.core.statistic.IHiidoStatisticCore;
import com.yymobile.core.statistic.pushnotify.PushNotifyStatisticHelper;
import java.io.Serializable;
import java.util.HashMap;

public class NavigationUtils {
    private static final String TAG = "NavigationUtils";

    public static void slideStartActivity(Context context, Intent intent) {
        com.yy.mobile.baseapi.NavigationUtils.slideStartActivity((Context)context, (Intent)intent);
    }

    public static void slideStartActivityForResult(Context context, Intent intent, int requestCode) {
        com.yy.mobile.baseapi.NavigationUtils.slideStartActivityForResult((Context)context, (Intent)intent, (int)requestCode);
    }

    public static void fadeStartActivity(Context context, Intent intent) {
        com.yy.mobile.baseapi.NavigationUtils.fadeStartActivity((Context)context, (Intent)intent);
    }

    public static void navToBrower(Context context, String url) {
        Intent it = new Intent("android.intent.action.VIEW");
        url = HttpsParser.convertToHttps((String)url);
        it.setData(Uri.parse((String)url));
        it = Intent.createChooser((Intent)it, null);
        NavigationUtils.slideStartActivity(context, it);
    }

    public static void navTo(Activity context, String uriString) {
        NavRestHandler.getInstance().handleNavString(context, uriString);
    }

    public static void navTo(Activity context, Uri uri) {
        NavRestHandler.getInstance().handleNav(context, uri);
    }

    public static void navToUri(Activity context, String uriString) {
        if (TextUtils.isEmpty((CharSequence)uriString)) {
            return;
        }
        Uri uri = Uri.parse((String)uriString.trim());
        NavigationUtils.navToUri(context, uri);
    }

    public static void navToUri(Activity context, Uri uri) {
        ARouter.getInstance().build(uri).navigation((Context)context);
    }

    public static void navTo(Activity context, String uriString, Object others) {
        NavRestHandler.getInstance().handleNavString(context, uriString, others);
    }

    public static void navTo(Activity context, Uri uri, Object others) {
        NavRestHandler.getInstance().handleNav(context, uri, others);
    }

    public static void toAnchorWorksDetailActivity(Context act, long anchorId, String category) {
        Intent intent = new Intent(act, AnchorWorksDetailActivity.class);
        intent.putExtra("anchor_uid", anchorId);
        intent.putExtra("category", category);
        NavigationUtils.slideStartActivity(act, intent);
    }

    public static void toLoginFrom(Context act, String tag) {
        NavigationUtils.toLogin(act);
    }

    public static void toLogin(Context act, boolean showBack, boolean isKicked) {
        NavigationUtils.toLogin(act);
    }

    public static void toLogin(Context act) {
        LoginUtil.showLoginDialog((Context)act);
    }

    public static void toAppMarket(Context context) {
        try {
            Intent it = new Intent("android.intent.action.VIEW");
            it.setData(Uri.parse((String)("market://details?id=" + context.getPackageName())));
            ActivityCompat.startActivity((Context)((Activity)context), (Intent)it, null);
        }
        catch (Exception e) {
            Toast.makeText((Context)context, (CharSequence)"\u672a\u68c0\u6d4b\u5230\u6709\u5b89\u88c5\u5e94\u7528\u5e02\u573a", (int)0).show();
            MLog.error((Object)"toAppMarket", (String)"no market installed", (Object[])new Object[0]);
        }
    }

    public static void toMain(Activity context) {
        ((NavigationUtilApi)CoreApiManager.getInstance().getApi(NavigationUtilApi.class)).toMain((Context)context);
    }

    public static void toMainTab(Activity context, String tabId) {
        ((NavigationUtilApi)CoreApiManager.getInstance().getApi(NavigationUtilApi.class)).toMainTab((Context)context, tabId);
    }

    public static void toMainTab(Activity context, int index) {
        ((NavigationUtilApi)CoreApiManager.getInstance().getApi(NavigationUtilApi.class)).toMainTab((Context)context, index);
    }

    public static void toMyChatActivity(Activity context, boolean isShare, long sid, long ssid) {
        Intent intent = new Intent("IM_TO_MY_CHAT_ACTIVITY");
        intent.putExtra("my_chat_is_share", isShare);
        intent.putExtra("my_chat_sid", sid);
        intent.putExtra("my_chat_ssid", ssid);
        intent.putExtra("my_chat_method_name", "toMyChatActivity_with_channel");
        Small.startAction((Intent)intent, (Activity)context);
    }

    public static void toUrl(Activity context, String url) {
        Intent intent = new Intent();
        intent.setAction("android.intent.action.VIEW");
        Uri contentUrl = Uri.parse((String)url);
        intent.setData(contentUrl);
        NavigationUtils.slideStartActivity((Context)context, intent);
    }

    public static void toJSSupportedWebView(Activity context, String url, boolean isFromBindPhoneAfterLogin) {
        NavigationUtils.toJSSupportedWebView(context, url, 17, false, false, false, isFromBindPhoneAfterLogin);
    }

    public static void toJSSupportedWebView(Activity context, String url, int requestCode, int isReurnRresh, int isReturnReshPart) {
        NavigationUtils.toJSSupportedWebView(context, url, 17, false, false, requestCode, isReurnRresh, isReturnReshPart);
    }

    public static void toJSSupportedWebView(Activity context, String url) {
        NavigationUtils.toJSSupportedWebView(context, url, 17, false, false);
    }

    public static void toJSSupportedWebView(Activity context, String url, String title) {
        NavigationUtils.toJSSupportedWebView(context, url, title, false, false);
    }

    public static void toJSSupportedWebView(Activity context, String url, boolean disableRefresh, boolean autoFinish) {
        NavigationUtils.toJSSupportedWebView(context, url, 17, disableRefresh, autoFinish);
    }

    public static void toJSSupportedWebView(Activity context, String url, String title, boolean disableRefresh, boolean autoFinish) {
        NavigationUtils.toJSSupportedWebView(context, url, title, true, disableRefresh, autoFinish);
    }

    public static void toJSSupportedWebView(Activity context, String url, String title, boolean isForceUseTitle, boolean disableRefresh, boolean autoFinish) {
        NavigationUtils.toJSSupportedWebView(context, url, title, isForceUseTitle, 17, disableRefresh, autoFinish, false, false);
    }

    public static void toJSSupportedWebView(Activity context, String url, int feature, boolean disableRefresh, boolean autoFinish) {
        NavigationUtils.toJSSupportedWebView(context, url, feature, disableRefresh, autoFinish, false);
    }

    public static void toJSSupportedWebView(Activity context, String url, int feature, boolean disableRefresh, boolean autoFinish, boolean showFeedback, boolean isFromBindPhoneAfterLogin) {
        NavigationUtils.toJSSupportedWebView(context, url, null, true, feature, disableRefresh, autoFinish, showFeedback, isFromBindPhoneAfterLogin);
    }

    public static void toJSSupportedWebView(Activity context, String url, int feature, boolean disableRefresh, boolean autoFinish, boolean showFeedback) {
        NavigationUtils.toJSSupportedWebView(context, url, null, true, feature, disableRefresh, autoFinish, showFeedback, false);
    }

    public static void toJSSupportedWebViewByApplication(Context context, String url) {
        NavigationUtils.toJSSupportedWebViewByApplication(context, url, null, true, 17, false, false, true, false);
    }

    public static void toJSSupportedWebViewByApplication(Context application, String url, String title, boolean forceUsePageTitle, int feature, boolean disableRefresh, boolean autoFinish, boolean showFeedback, boolean isFromBindPhoneAfterLogin) {
        if (application == null) {
            MLog.warn((Object)"toJSSupportedWebViewByApplication", (String)"context is null", (Object[])new Object[0]);
            return;
        }
        Intent intent = new Intent();
        intent.setClass(application, JsSupportWebAcitivity.class);
        url = HttpsParser.convertToHttps((String)url);
        intent.putExtra("yyweburl", url);
        if (StringUtils.isEmpty((String)title).booleanValue()) {
            intent.putExtra("yywebtitle", title);
        }
        intent.putExtra("webviewFeature", feature);
        intent.putExtra("usepagetitle", forceUsePageTitle);
        if (disableRefresh) {
            intent.putExtra("disableRefresh", "disableRefresh");
        }
        if (showFeedback) {
            intent.putExtra("usefeedback", true);
        }
        if (autoFinish) {
            intent.putExtra("autoFinish", "autoFinish");
        }
        intent.putExtra("isFromBindPhone", isFromBindPhoneAfterLogin);
        intent.setFlags(0x10000000);
        NavigationUtils.slideStartActivity(application, intent);
    }

    public static void toJSSupportedWebView(Activity context, String url, String title, boolean forceUsePageTitle, int feature, boolean disableRefresh, boolean autoFinish, boolean showFeedback, boolean isFromBindPhoneAfterLogin) {
        if (context == null) {
            MLog.warn((Object)"toJSSupportedWebView", (String)"context is null", (Object[])new Object[0]);
            return;
        }
        Intent intent = new Intent();
        intent.setClass((Context)context, JsSupportWebAcitivity.class);
        url = HttpsParser.convertToHttps((String)url);
        intent.putExtra("yyweburl", url);
        if (StringUtils.isEmpty((String)title).booleanValue()) {
            intent.putExtra("yywebtitle", title);
        }
        intent.putExtra("webviewFeature", feature);
        intent.putExtra("usepagetitle", forceUsePageTitle);
        if (disableRefresh) {
            intent.putExtra("disableRefresh", "disableRefresh");
        }
        if (showFeedback) {
            intent.putExtra("usefeedback", true);
        }
        if (autoFinish) {
            intent.putExtra("autoFinish", "autoFinish");
        }
        intent.putExtra("isFromBindPhone", isFromBindPhoneAfterLogin);
        NavigationUtils.slideStartActivity((Context)context, intent);
    }

    public static void toJSSupportedWebView(Activity context, String url, int feature, boolean disableRefresh, boolean autoFinish, int requestCode, int isReturnResh, int isReturnReshPart) {
        if (context == null) {
            MLog.warn((Object)"toJSSupportedWebView", (String)"context is null", (Object[])new Object[0]);
            return;
        }
        Intent intent = new Intent();
        intent.setClass((Context)context, JsSupportWebAcitivity.class);
        url = HttpsParser.convertToHttps((String)url);
        intent.putExtra("yyweburl", url);
        intent.putExtra("webviewFeature", feature);
        intent.putExtra("return_refresh", isReturnResh);
        intent.putExtra("return_refresh_part", isReturnReshPart);
        if (disableRefresh) {
            intent.putExtra("disableRefresh", "disableRefresh");
        }
        if (autoFinish) {
            intent.putExtra("autoFinish", "autoFinish");
        }
        NavigationUtils.slideStartActivityForResult((Context)context, intent, requestCode);
    }

    public static void toJSSupportedWebView(Activity context, String url, int feature, boolean disableRefresh, boolean autoFinish, String pageBackStyle) {
        if (context == null) {
            MLog.warn((Object)"toJSSupportedWebView", (String)"context is null", (Object[])new Object[0]);
            return;
        }
        Intent intent = new Intent();
        intent.setClass((Context)context, JsSupportWebAcitivity.class);
        url = HttpsParser.convertToHttps((String)url);
        intent.putExtra("yyweburl", url);
        intent.putExtra("webviewFeature", feature);
        if (disableRefresh) {
            intent.putExtra("disableRefresh", "disableRefresh");
        }
        if (autoFinish) {
            intent.putExtra("autoFinish", "autoFinish");
        }
        if (pageBackStyle != null && pageBackStyle.equals("history")) {
            intent.putExtra("web_page_back_style", "history");
        }
        NavigationUtils.slideStartActivity((Context)context, intent);
    }

    public static void toJSSupportedWebViewFullScreen(Activity context, String url) {
        if (context == null) {
            MLog.warn((Object)"toJSSupportedWebView", (String)"context is null", (Object[])new Object[0]);
            return;
        }
        Intent intent = new Intent();
        intent.setClass((Context)context, JsSupportWebAcitivity.class);
        url = HttpsParser.convertToHttps((String)url);
        intent.putExtra("yyweburl", url);
        intent.putExtra("webviewFeature", 17);
        intent.putExtra("full_screen", true);
        NavigationUtils.fadeStartActivity((Context)context, intent);
    }

    public static void toFeedBack(Context context, String appId) {
        ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic("50206", "0006");
        StringBuffer sb = new StringBuffer("https://" + DomainManager.getKfYyCom() + "/app/im.html");
        sb.append("?");
        sb.append("ft=app&appid=110");
        sb.append("&uid=" + LoginUtil.getUid());
        sb.append("&feedappid=" + (StringUtils.isEmpty((String)appId) == false ? appId : "yymand"));
        sb.append("&ticket=" + LoginProtocol.Factory.get().getWebToken());
        NavigationUtils.toJSSupportedWebView((Activity)context, sb.toString(), 17, false, false, true);
    }

    public static void toFeedBack(String url, Context context) {
        NavigationUtils.toJSSupportedWebView((Activity)context, url, 17, false, false, true);
    }

    public static void toProfile(Context context, long uid, int userType) {
        NavigationUtils.toPersonPage(context, uid);
    }

    public static void toProfile(Context context, long uid) {
        NavigationUtils.toPersonPage(context, uid);
    }

    public static void toPersonPage(Context context, long uid) {
        ARouter.getInstance().build("/User/View").withLong("extra_anchor_uid", uid).navigation(context);
    }

    public static void toPersonPage(Context context, long uid, int tabId) {
        ARouter.getInstance().build("/User/View").withLong("extra_anchor_uid", uid).withInt("extra_tab_id", tabId).navigation(context);
    }

    public static void toMyMessage(Context context) {
        if (context instanceof Activity) {
            Intent intent = new Intent("IM_TO_MY_CHAT_ACTIVITY");
            intent.putExtra("my_chat_method_name", "toMyMessage");
            Small.startAction((Intent)intent, (Activity)((Activity)context));
        }
    }

    public static void toMeVideo(Context context, String fromPath) {
        Intent intent = new Intent("SHENQU_ACTION_ME_SHORT_VIDEO");
        intent.putExtra("KEY", "ToActivityMeVideo");
        intent.putExtra("key_jump_from_path", fromPath);
        Small.startAction((Intent)intent, (Activity)((Activity)context));
    }

    public static void toMsgNotice(Context context) {
        Intent intent = new Intent(context, MsgNoticeActivity.class);
        NavigationUtils.slideStartActivity(context, intent);
    }

    public static void toBlackListSettingActivity(Context context) {
        if (context instanceof Activity) {
            Intent intent = new Intent("IM_TO_BLACK_LIST_SETTING_ACTIVITY");
            Small.startAction((Intent)intent, (Activity)((Activity)context));
        }
    }

    public static void toPrivacySetting(Context context) {
        if (context instanceof Activity) {
            Intent intent = new Intent("IM_TO_PRIVACY_SETTING_ACTIVITY");
            Small.startAction((Intent)intent, (Activity)((Activity)context));
        }
    }

    public static void toUserInfo(Context context, long uid) {
        NavigationUtils.toPersonPage(context, uid);
    }

    public static void toBindPhoneNumberActivity(Context context) {
        StringBuffer sb = new StringBuffer(UriProvider.YY_UDB_BINDPHONE_URL);
        sb.append("?");
        sb.append("appid=yymand");
        sb.append("&action=1");
        sb.append("&ticket=" + LoginProtocol.Factory.get().getOTP("yymand"));
        sb.append("&ticketType=2");
        sb.append("&yyuid=" + LoginUtil.getUid());
        sb.append("&deviceData=" + LoginProtocol.Factory.get().getDeviceData());
        NavigationUtils.toJSSupportedWebView((Activity)context, sb.toString());
    }

    public static void toBindPhoneNumberNewActivity(Activity activity) {
        StringBuffer sb = new StringBuffer(UriProvider.YY_UDB_BINDPHONE_URL);
        sb.append("?");
        sb.append("appid=yymand");
        sb.append("&action=1");
        sb.append("&ticket=" + LoginProtocol.Factory.get().getOTP("yymand"));
        sb.append("&ticketType=2");
        sb.append("&yyuid=" + LoginUtil.getUid());
        sb.append("&deviceData=" + LoginProtocol.Factory.get().getDeviceData());
        NavigationUtils.toJSSupportedWebView(activity, sb.toString());
    }

    public static void toBindPhoneNumberWithoutBack(Activity activity) {
        StringBuffer sb = new StringBuffer(UriProvider.YY_UDB_BINDPHONE_URL);
        sb.append("?");
        sb.append("appid=yymand");
        sb.append("&action=1");
        sb.append("&ticket=" + LoginProtocol.Factory.get().getOTP("yymand"));
        sb.append("&ticketType=2");
        sb.append("&yyuid=" + LoginUtil.getUid());
        sb.append("&deviceData=" + LoginProtocol.Factory.get().getDeviceData());
        sb.append("&isShowBack=false");
        sb.append("&isShowPopBack=false");
        sb.append("&isJumpSuccessed=false");
        if (!(GlobalActivityManager.INSTANCE.getCurrentActivity() instanceof JsSupportWebAcitivity)) {
            ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "51410", "0001", (Serializable)PushNotifyStatisticHelper.getProperty());
            NavigationUtils.toJSSupportedWebView(activity, sb.toString(), true);
        }
    }

    public static void toPhotoCenterActivity(Context context) {
        ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "0301", "0002");
        Intent intent = new Intent();
        intent.setAction("com.yy.mobile.ui.gallery.GalleryLivingListActivity");
        try {
            NavigationUtils.slideStartActivity(context, intent);
        }
        catch (Throwable throwable) {
            MLog.error((Object)context, (String)"had not found activity com.yy.mobile.ui.gallery.GalleryLivingListActivity", (Object[])new Object[0]);
            SingleToastUtil.showToast((Context)context.getApplicationContext(), (String)"\u8be5\u6a21\u5757\u6b63\u5728\u66f4\u65b0\u4e2d\uff0c\u656c\u8bf7\u671f\u5f85");
        }
    }

    public static void toSignInfoActivity(Activity context) {
        Intent intent = new Intent((Context)context, SignDetailsActivity.class);
        NavigationUtils.slideStartActivity((Context)context, intent);
    }

    public static void toMobileLiveCameraPerviewViaMain(Activity context) {
        if (!MLog.isLogLevelAboveVerbose()) {
            MLog.verbose((Object)"xuwakao", (String)("toMobileLiveCameraPerviewViaMain,context=" + context), (Object[])new Object[0]);
        }
        Intent intent = new Intent((Context)context, ((HostState)HostStore.INSTANCE.getState()).getMainActivityClass());
        intent.putExtra("EXTRA_START_FROM_ANCHOR_PER", 111);
        intent.addFlags(0x4000000);
        intent.addFlags(0x20000000);
        context.startActivity(intent);
    }

    public static void toPlayPreviewVideo(Activity activity, String videoUrl) {
        Intent intent = new Intent((Context)activity, SharpGirlDisplayActivity.class);
        intent.putExtra("ONLINE_VIDEO_URL", videoUrl);
        intent.putExtra("VIDEO_FROM", "CHANNEL");
        activity.startActivity(intent);
    }

    public static void toShortVideoDisplayActivity(Context context, long resId, String videoUrl, float dpi, HashMap<String, Object> extend) {
        NavigationUtils.toShortVideoDisplayActivity(context, resId, videoUrl, dpi, null, extend);
    }

    public static void toShortVideoDisplayActivity(Context context, long resId, String videoUrl, float dpi, String snapshotUrl, HashMap<String, Object> extend) {
        Intent intent = new Intent("SHENQU_ACTION_PLAY");
        intent.putExtra("KEY", "ToActivityShortVideoDisplay");
        Bundle bundle = new Bundle();
        bundle.putString("videoUrl", videoUrl);
        bundle.putLong("shenquId", resId);
        if (dpi > 0.0f) {
            bundle.putFloat("dpi", dpi);
        }
        if (snapshotUrl != null) {
            if (extend == null) {
                extend = new HashMap();
            }
            extend.put("extra_key_play_snapshort_url", snapshotUrl);
        }
        if (extend != null) {
            bundle.putSerializable("extend", extend);
        }
        intent.putExtras(bundle);
        Small.startAction((Intent)intent, (Activity)((Activity)context));
    }

    public static void toShortVideoRecordActivity(Context context, int cameraWorkFlowStrategy) {
        NavigationUtils.toShortVideoRecordActivity(context, cameraWorkFlowStrategy, null, null);
    }

    public static void toShortVideoRecordActivity(Context context, int strategy, String topic, String jumpPath) {
        Intent intent = new Intent("SHENQU_ACTION_VIDEO_RECORD");
        intent.putExtra("KEY", "ToActivityVideoRecord");
        intent.putExtra("key_camera_workflow_strategy", strategy);
        if (!StringUtils.isEmpty((String)topic).booleanValue()) {
            intent.putExtra("key_from_topic", topic);
        }
        if (!StringUtils.isEmpty((String)jumpPath).booleanValue()) {
            intent.putExtra("key_jump_to_path", jumpPath);
        }
        Small.startAction((Intent)intent, (Activity)((Activity)context));
    }

    @Deprecated
    public static void toMomentListActivity(Context context, MomentCategory category) {
        NavigationUtils.toMomentListActivity(context, category, MomentFrom.Other);
    }

    public static void toMomentListActivity(Context context, MomentCategory category, MomentFrom from) {
        ARouter.getInstance().build("/Moment/List").withSerializable("listCategory", (Serializable)category).withInt("from", from.getStatistic()).navigation(context);
    }

    public static void toRealNameCertificateWebView(Activity activity, long uid) {
        String url = UriProvider.USER_INFO_VERIFY + "?" + "appid=yy_mob" + "&ticket=" + LoginProtocol.Factory.get().getToken("5060") + "&ticketAppid=5060" + "&ticketType=0" + "&yyuid=" + uid + "&faceCertAllowed=1" + "&useNewZmxy=true" + "&sourceType=sdk";
        MLog.info((Object)TAG, (String)("toJSSupportedWebView: url = " + url), (Object[])new Object[0]);
        NavigationUtils.toJSSupportedWebView(activity, url);
    }

    public static void toLianMaiFailed(Activity context) {
        String url = LinkUriProvider.LIANMAI_AUTH_FAILURE;
        MLog.info((Object)TAG, (String)("toLianMaiFailed url =" + url), (Object[])new Object[0]);
        NavigationUtils.toJSSupportedWebView(context, url);
    }

    public static void toMobileLivePersonalReplayActivity(Context context, long uid) {
        Intent intent = new Intent("START_ACTION_REPLAY");
        intent.putExtra("KEY", "toMobileLivePersonalReplayActivity");
        intent.putExtra("uid", uid);
        Small.startAction((Intent)intent, (Activity)((Activity)context));
    }

    public static void toMobileLiveReplayWithTitle(Context context, String replayId, long uid, String playUrl, String imgUrl, String title, int toMobileLiveReplayPath) {
        Intent intent = new Intent("START_ACTION_REPLAY");
        intent.putExtra("KEY", "toMobileLiveReplayWithTitle");
        intent.putExtra("replayId", replayId);
        intent.putExtra("uid", uid);
        intent.putExtra("playurl", playUrl);
        intent.putExtra("imgUrl", imgUrl);
        intent.putExtra("title", title);
        intent.putExtra("toMobileLiveReplayPath", toMobileLiveReplayPath);
        Small.startAction((Intent)intent, (Activity)((Activity)context));
    }

    public static void toCameraPerviewActivity(Context context, String key, String value) {
        MLog.info((Object)TAG, (String)"toCameraPerviewActivity: startAction START_ACTION_MOBILE_LIVE", (Object[])new Object[0]);
        Intent intent = new Intent("START_ACTION_MOBILE_LIVE");
        intent.putExtra("KEY", "toCameraPerviewActivity");
        intent.putExtra("fromKey", key);
        intent.putExtra("fromValue", value);
        Small.startAction((Intent)intent, (Activity)((Activity)context));
    }

    public static void toCameraPerviewActivity(Context context) {
        Intent intent = new Intent("START_ACTION_MOBILE_LIVE");
        intent.putExtra("KEY", "toCameraPerviewActivity");
        Small.startAction((Intent)intent, (Activity)((Activity)context));
    }

    public static void toVoiceRoom(Context context) {
        Small.startAction((Intent)new Intent("START_ACTION_VOICE_HOMEPAGE"), (Activity)((Activity)context));
    }

    public static class YYWebViewFeature {
        public static final int FEATURE_SUPPORT_JS = 1;
        public static final int FEATURE_SUPPORT_TOOLBAR = 2;
        public static final int FEATURE_SUPPORT_APPSTORE_LINK = 4;
        public static final int FEATURE_CLEAR_CACHE = 8;
        public static final int FEATURE_ENABLE_CACHE = 16;
        public static final int FEATURE_CLEAR_FORMDATA = 32;
        public static final int FEATURE_CLEAR_HISTORY = 64;
    }
}

