/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.shenqu.tanmu;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.widget.TextView;
import com.yy.mobile.plugin.pluginunionmain.R;
import com.yy.mobile.util.log.MLog;
import java.lang.reflect.Field;

public class BottomTextView
extends TextView {
    private static final String TAG = "BottomTextView";
    TextPaint mTextPaint = this.getPaint();
    public boolean mIsDrawSide;
    public int mInnerColor;
    public int mOuterColor;
    public int mDefaultColor;

    public BottomTextView(Context context, int outerColor, int innnerColor, boolean isdrawside, int defaultColor) {
        super(context);
        this.mTextPaint.setTextSize((float)BottomTextView.sp2px(context, 18.0f));
        this.mInnerColor = innnerColor;
        this.mOuterColor = outerColor;
        this.mIsDrawSide = isdrawside;
        this.mDefaultColor = defaultColor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BottomTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mTextPaint.setTextSize((float)BottomTextView.sp2px(context, 18.0f));
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.BottomTextView);
        try {
            this.mInnerColor = a.getColor(R.styleable.BottomTextView_innnerColor, 0xFFFFFF);
            this.mOuterColor = a.getColor(R.styleable.BottomTextView_outerColor, 0xFFFFFF);
            this.mDefaultColor = a.getColor(R.styleable.BottomTextView_defaultColor, -1);
            this.mIsDrawSide = a.getBoolean(R.styleable.BottomTextView_isDrawSide, false);
        }
        finally {
            a.recycle();
        }
    }

    public BottomTextView(Context context, AttributeSet attrs, int defStyle, int outerColor, int innnerColor, boolean isdrawside, int defaultColor) {
        super(context, attrs, defStyle);
        this.mTextPaint.setTextSize((float)BottomTextView.sp2px(context, 18.0f));
        this.mInnerColor = innnerColor;
        this.mOuterColor = outerColor;
        this.mIsDrawSide = isdrawside;
        this.mDefaultColor = defaultColor;
    }

    protected void onDraw(Canvas canvas) {
        if (this.mIsDrawSide) {
            this.mTextPaint.setShadowLayer(0.0f, 0.0f, 0.0f, 0);
            this.setTextColorUseReflection(this.mOuterColor);
            this.mTextPaint.setStrokeWidth(2.0f);
            this.mTextPaint.setStyle(Paint.Style.FILL_AND_STROKE);
            this.mTextPaint.setFakeBoldText(true);
            super.onDraw(canvas);
            this.setTextColorUseReflection(this.mInnerColor);
            this.mTextPaint.setStrokeWidth(0.0f);
            this.mTextPaint.setStyle(Paint.Style.FILL_AND_STROKE);
            this.mTextPaint.setFakeBoldText(false);
        } else {
            this.setTextColorUseReflection(this.mDefaultColor);
            this.mTextPaint.setShadowLayer(2.0f, 3.0f, 3.0f, 0x5A000000);
        }
        super.onDraw(canvas);
    }

    private void setTextColorUseReflection(int color2) {
        try {
            Field textColorField = TextView.class.getDeclaredField("mCurTextColor");
            textColorField.setAccessible(true);
            textColorField.set((Object)this, color2);
            textColorField.setAccessible(false);
        }
        catch (Throwable throwable) {
            MLog.error((Object)TAG, (Throwable)throwable);
        }
        this.mTextPaint.setColor(color2);
    }

    public static int sp2px(Context context, float spValue) {
        float fontScale = context.getResources().getDisplayMetrics().scaledDensity;
        return (int)(spValue * fontScale + 0.5f);
    }
}

