/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.profile.takephoto;

import android.app.Activity;
import android.app.AppOpsManager;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.Process;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.FileProvider;
import android.view.View;
import android.widget.RelativeLayout;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.gyf.immersionbar.ImmersionBar;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.permission.AndroidPermission;
import com.yy.mobile.plugin.pluginunionmain.R;
import com.yy.mobile.ui.BaseActivity;
import com.yy.mobile.ui.profile.takephoto.PhotoEditController;
import com.yy.mobile.ui.profile.takephoto.TakePhotoController;
import com.yy.mobile.ui.utils.SingleToastUtil;
import com.yy.mobile.ui.utils.YYImageUtils;
import com.yy.mobile.ui.utils.dialog.BaseDialog;
import com.yy.mobile.ui.utils.dialog.DialogLinkManager;
import com.yy.mobile.ui.utils.dialog.OkDialog;
import com.yy.mobile.ui.utils.dialog.OkDialogListener;
import com.yy.mobile.util.ScreenUtil;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.YYFileUtils;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.ICoreManagerBase;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;

@Route(path="/Media/TakePhoto")
public class PictureTakerActivity
extends BaseActivity {
    private static final String TAG = "PictureTakerActivity";
    public static final String PHOTO_PATH = "edit_photo_path_key";
    private static final String RESULT_KEY = "result_path_key";
    public static final int RESULT_FAIL = 2;
    private static final String TAKE_TEMP = "picture_taker_temp.jpg";
    private static final String CAMERA_PREFIX = "picture_";
    public static final String TAKE_PHOTO_FILE_PATH = "take_photo_file_path";
    private IController mController;
    private String mPath;
    private ArrayList<String> mSelectedPaths;
    private int mStyle;
    private int mMethod;
    private int amount = 9;
    private int maxSize = Integer.MAX_VALUE;
    private String[] mResultPath;
    private String mCameraCapturingName;
    private String mFlagOfJump;
    DialogLinkManager dialogManager;
    private static final int REQUEST_EXTERNAL_STORAGE = 1;
    private static String[] PERMISSIONS_STORAGE = new String[]{"android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE"};

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Bundle data = null;
        data = savedInstanceState != null ? savedInstanceState : this.getIntent().getExtras();
        this.mPath = data.getString(PHOTO_PATH);
        this.mStyle = data.getInt("act_style_key", 1);
        this.amount = data.getInt("params_picture_amount", 9);
        this.maxSize = data.getInt("params_picture_max_size", Integer.MAX_VALUE);
        this.mFlagOfJump = data.getString("params_picture_flag_of_jump", "");
        MLog.verbose((Object)TAG, (String)("xuwakao : onCreate, savedInstanceState = " + savedInstanceState + ", mPath = " + this.mPath + ", mStyle = " + this.mStyle), (Object[])new Object[0]);
        try {
            int permission2 = ActivityCompat.checkSelfPermission((Context)this, (String)"android.permission.WRITE_EXTERNAL_STORAGE");
            if (permission2 != 0) {
                ActivityCompat.requestPermissions((Activity)this, (String[])PERMISSIONS_STORAGE, (int)1);
            }
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (String)"onCreate: check external storage error, which is ", (Throwable)e, (Object[])new Object[0]);
        }
        this.mMethod = !StringUtils.isEmptyString((String)this.mPath) ? 0 : data.getInt("take_photo_method_key", 2);
        if (this.mStyle == 1 || this.mStyle == 2 || this.mStyle == 5) {
            boolean compress = this.mStyle != 2 && this.mStyle != 5;
            this.mController = new TakePhotoController(this, compress);
            this.mSelectedPaths = data.getStringArrayList("act_extra_key_selected");
        } else {
            PhotoEditController ctrl = new PhotoEditController(this);
            if (this.mStyle == 4) {
                ctrl.enableClipPortrait(true);
            }
            this.mController = ctrl;
        }
        this.getWindow().setBackgroundDrawableResource(R.color.transparent);
        this.setContentView(this.mController.getContentView());
        if (this.mStyle == 5) {
            ((TakePhotoController)this.mController).setContentViewOkText("\u786e\u8ba4");
            ((TakePhotoController)this.mController).setContentViewTitle("\u786e\u8ba4\u56fe\u7247");
        }
        if (savedInstanceState != null) {
            final String[] result = savedInstanceState.getStringArray(RESULT_KEY);
            if (this.validateImages(result)) {
                this.getHandler().post(new Runnable(){

                    @Override
                    public void run() {
                        PictureTakerActivity.this.handleResult(result, PictureTakerActivity.this.mMethod);
                    }
                });
            }
            this.mCameraCapturingName = savedInstanceState.getString(TAKE_PHOTO_FILE_PATH);
        } else if (this.mMethod == 0) {
            this.mController.onResult(new String[]{this.mPath}, this.mMethod);
        } else {
            this.takePhoto();
        }
    }

    @Override
    public void onBackPressed() {
        this.mController.onCancel();
        super.onBackPressed();
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putInt("act_style_key", this.mStyle);
        outState.putStringArray(RESULT_KEY, this.mResultPath);
        outState.putString(TAKE_PHOTO_FILE_PATH, this.mCameraCapturingName);
    }

    /*
     * Unable to fully structure code
     */
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        block8: {
            paths = null;
            if (resultCode != -1) break block8;
            if (requestCode != 1) ** GOTO lbl-1000
            file = YYFileUtils.getTempFile((Context)this, (String)this.mCameraCapturingName);
            MLog.debug((Object)"PictureTakerActivity", (String)("PictureTaskerAct.onActivityResult, file = " + file), (Object[])new Object[0]);
            if (YYImageUtils.isImage(file)) {
                MLog.debug((Object)"PictureTakerActivity", (String)"PictureTaskerAct.onActivityResult, file is image", (Object[])new Object[0]);
                paths = new String[]{file.getPath()};
            } else if (requestCode == 3) {
                if (data != null) {
                    pathList = data.getStringArrayListExtra("result_params_selected_paths");
                    paths = new String[pathList.size()];
                    pathList.toArray(paths);
                }
            } else if (data != null) {
                uri = data.getData();
                MLog.debug((Object)"dingning", (String)("PictureTaskerAct.onActivityResult, uri = " + uri), (Object[])new Object[0]);
                paths = new String[]{YYFileUtils.getImageFilePathFromUri((Context)this, (Uri)uri)};
            }
        }
        if (paths != null && this.validateImages(paths)) {
            this.handleResult(paths, requestCode);
        } else {
            this.finish();
        }
    }

    public void takePhoto() {
        if ((this.mMethod == 1 || this.mMethod == 0) && this.hasExternalStoragePermission()) {
            this.takePhotoFromCamera();
        } else if (this.mMethod == 2) {
            this.selectPhoto();
        } else if (this.mMethod == 3) {
            this.selectMultiPhoto();
        }
    }

    private boolean hasExternalStoragePermission() {
        int perm = this.checkCallingOrSelfPermission("android.permission.WRITE_EXTERNAL_STORAGE");
        MLog.info((Object)TAG, (String)("hasExternalStoragePermission: perm is " + perm), (Object[])new Object[0]);
        return perm == 0;
    }

    private void takePhotoFromCamera() {
        final Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
        this.mCameraCapturingName = CAMERA_PREFIX + System.currentTimeMillis() + ".jpg";
        File out = YYFileUtils.getTempFile((Context)this, (String)this.mCameraCapturingName);
        out.delete();
        Uri photoUri = FileProvider.getUriForFile((Context)this, (String)(this.getPackageName() + ".unionyy.fileprovider"), (File)out);
        intent.putExtra("output", (Parcelable)photoUri);
        List<String> permissions = Collections.singletonList("android.permission.CAMERA");
        AndroidPermission p = (AndroidPermission)ICoreManagerBase.getCore(AndroidPermission.class);
        if (p != null) {
            p.checkPermission(BasicConfig.getInstance().getAppContext(), permissions, (Function0)new Function0<Unit>(){

                public Unit invoke() {
                    block2: {
                        try {
                            PictureTakerActivity.this.startActivityForResult(intent, 1);
                        }
                        catch (Exception e) {
                            boolean permission2;
                            MLog.error((Object)PictureTakerActivity.TAG, (String)"takePotoFromCamera fail, %s", (Throwable)e, (Object[])new Object[0]);
                            PackageManager pm = PictureTakerActivity.this.getPackageManager();
                            boolean bl = permission2 = 0 == pm.checkPermission("android.permission.CAMERA", "packageName");
                            if (permission2) break block2;
                            SingleToastUtil.showToast((String)"\u8bf7\u5230\u8bbe\u7f6e\u9875\u4e2d\u6253\u5f00\u76f8\u673a\u6743\u9650");
                        }
                    }
                    return null;
                }
            }, (Function0)new Function0<Unit>(){

                public Unit invoke() {
                    SingleToastUtil.showToast((String)"\u8bf7\u5230\u8bbe\u7f6e\u9875\u4e2d\u6253\u5f00\u76f8\u673a\u6743\u9650");
                    return null;
                }
            });
        }
    }

    private void askCameraPermission() {
    }

    private void selectPhoto() {
        if (this.preCheckBeforeSelectPhoto()) {
            SingleToastUtil.showToast((String)"\u8bf7\u5230\u8bbe\u7f6e\u9875\u6253\u5f00\"\u540e\u53f0\u5f39\u51fa\u754c\u9762\u6743\u9650\"");
            return;
        }
        Intent intent = new Intent();
        intent.setType("image/*");
        intent.setAction("android.intent.action.PICK");
        try {
            this.startActivityForResult(intent, 2);
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (String)"selectPhoto fail, %s", (Throwable)e, (Object[])new Object[0]);
        }
    }

    private boolean preCheckBeforeSelectPhoto() {
        if ("Redmi Note 3".equals(Build.MODEL) && !PictureTakerActivity.canBackgroundStart((Context)this)) {
            MLog.info((Object)TAG, (String)("preCheckBeforeSelectPhoto: special devices = " + Build.MODEL), (Object[])new Object[0]);
            return true;
        }
        return false;
    }

    private void selectMultiPhoto() {
    }

    private void handleResult(String[] paths, int requestCode) {
        this.mResultPath = paths;
        this.mController.onResult(paths, requestCode);
    }

    private boolean validateImages(String[] paths) {
        boolean result = false;
        if (paths == null || paths.length == 0) {
            return false;
        }
        for (int i = 0; i < paths.length; ++i) {
            String path = paths[i];
            if (YYImageUtils.isImage(path)) continue;
            return false;
        }
        return true;
    }

    public void selectCameraManager() {
        boolean permission2;
        PackageManager pm = this.getPackageManager();
        boolean bl = permission2 = 0 == pm.checkPermission("android.permission.CAMERA", "packageName");
        if (!permission2) {
            if (this.dialogManager == null) {
                this.dialogManager = this.getDialogLinkManager();
            }
            this.dialogManager.showDialog((BaseDialog)new OkDialog((CharSequence)this.getContext().getString(R.string.str_camera_manager_fail), false, false, false, new OkDialogListener(){

                public void onOk() {
                    PictureTakerActivity.this.dialogManager.dismissDialog();
                    PictureTakerActivity.this.finish();
                }
            }));
        }
    }

    protected boolean handleStatusBar() {
        ImmersionBar.with((Activity)this).statusBarColor(17170444).init();
        return true;
    }

    protected void configView() {
        View view = this.findViewById(R.id.title);
        if (view != null) {
            RelativeLayout.LayoutParams lp = (RelativeLayout.LayoutParams)view.getLayoutParams();
            lp.height += ScreenUtil.getStatusBarHeight();
        }
    }

    public static boolean canBackgroundStart(Context context) {
        AppOpsManager ops = null;
        if (Build.VERSION.SDK_INT >= 19) {
            ops = (AppOpsManager)context.getSystemService("appops");
            try {
                int op = 10021;
                Method method = ops.getClass().getMethod("checkOpNoThrow", Integer.TYPE, Integer.TYPE, String.class);
                Integer result = (Integer)method.invoke((Object)ops, op, Process.myUid(), context.getPackageName());
                return result == 0;
            }
            catch (Exception e) {
                MLog.error((Object)TAG, (String)"not support", (Throwable)e, (Object[])new Object[0]);
            }
        }
        return false;
    }

    public static interface IController {
        public View getContentView();

        public void onResult(String[] var1, int var2);

        public void onCancel();
    }
}

