/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.profile.anchor;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.handmark.pulltorefresh.library.PullToRefreshBase;
import com.handmark.pulltorefresh.library.PullToRefreshStaggeredGridView;
import com.handmark.pulltorefresh.library.extras_view.StaggeredGridView;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.hiidostatis.defs.obj.Property;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.plugin.main.events.IMobileLiveClient_onDeleteMobileLiveReplaySuccess_EventArgs;
import com.yy.mobile.plugin.pluginunionmain.R;
import com.yy.mobile.ui.BaseActivity;
import com.yy.mobile.ui.profile.anchor.AnchorWorksDetailActivity$$EventBinder;
import com.yy.mobile.ui.profile.anchor.DetailAnchorWorksAdapter;
import com.yy.mobile.ui.utils.NavigationUtils;
import com.yy.mobile.ui.widget.EndlessListScrollListener;
import com.yy.mobile.ui.widget.SimpleTitleBar;
import com.yy.mobile.util.StringUtils;
import com.yymobile.core.CoreManager;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.mobilelive.ILivePluginCore;
import com.yymobile.core.mobilelive.MobileLiveConstant;
import com.yymobile.core.profile.IAnchorWorksCore;
import com.yymobile.core.profile.RePlayMergeWorksInfo;
import com.yymobile.core.profile.RePlayWorksInfo;
import com.yymobile.core.profile.RequestAnchorRePlayWorksNoDataEvent;
import com.yymobile.core.profile.RequestAnchorRePlayWorksSuccessEvent;
import com.yymobile.core.profile.WorksInfo;
import com.yymobile.core.statistic.IHiidoStatisticCore;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;

public class AnchorWorksDetailActivity
extends BaseActivity {
    private static final String TAG = "AnchorWorksDetailActivity";
    public static final String CATEGORY = "category";
    public static final String ANCHOR_UID = "anchor_uid";
    private SimpleTitleBar mTitleBar;
    private String category;
    private long anchorUid;
    private PullToRefreshStaggeredGridView mStaggerGridView;
    private StaggeredGridView staggeredGridView;
    private RelativeLayout mRlNoData;
    private DetailAnchorWorksAdapter mAnchorWorksAdapter;
    private View mFootView;
    private TextView mFooterText;
    private EndlessListScrollListener mEndlessListScrollListener;
    private boolean mIsLastPage = false;
    private Runnable fixCompleteRefreshMsg = new Runnable(){

        @Override
        public void run() {
            if (AnchorWorksDetailActivity.this.mStaggerGridView != null) {
                AnchorWorksDetailActivity.this.mStaggerGridView.onRefreshComplete();
            }
            if (AnchorWorksDetailActivity.this.mEndlessListScrollListener != null) {
                AnchorWorksDetailActivity.this.mEndlessListScrollListener.onLoadComplete();
            }
        }
    };
    private EventBinder mAnchorWorksDetailActivitySniperEventBinder;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_anchor_works_detail);
        this.category = this.getIntent().getStringExtra(CATEGORY);
        this.anchorUid = this.getIntent().getLongExtra(ANCHOR_UID, 0L);
        this.initTitleBar();
        this.mStaggerGridView = (PullToRefreshStaggeredGridView)this.findViewById(R.id.staggered_grid_view);
        this.mRlNoData = (RelativeLayout)this.findViewById(R.id.rl_no_data);
        this.mAnchorWorksAdapter = new DetailAnchorWorksAdapter((Activity)this, true);
        this.mStaggerGridView.setMode(PullToRefreshBase.Mode.DISABLED);
        this.initStaggeredGrid();
        this.mStaggerGridView.setAdapter((ListAdapter)this.mAnchorWorksAdapter);
        ((IAnchorWorksCore)CoreManager.getCore(IAnchorWorksCore.class)).requestAnchorRePlayWorks(this.anchorUid, StringUtils.safeParseInt((String)this.category));
        Object var3_2 = null;
        if (this.mAnchorWorksDetailActivitySniperEventBinder == null) {
            this.mAnchorWorksDetailActivitySniperEventBinder = new AnchorWorksDetailActivity$$EventBinder();
        }
        this.mAnchorWorksDetailActivitySniperEventBinder.bindEvent((Object)this);
    }

    private void initTitleBar() {
        this.mTitleBar = (SimpleTitleBar)this.findViewById(R.id.title_bar);
        this.mTitleBar.setTitlte(RePlayMergeWorksInfo.getWorksTypeString((String)this.category));
        this.mTitleBar.setLeftBtn(R.drawable.icon_nav_back, new View.OnClickListener(){

            public void onClick(View v) {
                AnchorWorksDetailActivity.this.finish();
            }
        });
    }

    private void initStaggeredGrid() {
        this.initFootView();
        ((StaggeredGridView)this.mStaggerGridView.getRefreshableView()).addFooterView(this.mFootView);
        this.mFooterText.setVisibility(8);
        this.mStaggerGridView.setOnRefreshListener((PullToRefreshBase.OnRefreshListener)new PullToRefreshBase.OnRefreshListener<StaggeredGridView>(){

            public void onRefresh(PullToRefreshBase<StaggeredGridView> refreshView) {
                if (!AnchorWorksDetailActivity.this.checkNetToast()) {
                    AnchorWorksDetailActivity.this.getHandler().removeCallbacks(AnchorWorksDetailActivity.this.fixCompleteRefreshMsg);
                    AnchorWorksDetailActivity.this.getHandler().postDelayed(AnchorWorksDetailActivity.this.fixCompleteRefreshMsg, 300L);
                } else {
                    ((IAnchorWorksCore)CoreManager.getCore(IAnchorWorksCore.class)).requestAnchorRePlayWorksNextPage(AnchorWorksDetailActivity.this.anchorUid, StringUtils.safeParseInt((String)AnchorWorksDetailActivity.this.category));
                    if (AnchorWorksDetailActivity.this.mIsLastPage) {
                        AnchorWorksDetailActivity.this.mStaggerGridView.onRefreshComplete();
                    }
                }
            }
        });
        this.staggeredGridView = (StaggeredGridView)this.mStaggerGridView.getRefreshableView();
        this.staggeredGridView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> adapterView, View view, int position, long id2) {
                WorksInfo worksInfo;
                if (AnchorWorksDetailActivity.this.mAnchorWorksAdapter != null && position < AnchorWorksDetailActivity.this.mAnchorWorksAdapter.getData().size() && (worksInfo = AnchorWorksDetailActivity.this.mAnchorWorksAdapter.getData().get(position)) instanceof RePlayWorksInfo && ICoreManagerBase.getCore(ILivePluginCore.class) != null) {
                    RePlayWorksInfo rePlayWorksInfo = (RePlayWorksInfo)AnchorWorksDetailActivity.this.mAnchorWorksAdapter.getData().get(position);
                    Property property = new Property();
                    property.putString("key1", rePlayWorksInfo.worksType);
                    property.putString("key2", rePlayWorksInfo.liveId);
                    ((IHiidoStatisticCore)CoreManager.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "52504", "0004", (Serializable)property);
                    if (RePlayWorksInfo.strIsNum((String)rePlayWorksInfo.uid)) {
                        NavigationUtils.toMobileLiveReplayWithTitle((Context)AnchorWorksDetailActivity.this, rePlayWorksInfo.liveId, Long.valueOf(rePlayWorksInfo.uid), rePlayWorksInfo.videoUrl, rePlayWorksInfo.imageUrl, rePlayWorksInfo.title, MobileLiveConstant.TO_MOBILE_LIVE_REPLAY_PATH_BY_ANCHOR_USER_INFO);
                    }
                }
            }
        });
    }

    private void initFootView() {
        if (this.mFootView == null) {
            this.mFootView = LayoutInflater.from((Context)this).inflate(R.layout.personal_page_anchor_works_listfoot, null);
            this.mFooterText = (TextView)this.mFootView.findViewById(R.id.footer_text);
        }
    }

    @BusEvent(sync=true)
    public void onRequestAnchorRePlayWorksSuccess(RequestAnchorRePlayWorksSuccessEvent event) {
        List works = event.getWorks();
        boolean hasMore = event.isHasMore();
        this.mRlNoData.setVisibility(8);
        this.mStaggerGridView.setMode(PullToRefreshBase.Mode.PULL_FROM_END);
        this.mAnchorWorksAdapter.addData(works);
        this.mStaggerGridView.onRefreshComplete();
        if (!hasMore) {
            this.mIsLastPage = true;
            this.mFooterText.setVisibility(0);
            this.mStaggerGridView.setMode(PullToRefreshBase.Mode.DISABLED);
        }
    }

    @BusEvent(sync=true)
    public void onRequestAnchorRePlayWorksNoData(RequestAnchorRePlayWorksNoDataEvent event) {
        this.showNoData();
    }

    @Override
    public void showNoData() {
        this.mRlNoData.setVisibility(0);
        this.mStaggerGridView.setMode(PullToRefreshBase.Mode.DISABLED);
        this.mFooterText.setVisibility(8);
    }

    @BusEvent(sync=true)
    public void onDeleteMobileLiveReplaySuccess(IMobileLiveClient_onDeleteMobileLiveReplaySuccess_EventArgs busEventArgs) {
        String programId = busEventArgs.getProgamId();
        if (TextUtils.isEmpty((CharSequence)programId) || this.mAnchorWorksAdapter == null) {
            return;
        }
        List<WorksInfo> replayVideoEntityList = this.mAnchorWorksAdapter.getBeanList();
        Iterator<WorksInfo> it = replayVideoEntityList.iterator();
        while (it.hasNext()) {
            WorksInfo bean = it.next();
            if (!(bean instanceof RePlayWorksInfo)) continue;
            RePlayWorksInfo rePlayWorksInfo = (RePlayWorksInfo)bean;
            if (!programId.equals(rePlayWorksInfo.liveId)) continue;
            it.remove();
            break;
        }
        if (replayVideoEntityList.isEmpty()) {
            this.showNoData();
        }
        this.mAnchorWorksAdapter.notifyDataSetChanged();
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (this.mAnchorWorksDetailActivitySniperEventBinder != null) {
            this.mAnchorWorksDetailActivitySniperEventBinder.unBindEvent();
        }
    }
}

