/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget.text;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.widget.TextView;
import com.yy.mobile.plugin.pluginunionmain.R;
import com.yy.mobile.ui.utils.DimensUtils;
import com.yy.mobile.ui.utils.FontUtils;

public class StrokeTextView
extends TextView {
    private int mStrokeColor = -16777216;
    private int mStrokeWidth = 0;
    private Paint mPaint;

    public StrokeTextView(Context context) {
        super(context);
        this.init(context, null);
    }

    public StrokeTextView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public StrokeTextView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        this.mPaint = this.getPaint();
        if (attrs != null) {
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.StrokeTextView);
            this.mStrokeColor = a.getColor(R.styleable.StrokeTextView_strokeColor, -16777216);
            this.mStrokeWidth = a.getInt(R.styleable.StrokeTextView_strokeBorderWidth, 0);
            this.mStrokeWidth = DimensUtils.dip2pixel((Context)context, (float)this.mStrokeWidth);
            this.mPaint.setTypeface(FontUtils.getTypeFace(this.getContext(), FontUtils.FontType.REFRIGERATOR_DELUXE_HEAVY));
            a.recycle();
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.setMeasuredDimension(this.getMeasuredWidth() + this.mStrokeWidth, this.getMeasuredHeight() + this.mStrokeWidth);
    }

    protected void onDraw(Canvas canvas) {
        ColorStateList currentColor = this.getTextColors();
        this.mPaint.setFakeBoldText(true);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setStrokeJoin(Paint.Join.ROUND);
        this.mPaint.setStrokeWidth((float)this.mStrokeWidth);
        this.setTextColor(this.mStrokeColor);
        this.setGravity(17);
        super.onDraw(canvas);
        this.mPaint.setStyle(Paint.Style.FILL);
        this.setTextColor(currentColor);
        this.setGravity(17);
        super.onDraw(canvas);
    }
}

