/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.webviewutil.statusfragment;

import android.app.Fragment;
import android.content.Context;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.ui.widget.toast.Toast;
import com.yymobilecore.R;

public class LoadingFragment
extends Fragment {
    private static final String TIP_PARAM = "TIP_PARAM";
    private static final String DRAWABLE_PARAM = "DRAWABLE_PARAM";
    private static final String BACKGROUND_COLOR_PARAM = "BACKGROUND_COLOR_PARAM";
    private int mTip;
    private int mDrawable;
    private int mBackgroundColor;
    protected View.OnClickListener mLoadListener;

    public static LoadingFragment newInstance() {
        return new LoadingFragment();
    }

    public static LoadingFragment newInstance(int drawable2, int tips) {
        Bundle bundle = new Bundle();
        bundle.putInt(TIP_PARAM, tips);
        bundle.putInt(DRAWABLE_PARAM, drawable2);
        LoadingFragment fragment = new LoadingFragment();
        fragment.setArguments(bundle);
        return fragment;
    }

    public static LoadingFragment newInstance(int drawable2, int tips, int backgroundColor) {
        Bundle bundle = new Bundle();
        bundle.putInt(TIP_PARAM, tips);
        bundle.putInt(DRAWABLE_PARAM, drawable2);
        bundle.putInt(BACKGROUND_COLOR_PARAM, backgroundColor);
        LoadingFragment fragment = new LoadingFragment();
        fragment.setArguments(bundle);
        return fragment;
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = LayoutInflater.from((Context)this.getActivity()).inflate(R.layout.mn_fragment_loading, container, false);
        if (savedInstanceState != null) {
            this.mTip = savedInstanceState.getInt(TIP_PARAM, R.string.loading);
            this.mDrawable = savedInstanceState.getInt(DRAWABLE_PARAM, R.drawable.loading_img);
            this.mBackgroundColor = savedInstanceState.getInt(BACKGROUND_COLOR_PARAM, this.getResources().getColor(R.color.common_color_2));
        } else {
            Bundle bundle = this.getArguments();
            if (bundle != null) {
                this.mTip = bundle.getInt(TIP_PARAM, R.string.loading);
                this.mDrawable = bundle.getInt(DRAWABLE_PARAM, R.drawable.loading_img);
                this.mBackgroundColor = bundle.getInt(BACKGROUND_COLOR_PARAM, this.getResources().getColor(R.color.common_color_2));
            } else {
                this.mTip = R.string.loading;
            }
        }
        if (this.mTip > 0) {
            TextView textView = (TextView)view.findViewById(R.id.loading_text);
            textView.setText((CharSequence)this.getString(this.mTip));
            textView.setVisibility(0);
        }
        if (this.mDrawable > 0) {
            ImageView imageView = (ImageView)view.findViewById(R.id.loadingIv);
            imageView.setImageResource(this.mDrawable);
            imageView.setVisibility(0);
        }
        if (this.mBackgroundColor > 0) {
            view.setBackgroundColor(this.mBackgroundColor);
        }
        return view;
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putInt(TIP_PARAM, this.mTip);
        outState.putInt(DRAWABLE_PARAM, this.mDrawable);
        outState.putInt(BACKGROUND_COLOR_PARAM, this.mBackgroundColor);
    }

    public void setListener(View.OnClickListener listener) {
        this.mLoadListener = listener;
    }

    public void checkNetToast() {
        Toast.makeText((Context)BasicConfig.getInstance().getAppContext(), (CharSequence)"\u7f51\u7edc\u4e0d\u53ef\u7528", (int)0).show();
    }
}

