/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.profile.photo;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.FrameLayout;
import com.yy.mobile.image.ImageConfig;
import com.yy.mobile.image.RecycleImageView;
import com.yy.mobile.imageloader.ImageLoader;
import com.yy.mobile.plugin.pluginunionmain.R;
import com.yy.mobile.util.log.MLog;
import org.json.JSONObject;

public class PhotoItemView
extends FrameLayout {
    private RecycleImageView mImageView;
    private JSONObject mPhotoObject;
    private static final String TAG = "PhotoItemView";

    public PhotoItemView(Context context) {
        super(context);
        this.setupViews();
    }

    public PhotoItemView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setupViews();
    }

    private void setupViews() {
        LayoutInflater inflater = LayoutInflater.from((Context)this.getContext());
        View view = inflater.inflate(R.layout.layout_photo_itemview, null);
        this.setImageView((RecycleImageView)view.findViewById(R.id.photo_view));
        this.addView(view);
    }

    public void setData(JSONObject object) {
        this.setPhotoObject(object);
        try {
            String pUrl = object.getString("pUrl");
            ImageLoader.loadImage((String)pUrl, (RecycleImageView)this.getImageView(), (ImageConfig)ImageConfig.bigImageConfig(), (int)R.drawable.mn_yy_bear_logo);
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (Throwable)e);
        }
    }

    public void reload() {
        try {
            String pUrl = this.getPhotoObject().getString("pUrl");
            ImageLoader.loadImage((String)pUrl, (RecycleImageView)this.getImageView(), (ImageConfig)ImageConfig.bigImageConfig(), (int)R.drawable.mn_yy_bear_logo);
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (Throwable)e);
        }
    }

    public void recycle() {
    }

    private RecycleImageView getImageView() {
        return this.mImageView;
    }

    private void setImageView(RecycleImageView imageView) {
        this.mImageView = imageView;
    }

    private JSONObject getPhotoObject() {
        return this.mPhotoObject;
    }

    private void setPhotoObject(JSONObject photoObject) {
        this.mPhotoObject = photoObject;
    }
}

