/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget.dialog;

import android.app.Dialog;
import android.text.TextUtils;
import android.text.method.LinkMovementMethod;
import android.view.View;
import android.view.Window;
import android.widget.TextView;
import com.yy.mobile.plugin.pluginunionmain.R;
import com.yy.mobile.ui.utils.dialog.BaseDialog;
import com.yy.mobile.ui.utils.dialog.OkCancelDialogListener;

public class TitleMessageClickableOkCancelDialog
implements BaseDialog {
    private final CharSequence title;
    private boolean isTitleCenter = true;
    private final CharSequence message;
    private boolean isMessageCenter = true;
    private boolean isMessageClickable = false;
    private final CharSequence okLabel;
    private final CharSequence cancelLabel;
    private boolean outsideCancelable;
    private boolean backCancelable;
    private final OkCancelDialogListener listener;

    public TitleMessageClickableOkCancelDialog(CharSequence title, boolean isTitleCenter, CharSequence message, boolean isMessageCenter, boolean isMessageClickable, CharSequence okLabel, CharSequence cancelLabel, boolean outsideCancelable, boolean backCancelable, OkCancelDialogListener listener) {
        this.title = title;
        this.isTitleCenter = isTitleCenter;
        this.isMessageCenter = isMessageCenter;
        this.message = message;
        this.isMessageClickable = isMessageClickable;
        this.okLabel = okLabel;
        this.cancelLabel = cancelLabel;
        this.outsideCancelable = outsideCancelable;
        this.backCancelable = backCancelable;
        this.listener = listener;
    }

    public TitleMessageClickableOkCancelDialog(CharSequence title, CharSequence message, CharSequence okLabel, CharSequence cancelLabel, boolean outsideCancelable, boolean backCancelable, OkCancelDialogListener listener) {
        this(title, true, message, true, false, okLabel, cancelLabel, outsideCancelable, backCancelable, listener);
    }

    public TitleMessageClickableOkCancelDialog(CharSequence title, CharSequence message, boolean isMessageCenter, CharSequence okLabel, CharSequence cancelLabel, boolean outsideCancelable, boolean backCancelable, OkCancelDialogListener listener) {
        this(title, true, message, isMessageCenter, false, okLabel, cancelLabel, outsideCancelable, backCancelable, listener);
    }

    public void init(Dialog dialog) {
        dialog.setCancelable(this.backCancelable);
        dialog.setCanceledOnTouchOutside(this.outsideCancelable);
        Window window = dialog.getWindow();
        window.setContentView(this.getLayoutResId());
        TextView titleTv = (TextView)window.findViewById(R.id.message);
        if (this.isTitleCenter) {
            titleTv.setGravity(17);
        } else {
            titleTv.setGravity(19);
        }
        if (!TextUtils.isEmpty((CharSequence)this.title)) {
            titleTv.setText(this.title);
        }
        TextView messageTv = (TextView)window.findViewById(R.id.message_content);
        if (this.isMessageCenter) {
            messageTv.setGravity(17);
        } else {
            messageTv.setGravity(3);
        }
        if (!TextUtils.isEmpty((CharSequence)this.message)) {
            messageTv.setText(this.message);
        }
        if (this.isMessageClickable) {
            messageTv.setMovementMethod(LinkMovementMethod.getInstance());
        }
        TextView ok = (TextView)window.findViewById(R.id.btn_ok);
        ok.setText(this.okLabel);
        if (this.okLabel.length() > 4) {
            if (dialog.getContext().getResources().getDisplayMetrics().widthPixels <= 480) {
                ok.setTextSize(2, 14.0f);
            } else {
                ok.setTextSize(2, 16.0f);
            }
        }
        ok.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (TitleMessageClickableOkCancelDialog.this.listener != null) {
                    TitleMessageClickableOkCancelDialog.this.listener.onOk();
                }
            }
        });
        TextView cancel = (TextView)window.findViewById(R.id.btn_cancel);
        cancel.setText(this.cancelLabel);
        if (this.cancelLabel.length() > 4) {
            if (dialog.getContext().getResources().getDisplayMetrics().widthPixels <= 480) {
                cancel.setTextSize(2, 14.0f);
            } else {
                cancel.setTextSize(2, 16.0f);
            }
        }
        cancel.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (TitleMessageClickableOkCancelDialog.this.listener != null) {
                    TitleMessageClickableOkCancelDialog.this.listener.onCancel();
                }
            }
        });
    }

    public int getLayoutResId() {
        return R.layout.layout_title_ok_cancel_dialog;
    }
}

