/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget.dialog;

import android.app.Dialog;
import android.content.DialogInterface;
import android.text.InputFilter;
import android.text.TextUtils;
import android.view.KeyEvent;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.widget.EditText;
import android.widget.TextView;
import com.yy.mobile.plugin.pluginunionmain.R;
import com.yy.mobile.ui.utils.dialog.BaseDialog;

public class SimpleNumberInputDialog
implements BaseDialog {
    private String message;
    private boolean backCancelable;
    private boolean outsideCancelable;
    private int maxLength;
    private final InputDialogListener listener;

    public SimpleNumberInputDialog(String message, boolean backCancelable, boolean outsideCancelable, int maxLength, InputDialogListener listener) {
        this.message = message;
        this.backCancelable = backCancelable;
        this.outsideCancelable = outsideCancelable;
        this.maxLength = maxLength;
        this.listener = listener;
    }

    public void init(Dialog dialog) {
        dialog.setCancelable(this.backCancelable);
        dialog.setCanceledOnTouchOutside(this.outsideCancelable);
        Window window = dialog.getWindow();
        window.setContentView(this.getLayoutResId());
        WindowManager.LayoutParams params = window.getAttributes();
        params.width = -1;
        params.height = -2;
        params.softInputMode = 37;
        window.setAttributes(params);
        window.clearFlags(131072);
        window.findViewById(R.id.rl_root).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (SimpleNumberInputDialog.this.listener != null) {
                    SimpleNumberInputDialog.this.listener.cancel();
                }
            }
        });
        final EditText etInput = (EditText)window.findViewById(R.id.et_input_text);
        if (!TextUtils.isEmpty((CharSequence)this.message)) {
            etInput.setHint((CharSequence)this.message);
        }
        etInput.setFilters(new InputFilter[]{new InputFilter.LengthFilter(this.maxLength)});
        etInput.setOnEditorActionListener(new TextView.OnEditorActionListener(){

            public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
                if (actionId == 6 && SimpleNumberInputDialog.this.listener != null) {
                    String input = etInput.getText().toString();
                    SimpleNumberInputDialog.this.listener.confirm(input);
                }
                return false;
            }
        });
        window.findViewById(R.id.btn_ok).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (SimpleNumberInputDialog.this.listener != null) {
                    String input = etInput.getText().toString();
                    SimpleNumberInputDialog.this.listener.confirm(input);
                }
            }
        });
        dialog.setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialog) {
                if (SimpleNumberInputDialog.this.listener != null) {
                    SimpleNumberInputDialog.this.listener.cancel();
                }
            }
        });
    }

    public int getLayoutResId() {
        return R.layout.layout_input_number;
    }

    public static interface InputDialogListener {
        public void cancel();

        public boolean confirm(String var1);
    }
}

