/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget.dialog;

import android.app.Dialog;
import android.text.TextUtils;
import android.text.method.MovementMethod;
import android.text.method.ScrollingMovementMethod;
import android.view.View;
import android.view.Window;
import android.widget.TextView;
import com.yy.mobile.plugin.pluginunionmain.R;
import com.yy.mobile.ui.utils.dialog.BaseDialog;
import com.yy.mobile.ui.utils.dialog.OkCancelDialogListener;

public class UpdateDialog
implements BaseDialog {
    private boolean silentUpdate;
    private CharSequence message;
    private CharSequence okLabel;
    private CharSequence cancelLabel;
    private boolean cancelable;
    private final OkCancelDialogListener listener;

    public UpdateDialog(boolean silentUpdate, CharSequence message, CharSequence okLabel, CharSequence cancelLabel, boolean cancelable, OkCancelDialogListener listener) {
        this.silentUpdate = silentUpdate;
        this.message = message;
        this.okLabel = okLabel;
        this.cancelLabel = cancelLabel;
        this.cancelable = cancelable;
        this.listener = listener;
    }

    public void init(final Dialog dialog) {
        dialog.setCancelable(this.cancelable);
        dialog.setCanceledOnTouchOutside(this.cancelable);
        Window window = dialog.getWindow();
        window.setContentView(this.getLayoutResId());
        TextView tip = (TextView)window.findViewById(R.id.message);
        if (!TextUtils.isEmpty((CharSequence)this.message)) {
            tip.setText(this.message);
        }
        tip.setMovementMethod((MovementMethod)new ScrollingMovementMethod());
        TextView ok = (TextView)window.findViewById(R.id.btn_ok);
        if (!TextUtils.isEmpty((CharSequence)this.okLabel)) {
            ok.setText(this.okLabel);
        }
        ok.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                dialog.dismiss();
                if (UpdateDialog.this.listener != null) {
                    UpdateDialog.this.listener.onOk();
                }
            }
        });
        TextView cancel = (TextView)window.findViewById(R.id.btn_cancel);
        if (!TextUtils.isEmpty((CharSequence)this.cancelLabel)) {
            cancel.setText(this.cancelLabel);
        }
        cancel.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                dialog.dismiss();
                if (UpdateDialog.this.listener != null) {
                    UpdateDialog.this.listener.onCancel();
                }
            }
        });
    }

    public int getLayoutResId() {
        return R.layout.layout_update_dialog;
    }
}

