/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.home.image;

import android.content.Context;
import android.widget.ImageView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.request.RequestOptions;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.http.httpsparser.HttpsParser;
import com.yy.mobile.util.FP;

public class GlideImageManager {
    public static void loadImage(Context context, String url, ImageView imgView, int placeholderId) {
        GlideImageManager.loadImage(context, url, imgView, placeholderId, placeholderId, 1.0f);
    }

    public static void loadImage(Context context, String url, ImageView imgView, int placeholderId, float sizeMultiplier) {
        GlideImageManager.loadImage(context, url, imgView, placeholderId, placeholderId, sizeMultiplier);
    }

    public static void loadImage(Context context, String url, ImageView imgView, int placeholderId, int errorId, float sizeMultiplier) {
        if (context == null || imgView == null) {
            return;
        }
        if (GlideImageManager.isGifUrl(url)) {
            GlideImageManager.loadImageAsGif(context, url, imgView, placeholderId, errorId);
        } else {
            Glide.with((Context)context).load(HttpsParser.convertToHttps((String)url)).apply(new RequestOptions().placeholder(placeholderId).sizeMultiplier(sizeMultiplier).error(errorId).dontTransform()).into(imgView);
        }
    }

    private static void loadImageAsGif(Context context, String url, ImageView imgView, int placeholderId, int errorId) {
        Glide.with((Context)context).asGif().load(HttpsParser.convertToHttps((String)url)).apply(new RequestOptions().diskCacheStrategy(DiskCacheStrategy.AUTOMATIC).placeholder(placeholderId).error(errorId)).into(imgView);
    }

    private static boolean isGifUrl(String url) {
        return !FP.empty((CharSequence)url) && url.endsWith(".gif");
    }

    public static void clearMemory() {
        if (BasicConfig.getInstance().getAppContext() != null) {
            Glide.get((Context)BasicConfig.getInstance().getAppContext()).clearMemory();
        }
    }

    public static void trimMemory(int level) {
        if (BasicConfig.getInstance().getAppContext() != null) {
            Glide.get((Context)BasicConfig.getInstance().getAppContext()).trimMemory(level);
        }
    }
}

