/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.task;

import android.annotation.SuppressLint;
import android.app.Application;
import android.content.Context;
import android.os.SystemClock;
import android.support.annotation.NonNull;
import android.util.Log;
import android.util.SparseArray;
import com.example.configcenter.ILog;
import com.example.configcenter.Network;
import com.example.configcenter.Publess;
import com.facebook.stetho.Stetho;
import com.yy.android.small.plugin.PluginManager;
import com.yy.mobile.RxBus;
import com.yy.mobile.YYMobileApp;
import com.yy.mobile.abtest.ABTestConfigInitializer;
import com.yy.mobile.baseapi.event.EntLiveGetCoreEvent;
import com.yy.mobile.baseapi.model.store.YYState;
import com.yy.mobile.baseapi.model.store.YYStore;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.file.FileRequestManager;
import com.yy.mobile.guid.GuidFactory;
import com.yy.mobile.http.RequestIntercepter;
import com.yy.mobile.http.RequestManager;
import com.yy.mobile.imageloader.ImageLoader;
import com.yy.mobile.model.Action;
import com.yy.mobile.model.Processor;
import com.yy.mobile.model.constant.Constants;
import com.yy.mobile.model.middleware.AddDataModuleApiMethodMiddleware;
import com.yy.mobile.model.middleware.AddUiModuleApiMethodMiddleware;
import com.yy.mobile.model.store.HostStore;
import com.yy.mobile.model.store.action.HostState_AppIdAction;
import com.yy.mobile.model.store.action.HostState_AppIdWithoutPlatformAction;
import com.yy.mobile.model.store.action.HostState_WechatAppIdAction;
import com.yy.mobile.plugin.pluginunionmain.PluginBus;
import com.yy.mobile.sdkwrapper.BasicYYHandlerMgr;
import com.yy.mobile.statistic.AbstractReportProperty;
import com.yy.mobile.statistic.StatisticDataContainer;
import com.yy.mobile.statistic.StatisticDataContainerInterface;
import com.yy.mobile.statistic.StatisticNewDataContainer;
import com.yy.mobile.statistic.StatisticService;
import com.yy.mobile.task.LazyRun;
import com.yy.mobile.task.StepMsgDef;
import com.yy.mobile.ui.activity.GlobalActivityManager;
import com.yy.mobile.ui.home.command.YYCommandProcessor;
import com.yy.mobile.ui.notify.LoginForPushReceiver;
import com.yy.mobile.ui.setting.FeatureManager;
import com.yy.mobile.ui.utils.rest.AggregationPageApiList;
import com.yy.mobile.ui.utils.rest.CommonApiList;
import com.yy.mobile.ui.utils.rest.DiamondApiList;
import com.yy.mobile.ui.utils.rest.DiscoveryApiList;
import com.yy.mobile.ui.utils.rest.LiveCenterApiList;
import com.yy.mobile.ui.utils.rest.LoginApiList;
import com.yy.mobile.ui.utils.rest.MomentApiList;
import com.yy.mobile.ui.utils.rest.OnepieceApiList;
import com.yy.mobile.ui.utils.rest.PersonalCenterApiList;
import com.yy.mobile.ui.utils.rest.PhotoCenterAPIList;
import com.yy.mobile.ui.utils.rest.PopwebApiList;
import com.yy.mobile.ui.utils.rest.ToastApiList;
import com.yy.mobile.ui.utils.rest.UserInfoApiList;
import com.yy.mobile.ui.utils.rest.VoiceRoomApiList;
import com.yy.mobile.ui.utils.rest.WebCtrlApiList;
import com.yy.mobile.ui.utils.rest.base.INavRestCore;
import com.yy.mobile.ui.utils.rest.base.IRestApiList;
import com.yy.mobile.ui.webviewutil.WebConfig;
import com.yy.mobile.ui.ylink.YLink;
import com.yy.mobile.util.NetworkUtils;
import com.yy.mobile.util.RxUtils;
import com.yy.mobile.util.TelephonyUtils;
import com.yy.mobile.util.TimeUtils;
import com.yy.mobile.util.YYFileUtils;
import com.yy.mobile.util.activity.YYActivityManager;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.util.taskexecutor.YYTaskExecutor;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.CoreManager;
import com.yymobile.core.Env;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.UriProvider;
import com.yymobile.core.adposmonitor.AdPosMonitorImp;
import com.yymobile.core.basicgunview.IDanmuConfigCore;
import com.yymobile.core.config.model.PublessCore;
import com.yymobile.core.config.model.PublessLog;
import com.yymobile.core.config.model.PublessNetworkImpl;
import com.yymobile.core.db.DbManager;
import com.yymobile.core.ent.v2.EntCoreManagerV2;
import com.yymobile.core.ent.v2.IEntCoreManagerV2;
import com.yymobile.core.forebackground.IForeBackgroundCore;
import com.yymobile.core.forebackground.ISdkBackgroundCore;
import com.yymobile.core.foundation.IHttpDnsConfigCore;
import com.yymobile.core.foundation.IOKHttpConfigCore;
import com.yymobile.core.httphostconfig.IHttpHostConfigCore;
import com.yymobile.core.logupload.ILogUploadCore;
import com.yymobile.core.performancemonitor.PerformanceMonitorSwitchController;
import com.yymobile.core.qos.QosRequestIntercepter;
import com.yymobile.core.statistic.IHiidoStatisticCore;
import com.yymobile.core.statistic.StatisticUtil;
import com.yymobile.core.utils.HttpConfigUtils;
import com.yymobile.core.yyhandler.IYYHandlerMgr;
import io.reactivex.functions.Consumer;
import io.reactivex.schedulers.Schedulers;
import java.io.File;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;

public class StartupManager {
    public static final String TAG = "StartupManager";
    public static boolean DEBUG = BasicConfig.getInstance().isDebuggable();
    private static volatile StartupManager sInstance;
    private static volatile SparseArray<Step> mStepPool;
    private static long sStartupComsumeTime;
    private Application mContext;
    private AtomicReference<Boolean> urgentRef = new AtomicReference<Boolean>(false);
    private AtomicReference<Boolean> startRef = new AtomicReference<Boolean>(false);

    private StartupManager() {
        this.mContext = (Application)BasicConfig.getInstance().getAppContext();
        if (mStepPool.size() > 0) {
            return;
        }
        mStepPool.clear();
        mStepPool.put(StepMsgDef.MSG_STEP_INIT_PUBLESS, (Object)new StepInitPubless());
        mStepPool.put(StepMsgDef.MSG_STEP_INIT_IMAGE_AND_REQUEST_MANAGER, (Object)new StepInitImageAndRequestManager());
        mStepPool.put(StepMsgDef.MSG_STEP_REQUEST_BASE_DATA, (Object)new StepRequestBaseData());
        mStepPool.put(StepMsgDef.MSG_STEP_YLINK_INIT, (Object)new StepYlinkInit());
        mStepPool.put(StepMsgDef.MSG_STEP_COREMANAGER_INIT, (Object)new StepCoremanagerInit());
        mStepPool.put(StepMsgDef.MSG_STEP_NAV_REST, (Object)new StepNavRest());
        mStepPool.put(StepMsgDef.MSG_STEP_PLUGINMANAGER, (Object)new StepPluginManager());
        mStepPool.put(StepMsgDef.MSG_STEP_GLOBAL_ACTIVITY_MANAGER, (Object)new StepGlobalActivityManager());
        mStepPool.put(StepMsgDef.MSG_STEP_DBMANAGER_INIT, (Object)new StepDbManagerInit());
        mStepPool.put(StepMsgDef.MSG_STEP_COREMANAGER_POST_INIT, (Object)new StepCoremanagerDelayInit());
        mStepPool.put(StepMsgDef.MSG_STEP_FORE_BACKGROUND_CORE_INIT, (Object)new StepForebackgroundCoreInit());
        mStepPool.put(StepMsgDef.MSG_STEP_STATISTIC_SERVICE, (Object)new StepStatisticServiceInit());
        mStepPool.put(StepMsgDef.MSG_STEP_ADPOSMONITORCORE_QUERY, (Object)new StepAdposmonitorCoreQuery());
        mStepPool.put(StepMsgDef.MSG_STEP_REPORT_UNCATCH_CRASH, (Object)new ReportUncatchCrash());
        mStepPool.put(StepMsgDef.MSG_STEP_DISPATCH_APPID, (Object)new StepAppId());
        mStepPool.put(StepMsgDef.MSG_STEP_WEB_REDIRECT_CONFIG, (Object)new WebRedirectConfigQuery());
        mStepPool.put(StepMsgDef.MSG_STEP_HOST_STORE_INIT, (Object)new StepHostStoreInit());
        mStepPool.put(StepMsgDef.MSG_STEP_ABTEST_CONFIG_UPDATE, (Object)new ABTestUpdateConfig());
    }

    public static long getStartupComsumeTime() {
        return sStartupComsumeTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StartupManager instance() {
        if (sInstance == null) {
            Class<StartupManager> clazz = StartupManager.class;
            synchronized (StartupManager.class) {
                if (sInstance == null) {
                    sInstance = new StartupManager();
                }
                // ** MonitorExit[var0] (shouldn't be in output)
                return sInstance;
            }
        }
        return sInstance;
    }

    public void start() {
        if (!this.startRef.getAndSet(true).booleanValue()) {
            this.run();
        }
    }

    @SuppressLint(value={"CheckResult"})
    private void run() {
        long time = SystemClock.currentThreadTimeMillis();
        PluginBus.INSTANCE.get();
        ((Step)mStepPool.get(StepMsgDef.MSG_STEP_HOST_STORE_INIT)).run();
        ((Step)mStepPool.get(StepMsgDef.MSG_STEP_DISPATCH_APPID)).run();
        ((Step)mStepPool.get(StepMsgDef.MSG_STEP_INIT_PUBLESS)).run();
        ((Step)mStepPool.get(StepMsgDef.MSG_STEP_COREMANAGER_INIT)).run();
        ((Step)mStepPool.get(StepMsgDef.MSG_STEP_YLINK_INIT)).run();
        ((Step)mStepPool.get(StepMsgDef.MSG_STEP_NAV_REST)).run();
        ((Step)mStepPool.get(StepMsgDef.MSG_STEP_PLUGINMANAGER)).run();
        ((Step)mStepPool.get(StepMsgDef.MSG_STEP_GLOBAL_ACTIVITY_MANAGER)).run();
        ((Step)mStepPool.get(StepMsgDef.MSG_STEP_ABTEST_CONFIG_UPDATE)).run();
        ICoreManagerBase.getLoginCore();
        Log.d((String)TAG, (String)("ticker ensure:" + (SystemClock.currentThreadTimeMillis() - time)));
        RxBus.getDefault().register(EntLiveGetCoreEvent.class).observeOn(Schedulers.io()).subscribe((Consumer)new Consumer<EntLiveGetCoreEvent>(){

            public void accept(@io.reactivex.annotations.NonNull EntLiveGetCoreEvent event) throws Exception {
                StartupManager.this.handelEntLiveGetCore();
            }
        }, RxUtils.errorConsumer((String)TAG));
        MLog.info((Object)"CoreManager", (String)"--------------------------------CoreManager init--------------------------------", (Object[])new Object[0]);
        RequestManager.instance().addRequestIntercepter((RequestIntercepter)new QosRequestIntercepter());
        Env.instance().init();
        StartupManager.initTelephonyApi((Context)YYMobileApp.gContext);
        this.initNetWorkApi((Context)YYMobileApp.gContext);
        YYStore.INSTANCE.registerProcessor((Processor)new YYCommandProcessor());
        FeatureManager.init();
        FileRequestManager.instance().init((Context)YYMobileApp.gContext);
        GuidFactory.getInstance().init();
        ImageLoader.init((int)-1, (int)-1);
    }

    private static void initTelephonyApi(final Context c) {
        TelephonyUtils.setTelephonyApi((TelephonyUtils.TelephonyApi)new TelephonyUtils.TelephonyApi(){

            public String getImei(Context context) {
                return ((IHiidoStatisticCore)ICoreManagerBase.getCore(IHiidoStatisticCore.class)).getDeviceId(c);
            }
        });
    }

    private void initNetWorkApi(final Context c) {
        NetworkUtils.setNetWorkApi((NetworkUtils.NetWorkApi)new NetworkUtils.NetWorkApi(){

            public String getMac(Context context) {
                return ((IHiidoStatisticCore)ICoreManagerBase.getCore(IHiidoStatisticCore.class)).getMac(c);
            }
        });
    }

    private void handelEntLiveGetCore() {
        ISdkBackgroundCore sdkBackgroundCore;
        MLog.info((Object)TAG, (String)"handelEntLiveGetCore", (Object[])new Object[0]);
        ((Step)mStepPool.get(StepMsgDef.MSG_STEP_WEB_REDIRECT_CONFIG)).run();
        ((Step)mStepPool.get(StepMsgDef.MSG_STEP_DBMANAGER_INIT)).run();
        ((Step)mStepPool.get(StepMsgDef.MSG_STEP_COREMANAGER_POST_INIT)).run();
        ((Step)mStepPool.get(StepMsgDef.MSG_STEP_FORE_BACKGROUND_CORE_INIT)).run();
        ((Step)mStepPool.get(StepMsgDef.MSG_STEP_ADPOSMONITORCORE_QUERY)).run();
        ((Step)mStepPool.get(StepMsgDef.MSG_STEP_STATISTIC_SERVICE)).run();
        if (BasicConfig.getInstance().isDebuggable()) {
            Stetho.initializeWithDefaults((Context)YYMobileApp.gContext);
        }
        if (((YYState)YYStore.INSTANCE.getState()).getStartType() == 2 && (sdkBackgroundCore = (ISdkBackgroundCore)CoreManager.getCore(ISdkBackgroundCore.class)) != null) {
            try {
                sdkBackgroundCore.changeToBackground();
            }
            catch (Throwable e) {
                MLog.error((Object)TAG, (String)"changeToBackground error", (Throwable)e, (Object[])new Object[0]);
            }
        }
        ((Step)mStepPool.get(StepMsgDef.MSG_STEP_REQUEST_BASE_DATA)).run();
        ((Step)mStepPool.get(StepMsgDef.MSG_STEP_REPORT_UNCATCH_CRASH)).run();
        new LazyRun((Context)YYMobileApp.gContext).run();
    }

    static {
        mStepPool = new SparseArray();
        sStartupComsumeTime = -1L;
    }

    private class ABTestUpdateConfig
    extends Step {
        private ABTestUpdateConfig() {
        }

        @Override
        public void doAction() {
            ABTestConfigInitializer.INSTANCE.setupABTest();
        }

        @Override
        public int getID() {
            return StepMsgDef.MSG_STEP_ABTEST_CONFIG_UPDATE;
        }

        @Override
        public String getDescription() {
            return "ABTestUpdateConfig";
        }
    }

    private class WebRedirectConfigQuery
    extends Step {
        private WebRedirectConfigQuery() {
        }

        @Override
        public void doAction() {
            if (!MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)StartupManager.TAG, (String)"WebRedirectConfigQuery is Running", (Object[])new Object[0]);
                WebConfig.getInstance().getWebRedirectInfoList();
            }
        }

        @Override
        public int getID() {
            return StepMsgDef.MSG_STEP_WEB_REDIRECT_CONFIG;
        }

        @Override
        public String getDescription() {
            return "WebRedirectConfigQuery";
        }
    }

    private class StepAdposmonitorCoreQuery
    extends Step {
        private StepAdposmonitorCoreQuery() {
        }

        @Override
        public void doAction() {
            AdPosMonitorImp.get().queryAdHttpConfig();
        }

        @Override
        public String getDescription() {
            return "AdposMonitorCoreQuery";
        }

        @Override
        public int getID() {
            return StepMsgDef.MSG_STEP_ADPOSMONITORCORE_QUERY;
        }
    }

    private class ReportUncatchCrash
    extends Step {
        private ReportUncatchCrash() {
        }

        @Override
        public void doAction() {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    PerformanceMonitorSwitchController.reportUncatchCrash();
                }
            }, (long)5000L);
        }

        @Override
        public String getDescription() {
            return "ReportUncatchCrash";
        }

        @Override
        public int getID() {
            return StepMsgDef.MSG_STEP_REPORT_UNCATCH_CRASH;
        }
    }

    private class StepStatisticServiceInit
    extends Step {
        private StepStatisticServiceInit() {
        }

        @Override
        public void doAction() {
            StatisticService.instance().addReportContainer(TimeUtils.MINUTES.toMillis((long)5L), UriProvider.ENT_REPORT_URL, (StatisticDataContainerInterface)StatisticDataContainer.instance());
            StatisticService.instance().addReportContainer(TimeUtils.MINUTES.toMillis((long)5L), UriProvider.ENT_REPORT_NEW_URL, (StatisticDataContainerInterface)StatisticUtil.instance().get(StatisticNewDataContainer.class));
            StatisticService.instance().setReportProperty(new AbstractReportProperty(){

                public long getUid() {
                    return LoginUtil.getUid();
                }
            });
        }

        @Override
        public String getDescription() {
            return "StatisticServiceInit";
        }

        @Override
        public int getID() {
            return StepMsgDef.MSG_STEP_STATISTIC_SERVICE;
        }
    }

    private class StepForebackgroundCoreInit
    extends Step {
        private StepForebackgroundCoreInit() {
        }

        @Override
        public void doAction() {
            YYActivityManager.INSTANCE.registerActivityLifecycleCallbacks(((IForeBackgroundCore)CoreManager.getCore(IForeBackgroundCore.class)).getActivityLifecycleCallbacks());
        }

        @Override
        public String getDescription() {
            return "ForebackgroundCoreInit";
        }

        @Override
        public int getID() {
            return StepMsgDef.MSG_STEP_FORE_BACKGROUND_CORE_INIT;
        }
    }

    private class StepCoremanagerDelayInit
    extends Step {
        private StepCoremanagerDelayInit() {
        }

        @Override
        public void doAction() {
            ICoreManagerBase.getUserCore();
            LoginForPushReceiver.init();
        }

        @Override
        public String getDescription() {
            return "CoreManagerDelayInit";
        }

        @Override
        public int getID() {
            return StepMsgDef.MSG_STEP_COREMANAGER_POST_INIT;
        }
    }

    private class StepDbManagerInit
    extends Step {
        private StepDbManagerInit() {
        }

        @Override
        public void doAction() {
            DbManager.init((Context)YYMobileApp.gContext);
        }

        @Override
        public String getDescription() {
            return "DbManagerInit";
        }

        @Override
        public int getID() {
            return StepMsgDef.MSG_STEP_DBMANAGER_INIT;
        }
    }

    private class StepGlobalActivityManager
    extends Step {
        private StepGlobalActivityManager() {
        }

        @Override
        public void doAction() {
            GlobalActivityManager.INSTANCE.init(StartupManager.this.mContext);
        }

        @Override
        public String getDescription() {
            return "GlobalActivityManagerInit";
        }

        @Override
        public int getID() {
            return StepMsgDef.MSG_STEP_GLOBAL_ACTIVITY_MANAGER;
        }
    }

    private class StepPluginManager
    extends Step {
        private StepPluginManager() {
        }

        @Override
        public void doAction() {
            PluginManager.INSTANCE.register(IYYHandlerMgr.class, (Object)BasicYYHandlerMgr.getInstance());
            PluginManager.INSTANCE.register(IEntCoreManagerV2.class, (Object)EntCoreManagerV2.INSTANCE);
        }

        @Override
        public String getDescription() {
            return "StepPluginManagerInit";
        }

        @Override
        public int getID() {
            return StepMsgDef.MSG_STEP_PLUGINMANAGER;
        }
    }

    private class StepNavRest
    extends Step {
        private StepNavRest() {
        }

        private void addMatchList(@NonNull INavRestCore navRestCore, IRestApiList apiList) {
            if (apiList != null) {
                navRestCore.addMatchList(apiList.getList());
            }
        }

        @Override
        public void doAction() {
            INavRestCore navRestCore = (INavRestCore)ICoreManagerBase.getCore(INavRestCore.class);
            if (navRestCore != null) {
                this.addMatchList(navRestCore, new LoginApiList());
                this.addMatchList(navRestCore, new WebCtrlApiList());
                this.addMatchList(navRestCore, new LiveCenterApiList());
                this.addMatchList(navRestCore, new PersonalCenterApiList());
                this.addMatchList(navRestCore, new UserInfoApiList());
                this.addMatchList(navRestCore, new CommonApiList());
                this.addMatchList(navRestCore, new DiscoveryApiList());
                this.addMatchList(navRestCore, new PhotoCenterAPIList());
                this.addMatchList(navRestCore, new MomentApiList());
                this.addMatchList(navRestCore, new DiamondApiList());
                this.addMatchList(navRestCore, new VoiceRoomApiList());
                this.addMatchList(navRestCore, new OnepieceApiList());
                this.addMatchList(navRestCore, new AggregationPageApiList());
                this.addMatchList(navRestCore, new ToastApiList());
                this.addMatchList(navRestCore, new PopwebApiList());
            }
        }

        @Override
        public String getDescription() {
            return "NavRestInit";
        }

        @Override
        public int getID() {
            return StepMsgDef.MSG_STEP_NAV_REST;
        }
    }

    private class StepCoremanagerInit
    extends Step {
        private StepCoremanagerInit() {
        }

        @Override
        public void doAction() {
            CoreManager.init((Context)StartupManager.this.mContext);
        }

        @Override
        public String getDescription() {
            return "@CoreManagerInit";
        }

        @Override
        public int getID() {
            return StepMsgDef.MSG_STEP_COREMANAGER_INIT;
        }
    }

    private class StepYlinkInit
    extends Step {
        private StepYlinkInit() {
        }

        @Override
        public void doAction() {
            YLink.init();
        }

        @Override
        public String getDescription() {
            return "YlinkInit";
        }

        @Override
        public int getID() {
            return StepMsgDef.MSG_STEP_YLINK_INIT;
        }
    }

    private class StepRequestBaseData
    extends Step {
        private StepRequestBaseData() {
        }

        private void requestDanmuInfo() {
            ((IDanmuConfigCore)CoreManager.getCore(IDanmuConfigCore.class)).reqDanmuConfigInfo();
        }

        private void reqHttpHostConfigData() {
            IHttpHostConfigCore core = (IHttpHostConfigCore)CoreFactory.getCore(IHttpHostConfigCore.class);
            if (core != null) {
                core.reqHttpHostConfig();
            }
        }

        private void readHttpHostConfig() {
            String jsonBuffer;
            File file;
            if (BasicConfig.getInstance().getConfigDir().exists() && (file = new File(BasicConfig.getInstance().getConfigDir().getAbsolutePath() + "/https.json")).exists() && (jsonBuffer = YYFileUtils.readJsonData((String)file.getAbsolutePath())) != null && !jsonBuffer.isEmpty()) {
                HttpConfigUtils.convertJsonToMap((String)jsonBuffer);
            }
            this.reqHttpHostConfigData();
        }

        private void requestHttpDnsInfo() {
            IHttpDnsConfigCore core = (IHttpDnsConfigCore)CoreFactory.getCore(IHttpDnsConfigCore.class);
            if (core != null) {
                core.reqHttpDnsConfig();
            }
        }

        private void requestOKHttpInfo() {
            IOKHttpConfigCore core = (IOKHttpConfigCore)CoreFactory.getCore(IOKHttpConfigCore.class);
            if (core != null) {
                core.reqOKHttpConfig();
            }
        }

        @Override
        public void doAction() {
            this.readHttpHostConfig();
            this.requestDanmuInfo();
            this.requestHttpDnsInfo();
            this.requestOKHttpInfo();
            ((ILogUploadCore)CoreManager.getCore(ILogUploadCore.class)).requestLogSwitchFlag();
        }

        @Override
        public String getDescription() {
            return "RequestBaseData";
        }

        @Override
        public int getID() {
            return StepMsgDef.MSG_STEP_REQUEST_BASE_DATA;
        }
    }

    private class StepInitImageAndRequestManager
    extends Step {
        private StepInitImageAndRequestManager() {
        }

        @Override
        public void doAction() {
        }

        @Override
        public String getDescription() {
            return "StepInitImageAndRequestManager";
        }

        @Override
        public int getID() {
            return StepMsgDef.MSG_STEP_INIT_IMAGE_AND_REQUEST_MANAGER;
        }
    }

    private class StepInitPubless
    extends Step {
        private StepInitPubless() {
        }

        @Override
        public void doAction() {
            MLog.info((Object)StartupManager.TAG, (String)"StepInitPubless doAction", (Object[])new Object[0]);
            Publess.enableLog((ILog)new PublessLog());
            Publess.performNetwork((Network)new PublessNetworkImpl());
            PublessCore.init();
        }

        @Override
        public int getID() {
            return StepMsgDef.MSG_STEP_INIT_PUBLESS;
        }

        @Override
        public String getDescription() {
            return "\u521d\u59cb\u5316\u7edf\u4e00\u914d\u7f6e\u4e2d\u5fc3";
        }
    }

    private static abstract class Step
    implements Runnable {
        private boolean mHasDone;

        private Step() {
        }

        @Override
        public final void run() {
            if (this.mHasDone && !this.needRedo()) {
                return;
            }
            this.mHasDone = false;
            String desCri = this.getDescription();
            if (DEBUG && desCri != null && !MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)StartupManager.TAG, (String)("begin step: " + desCri), (Object[])new Object[0]);
            }
            this.doAction();
            if (DEBUG && desCri != null && !MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)StartupManager.TAG, (String)("end step: " + desCri), (Object[])new Object[0]);
            }
            this.mHasDone = true;
        }

        protected boolean needRedo() {
            return false;
        }

        public abstract void doAction();

        public abstract int getID();

        public abstract String getDescription();
    }

    public static class StepAppId
    extends Step {
        public static String WECHAT_APP_ID = "wxe99623d9884aa324";

        @Override
        public void doAction() {
            HostStore.INSTANCE.dispatch((Action)new HostState_AppIdAction(Constants.APP_ID_UNION));
            HostStore.INSTANCE.dispatch((Action)new HostState_AppIdWithoutPlatformAction("yym"));
            HostStore.INSTANCE.dispatch((Action)new HostState_WechatAppIdAction(WECHAT_APP_ID));
        }

        @Override
        public int getID() {
            return StepMsgDef.MSG_STEP_DISPATCH_APPID;
        }

        @Override
        public String getDescription() {
            return "StepAppId";
        }
    }

    public static class StepHostStoreInit
    extends Step {
        @Override
        public void doAction() {
            HostStore.INSTANCE.init(Arrays.asList(new AddDataModuleApiMethodMiddleware(), new AddUiModuleApiMethodMiddleware()));
        }

        @Override
        public int getID() {
            return StepMsgDef.MSG_STEP_HOST_STORE_INIT;
        }

        @Override
        public String getDescription() {
            return "StepHostStoreInit";
        }
    }
}

