/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.photoselect;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.net.Uri;
import android.os.Build;
import android.os.Parcelable;
import android.view.View;
import android.widget.TextView;
import com.yanzhenjie.permission.Action;
import com.yanzhenjie.permission.AndPermission;
import com.yanzhenjie.permission.runtime.option.RuntimeOption;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.permission.SafeAction;
import com.yy.mobile.photoselect.PhotoEditController;
import com.yy.mobile.photoselect.PhotoSelectActivity;
import com.yy.mobile.plugin.pluginunionmain.R;
import com.yy.mobile.ui.BaseActivity;
import com.yy.mobile.ui.BaseActivityKt;
import com.yy.mobile.ui.mobilelive.ClipImagePresent;
import com.yy.mobile.ui.mobilelive.clipimage.ClipImageView;
import com.yy.mobile.ui.mobilelive.clipimage.ClipParaInfo;
import com.yy.mobile.ui.mobilelive.clipimage.IClipImagePresenter;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.TimeUtils;
import com.yy.mobile.util.YYFileUtils;
import com.yy.mobile.util.YYImageUtils;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.gallery.module.GalleryConst;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0015\u0018\u0000 ,2\u00020\u0001:\u0002+,B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u0010\u0019\u001a\u00020\u0018H\u0002J\u0016\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u0010J\u0006\u0010\u001d\u001a\u00020\u0010J\u0006\u0010\u001e\u001a\u00020\u0018J\u0012\u0010\u001f\u001a\u00020\u00182\b\u0010 \u001a\u0004\u0018\u00010\u0015H\u0016J\u0016\u0010!\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020\t2\u0006\u0010#\u001a\u00020\u0010J\b\u0010$\u001a\u00020\u0018H\u0002J\u000e\u0010%\u001a\u00020\u00182\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010&\u001a\u00020\u00182\u0006\u0010'\u001a\u00020\u0010J\u0010\u0010(\u001a\u00020\u00182\u0006\u0010)\u001a\u00020\u0010H\u0002J\u0006\u0010*\u001a\u00020\u0018R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/yy/mobile/photoselect/PhotoEditController;", "Landroid/view/View$OnClickListener;", "activity", "Landroid/app/Activity;", "callback", "Lcom/yy/mobile/photoselect/PhotoEditController$CancelCallback;", "(Landroid/app/Activity;Lcom/yy/mobile/photoselect/PhotoEditController$CancelCallback;)V", "mActivity", "mBmpPath", "", "mCancelCallback", "mClipImagePresent", "Lcom/yy/mobile/ui/mobilelive/clipimage/IClipImagePresenter;", "mClipImageView", "Lcom/yy/mobile/ui/mobilelive/clipimage/ClipImageView;", "mEditInit", "", "mPhotoFromCamera", "mRetakePhoto", "Landroid/widget/TextView;", "mRootView", "Landroid/view/View;", "mUploadPhoto", "deleteTempImage", "", "finishActivity", "initPhotoEditContentView", "rootView", "isFromCamera", "onBackPressed", "onCancel", "onClick", "v", "onGetPhoto", "bmpPath", "photoFromCamera", "realTakePhotoFromCamera", "setEditInit", "setEditPhotoFrom", "isFromCoverGallery", "setEditViewVisible", "isVisible", "takePhotoFromCamera", "CancelCallback", "Companion", "pluginunionmain_release"})
public final class PhotoEditController
implements View.OnClickListener {
    private Activity mActivity;
    private View mRootView;
    private TextView mUploadPhoto;
    private TextView mRetakePhoto;
    private CancelCallback mCancelCallback;
    private ClipImageView mClipImageView;
    private IClipImagePresenter mClipImagePresent;
    private boolean mPhotoFromCamera;
    private boolean mEditInit;
    private String mBmpPath;
    @NotNull
    public static final String TAG = "PhotoEditController";
    @NotNull
    public static final String CLIP_NAME = "clip_";
    @NotNull
    public static final String JPG_EXT = ".jpg";
    @NotNull
    public static final String CAMERA_PREFIX = "pic_";
    public static final int IMAGE_CAPTURE_REPUEST_CODE = 0;
    public static final Companion Companion = new Companion(null);

    public final void initPhotoEditContentView(@NotNull View rootView, boolean isFromCamera) {
        block12: {
            Intrinsics.checkParameterIsNotNull((Object)rootView, (String)"rootView");
            this.mPhotoFromCamera = isFromCamera;
            this.mRootView = rootView;
            if (this.mRootView == null) break block12;
            View view = this.mRootView;
            Object object = view != null ? view.findViewById(R.id.clip_image_view) : null;
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.yy.mobile.ui.mobilelive.clipimage.ClipImageView");
            }
            this.mClipImageView = (ClipImageView)((Object)object);
            this.mClipImagePresent = new ClipImagePresent();
            ClipImageView clipImageView = this.mClipImageView;
            if (clipImageView != null) {
                ClipImageView clipImageView2 = clipImageView;
                boolean bl = false;
                boolean bl2 = false;
                ClipImageView $receiver = clipImageView2;
                IClipImagePresenter iClipImagePresenter = this.mClipImagePresent;
                if (iClipImagePresenter != null) {
                    iClipImagePresenter.setClipImageView($receiver);
                }
            }
            View view2 = this.mRootView;
            Object object2 = view2 != null ? view2.findViewById(R.id.btn_use) : null;
            if (object2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.widget.TextView");
            }
            this.mUploadPhoto = (TextView)object2;
            View view3 = this.mRootView;
            Object object3 = view3 != null ? view3.findViewById(R.id.btn_retake) : null;
            if (object3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.widget.TextView");
            }
            this.mRetakePhoto = (TextView)object3;
            if (!this.mPhotoFromCamera) {
                TextView textView = this.mRetakePhoto;
                if (textView != null) {
                    textView.setText((CharSequence)"\u53d6\u6d88");
                }
            } else {
                TextView textView = this.mRetakePhoto;
                if (textView != null) {
                    textView.setText((CharSequence)"\u91cd\u62cd");
                }
            }
            TextView textView = this.mUploadPhoto;
            if (textView != null) {
                textView.setOnClickListener((View.OnClickListener)this);
            }
            TextView textView2 = this.mRetakePhoto;
            if (textView2 != null) {
                textView2.setOnClickListener((View.OnClickListener)this);
            }
            View view4 = this.mRootView;
            if (view4 != null) {
                view4.setVisibility(8);
            }
        }
    }

    public final void onGetPhoto(@NotNull String bmpPath, boolean photoFromCamera) {
        Intrinsics.checkParameterIsNotNull((Object)bmpPath, (String)"bmpPath");
        if (FP.empty((CharSequence)bmpPath) || StringsKt.lastIndexOf$default((CharSequence)bmpPath, (String)".", (int)0, (boolean)false, (int)6, null) == -1) {
            MLog.error((Object)TAG, (String)"--conGetPhoto bmtPath is NULL", (Object[])new Object[0]);
            return;
        }
        this.mBmpPath = bmpPath;
        try {
            ClipParaInfo info = new ClipParaInfo();
            info.aspectX = 3;
            info.aspectY = 2;
            info.maxWidth = 1;
            info.inputPath = bmpPath;
            if (this.mClipImagePresent != null) {
                IClipImagePresenter iClipImagePresenter = this.mClipImagePresent;
                if (iClipImagePresenter != null) {
                    iClipImagePresenter.initClipParaInfo(info);
                }
            }
        }
        catch (Exception ex) {
            MLog.error((Object)TAG, (Throwable)ex);
        }
        this.mPhotoFromCamera = photoFromCamera;
    }

    private final void setEditViewVisible(boolean isVisible) {
        if (this.mRootView != null && this.mActivity != null) {
            try {
                if (isVisible) {
                    View view = this.mRootView;
                    if (view != null) {
                        view.setVisibility(0);
                    }
                } else {
                    View view = this.mRootView;
                    if (view != null) {
                        view.setVisibility(8);
                    }
                    if (this.mCancelCallback != null) {
                        View view2 = this.mRootView;
                        if (view2 != null) {
                            View view3 = view2;
                            boolean bl = false;
                            boolean bl2 = false;
                            View $receiver = view3;
                            CancelCallback cancelCallback = this.mCancelCallback;
                            if (cancelCallback != null) {
                                cancelCallback.onCancel($receiver);
                            }
                        }
                    }
                }
            }
            catch (Throwable ex) {
                MLog.error((Object)TAG, (Throwable)ex);
            }
        }
    }

    public final void setEditPhotoFrom(boolean isFromCoverGallery) {
        block0: {
            block1: {
                this.mPhotoFromCamera = isFromCoverGallery;
                if (this.mRetakePhoto == null) break block0;
                if (this.mPhotoFromCamera) break block1;
                TextView textView = this.mRetakePhoto;
                if (textView == null) break block0;
                textView.setText((CharSequence)"\u53d6\u6d88");
                break block0;
            }
            TextView textView = this.mRetakePhoto;
            if (textView == null) break block0;
            textView.setText((CharSequence)"\u91cd\u62cd");
        }
    }

    public final void onCancel() {
        if (this.mPhotoFromCamera) {
            this.deleteTempImage();
        }
        this.setEditViewVisible(false);
    }

    /*
     * WARNING - void declaration
     */
    public final void takePhotoFromCamera() {
        String[] stringArray;
        void $this$toTypedArray$iv;
        ArrayList<String> permission = new ArrayList<String>();
        permission.add("android.permission.CAMERA");
        Collection collection = permission;
        RuntimeOption runtimeOption = AndPermission.with((Activity)this.mActivity).runtime();
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
        if (stringArray2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        String[] stringArray3 = stringArray = stringArray2;
        runtimeOption.permission(Arrays.copyOf(stringArray3, stringArray3.length)).onGranted((Action)new SafeAction<List<? extends String>>(this, (Object)this.mActivity){
            final /* synthetic */ PhotoEditController this$0;

            public void onSafeAction(@NotNull List<String> data) {
                Intrinsics.checkParameterIsNotNull(data, (String)"data");
                PhotoEditController.access$realTakePhotoFromCamera(this.this$0);
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1);
            }
        }).onDenied((Action)takePhotoFromCamera.2.INSTANCE).start();
    }

    private final void realTakePhotoFromCamera() {
        long uid = LoginUtil.getUid();
        MLog.info((Object)"PhotoSelectActivity", (String)("-- realTakePhotoFromCamera uid = " + uid), (Object[])new Object[0]);
        Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
        String camCapturingName = StringUtils.isEmpty((String)Long.toString(uid)) == false ? String.valueOf(uid) + "_" + TimeUtils.curSec() + JPG_EXT : CAMERA_PREFIX + TimeUtils.curSec() + JPG_EXT;
        Activity activity = this.mActivity;
        if (activity == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.yy.mobile.photoselect.PhotoSelectActivity");
        }
        ((PhotoSelectActivity)activity).saveCamCaptureName(camCapturingName);
        try {
            File out = YYFileUtils.getTempFile((Context)((Context)this.mActivity), (String)camCapturingName);
            out.delete();
            Uri uri = AndPermission.getFileUri((Activity)this.mActivity, (File)out);
            if (Intrinsics.areEqual((Object)Build.MANUFACTURER, (Object)"OPPO") ^ true) {
                intent.putExtra("android.intent.extras.CAMERA_FACING", 1);
            }
            intent.putExtra("output", (Parcelable)uri);
            Activity activity2 = this.mActivity;
            if (activity2 != null) {
                activity2.startActivityForResult(intent, 0);
            }
        }
        catch (Exception e) {
            MLog.error((Object)"PhotoSelectActivity", (String)("-- realTakePhotoFromCamera fail " + e), (Object[])new Object[0]);
        }
    }

    private final void deleteTempImage() {
        if (this.mBmpPath != null) {
            if (MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)TAG, (String)("deleteTempImage path=" + this.mBmpPath), (Object[])new Object[0]);
            }
            YYFileUtils.removeFile((String)this.mBmpPath);
            this.mBmpPath = null;
        }
    }

    public final void setEditInit(boolean mEditInit) {
        this.mEditInit = mEditInit;
    }

    private final void finishActivity() {
        block2: {
            if (this.mActivity == null) break block2;
            Activity activity = this.mActivity;
            if (activity != null) {
                activity.setResult(-1);
            }
            Activity activity2 = this.mActivity;
            if (activity2 != null) {
                activity2.finish();
            }
        }
    }

    public void onClick(@Nullable View v) {
        if (v == this.mRetakePhoto) {
            if (this.mClipImagePresent != null) {
                IClipImagePresenter iClipImagePresenter = this.mClipImagePresent;
                if (iClipImagePresenter != null) {
                    iClipImagePresenter.setClipImageViewBitmapPath(null);
                }
            }
            if (this.mEditInit) {
                this.finishActivity();
                return;
            }
            if (this.mPhotoFromCamera) {
                this.deleteTempImage();
                this.takePhotoFromCamera();
                Activity activity = this.mActivity;
                if (activity == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.yy.mobile.ui.BaseActivityKt");
                }
                ((BaseActivityKt)activity).getHandler().postDelayed(new Runnable(this){
                    final /* synthetic */ PhotoEditController this$0;

                    public final void run() {
                        this.this$0.onCancel();
                    }
                    {
                        this.this$0 = photoEditController;
                    }
                }, 1000L);
            } else {
                this.onCancel();
            }
        } else if (v == this.mUploadPhoto) {
            try {
                Bitmap bitmap;
                IClipImagePresenter iClipImagePresenter = this.mClipImagePresent;
                Object object = bitmap = iClipImagePresenter != null ? iClipImagePresenter.getClipBitmap() : null;
                if (bitmap != null) {
                    File clipTemp;
                    long uid = LoginUtil.getUid();
                    String path = CLIP_NAME + TimeUtils.curSec() + JPG_EXT;
                    if (!StringUtils.isEmpty((String)Long.toString(uid)).booleanValue()) {
                        path = Long.toString(uid) + "_" + TimeUtils.curSec() + JPG_EXT;
                    }
                    MLog.info((Object)TAG, (String)("-- onClick uid=" + uid + ", file path=" + path), (Object[])new Object[0]);
                    GalleryConst.PhotoQuality mQuality = GalleryConst.PhotoQuality.LIVE_COVER;
                    File file = clipTemp = YYFileUtils.getTempFile((Context)((Context)this.mActivity), (String)path);
                    Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"clipTemp");
                    YYFileUtils.saveBitmap((Bitmap)bitmap, (String)file.getPath(), (Bitmap.CompressFormat)Bitmap.CompressFormat.JPEG, (int)80);
                    if (bitmap.getWidth() * bitmap.getHeight() > mQuality.width * mQuality.height) {
                        YYImageUtils.resizeImage((String)clipTemp.getPath(), (String)clipTemp.getPath(), (int)mQuality.width, (int)mQuality.height, (Matrix)new Matrix(), (int)mQuality.quality);
                    }
                    if (this.mPhotoFromCamera) {
                        this.deleteTempImage();
                    }
                    MLog.info((Object)TAG, (String)("mPhotoFromCamera =" + this.mPhotoFromCamera + " mPhotoFile=" + this.mBmpPath), (Object[])new Object[0]);
                    Intent data = new Intent();
                    data.putExtra("take_pic_local_path_key", clipTemp.getAbsolutePath());
                    Activity activity = this.mActivity;
                    if (activity != null) {
                        activity.setResult(0, data);
                    }
                    Activity activity2 = this.mActivity;
                    if (activity2 != null) {
                        activity2.finish();
                    }
                } else {
                    MLog.error((Object)TAG, (String)"mEditView.getCroppedImage() ==  null", (Object[])new Object[0]);
                    Activity activity = this.mActivity;
                    if (activity == null) {
                        throw new TypeCastException("null cannot be cast to non-null type com.yy.mobile.ui.BaseActivity<*, *>");
                    }
                    ((BaseActivity)activity).toast("\u7f16\u8f91\u7684\u56fe\u7247\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u7f16\u8f91!");
                    this.onCancel();
                }
            }
            catch (Exception e) {
                MLog.error((Object)TAG, (Throwable)e);
                Activity activity = this.mActivity;
                if (activity == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.yy.mobile.ui.BaseActivity<*, *>");
                }
                ((BaseActivity)activity).toast("\u7f16\u8f91\u7684\u56fe\u7247\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u7f16\u8f91!");
                this.onCancel();
            }
        }
    }

    public final boolean onBackPressed() {
        if (this.mEditInit) {
            this.finishActivity();
            return true;
        }
        if (this.mRootView != null) {
            View view = this.mRootView;
            if (view == null) {
                Intrinsics.throwNpe();
            }
            if (view.isShown() && this.mActivity != null) {
                try {
                    this.onCancel();
                }
                catch (Throwable ex) {
                    MLog.error((Object)TAG, (Throwable)ex);
                }
                return true;
            }
        }
        return false;
    }

    public PhotoEditController(@NotNull Activity activity, @NotNull CancelCallback callback) {
        Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
        Intrinsics.checkParameterIsNotNull((Object)callback, (String)"callback");
        this.mActivity = activity;
        this.mCancelCallback = callback;
    }

    public static final /* synthetic */ void access$realTakePhotoFromCamera(PhotoEditController $this) {
        $this.realTakePhotoFromCamera();
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/yy/mobile/photoselect/PhotoEditController$CancelCallback;", "", "onCancel", "", "view", "Landroid/view/View;", "pluginunionmain_release"})
    public static interface CancelCallback {
        public void onCancel(@NotNull View var1);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/yy/mobile/photoselect/PhotoEditController$Companion;", "", "()V", "CAMERA_PREFIX", "", "CLIP_NAME", "IMAGE_CAPTURE_REPUEST_CODE", "", "JPG_EXT", "TAG", "pluginunionmain_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

