/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget.dialog;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.support.annotation.NonNull;
import com.yy.mobile.plugin.pluginunionmain.R;
import com.yy.mobile.ui.dialog.IDialogLinkManagerCore;
import com.yy.mobile.ui.utils.dialog.BaseDialog;
import com.yy.mobile.ui.utils.dialog.DialogLinkManager;
import com.yy.mobile.ui.widget.dialog.ButtonItem;
import com.yy.mobile.ui.widget.dialog.CommonPopupDialog;
import com.yymobile.core.ICoreManagerBase;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

public class YY1931UploadDialog
implements BaseDialog {
    private YY1931UploadDialogListener mListener;
    private Activity mActivity;
    private Dialog mDialog;

    public YY1931UploadDialog(@NonNull Activity activity, YY1931UploadDialogListener listener) {
        this.mActivity = activity;
        this.mListener = listener;
    }

    public void init(Dialog dialog) {
        if (this.mActivity == null) {
            return;
        }
        ArrayList<ButtonItem> list = new ArrayList<ButtonItem>();
        this.initButtonItem(list);
        ButtonItem cancel = new ButtonItem(this.mActivity.getString(R.string.str_cancel), new ButtonItem.OnClickListener(){

            public void onClick() {
                YY1931UploadDialog.this.mDialog.dismiss();
            }
        });
        this.mDialog = new CommonPopupDialog((Context)this.mActivity, this.mActivity.getString(R.string.str_1931_choice_title), list, cancel);
        this.mDialog.setCancelable(true);
        this.mDialog.setCanceledOnTouchOutside(true);
        this.mDialog.show();
        this.resetDialogLinkManager();
    }

    public int getLayoutResId() {
        return 0;
    }

    private void initButtonItem(@NonNull List<ButtonItem> list) {
        if (this.mActivity == null) {
            return;
        }
        ButtonItem pic = new ButtonItem(this.mActivity.getString(R.string.str_1931_choice_pic), new ButtonItem.OnClickListener(){

            public void onClick() {
                if (YY1931UploadDialog.this.mListener != null) {
                    YY1931UploadDialog.this.mListener.onImage();
                }
                YY1931UploadDialog.this.dismissDialog();
            }
        });
        list.add(pic);
        ButtonItem video = new ButtonItem(this.mActivity.getString(R.string.str_1931_choice_video), new ButtonItem.OnClickListener(){

            public void onClick() {
                if (YY1931UploadDialog.this.mListener != null) {
                    YY1931UploadDialog.this.mListener.onVideo();
                }
                YY1931UploadDialog.this.dismissDialog();
            }
        });
        list.add(video);
        ButtonItem audio = new ButtonItem(this.mActivity.getString(R.string.str_1931_choice_audio), new ButtonItem.OnClickListener(){

            public void onClick() {
                if (YY1931UploadDialog.this.mListener != null) {
                    YY1931UploadDialog.this.mListener.onAudioTake();
                }
                YY1931UploadDialog.this.dismissDialog();
            }
        });
        list.add(audio);
    }

    public void dismissDialog() {
        if (this.mDialog != null) {
            this.mDialog.dismiss();
        }
        this.mDialog = null;
        this.mActivity = null;
    }

    private void resetDialogLinkManager() {
        DialogLinkManager dialogLinkManager = ((IDialogLinkManagerCore)ICoreManagerBase.getCore(IDialogLinkManagerCore.class)).getDialogLinkManager();
        WeakReference context = dialogLinkManager.mContext;
        if (context != null && context.get() != null && context.get() == this.mActivity) {
            dialogLinkManager.mDialog = this.mDialog;
        }
    }

    public static interface YY1931UploadDialogListener {
        public void onImage();

        public void onVideo();

        public void onAudioTake();
    }
}

