/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget.dialog;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.view.KeyEvent;
import android.view.View;
import android.view.Window;
import android.widget.EditText;
import android.widget.TextView;
import com.yy.mobile.RxBus;
import com.yy.mobile.plugin.main.events.IAuthClient_onHideLoadingProgressbar_EventArgs;
import com.yy.mobile.plugin.pluginunionmain.R;
import com.yy.mobile.ui.utils.dialog.BaseDialog;
import com.yy.mobile.ui.widget.toast.Toast;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.log.MLog;

public class DynamicTokenLoginDialog
implements BaseDialog {
    private static final String TAG = "DynamicTokenLoginDialog";
    private boolean cancelable;
    private boolean outSideCancelable;
    private boolean showErrorTip;
    private DynamicTokenLoginDialogListener listener;

    public DynamicTokenLoginDialog(boolean cancelable, boolean outSideCancelable, boolean showErrorTip, DynamicTokenLoginDialogListener listener) {
        this.cancelable = cancelable;
        this.outSideCancelable = outSideCancelable;
        this.showErrorTip = showErrorTip;
        this.listener = listener;
    }

    public void init(final Dialog dialog) {
        dialog.setCancelable(this.cancelable);
        dialog.setCanceledOnTouchOutside(this.outSideCancelable);
        dialog.show();
        Window window = dialog.getWindow();
        window.setContentView(this.getLayoutResId());
        window.clearFlags(131072);
        window.setSoftInputMode(5);
        final EditText input = (EditText)window.findViewById(R.id.dynamic_token);
        TextView errorTip = (TextView)window.findViewById(R.id.hw_token_error_tip);
        if (this.showErrorTip) {
            errorTip.setVisibility(0);
        }
        TextView cancle = (TextView)window.findViewById(R.id.btn_cancel);
        cancle.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                DynamicTokenLoginDialog.this.listener.onCancle();
                dialog.dismiss();
            }
        });
        TextView ok = (TextView)window.findViewById(R.id.btn_ok);
        ok.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                dialog.setOnDismissListener(null);
                String inputCode = input.getText().toString().trim();
                if (!StringUtils.isEmptyString((String)inputCode)) {
                    dialog.dismiss();
                    DynamicTokenLoginDialog.this.listener.onOK(inputCode);
                } else {
                    Toast.makeText((Context)dialog.getContext(), (CharSequence)"\u8bf7\u8f93\u5165\u9a8c\u8bc1\u7801\uff01", (int)0).show();
                }
            }
        });
        input.setOnKeyListener(new View.OnKeyListener(){

            public boolean onKey(View v, int keyCode, KeyEvent event) {
                if (66 == keyCode && event.getAction() == 0) {
                    String inputCode = input.getText().toString().trim();
                    DynamicTokenLoginDialog.this.listener.onOK(inputCode);
                    MLog.info((Object)DynamicTokenLoginDialog.TAG, (String)"enter to confirm", (Object[])new Object[0]);
                    return true;
                }
                return false;
            }
        });
        dialog.setOnDismissListener(new DialogInterface.OnDismissListener(){

            public void onDismiss(DialogInterface dialog) {
                RxBus.getDefault().post((Object)new IAuthClient_onHideLoadingProgressbar_EventArgs());
            }
        });
    }

    public int getLayoutResId() {
        return R.layout.layout_dynamic_token_dialog;
    }

    public static interface DynamicTokenLoginDialogListener {
        public void onOK(String var1);

        public void onCancle();
    }
}

