/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.utils.rest;

import android.app.Activity;
import android.net.Uri;
import com.yy.mobile.ui.utils.NavigationUtils;
import com.yy.mobile.ui.utils.rest.base.INavParam;
import com.yy.mobile.ui.utils.rest.base.IRestApiEx;
import com.yy.mobile.ui.utils.rest.base.IRestApiList;
import com.yy.mobile.ui.utils.rest.base.NavRestApi;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.log.MLog;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;

public class WebCtrlApiList
implements IRestApiList {
    private static final String TAG = "WebCtrlApiList";
    private static final String AUTHORITY = "Web";

    public List<IRestApiEx> getList() {
        ArrayList<IRestApiEx> list = new ArrayList<IRestApiEx>();
        list.add(this.gotoWeb());
        list.add(this.gotoAsynWeb());
        return list;
    }

    private IRestApiEx gotoAsynWeb() {
        return new NavRestApi(){

            public String getAuthority() {
                return WebCtrlApiList.AUTHORITY;
            }

            public String getPath() {
                return "AsynWebView/Features/#/Url/*";
            }

            public void run() {
                INavParam param = (INavParam)this.getParam();
                Uri uri = param.uri;
                List segments = uri.getPathSegments();
                int features = Integer.valueOf((String)segments.get(2));
                String url = String.valueOf(segments.get(4));
                WebCtrlApiList.this.handleWeb(param, features, url);
            }
        };
    }

    private IRestApiEx gotoWeb() {
        return new NavRestApi(){

            public String getAuthority() {
                return WebCtrlApiList.AUTHORITY;
            }

            public String getPath() {
                return "Features/#/Url/*";
            }

            public void run() {
                INavParam param = (INavParam)this.getParam();
                Uri uri = param.uri;
                List segments = uri.getPathSegments();
                int features = Integer.valueOf((String)segments.get(1));
                String url = String.valueOf(segments.get(3));
                WebCtrlApiList.this.handleWeb(param, features, url);
            }
        };
    }

    private void handleWeb(INavParam param, int features, final String encodeUrl) {
        final Activity act = param.context;
        act.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                String url = "";
                if (!FP.empty((CharSequence)encodeUrl)) {
                    url = Uri.decode((String)encodeUrl);
                }
                int isRefresh = WebCtrlApiList.this.parseUrlToGetRefresh(url, "isRefresh");
                int isReshPart = WebCtrlApiList.this.parseUrlToGetRefresh(url, "isReshPart");
                MLog.info((Object)WebCtrlApiList.TAG, (String)" toJSSupportedWebView...", (Object[])new Object[0]);
                if (isRefresh == 1 || isReshPart == 1) {
                    NavigationUtils.toJSSupportedWebView(act, url, isReshPart == 1 ? 7200 : 7100, isRefresh, isReshPart);
                } else {
                    NavigationUtils.toJSSupportedWebView(act, url);
                }
            }
        });
    }

    private int parseUrlToGetRefresh(String url, String tag) {
        try {
            List urlParamsList = URLEncodedUtils.parse((URI)new URI(url), (String)"UTF-8");
            for (NameValuePair nameValue : urlParamsList) {
                if (!tag.equals(nameValue.getName())) continue;
                return StringUtils.safeParseInt((String)nameValue.getValue());
            }
        }
        catch (Exception e) {
            MLog.info((Object)TAG, (String)e.getMessage(), (Object[])new Object[0]);
            return 0;
        }
        return 0;
    }
}

