/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.shenqu.tanmu;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RectF;
import android.graphics.SurfaceTexture;
import android.graphics.Xfermode;
import android.os.Handler;
import android.util.AttributeSet;
import android.util.SparseArray;
import android.view.TextureView;
import com.yy.mobile.ui.shenqu.tanmu.ArkMath;
import com.yy.mobile.util.log.MLog;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicBoolean;

public class IconAnimationTextureView
extends TextureView
implements TextureView.SurfaceTextureListener {
    private static final String TAG = "IconAnimationTextureView";
    public static final int FULL_UPDATE = 1;
    public static final int Minimal_Update = 2;
    public static final int HIGH_PERFORMANCE = 1;
    public static final int HIGH_QUALITY = 2;
    private static final int X = 0;
    private static final int Y = 1;
    private static final int ROTATION = 2;
    private static final int SCALE_X = 3;
    private static final int SCALE_Y = 4;
    private static final int ALPHA = 5;
    private static int TIME_IN_FRAME = 17;
    private int mUpdateModel = 2;
    private int mAnimationModel = 2;
    private SurfaceTexture mSurfaceTexture;
    private AnimationThread mThread;
    private Paint mPaint;
    private Paint mClearPaint;
    private RectF mDirtyRF = new RectF();
    private RectF mLastDirtyRF = new RectF();
    private RectF mLastLastDirtyRF = new RectF();
    private LinkedList<IconAnimation> mAnimations = new LinkedList();
    OnAnimationEndCallback mAnimationEndCallback;

    public IconAnimationTextureView(Context context) {
        super(context);
        this.init();
    }

    public IconAnimationTextureView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public IconAnimation createAnimation(Bitmap target) {
        return new IconAnimation(target);
    }

    public void endAllAnimation() {
        this.endAllAnimation(null);
    }

    public void endAllAnimation(OnAnimationEndCallback callback) {
        this.mAnimationEndCallback = callback;
        if (null != this.mThread) {
            this.mThread.mRunning.set(false);
        }
        this.mAnimations.clear();
    }

    public void setUpdateModel(int updateModel) {
        this.mUpdateModel = updateModel;
    }

    public void setAnimationModel(int model) {
        this.mAnimationModel = model;
        TIME_IN_FRAME = 1 == this.mAnimationModel ? 34 : 17;
    }

    public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
        this.mSurfaceTexture = surface;
        if (null != this.mThread) {
            this.mThread.mRunning.set(false);
            this.mThread = null;
        }
        this.clearCanvas();
    }

    public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
        if (this.mThread != null) {
            this.mThread.mDestroyed.set(true);
        }
        this.endAllAnimation();
        return true;
    }

    public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
    }

    public void onSurfaceTextureUpdated(SurfaceTexture surface) {
    }

    protected synchronized void clearAnimations() {
        this.mAnimations.clear();
    }

    private synchronized boolean isFinished() {
        return this.mAnimations.size() == 0;
    }

    private synchronized void addAnimation(IconAnimation ia) {
        this.mAnimations.add(ia);
    }

    private synchronized LinkedList<IconAnimation> popAllAnimaiton() {
        LinkedList<IconAnimation> list = this.mAnimations;
        this.mAnimations = new LinkedList();
        return list;
    }

    private synchronized void addAnimations(LinkedList<IconAnimation> anims) {
        this.mAnimations.addAll(anims);
    }

    private void init() {
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
        this.mPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_OVER));
        this.mClearPaint = new Paint();
        this.mClearPaint.setColor(0);
        this.mClearPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.CLEAR));
        this.setSurfaceTextureListener(this);
        this.setOpaque(false);
    }

    private void drawAnimations(Canvas canvas) {
        if (canvas == null) {
            return;
        }
        this.clearDirty(canvas);
        LinkedList<IconAnimation> unfinishedAnimations = new LinkedList<IconAnimation>();
        LinkedList<IconAnimation> animations = this.popAllAnimaiton();
        while (!animations.isEmpty()) {
            IconAnimation ia = animations.pop();
            if (ia.target == null || ia.animationHolds.size() == 0) continue;
            IconFrameHolds currentFrame = this.getCurrentFrame(ia);
            this.drawFrame(canvas, currentFrame);
            this.frameDrew(ia, currentFrame);
            long frameCount = ia.frameCount;
            if (frameCount == -1L) {
                unfinishedAnimations.add(ia);
                continue;
            }
            ++ia.frameIndex;
            if (ia.frameIndex <= frameCount) {
                unfinishedAnimations.add(ia);
                continue;
            }
            if (ia.listener == null) continue;
            ia.listener.onAnimationEnd(ia);
        }
        if (unfinishedAnimations.size() != 0) {
            this.addAnimations(unfinishedAnimations);
        }
    }

    protected void frameDrew(IconAnimation animation, IconFrameHolds currentFrame) {
    }

    public synchronized boolean isThreadStopped() {
        if (null == this.mThread) {
            return true;
        }
        return !this.mThread.mRunning.get();
    }

    private void clearDirty(Canvas canvas) {
        if (1 == this.mUpdateModel) {
            canvas.drawRect(0.0f, 0.0f, (float)canvas.getWidth(), (float)canvas.getHeight(), this.mClearPaint);
            return;
        }
        float left = ArkMath.min(this.mDirtyRF.left, this.mLastDirtyRF.left, this.mLastLastDirtyRF.left);
        float top = ArkMath.min(this.mDirtyRF.top, this.mLastDirtyRF.top, this.mLastLastDirtyRF.top);
        float right = ArkMath.max(this.mDirtyRF.right, this.mLastDirtyRF.right, this.mLastLastDirtyRF.right);
        float bottom = ArkMath.max(this.mDirtyRF.bottom, this.mLastDirtyRF.bottom, this.mLastLastDirtyRF.bottom);
        canvas.drawRect(left, top, right, bottom, this.mClearPaint);
        this.mLastLastDirtyRF.set(this.mLastDirtyRF);
        this.mLastDirtyRF.set(this.mDirtyRF);
        this.mDirtyRF.left = canvas.getWidth();
        this.mDirtyRF.top = canvas.getHeight();
        this.mDirtyRF.right = 0.0f;
        this.mDirtyRF.bottom = 0.0f;
    }

    private void drawFrame(Canvas canvas, IconFrameHolds holds) {
        Bitmap bitmap = holds.bitmap;
        float left = holds.x;
        float top = holds.y;
        float rotation = holds.rotation;
        float width = (float)bitmap.getWidth() * holds.scaleX;
        float height = (float)bitmap.getHeight() * holds.scaleY;
        float centerX = left + width / 2.0f;
        float centerY = top + height / 2.0f;
        float right = left + width;
        float bottom = top + height;
        RectF rf = new RectF(left, top, right, bottom);
        canvas.drawBitmap(bitmap, null, rf, this.mPaint);
        if (2 == this.mUpdateModel) {
            this.calcDirtyRect(left, top, right, bottom);
        }
    }

    private void calcDirtyRect(float left, float top, float right, float bottom) {
        this.mDirtyRF.left = Math.min(left, this.mDirtyRF.left);
        this.mDirtyRF.top = Math.min(top, this.mDirtyRF.top);
        this.mDirtyRF.right = Math.max(right, this.mDirtyRF.right);
        this.mDirtyRF.bottom = Math.max(bottom, this.mDirtyRF.bottom);
        double r = Math.sqrt(this.mDirtyRF.width() / 2.0f * this.mDirtyRF.height() / 2.0f);
        this.mDirtyRF.left = (float)((double)this.mDirtyRF.left - r);
        this.mDirtyRF.top = (float)((double)this.mDirtyRF.top - r);
        this.mDirtyRF.right = (float)((double)this.mDirtyRF.right + r);
        this.mDirtyRF.bottom = (float)((double)this.mDirtyRF.bottom + r);
    }

    private IconFrameHolds getCurrentFrame(IconAnimation ia) {
        IconFrameHolds ifh = new IconFrameHolds();
        ifh.bitmap = ia.target;
        SparseArray animationHolds = ia.animationHolds;
        int size = animationHolds.size();
        for (int index = 0; index < size; ++index) {
            int key = animationHolds.keyAt(index);
            float currentValue = this.getCurrentValue((float[])animationHolds.get(key), ia.frameIndex, ia.frameCount);
            this.setFrameHolds(ifh, key, currentValue);
        }
        return ifh;
    }

    private float getCurrentValue(float[] values, long index, long count) {
        if (values.length == 1) {
            return values[0];
        }
        float currentValue = values[0];
        if (-1L != count) {
            currentValue += (values[1] - values[0]) * (float)index / (float)count;
        }
        return currentValue;
    }

    private void setFrameHolds(IconFrameHolds ifh, int key, float currentValue) {
        switch (key) {
            case 0: {
                ifh.x = currentValue;
                break;
            }
            case 1: {
                ifh.y = currentValue;
                break;
            }
            case 2: {
                ifh.rotation = currentValue;
                break;
            }
            case 3: {
                ifh.scaleX = currentValue;
                break;
            }
            case 4: {
                ifh.scaleY = currentValue;
                break;
            }
            case 5: {
                ifh.alpha = currentValue;
                break;
            }
        }
    }

    private void startAnimation(IconAnimation ia) {
        this.addAnimation(ia);
        if (this.mThread == null || !this.mThread.mRunning.get()) {
            this.mThread = null;
            this.mThread = new AnimationThread();
            this.mThread.start();
        }
    }

    private void endAnimation(IconAnimation ia) {
        this.endAllAnimation();
    }

    private void clearCanvas() {
        Canvas canvas = null;
        try {
            if (null != this.mSurfaceTexture) {
                canvas = this.lockCanvas();
            }
            if (canvas != null) {
                canvas.drawColor(0, PorterDuff.Mode.CLEAR);
            }
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (Throwable)e);
        }
        finally {
            if (canvas != null) {
                try {
                    this.unlockCanvasAndPost(canvas);
                }
                catch (Throwable throwable) {
                    MLog.error((Object)TAG, (Throwable)throwable);
                }
            }
        }
    }

    protected static class IconFrameHolds {
        public Bitmap bitmap;
        public float x = 0.0f;
        public float y = 0.0f;
        public float rotation = 0.0f;
        public float scaleX = 1.0f;
        public float scaleY = 1.0f;
        public float alpha = 1.0f;

        protected IconFrameHolds() {
        }
    }

    public static interface OnAnimationListener2 {
        public void onAnimationEnd(IconAnimation var1);
    }

    public static interface OnAnimationListener {
        public void onAnimationEnd(IconAnimation var1);
    }

    class AnimationThread
    extends Thread {
        private AtomicBoolean mRunning;
        private AtomicBoolean mDestroyed;

        AnimationThread() {
            super("client IconAnimationTextureView Animation Thread");
            this.mRunning = new AtomicBoolean(true);
            this.mDestroyed = new AtomicBoolean(false);
            if (1 == IconAnimationTextureView.this.mAnimationModel) {
                int priority = 4;
                if (1 > priority) {
                    priority = 1;
                }
                this.setPriority(priority);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long startTime = System.currentTimeMillis();
            Canvas canvas = null;
            while (this.mRunning.get() && !IconAnimationTextureView.this.isFinished() && !this.mDestroyed.get()) {
                if (IconAnimationTextureView.this.getContext() != null && ((Activity)IconAnimationTextureView.this.getContext()).isFinishing()) {
                    IconAnimationTextureView.this.endAllAnimation();
                    break;
                }
                canvas = null;
                SurfaceTexture holder = IconAnimationTextureView.this.mSurfaceTexture;
                try {
                    if (holder != null) {
                        canvas = IconAnimationTextureView.this.lockCanvas();
                    }
                    if (canvas != null) {
                        IconAnimationTextureView.this.drawAnimations(canvas);
                    }
                }
                catch (Exception e) {
                    MLog.error((Object)IconAnimationTextureView.TAG, (Throwable)e);
                }
                finally {
                    if (canvas != null) {
                        try {
                            IconAnimationTextureView.this.unlockCanvasAndPost(canvas);
                        }
                        catch (Throwable throwable) {
                            MLog.error((Object)IconAnimationTextureView.TAG, (Throwable)throwable);
                        }
                    }
                }
                long endTime = System.currentTimeMillis();
                int diffTime = (int)(endTime - startTime);
                if (diffTime < TIME_IN_FRAME) {
                    try {
                        Thread.sleep(TIME_IN_FRAME - diffTime);
                    }
                    catch (InterruptedException e) {
                        MLog.error((Object)IconAnimationTextureView.TAG, (Throwable)e);
                    }
                    startTime += (long)TIME_IN_FRAME;
                    continue;
                }
                startTime = endTime;
            }
            if (!this.mRunning.get() && IconAnimationTextureView.this.mAnimationEndCallback != null) {
                IconAnimationTextureView.this.mAnimationEndCallback.onAnimationEnd();
                IconAnimationTextureView.this.mAnimationEndCallback = null;
            }
            if (!this.mDestroyed.get()) {
                IconAnimationTextureView.this.clearCanvas();
            }
            this.mRunning.set(false);
        }
    }

    public class IconAnimation {
        public static final long FOREVER = -1L;
        private static final long FOREVER_FRAME_COUNT = -1L;
        private static final long DEFAULT_FRAME_COUNT = 40L;
        public Bitmap target;
        public long frameIndex = 0L;
        public long frameCount = 40L;
        public long duration = 0L;
        private SparseArray<float[]> animationHolds = new SparseArray();
        private OnAnimationListener listener;
        private OnAnimationListener2 listener2;

        protected IconAnimation(Bitmap target) {
            this.target = target;
        }

        public IconAnimation x(float ... xs) {
            this.animationHolds.put(0, (Object)xs);
            return this;
        }

        public IconAnimation y(float ... ys) {
            this.animationHolds.put(1, (Object)ys);
            return this;
        }

        public float[] getY() {
            return (float[])this.animationHolds.get(1);
        }

        public IconAnimation rotation(float ... rotations) {
            this.animationHolds.put(2, (Object)rotations);
            return this;
        }

        public IconAnimation scaleX(float ... scaleXs) {
            this.animationHolds.put(3, (Object)scaleXs);
            return this;
        }

        public IconAnimation scaleY(float ... scaleYs) {
            this.animationHolds.put(4, (Object)scaleYs);
            return this;
        }

        public IconAnimation alpha(float ... alphas) {
            this.animationHolds.put(5, (Object)alphas);
            return this;
        }

        public IconAnimation duration(long duration) {
            this.duration = duration;
            this.frameCount = duration == -1L ? -1L : duration / (long)TIME_IN_FRAME;
            return this;
        }

        public IconAnimation setListener(OnAnimationListener listener) {
            this.listener = listener;
            return this;
        }

        public IconAnimation setListener2(OnAnimationListener2 listener) {
            this.listener2 = listener;
            return this;
        }

        public void start() {
            IconAnimationTextureView.this.startAnimation(this);
        }

        public void start(long delayMillis) {
            if (0L == delayMillis) {
                this.start();
                return;
            }
            new Handler().postDelayed(new Runnable(){

                @Override
                public void run() {
                    IconAnimation.this.start();
                }
            }, delayMillis);
        }

        public void end() {
            IconAnimationTextureView.this.endAnimation(this);
            if (this.listener != null) {
                this.listener.onAnimationEnd(this);
            }
        }
    }

    public static interface OnAnimationEndCallback {
        public void onAnimationEnd();
    }
}

