/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.PorterDuff;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.image.ImageConfig;
import com.yy.mobile.image.RecycleImageView;
import com.yy.mobile.imageloader.ImageLoader;
import com.yy.mobile.plugin.pluginunionmain.R;
import com.yy.mobile.ui.BaseFragment;
import com.yy.mobile.ui.utils.DensityUtil;
import com.yy.mobile.ui.widget.CommTitleUICreator;
import com.yy.mobile.util.DimenConverter;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.YYImageUtils;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.live.gson.RightBtnInfo;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

public class CommonTitleFragment
extends BaseFragment {
    private static final String TAG = "CommonTitleFragment";
    public static final String IS_SHOW_BACK_BTN = "isShowBackBtn";
    private TextView mTextTitle;
    private ImageView mImageTitle;
    private ViewGroup mRightContainer;
    private List<RightBtnInfo> mInfos = new ArrayList<RightBtnInfo>();
    private View.OnClickListener mBackListener;
    private RecycleImageView mBack;
    private int mImageTitleResId = -1;
    private String mTitleText;
    private ViewGroup root;
    private View divider;
    private boolean isShowBackBtn = true;
    private boolean hideTitle = false;
    private RecycleImageView close;
    private View.OnClickListener mCloseListener;

    public static CommonTitleFragment getInstance() {
        CommonTitleFragment fragment = new CommonTitleFragment();
        return fragment;
    }

    public static CommonTitleFragment getInstance(boolean isShowBack) {
        CommonTitleFragment fragment = new CommonTitleFragment();
        Bundle bundle = new Bundle();
        bundle.putBoolean(IS_SHOW_BACK_BTN, isShowBack);
        fragment.setArguments(bundle);
        return fragment;
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.layout_common_title, container, false);
        if (this.getArguments() != null) {
            this.isShowBackBtn = this.getArguments().getBoolean(IS_SHOW_BACK_BTN);
        }
        this.mTextTitle = (TextView)view.findViewById(R.id.text_title);
        this.mImageTitle = (ImageView)view.findViewById(R.id.image_title);
        this.mBack = (RecycleImageView)view.findViewById(R.id.back);
        this.mRightContainer = (ViewGroup)view.findViewById(R.id.right_container);
        this.mBack.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (CommonTitleFragment.this.mBackListener != null) {
                    CommonTitleFragment.this.mBackListener.onClick(v);
                }
            }
        });
        this.mBack.setVisibility(this.isShowBackBtn ? 0 : 8);
        this.close = (RecycleImageView)view.findViewById(R.id.close);
        this.close.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (CommonTitleFragment.this.mCloseListener != null) {
                    CommonTitleFragment.this.mCloseListener.onClick(view);
                }
            }
        });
        if (this.mImageTitleResId > 0) {
            this.setTitleImage(this.mImageTitleResId);
        } else if (!FP.empty((CharSequence)this.mTitleText)) {
            this.setTitleText(this.mTitleText);
        }
        this.divider = view.findViewById(R.id.divider);
        this.root = (ViewGroup)view.findViewById(R.id.root);
        return view;
    }

    public void setDividerVisibility(boolean visible) {
        if (null == this.divider) {
            return;
        }
        this.divider.setVisibility(visible ? 0 : 8);
    }

    public void hideTitleText() {
        if (this.mTextTitle == null) {
            return;
        }
        this.hideTitle = true;
        this.mTextTitle.setText((CharSequence)"");
        this.mTextTitle.setVisibility(4);
    }

    public void showTitleText() {
        if (this.mTextTitle == null) {
            return;
        }
        this.hideTitle = false;
        this.mTextTitle.setVisibility(0);
    }

    public void setTitleText(String title) {
        this.mTitleText = title;
        this.mImageTitleResId = -1;
        if (this.mTextTitle == null || this.mImageTitle == null || this.hideTitle) {
            return;
        }
        this.mTextTitle.setText((CharSequence)this.mTitleText);
        this.mImageTitle.setVisibility(4);
        this.mTextTitle.setVisibility(0);
    }

    public void setTitleTextColor(int color2) {
        if (this.mTextTitle == null || this.mImageTitle == null || this.hideTitle) {
            return;
        }
        this.mTextTitle.setTextColor(color2);
    }

    public void setTitleImage(int resId) {
        this.mTitleText = "";
        this.mImageTitleResId = resId;
        if (this.mTextTitle == null || this.mImageTitle == null) {
            return;
        }
        this.mImageTitle.setVisibility(0);
        this.mTextTitle.setVisibility(4);
        if (resId > 0) {
            this.mImageTitle.setImageResource(this.mImageTitleResId);
        } else {
            this.mImageTitle.setVisibility(4);
        }
    }

    public void clearTitle() {
        if (this.mRightContainer == null || this.mInfos == null) {
            return;
        }
        this.mRightContainer.removeAllViews();
        this.mInfos.clear();
    }

    public void setBackBtnState(int flag) {
        this.mBack.setVisibility(flag);
    }

    public void setBackBtnEnableState(boolean enableState) {
        this.mBack.clearColorFilter();
        if (enableState) {
            this.mBack.setEnabled(true);
        } else {
            this.mBack.setEnabled(false);
            this.mBack.setColorFilter(Color.parseColor((String)"#cccccc"), PorterDuff.Mode.SRC_IN);
        }
    }

    public void setCloseListener(boolean btnShow, View.OnClickListener listener2) {
        if (btnShow) {
            if (this.close != null) {
                this.close.setVisibility(0);
            }
            this.mCloseListener = listener2;
        }
    }

    public void setBackListener(View.OnClickListener listener2) {
        this.mBackListener = listener2;
    }

    public void setRightContainerWidth(int subSize) {
    }

    public void addRightBtn(RightBtnInfo info, View.OnClickListener listener2, float ... textSize) {
        if (info == null) {
            return;
        }
        int resId = -1;
        boolean useImage = true;
        int width = 0;
        switch (info.icon) {
            case 1000: {
                resId = R.drawable.selector_sharp_girl_post;
                width = (int)this.getResources().getDimension(R.dimen.right_btn_short_width);
                break;
            }
            case 1001: {
                resId = R.drawable.selector_sharp_girl_msg;
                width = (int)this.getResources().getDimension(R.dimen.right_btn_short_width);
                break;
            }
            case 1002: {
                resId = R.drawable.selector_sharp_girl_share;
                width = (int)this.getResources().getDimension(R.dimen.right_btn_short_width);
                break;
            }
            case 1003: {
                resId = R.drawable.selector_sharp_girl_only_owner;
                width = (int)this.getResources().getDimension(R.dimen.right_btn_long_width);
                break;
            }
            case 1004: {
                resId = R.drawable.selector_sharp_girl_close;
                width = (int)this.getResources().getDimension(R.dimen.right_btn_short_width);
                break;
            }
            case 1005: {
                resId = R.drawable.selector_sharp_girl_clear;
                width = (int)this.getResources().getDimension(R.dimen.right_btn_short_width);
                break;
            }
            case 1006: {
                resId = R.drawable.selector_sharp_girl_share;
                width = (int)this.getResources().getDimension(R.dimen.right_btn_short_width);
                break;
            }
            default: {
                useImage = false;
                int n = width = info.width == 0 ? (int)this.getResources().getDimension(R.dimen.right_btn_long_width) : info.width;
            }
        }
        if (resId < 0 && useImage) {
            return;
        }
        this.mInfos.add(info);
        View view = BtnCreator.create(LayoutInflater.from((Context)this.getActivity()), R.layout.layout_sharp_girl_right_btn);
        ImageView imageView = (ImageView)view.findViewById(R.id.image_btn);
        TextView textBtn = (TextView)view.findViewById(R.id.text_btn);
        if (useImage) {
            imageView.setImageResource(resId);
            imageView.setVisibility(0);
            textBtn.setVisibility(8);
        } else {
            textBtn.setText((CharSequence)info.title);
            if (textSize.length == 1) {
                textBtn.setTextSize(textSize[0]);
            } else {
                textBtn.setTextSize(20.0f);
            }
            textBtn.setVisibility(0);
            imageView.setVisibility(8);
            if (info.changeColor) {
                textBtn.setTextColor(Color.parseColor((String)"#FF8900"));
            }
        }
        TextView textView = (TextView)view.findViewById(R.id.news);
        textView.setId(info.identifier);
        if (FP.empty((CharSequence)info.badge)) {
            textView.setVisibility(4);
        } else {
            textView.setVisibility(0);
            textView.setText((CharSequence)info.badge);
        }
        if (info.selectable) {
            this.updateBtnCheckedState(view, info, false);
        }
        view.setOnClickListener(listener2);
        int dimen2 = (int)this.getResources().getDimension(R.dimen.top_header_height);
        view.setTag((Object)info);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(width, dimen2);
        this.mRightContainer.addView(view, (ViewGroup.LayoutParams)params);
    }

    public void addNewRightBtn(RightBtnInfo info, View.OnClickListener listener2) {
        this.addNewRightBtn(info, listener2, DensityUtil.dip2px((Context)this.getContext(), (float)16.0f));
    }

    public void addNewRightBtn(RightBtnInfo info, View.OnClickListener listener2, final int drawableWidth) {
        if (info == null) {
            return;
        }
        if (info.rightBarItemImgStyle == 1 && !FP.empty((CharSequence)info.img)) {
            RecycleImageView imageBtn = new RecycleImageView(this.getContext());
            int size = DimenConverter.dip2px((Context)this.getContext(), (float)22.0f);
            RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(size, size);
            layoutParams.setMargins(0, 0, DimenConverter.dip2px((Context)this.getContext(), (float)8.0f), 0);
            layoutParams.addRule(14);
            this.mRightContainer.addView((View)imageBtn, (ViewGroup.LayoutParams)layoutParams);
            this.mInfos.add(info);
            imageBtn.setOnClickListener(listener2);
            ImageLoader.loadImage((RecycleImageView)imageBtn, (String)info.img);
            return;
        }
        if (info.style.equals(RightBtnInfo.STYLE_TASK) || info.style.equals(RightBtnInfo.STYLE_TASK_DEFAULT)) {
            this.mInfos.add(info);
            CommTitleUICreator.createTaskRightView(this.getContext(), info, this.mRightContainer, listener2);
            return;
        }
        int resId = -1;
        boolean useImage = true;
        int width = 0;
        useImage = false;
        width = (int)this.getResources().getDimension(R.dimen.right_btn_long_width);
        if (resId < 0 && useImage) {
            return;
        }
        this.mInfos.add(info);
        View view = BtnCreator.create(LayoutInflater.from((Context)this.getActivity()), R.layout.layout_sharp_girl_right_btn);
        ImageView imageView = (ImageView)view.findViewById(R.id.image_btn);
        TextView textBtn = (TextView)view.findViewById(R.id.text_btn);
        if (useImage) {
            imageView.setImageResource(resId);
            imageView.setVisibility(0);
            textBtn.setVisibility(8);
            if (info.enable) {
                imageView.clearColorFilter();
            } else {
                imageView.setColorFilter(Color.parseColor((String)"#cccccc"), PorterDuff.Mode.SRC_IN);
            }
        } else {
            if (!StringUtils.isNullOrEmpty((String)info.img)) {
                final WeakReference<TextView> fTextBtn = new WeakReference<TextView>(textBtn);
                final ImageConfig imageConfig = ImageConfig.defaultImageConfig();
                BitmapDrawable drawable2 = ImageLoader.getBitmapFromCache((String)info.img, (ImageConfig)imageConfig);
                if (null != drawable2) {
                    Bitmap bitmap = YYImageUtils.resize((Bitmap)drawable2.getBitmap(), (int)drawableWidth, (int)drawableWidth);
                    if (null != bitmap) {
                        BitmapDrawable bigDrawable = new BitmapDrawable(this.getContext().getResources(), bitmap);
                        bigDrawable.setBounds(0, 0, drawableWidth, drawableWidth);
                        textBtn.setCompoundDrawables((Drawable)bigDrawable, null, null, null);
                    }
                } else {
                    final String fUrl = info.img;
                    ImageLoader.loadBitmap((Context)BasicConfig.getInstance().getAppContext(), (String)fUrl, (ImageLoader.BitmapLoadListener)new ImageLoader.BitmapLoadListener(){

                        public void onLoadFailed(Exception e) {
                            MLog.error((Object)"webview rightitem", (String)"load img error", (Object[])new Object[0]);
                        }

                        public void onResourceReady(Bitmap bitmap) {
                            if (bitmap != null) {
                                Bitmap bitmap2;
                                Context context = BasicConfig.getInstance().getAppContext();
                                ImageLoader.addBitmapToCache((String)fUrl, (BitmapDrawable)new BitmapDrawable(context.getResources(), bitmap), (ImageConfig)imageConfig);
                                TextView btn = (TextView)fTextBtn.get();
                                if (btn != null && (bitmap2 = YYImageUtils.resize((Bitmap)bitmap, (int)drawableWidth, (int)drawableWidth)) != null) {
                                    BitmapDrawable bigDrawable = new BitmapDrawable(context.getResources(), bitmap2);
                                    bigDrawable.setBounds(0, 0, drawableWidth, drawableWidth);
                                    btn.setCompoundDrawables((Drawable)bigDrawable, null, null, null);
                                }
                            }
                        }
                    });
                }
            }
            textBtn.setText((CharSequence)info.title);
            textBtn.setTextSize(15.0f);
            textBtn.setVisibility(0);
            imageView.setVisibility(8);
            if (!info.enable) {
                textBtn.setTextColor(Color.parseColor((String)"#cccccc"));
            }
        }
        TextView textView = (TextView)view.findViewById(R.id.news);
        textView.setId(info.identifier);
        if (FP.empty((CharSequence)info.badge)) {
            textView.setVisibility(4);
        } else {
            textView.setVisibility(0);
            textView.setText((CharSequence)info.badge);
        }
        if (info.selectable) {
            this.updateBtnCheckedState(view, info, false);
        }
        if (info.enable) {
            view.setEnabled(true);
        } else {
            view.setEnabled(false);
        }
        view.findViewById(R.id.right_btn_layout).setOnClickListener(listener2);
        int dimen2 = (int)this.getResources().getDimension(R.dimen.top_header_height);
        view.setTag((Object)info);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-2, dimen2);
        if (info.hidden) {
            view.setVisibility(8);
        } else {
            view.setVisibility(0);
        }
        this.mRightContainer.addView(view, (ViewGroup.LayoutParams)params);
    }

    public void updateBtnCheckedState(View view, RightBtnInfo info) {
        this.updateBtnCheckedState(view, info, true);
    }

    public void updateBtnCheckedState(View view, RightBtnInfo info, boolean changeSelected) {
        if (view == null || info == null) {
            return;
        }
        if (changeSelected) {
            info.selected = !info.selected;
        }
        int resId = -1;
        switch (info.icon) {
            case 1000: {
                if (info.selected) {
                    resId = R.drawable.tab_post_icon_pressed;
                    break;
                }
                resId = R.drawable.tab_post_icon_unpressed;
                break;
            }
            case 1001: {
                if (info.selected) {
                    resId = R.drawable.tab_msg_icon_pressed;
                    break;
                }
                resId = R.drawable.tab_msg_icon_unpressed;
                break;
            }
            case 1002: {
                if (info.selected) {
                    resId = R.drawable.sharp_girl_share_pressed;
                    break;
                }
                resId = R.drawable.sharp_girl_share_normal;
                break;
            }
            case 1003: {
                if (info.selected) {
                    resId = R.drawable.tab_only_owner_icon_pressed;
                    break;
                }
                resId = R.drawable.tab_only_owner_icon_upressed;
                break;
            }
            case 1004: {
                if (info.selected) {
                    resId = R.drawable.tab_close_icon_pressed;
                    break;
                }
                resId = R.drawable.tab_close_icon_unpressed;
                break;
            }
            case 1005: {
                if (info.selected) {
                    resId = R.drawable.tab_clear_icon_pressed;
                    break;
                }
                resId = R.drawable.tab_clear_icon_unpressed;
                break;
            }
        }
        if (resId < 0) {
            return;
        }
        view.setTag((Object)info);
        ImageView imageView = (ImageView)view.findViewById(R.id.image_btn);
        imageView.setImageResource(resId);
    }

    public int createBtnId(RightBtnInfo info) {
        return info.identifier << 2;
    }

    public void updateMsgStatus(int id2, String badge) {
        TextView view;
        if (!MLog.isLogLevelAboveVerbose()) {
            MLog.verbose((Object)TAG, (String)("xuwakao, id = " + id2 + ", badge = " + badge), (Object[])new Object[0]);
        }
        if ((view = (TextView)this.getActivity().findViewById(id2)) == null) {
            return;
        }
        if (FP.empty((CharSequence)badge)) {
            view.setVisibility(4);
            return;
        }
        view.setVisibility(0);
        view.setText((CharSequence)badge);
    }

    public void addLeftButtonWithImageUlr(String url) {
        RecycleImageView recycleImageView = this.mBack;
        ImageLoader.loadImage((String)url, (RecycleImageView)recycleImageView, (ImageConfig)ImageConfig.defaultImageConfig(), (int)0);
    }

    public void addLeftButtonWithImageRes(int imgRes) {
        if (null != this.mBack) {
            this.mBack.setImageResource(imgRes);
        }
    }

    public void addRightButtonWithImageUlr(String url, View.OnClickListener clickListener) {
        ViewGroup right = this.mRightContainer;
        right.removeAllViews();
        RecycleImageView recycleImageView = new RecycleImageView(this.getContext());
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -1);
        params.addRule(11);
        right.addView((View)recycleImageView, (ViewGroup.LayoutParams)params);
        ImageLoader.loadImage((String)url, (RecycleImageView)recycleImageView, (ImageConfig)ImageConfig.defaultImageConfig(), (int)0);
        right.setOnClickListener(clickListener);
    }

    public void setMyBackground(int color2) {
        if (this.mTextTitle == null || this.mImageTitle == null) {
            return;
        }
        this.root.setBackgroundColor(color2);
        if (this.divider != null) {
            this.divider.setBackgroundColor(color2);
        }
    }

    public static class BtnCreator {
        public static View create(LayoutInflater inflater, int resId) {
            return inflater.inflate(resId, null);
        }
    }

    private static interface RightBtnIcon {
        public static final int POST_ICON_IMAGE = 1000;
        public static final int MSG_ICON_IMAGE = 1001;
        public static final int SHARE_ICON_IMAGE = 1002;
        public static final int POSTTOOWNER_ICON_IMAGE = 1003;
        public static final int CLOSE_ICON_IMAGE = 1004;
        public static final int CLEARMESSAGE_ICON_IMAGE = 1005;
        public static final int SHARE_BLACK_ICON_IMAGE = 1006;
        public static final int POST_IDENTIFIER = 0;
        public static final int MSG_IDENTIFIER = 1;
        public static final int SHARE_IDENTIFIER = 2;
        public static final int RELEASE_IDENTIFIER = 3;
        public static final int CANCEL_IDENTIFIER = 4;
    }
}

