/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget;

import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.support.annotation.AttrRes;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.yy.mobile.smartrefresh.layout.R;
import com.yy.mobile.smartrefresh.layout.api.RefreshHeader;
import com.yy.mobile.smartrefresh.layout.api.RefreshKernel;
import com.yy.mobile.smartrefresh.layout.api.RefreshLayout;
import com.yy.mobile.smartrefresh.layout.constant.RefreshState;
import com.yy.mobile.smartrefresh.layout.constant.SpinnerStyle;
import com.yy.mobile.smartrefresh.layout.util.ColorUtils;
import com.yy.mobile.smartrefresh.layout.util.DensityUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

@SuppressLint(value={"CustomViewStyleable"})
public class BallPulseHeader
extends RelativeLayout
implements RefreshHeader {
    public static final int DEFAULT_SIZE = 50;
    protected boolean mManualNormalColor;
    protected boolean mManualAnimationColor;
    protected SpinnerStyle mSpinnerStyle;
    protected Paint mPaint;
    protected int mNormalColor = -1118482;
    protected int mAnimatingColor = -1615546;
    protected float mCircleSpacing;
    protected float[] mScaleFloats = new float[]{1.0f, 1.0f, 1.0f};
    private View resView;
    private TextView msgTextView;
    private String msgText;
    protected boolean mIsStarted = false;
    protected ArrayList<ValueAnimator> mAnimators;
    protected Map<ValueAnimator, ValueAnimator.AnimatorUpdateListener> mUpdateListeners = new HashMap<ValueAnimator, ValueAnimator.AnimatorUpdateListener>();

    public BallPulseHeader(@NonNull Context context) {
        this(context, null);
    }

    public BallPulseHeader(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BallPulseHeader(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        BallPulseHeader thisView = this;
        thisView.setVisibility(8);
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.BallPulseFooter);
        this.mPaint = new Paint();
        this.mPaint.setColor(-1);
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setAntiAlias(true);
        ta.recycle();
        this.mCircleSpacing = DensityUtil.dp2px((float)4.0f);
        this.mAnimators = new ArrayList();
        int[] delays = new int[]{120, 240, 360};
        for (int i = 0; i < 3; ++i) {
            final int index = i;
            ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{1.0f, 0.3f, 1.0f});
            animator.setDuration(750L);
            animator.setRepeatCount(-1);
            animator.setTarget((Object)i);
            animator.setStartDelay((long)delays[i]);
            this.mUpdateListeners.put(animator, new ValueAnimator.AnimatorUpdateListener((View)thisView){
                final /* synthetic */ View val$thisView;
                {
                    this.val$thisView = view;
                }

                public void onAnimationUpdate(ValueAnimator animation) {
                    BallPulseHeader.this.mScaleFloats[index] = ((Float)animation.getAnimatedValue()).floatValue();
                    this.val$thisView.postInvalidate();
                }
            });
            this.mAnimators.add(animator);
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mAnimators != null) {
            for (int i = 0; i < this.mAnimators.size(); ++i) {
                this.mAnimators.get(i).cancel();
                this.mAnimators.get(i).removeAllListeners();
                this.mAnimators.get(i).removeAllUpdateListeners();
            }
        }
    }

    public void onStateChanged(@NonNull RefreshLayout refreshLayout, @NonNull RefreshState oldState, @NonNull RefreshState newState) {
        switch (newState) {
            case Refreshing: {
                this.setVisibility(0);
                break;
            }
            case PullDownCanceled: 
            case RefreshFinish: {
                this.setVisibility(8);
            }
        }
    }

    protected void dispatchDraw(Canvas canvas) {
        BallPulseHeader thisView = this;
        int width = thisView.getWidth();
        int height = thisView.getHeight();
        float radius = ((float)Math.min(width, height) - this.mCircleSpacing * 2.0f) / 14.0f;
        float x = (float)width / 2.0f - (radius * 2.0f + this.mCircleSpacing);
        float y = (float)height / 2.0f;
        for (int i = 0; i < 3; ++i) {
            canvas.save();
            float translateX = x + radius * 2.0f * (float)i + this.mCircleSpacing * (float)i;
            canvas.translate(translateX, y);
            canvas.scale(this.mScaleFloats[i], this.mScaleFloats[i]);
            canvas.drawCircle(0.0f, 0.0f, radius, this.mPaint);
            canvas.restore();
        }
        super.dispatchDraw(canvas);
    }

    public void onStartAnimator(@NonNull RefreshLayout layout2, int height, int maxDragHeight) {
        if (this.mIsStarted) {
            return;
        }
        for (int i = 0; i < this.mAnimators.size(); ++i) {
            ValueAnimator animator = this.mAnimators.get(i);
            ValueAnimator.AnimatorUpdateListener updateListener = this.mUpdateListeners.get(animator);
            if (updateListener != null) {
                animator.addUpdateListener(updateListener);
            }
            animator.start();
        }
        this.mIsStarted = true;
        this.mPaint.setColor(this.mAnimatingColor);
    }

    public int onFinish(@NonNull RefreshLayout layout2, boolean success) {
        if (this.mAnimators != null && this.mIsStarted) {
            this.mIsStarted = false;
            this.mScaleFloats = new float[]{1.0f, 1.0f, 1.0f};
            for (ValueAnimator animator : this.mAnimators) {
                if (animator == null) continue;
                animator.removeAllUpdateListeners();
                animator.end();
            }
        }
        this.mPaint.setColor(this.mNormalColor);
        return 0;
    }

    public boolean isSupportHorizontalDrag() {
        return false;
    }

    public void setMsgText(String text) {
        this.msgText = text;
    }

    public String getMsgText() {
        return this.msgText;
    }

    @NonNull
    public View getView() {
        return this;
    }

    public SpinnerStyle getSpinnerStyle() {
        return null;
    }

    @Deprecated
    public void setPrimaryColors(int ... colors) {
        if (!this.mManualAnimationColor && colors.length > 1) {
            this.setAnimatingColor(colors[0]);
            this.mManualAnimationColor = false;
        }
        if (!this.mManualNormalColor) {
            if (colors.length > 1) {
                this.setNormalColor(colors[1]);
            } else if (colors.length > 0) {
                this.setNormalColor(ColorUtils.compositeColors((int)-1711276033, (int)colors[0]));
            }
            this.mManualNormalColor = false;
        }
    }

    public void onInitialized(RefreshKernel kernel, int height, int extendHeight) {
    }

    public void onHorizontalDrag(float percentX, int offsetX, int offsetMax) {
    }

    public BallPulseHeader setSpinnerStyle(SpinnerStyle mSpinnerStyle) {
        this.mSpinnerStyle = mSpinnerStyle;
        return this;
    }

    public BallPulseHeader setNormalColor(@ColorInt int color2) {
        this.mNormalColor = color2;
        this.mManualNormalColor = true;
        if (!this.mIsStarted) {
            this.mPaint.setColor(color2);
        }
        return this;
    }

    public BallPulseHeader setAnimatingColor(@ColorInt int color2) {
        this.mAnimatingColor = color2;
        this.mManualAnimationColor = true;
        if (this.mIsStarted) {
            this.mPaint.setColor(color2);
        }
        return this;
    }

    public void onPullingDown(float percent, int offset, int headerHeight, int extendHeight) {
    }

    public void onReleasing(float percent, int offset, int headerHeight, int extendHeight) {
    }
}

