/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.channelpk.ui.module.PKBarModule;

import android.graphics.Bitmap;
import android.graphics.drawable.AnimationDrawable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.FragmentActivity;
import android.view.View;
import android.widget.ImageView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.request.target.SimpleTarget;
import com.bumptech.glide.request.target.Target;
import com.bumptech.glide.request.transition.Transition;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.mobile.channelpk.coremodule.core.IChannelPKCore;
import com.yy.mobile.channelpk.coremodule.event.ChannelPK_OnModelChange_Rank_EventArgs;
import com.yy.mobile.channelpk.coremodule.model.ChannelPkNotifyInfo;
import com.yy.mobile.channelpk.ui.PKConstants;
import com.yy.mobile.channelpk.ui.module.PKBarModule.PKBarModule$$EventBinder;
import com.yy.mobile.channelpk.ui.module.base.LayoutModule;
import com.yy.mobile.channelpk.ui.view.PkBarView;
import com.yy.mobile.plugin.pluginunionchannelpk.R;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.CoreFactory;

public class PKBarModule
extends LayoutModule {
    public PkBarView mPkBarView;
    public boolean hasDownloadLeftBitmap = false;
    public boolean hasDownloadRightBitmap = false;
    private boolean isInitialized = false;
    private int lEffect = 0;
    private int rEffect = 0;
    protected ChannelPkNotifyInfo pkInfo;
    private EventBinder mPKBarModuleSniperEventBinder;

    @Override
    public int onViewAttach() {
        return R.id.module_pk_bar;
    }

    @Override
    public int onGetLayoutResId() {
        return R.layout.module_pk_bar;
    }

    @Override
    public void onViewCreated(View view) {
        super.onViewCreated(view);
        this.mPkBarView = (PkBarView)view.findViewById(R.id.view_pk_bar);
    }

    @Override
    public void onOrientationChanged(boolean isLandscape) {
        super.onOrientationChanged(isLandscape);
    }

    @Override
    public void onPkStart() {
        if (this.mPkBarView == null) {
            return;
        }
        this.mPkBarView.clear();
        this.mPkBarView.showReadySpace();
        this.pkInfo = ((IChannelPKCore)CoreFactory.getCore(IChannelPKCore.class)).getChannelPkInfo();
        this.isInitialized = false;
        this.hasDownloadRightBitmap = false;
        this.hasDownloadLeftBitmap = false;
    }

    @Override
    public void onPkGoing() {
        if (this.mPkBarView == null) {
            return;
        }
        this.mPkBarView.hideReadySpace();
        this.updatePkData();
        this.handleProgressView();
        this.updatePkView();
        this.isInitialized = true;
    }

    @Override
    public void onPkEnd() {
        if (this.mPkBarView == null) {
            return;
        }
        this.mPkBarView.hideReadySpace();
        this.updatePkData();
        this.mPkBarView.setNeedShowProgress(false);
        this.updatePkView();
        this.isInitialized = true;
    }

    @BusEvent
    public void onModelChange(ChannelPK_OnModelChange_Rank_EventArgs eventArgs) {
        MLog.info((Object)"PKBarModule", (String)("onModelChange rank isOpen:" + eventArgs.isOpen()), (Object[])new Object[0]);
        if (eventArgs.isOpen()) {
            this.mPkBarView.getBarRootView().setPadding(PKConstants.PADDING.SIZE_30, 0, PKConstants.PADDING.SIZE_30, 0);
        } else {
            this.mPkBarView.getBarRootView().setPadding(0, 0, 0, 0);
        }
    }

    private void updatePkData() {
        this.pkInfo = ((IChannelPKCore)CoreFactory.getCore(IChannelPKCore.class)).getChannelPkInfo();
        if (this.pkInfo == null) {
            MLog.error((Object)"PKBarModule", (String)"getChannelPkInfo is null!", (Object[])new Object[0]);
            return;
        }
        if (!this.isInitialized) {
            String blueBarUrl = this.pkInfo.lMobCoolPKUrl;
            String originBarUrl = this.pkInfo.rMobCoolPKUrl;
            if (!FP.empty((CharSequence)blueBarUrl) && !this.hasDownloadLeftBitmap) {
                Glide.with((FragmentActivity)((FragmentActivity)this.mContext.get())).asBitmap().load(blueBarUrl).into((Target)new SimpleTarget<Bitmap>(){

                    public void onResourceReady(@NonNull Bitmap bitmap, @Nullable Transition<? super Bitmap> transition) {
                        PKBarModule.this.mPkBarView.setLeftBitmap(bitmap);
                        PKBarModule.this.hasDownloadLeftBitmap = true;
                    }
                });
            }
            if (!FP.empty((CharSequence)originBarUrl) && !this.hasDownloadRightBitmap) {
                Glide.with((FragmentActivity)((FragmentActivity)this.mContext.get())).asBitmap().load(originBarUrl).into((Target)new SimpleTarget<Bitmap>(){

                    public void onResourceReady(@NonNull Bitmap bitmap, @Nullable Transition<? super Bitmap> transition) {
                        PKBarModule.this.mPkBarView.setRightBitmap(bitmap);
                        PKBarModule.this.hasDownloadRightBitmap = true;
                    }
                });
            }
        }
        this.setPkData(this.pkInfo.lnum, this.pkInfo.rnum);
    }

    protected void setPkData(int leftNum, int rightNum) {
        this.mPkBarView.setPkData(leftNum, rightNum, "\u6211\u65b9" + leftNum, rightNum + "\u5bf9\u65b9");
    }

    private void handleProgressView() {
        if (!this.isInitialized) {
            this.lEffect = ((IChannelPKCore)CoreFactory.getCore(IChannelPKCore.class)).getChannelPkInfo().lEffect;
            this.rEffect = ((IChannelPKCore)CoreFactory.getCore(IChannelPKCore.class)).getChannelPkInfo().rEffect;
        }
        boolean isNeedProgress = this.rEffect != 0 || this.lEffect != 0;
        this.mPkBarView.setNeedShowProgress(isNeedProgress);
        if (!isNeedProgress) {
            return;
        }
        int leftDrawableRes = 0;
        if (this.lEffect == 1) {
            leftDrawableRes = R.drawable.anim_pk_bar_right_rocket;
        } else if (this.lEffect == 2) {
            leftDrawableRes = R.drawable.anim_pk_bar_right_dragon;
        }
        int rightDrawableRes = 0;
        if (this.rEffect == 1) {
            rightDrawableRes = R.drawable.anim_pk_bar_left_rocket;
        } else if (this.rEffect == 2) {
            rightDrawableRes = R.drawable.anim_pk_bar_left_dragon;
        }
        Object drawable2 = this.mPkBarView.getRatio() > this.mPkBarView.getOldRatio() ? (leftDrawableRes == 0 ? null : this.getResources().getDrawable(leftDrawableRes)) : (this.mPkBarView.getRatio() < this.mPkBarView.getOldRatio() ? (rightDrawableRes == 0 ? null : this.getResources().getDrawable(rightDrawableRes)) : null);
        ImageView mImgProgress = this.mPkBarView.getProgressImageView();
        mImgProgress.setImageDrawable(drawable2);
        AnimationDrawable animationDrawable = (AnimationDrawable)mImgProgress.getDrawable();
        if (animationDrawable != null) {
            animationDrawable.start();
        }
    }

    private void updatePkView() {
        this.mPkBarView.updatePkView();
    }

    @Override
    public void onDestroy() {
        if (this.mPkBarView != null) {
            this.mPkBarView.clear();
        }
        this.hasDownloadLeftBitmap = false;
        this.hasDownloadRightBitmap = false;
        this.isInitialized = false;
        this.lEffect = 0;
        this.rEffect = 0;
        super.onDestroy();
    }

    @Override
    public void onEventBind() {
        super.onEventBind();
        if (this.mPKBarModuleSniperEventBinder == null) {
            this.mPKBarModuleSniperEventBinder = new PKBarModule$$EventBinder();
        }
        this.mPKBarModuleSniperEventBinder.bindEvent((Object)this);
    }

    @Override
    public void onEventUnBind() {
        super.onEventUnBind();
        if (this.mPKBarModuleSniperEventBinder != null) {
            this.mPKBarModuleSniperEventBinder.unBindEvent();
        }
    }
}

