/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.channelpk.ui.pknor.ui.circleProgressView;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.animation.LinearInterpolator;
import com.yy.mobile.util.log.MLog;

public class PKCoolingLayer
extends View {
    Context mContex;
    Paint mCirclePaint;
    int mWidth;
    int mHeight;
    RectF mCircleRectF;
    float circleRadius = 0.0f;
    float mAngle = 0.0f;
    boolean isRuning;
    OnCountDownFinishedListener onCountDownFinishedListener;

    public void setOnCountDownFinishedListener(OnCountDownFinishedListener onCountDownFinishedListener) {
        this.onCountDownFinishedListener = onCountDownFinishedListener;
    }

    public PKCoolingLayer(Context context) {
        super(context);
        this.initView(context);
    }

    public PKCoolingLayer(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.initView(context);
    }

    private void initView(Context context) {
        this.mContex = context;
        this.mCirclePaint = new Paint();
        this.mCirclePaint.setAntiAlias(true);
        this.mCirclePaint.setStyle(Paint.Style.FILL);
        this.mCirclePaint.setColor(-872415232);
        this.mCirclePaint.setAlpha(150);
    }

    public int dp2px(Context context, float dpVal) {
        return (int)TypedValue.applyDimension((int)1, (float)dpVal, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    public void startCountDown(int countDown) {
        ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{360.0f, 0.0f});
        animator.setDuration((long)countDown);
        animator.setInterpolator((TimeInterpolator)new LinearInterpolator());
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                float value;
                PKCoolingLayer.this.mAngle = value = ((Float)animation.getAnimatedValue()).floatValue();
                PKCoolingLayer.this.postInvalidate();
            }
        });
        animator.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
                MLog.info((Object)"cyy", (String)"onAnimationStart", (Object[])new Object[0]);
                PKCoolingLayer.this.isRuning = true;
            }

            public void onAnimationEnd(Animator animation) {
                MLog.info((Object)"cyy", (String)"onAnimationEnd", (Object[])new Object[0]);
                PKCoolingLayer.this.isRuning = false;
                if (PKCoolingLayer.this.onCountDownFinishedListener != null) {
                    PKCoolingLayer.this.onCountDownFinishedListener.onCountDownFinished();
                }
            }

            public void onAnimationCancel(Animator animation) {
                MLog.info((Object)"cyy", (String)"onAnimationCancel", (Object[])new Object[0]);
                PKCoolingLayer.this.isRuning = false;
            }

            public void onAnimationRepeat(Animator animation) {
                MLog.info((Object)"cyy", (String)"onAnimationRepeat", (Object[])new Object[0]);
                PKCoolingLayer.this.isRuning = true;
            }
        });
        animator.start();
    }

    public boolean isFrozen() {
        return this.isRuning;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.mWidth = this.getMeasuredWidth();
        this.mHeight = this.getMeasuredHeight();
    }

    protected void onDraw(Canvas canvas) {
        float halfWidth = this.mWidth / 2;
        float halfHeight = this.mHeight / 2;
        this.circleRadius = halfWidth - (float)this.dp2px(this.mContex, 10.0f);
        if (null == this.mCircleRectF) {
            this.mCircleRectF = new RectF(halfWidth - this.circleRadius, halfHeight - this.circleRadius, halfWidth + this.circleRadius, halfHeight + this.circleRadius);
        }
        canvas.drawArc(this.mCircleRectF, -90.0f + (360.0f - this.mAngle), this.mAngle, true, this.mCirclePaint);
    }

    public static interface OnCountDownFinishedListener {
        public void onCountDownFinished();
    }
}

