/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.channelpk.ui.pknor.ui;

import android.app.Dialog;
import android.content.DialogInterface;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentTransaction;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.webkit.WebView;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.yy.android.sniper.api.event.EventCompat;
import com.yy.mobile.channelpk.utils.RxViewUtlis;
import com.yy.mobile.liveapi.help.WebViewEventListener;
import com.yy.mobile.plugin.pluginunionchannelpk.R;
import com.yy.mobile.ui.BaseLinkFragment;
import com.yy.mobile.ui.basicchanneltemplate.component.PopupComponent;
import com.yy.mobile.util.DeepColorUtils;
import com.yy.mobile.ylink.bridge.CoreApiManager;
import com.yy.mobile.ylink.bridge.coreapi.IWebViewEventListener;
import com.yy.mobile.ylink.bridge.coreapi.WebViewFragmentApi;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.functions.Consumer;

public class WebPopComponent
extends PopupComponent
implements EventCompat {
    private String title;
    private String url;
    private int width;
    private int height;
    private int gravity;
    private int layoutId;
    private boolean backgroundGray = false;
    private boolean isEnableCloseOutside = true;
    private boolean isTransparent = false;
    private boolean isBlackTitleBg = false;
    private IWebViewEventListener webViewEventListener;
    public BaseLinkFragment mFragment;
    private View rootView;
    private RelativeLayout webContent;
    private RelativeLayout webComponent;
    private ImageView backView;
    private ImageView refreshView;
    private ImageView helpView;
    private TextView titleView;
    private CompositeDisposable mCompositeDisposable;
    OnBackClickListener onBackClickListener;
    OnRefreshClickListener onRefreshClickListener;
    OnHelpClickListener onHelpClickListener;

    public WebPopComponent setBlackTitleBg(boolean isBlackTitleBg) {
        this.isBlackTitleBg = isBlackTitleBg;
        return this;
    }

    public WebPopComponent setTitle(String title) {
        this.title = title;
        return this;
    }

    public WebPopComponent setUrl(String url) {
        this.url = url;
        return this;
    }

    public WebPopComponent setWidth(int width) {
        this.width = width;
        return this;
    }

    public WebPopComponent setHeight(int height) {
        this.height = height;
        return this;
    }

    public WebPopComponent setGravity(int gravity) {
        this.gravity = gravity;
        return this;
    }

    public WebPopComponent setBackground(boolean isGray) {
        this.backgroundGray = isGray;
        return this;
    }

    public WebPopComponent setCanceledOnTouchOutside(boolean enabled) {
        this.isEnableCloseOutside = enabled;
        return this;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setStyle(0, 16973833);
        this.mCompositeDisposable = new CompositeDisposable();
        if (savedInstanceState != null) {
            this.title = savedInstanceState.getString("BUNDLE_TITLE");
            this.url = savedInstanceState.getString("BUNDLE_URL");
            this.width = savedInstanceState.getInt("BUNDLE_WIDTH");
            this.height = savedInstanceState.getInt("BUNDLE_HEIGHT");
            this.gravity = savedInstanceState.getInt("BUNDLE_GRAVITY");
            this.layoutId = savedInstanceState.getInt("BUNDLE_LAYOUTID");
            this.backgroundGray = savedInstanceState.getBoolean("BUNDLE_BACKGROUNDGRAY", false);
            this.isEnableCloseOutside = savedInstanceState.getBoolean("BUNDLE_ISENABLECLOSEOUTSIDE", true);
            this.isTransparent = savedInstanceState.getBoolean("BUNDLE_ISTRANSPARENT", false);
            this.isBlackTitleBg = savedInstanceState.getBoolean("BUNDLE_ISBLACKTITLEBG", false);
        }
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        Bundle bundle = new Bundle();
        bundle.putString("BUNDLE_TITLE", this.title);
        bundle.putString("BUNDLE_URL", this.url);
        bundle.putInt("BUNDLE_WIDTH", this.width);
        bundle.putInt("BUNDLE_HEIGHT", this.height);
        bundle.putInt("BUNDLE_GRAVITY", this.gravity);
        bundle.putInt("BUNDLE_LAYOUTID", this.layoutId);
        bundle.putBoolean("BUNDLE_BACKGROUNDGRAY", this.backgroundGray);
        bundle.putBoolean("BUNDLE_ISENABLECLOSEOUTSIDE", this.isEnableCloseOutside);
        bundle.putBoolean("BUNDLE_ISTRANSPARENT", this.isTransparent);
        bundle.putBoolean("BUNDLE_ISBLACKTITLEBG", this.isBlackTitleBg);
        outState.putAll(bundle);
    }

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        Dialog dialog = super.onCreateDialog(savedInstanceState);
        dialog.setCanceledOnTouchOutside(true);
        dialog.requestWindowFeature(1);
        dialog.getWindow().setWindowAnimations(R.style.DialogAnimation);
        dialog.getWindow().setBackgroundDrawableResource(17170445);
        dialog.getWindow().setGravity(this.gravity != 0 ? this.gravity : 81);
        dialog.setCanceledOnTouchOutside(this.isEnableCloseOutside);
        if (this.width == 0) {
            this.width = -1;
        }
        if (this.height == 0) {
            this.height = -1;
        }
        dialog.getWindow().setLayout(this.width, this.height);
        if (this.backgroundGray) {
            WindowManager.LayoutParams lp = dialog.getWindow().getAttributes();
            lp.dimAmount = 0.5f;
            dialog.getWindow().setAttributes(lp);
            dialog.getWindow().addFlags(2);
        }
        dialog.setOnKeyListener(new DialogInterface.OnKeyListener(){

            public boolean onKey(DialogInterface dialog, int keyCode, KeyEvent event) {
                if (keyCode == 4 && event.getAction() == 0) {
                    WebView webView = ((WebViewFragmentApi)CoreApiManager.getInstance().getApi(WebViewFragmentApi.class)).getWebView(WebPopComponent.this.mFragment);
                    if (webView != null && webView.canGoBack()) {
                        webView.goBack();
                        return true;
                    }
                    if (WebPopComponent.this.onBackClickListener != null) {
                        WebPopComponent.this.onBackClickListener.onBackClick();
                        WebPopComponent.this.dismissAllowingStateLoss();
                        return true;
                    }
                }
                return false;
            }
        });
        return dialog;
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.rootView = inflater.inflate(R.layout.view_web_popup_component, container, false);
        DeepColorUtils.setNightMode((View)this.rootView, (int)0);
        this.backView = (ImageView)this.rootView.findViewById(R.id.back);
        this.refreshView = (ImageView)this.rootView.findViewById(R.id.refresh);
        this.helpView = (ImageView)this.rootView.findViewById(R.id.help);
        this.titleView = (TextView)this.rootView.findViewById(R.id.title);
        this.webContent = (RelativeLayout)this.rootView.findViewById(R.id.web_content);
        this.webComponent = (RelativeLayout)this.rootView.findViewById(R.id.web_component);
        if (this.isTransparent) {
            this.webContent.setBackgroundColor(this.getResources().getColor(17170445));
        }
        if (this.isBlackTitleBg) {
            this.titleView.setTextColor(-1);
            this.backView.setImageResource(R.drawable.icon_nav_white);
            this.webComponent.setBackgroundColor(-16777216);
            this.webContent.setBackgroundColor(-16777216);
        } else {
            this.titleView.setTextColor(-16777216);
            this.backView.setImageResource(R.drawable.icon_nav_back);
            this.webComponent.setBackgroundColor(-1);
            this.webContent.setBackgroundColor(-1);
        }
        this.mFragment = this.getOrCreatWebViewFragment(this.url);
        FragmentTransaction ft = this.getContent().getChildFragmentManager().beginTransaction();
        if (this.mFragment.isDetached()) {
            ft.attach((Fragment)this.mFragment);
            ft.commitAllowingStateLoss();
        } else if (!this.mFragment.isAdded()) {
            ft.add(R.id.web_content, (Fragment)this.mFragment);
            ft.commitAllowingStateLoss();
        }
        this.titleView.setText((CharSequence)this.title);
        this.initBackListener();
        this.initRefreshListener();
        this.initHelpListener();
        return this.rootView;
    }

    public void onDestroy() {
        super.onDestroy();
        this.mCompositeDisposable.clear();
    }

    private void initBackListener() {
        if (this.onBackClickListener != null) {
            this.backView.setVisibility(0);
            this.backView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (WebPopComponent.this.onBackClickListener != null) {
                        WebPopComponent.this.onBackClickListener.onBackClick();
                        WebPopComponent.this.dismissAllowingStateLoss();
                    }
                }
            });
        }
    }

    private void initRefreshListener() {
        if (this.onRefreshClickListener != null) {
            this.refreshView.setVisibility(0);
            this.mCompositeDisposable.add(RxViewUtlis.clicks((View)this.refreshView, 500L).subscribe((Consumer)new Consumer<Object>(){

                public void accept(Object view) throws Exception {
                    if (WebPopComponent.this.onRefreshClickListener != null) {
                        WebPopComponent.this.onRefreshClickListener.onRefreshClick();
                        WebPopComponent.this.getWebView().reload();
                    }
                }
            }));
        }
    }

    private void initHelpListener() {
        if (this.onHelpClickListener != null) {
            this.helpView.setVisibility(0);
            this.helpView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (WebPopComponent.this.onHelpClickListener != null) {
                        WebPopComponent.this.onHelpClickListener.onHelpClick();
                    }
                }
            });
        }
    }

    public BaseLinkFragment getOrCreatWebViewFragment(String url) {
        if (this.webViewEventListener == null) {
            this.webViewEventListener = new WebViewEventListener();
        }
        BaseLinkFragment wvFragment = ((WebViewFragmentApi)CoreApiManager.getInstance().getApi(WebViewFragmentApi.class)).createWebViewFragment(url, true, this.webViewEventListener, false);
        return wvFragment;
    }

    public WebView getWebView() {
        if (this.mFragment != null) {
            return ((WebViewFragmentApi)CoreApiManager.getInstance().getApi(WebViewFragmentApi.class)).getWebView(this.mFragment);
        }
        return null;
    }

    public WebPopComponent setOnRefreshClickListener(OnRefreshClickListener onRefreshClickListener) {
        this.onRefreshClickListener = onRefreshClickListener;
        return this;
    }

    public WebPopComponent setOnBackClickListener(OnBackClickListener rootViewFinish) {
        this.onBackClickListener = rootViewFinish;
        return this;
    }

    public WebPopComponent setOnHelpClickListener(OnHelpClickListener onHelpClickListener) {
        this.onHelpClickListener = onHelpClickListener;
        return this;
    }

    public static interface OnHelpClickListener {
        public void onHelpClick();
    }

    public static interface OnRefreshClickListener {
        public void onRefreshClick();
    }

    public static interface OnBackClickListener {
        public void onBackClick();
    }
}

