/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.channelpk.ui.pknor.adapter;

import android.content.Context;
import android.support.v4.app.FragmentActivity;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.bumptech.glide.Glide;
import com.yy.mobile.channelpk.coremodule.M_One;
import com.yy.mobile.channelpk.coremodule.M_Two;
import com.yy.mobile.channelpk.coremodule.model.InviteFriendInfo;
import com.yy.mobile.channelpk.presenter.PkDilogPresenter;
import com.yy.mobile.channelpk.ui.pkrank.ui.RankLevelWithBgView;
import com.yy.mobile.image.CircleCompatImageView;
import com.yy.mobile.memoryrecycle.drawablerecycle.DrawableUtil;
import com.yy.mobile.plugin.pluginunionchannelpk.R;
import com.yy.mobile.util.FP;

public class InviteListAdapter
extends RecyclerView.Adapter<ViewHolder>
implements View.OnClickListener {
    private OnRecyclerViewItemClickListener mOnItemClickListener = null;
    private PkDilogPresenter presenter;
    private Context mContext;

    public InviteListAdapter(PkDilogPresenter presenter, FragmentActivity fragmentActivity) {
        this.presenter = presenter;
        this.mContext = fragmentActivity;
    }

    public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View view = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.layout_pk_nor_friend_item, parent, false);
        view.findViewById(R.id.bt_invite).setOnClickListener((View.OnClickListener)this);
        ViewHolder vh = new ViewHolder(view);
        return vh;
    }

    public void onBindViewHolder(ViewHolder holder, int position) {
        InviteFriendInfo info = this.presenter.getInviteList().get(position);
        if (!FP.empty((CharSequence)info.pic) && this.mContext != null) {
            Glide.with((Context)this.mContext).load(info.pic).into((ImageView)holder.mPic);
        } else {
            holder.mPic.setImageDrawable(DrawableUtil.getDrawable((int)R.drawable.default_portrait));
        }
        TextView tvInvite = holder.btInvite;
        tvInvite.setTag((Object)position);
        if (info.status == 1) {
            tvInvite.setEnabled(false);
            tvInvite.setText((CharSequence)"\u4e92\u52a8\u4e2d");
            tvInvite.setTextColor(0x4DFFFFFF);
        } else if (info.status == 2) {
            tvInvite.setEnabled(false);
            tvInvite.setText((CharSequence)"\u672a\u5f00\u64ad");
            tvInvite.setTextColor(0x4DFFFFFF);
        } else if (info.status == 3) {
            tvInvite.setEnabled(false);
            tvInvite.setText((CharSequence)"\u5df2\u5c4f\u853d");
            tvInvite.setTextColor(0x4DFFFFFF);
        } else {
            tvInvite.setEnabled(true);
            tvInvite.setText((CharSequence)"\u9080\u8bf7");
            tvInvite.setTextColor(-16777216);
        }
        if (info.name.length() > 10) {
            holder.mTextView.setText((CharSequence)(info.name.substring(0, 11) + "..."));
        } else {
            holder.mTextView.setText((CharSequence)info.name);
        }
        holder.tvNumber.setText((CharSequence)(position + 1 + ""));
        int division = info.division;
        int phase = info.phase;
        int starNum = info.starNum;
        if (info.specialStyle == 1) {
            holder.rankLevelWithBgView.setRevengeLevelData(division, phase, starNum);
        } else if (M_One.isRankForDialog() || M_Two.isRankForDialog()) {
            holder.rankLevelWithBgView.setRankLevelData(division, phase, starNum);
        } else {
            holder.rankLevelWithBgView.setVisibility(8);
        }
    }

    public int getItemCount() {
        return this.presenter.getInviteList().size();
    }

    public void onClick(View v) {
        if (v.getId() == R.id.bt_invite && this.mOnItemClickListener != null) {
            int index = (Integer)v.getTag();
            this.presenter.setCurrntInfo(index);
            this.mOnItemClickListener.onItemClick(v);
        }
    }

    public void setOnItemClickListener(OnRecyclerViewItemClickListener listener) {
        this.mOnItemClickListener = listener;
    }

    public static interface OnRecyclerViewItemClickListener {
        public void onItemClick(View var1);
    }

    public static class ViewHolder
    extends RecyclerView.ViewHolder {
        public TextView mTextView;
        public CircleCompatImageView mPic;
        public TextView btInvite;
        public TextView tvNumber;
        public RankLevelWithBgView rankLevelWithBgView;

        public ViewHolder(View view) {
            super(view);
            this.mTextView = (TextView)view.findViewById(R.id.text);
            this.mPic = (CircleCompatImageView)view.findViewById(R.id.pic);
            this.btInvite = (TextView)view.findViewById(R.id.bt_invite);
            this.tvNumber = (TextView)view.findViewById(R.id.tv_number);
            this.rankLevelWithBgView = (RankLevelWithBgView)view.findViewById(R.id.rank_level_view);
        }
    }
}

