/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.channelpk.ui.pkmvp.ui.seat;

import android.animation.ObjectAnimator;
import android.content.Context;
import android.graphics.Rect;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.yy.mobile.channelpk.coremodule.core.IChannelPKCore;
import com.yy.mobile.channelpk.coremodule.model.ChannelPkNotifyInfo;
import com.yy.mobile.channelpk.coremodule.model.pkmvp.PkMvpSeatRankItem;
import com.yy.mobile.channelpk.ui.pkmvp.ui.seat.PkMvpSeatAdapter;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.plugin.pluginunionchannelpk.R;
import com.yy.mobile.util.ResolutionUtils;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.ICoreManagerBase;
import java.util.Collections;
import java.util.List;

public class PkMvpSeatView
extends RelativeLayout {
    private RecyclerView rvOurSeat;
    private RecyclerView rvTheirSeat;
    private PkMvpSeatAdapter adapterOur;
    private PkMvpSeatAdapter adapterTheir;
    private View viewAceLeft;
    private View viewAceRight;
    boolean isAcePlayed = false;
    private static int MAX_SIZE_SEAT = 4;
    private RelativeLayout pkMvpSeatBg;
    OnSeatItemClickListener mOnSeatItemClickListener;

    public PkMvpSeatView(Context context) {
        super(context);
        this.initView(context);
    }

    public PkMvpSeatView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(context);
    }

    private void initView(Context context) {
        LayoutInflater.from((Context)context).inflate(R.layout.layout_pk_mvp_seatview_ex, (ViewGroup)this, true);
        this.pkMvpSeatBg = (RelativeLayout)this.findViewById(R.id.pk_mvp_seat_bg);
        this.viewAceLeft = this.findViewById(R.id.icon_ace_left);
        this.viewAceRight = this.findViewById(R.id.icon_ace_right);
        this.rvOurSeat = (RecyclerView)this.findViewById(R.id.rv_seat_us);
        this.rvTheirSeat = (RecyclerView)this.findViewById(R.id.rv_seat_them);
        LinearLayoutManager linearLayoutManagerLeft = new LinearLayoutManager(context);
        linearLayoutManagerLeft.setOrientation(0);
        LinearLayoutManager linearLayoutManagerRight = new LinearLayoutManager(context);
        linearLayoutManagerRight.setOrientation(0);
        this.rvOurSeat.setLayoutManager((RecyclerView.LayoutManager)linearLayoutManagerLeft);
        this.rvTheirSeat.setLayoutManager((RecyclerView.LayoutManager)linearLayoutManagerRight);
        this.adapterOur = new PkMvpSeatAdapter();
        this.adapterTheir = new PkMvpSeatAdapter();
        this.adapterOur.setItemClickListener(new PkMvpSeatAdapter.OnItemClickListener(){

            @Override
            public void onItemClick(int position) {
                if (PkMvpSeatView.this.mOnSeatItemClickListener != null) {
                    PkMvpSeatView.this.mOnSeatItemClickListener.onSeatItemClick(true);
                }
            }
        });
        this.adapterTheir.setItemClickListener(new PkMvpSeatAdapter.OnItemClickListener(){

            @Override
            public void onItemClick(int position) {
                if (PkMvpSeatView.this.mOnSeatItemClickListener != null) {
                    PkMvpSeatView.this.mOnSeatItemClickListener.onSeatItemClick(false);
                }
            }
        });
        int spacingInPixels = (int)ResolutionUtils.convertDpToPixel((float)10.0f, (Context)BasicConfig.getInstance().getAppContext());
        this.rvOurSeat.addItemDecoration((RecyclerView.ItemDecoration)new SpaceItemDecoration(spacingInPixels));
        this.rvTheirSeat.addItemDecoration((RecyclerView.ItemDecoration)new SpaceItemDecoration(spacingInPixels));
        this.rvOurSeat.setAdapter((RecyclerView.Adapter)this.adapterOur);
        this.rvTheirSeat.setAdapter((RecyclerView.Adapter)this.adapterTheir);
        this.setData();
        int ace = ((IChannelPKCore)ICoreManagerBase.getCore(IChannelPKCore.class)).getChannelPkInfo().ace;
        if (ace > 0) {
            if (ace == 1) {
                this.playAce(true);
            } else if (ace == 2) {
                this.playAce(false);
            }
        }
    }

    public void setBgVisible(int visible) {
        this.pkMvpSeatBg.setVisibility(visible);
    }

    public void setData() {
        List ourTeamList = ((IChannelPKCore)ICoreManagerBase.getCore(IChannelPKCore.class)).getChannelPkInfo().leftList;
        List theirTeamList = ((IChannelPKCore)ICoreManagerBase.getCore(IChannelPKCore.class)).getChannelPkInfo().rightList;
        boolean isLeftFalse = ourTeamList.size() > 0 ? ((PkMvpSeatRankItem)ourTeamList.get(0)).isFailed() : this.getIsLeftFailed();
        this.checkCount(ourTeamList, true, isLeftFalse);
        Collections.reverse(ourTeamList);
        boolean isRightFalse = theirTeamList.size() > 0 ? ((PkMvpSeatRankItem)theirTeamList.get(0)).isFailed() : this.getIsRightFailed();
        this.checkCount(theirTeamList, false, isRightFalse);
        this.adapterOur.setItems(ourTeamList);
        this.adapterTheir.setItems(theirTeamList);
    }

    public void reset() {
        this.isAcePlayed = false;
        this.viewAceLeft.setVisibility(4);
        this.viewAceRight.setVisibility(4);
        this.setData();
    }

    private void checkCount(List<PkMvpSeatRankItem> items, boolean isOurTeam, boolean isFailed) {
        if (items.size() < MAX_SIZE_SEAT) {
            for (int i = 0; i < MAX_SIZE_SEAT; ++i) {
                if (i < items.size()) continue;
                PkMvpSeatRankItem item = new PkMvpSeatRankItem();
                item.isOurTeam = isOurTeam;
                item.rank = i + 1;
                item.isFailse = isFailed;
                item.isMvp = false;
                item.isFirstRank = false;
                item.isMySelf = false;
                items.add(item);
            }
        }
    }

    public void playAce(boolean isLeftFailed) {
        if (!this.isAcePlayed) {
            MLog.info((Object)"PkMvpSeatViewEx", (String)("playAce\uff1a" + isLeftFailed), (Object[])new Object[0]);
            this.isAcePlayed = true;
            if (isLeftFailed) {
                this.viewAceLeft.setVisibility(0);
                ObjectAnimator animator = ObjectAnimator.ofFloat((Object)this.viewAceLeft, (String)"translationX", (float[])new float[]{-((int)ResolutionUtils.convertDpToPixel((float)80.0f, (Context)BasicConfig.getInstance().getAppContext())), 0.0f});
                animator.setDuration(1000L);
                animator.start();
            } else {
                this.viewAceRight.setVisibility(0);
                ObjectAnimator animator = ObjectAnimator.ofFloat((Object)this.viewAceRight, (String)"translationX", (float[])new float[]{(int)ResolutionUtils.convertDpToPixel((float)80.0f, (Context)BasicConfig.getInstance().getAppContext()), 0.0f});
                animator.setDuration(1000L);
                animator.start();
            }
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
    }

    private boolean getIsLeftFailed() {
        ChannelPkNotifyInfo info = ((IChannelPKCore)ICoreManagerBase.getCore(IChannelPKCore.class)).getChannelPkInfo();
        return StringUtils.isEmpty((String)info.pkWin) == false && info.pkWin.equals("2");
    }

    private boolean getIsRightFailed() {
        ChannelPkNotifyInfo info = ((IChannelPKCore)ICoreManagerBase.getCore(IChannelPKCore.class)).getChannelPkInfo();
        return StringUtils.isEmpty((String)info.pkWin) == false && info.pkWin.equals("1");
    }

    public void setOnSeatItemClickListener(OnSeatItemClickListener onSeatItemClickListener) {
        this.mOnSeatItemClickListener = onSeatItemClickListener;
    }

    public static interface OnSeatItemClickListener {
        public void onSeatItemClick(boolean var1);
    }

    public class SpaceItemDecoration
    extends RecyclerView.ItemDecoration {
        private int space;

        public SpaceItemDecoration(int space) {
            this.space = space;
        }

        public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
            outRect.left = parent.getChildAdapterPosition(view) == 0 ? 0 : this.space;
        }
    }
}

