/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.channelpk.ui;

import android.support.v4.app.FragmentActivity;
import android.view.View;
import com.yy.mobile.channelpk.coremodule.M_One;
import com.yy.mobile.channelpk.coremodule.M_Two;
import com.yy.mobile.channelpk.ui.PKModule;
import com.yy.mobile.channelpk.ui.pkproxy.BasePKModuleManager;
import com.yy.mobile.util.log.MLog;
import java.util.ArrayList;
import pluginunionchannelpk.ModuleFactory;

public class PkModuleManager
extends BasePKModuleManager {
    private FragmentActivity activity;
    private View container;

    public PkModuleManager() {
        ArrayList<String> mountList = new ArrayList<String>();
        ArrayList<String> unmountList = new ArrayList<String>();
        if (M_One.isNew()) {
            MLog.info((Object)"[channelpk_main] PkModuleManager ", (String)"new mode", (Object[])new Object[0]);
            mountList.addAll(ModuleFactory.INSTANCE.addNewModule());
            unmountList.addAll(ModuleFactory.INSTANCE.removeNewModule());
            this.getCurrentModel().add("2");
        } else {
            MLog.info((Object)"[channelpk_main] PkModuleManager ", (String)"nor mode", (Object[])new Object[0]);
            mountList.addAll(ModuleFactory.INSTANCE.addNorModule());
            unmountList.addAll(ModuleFactory.INSTANCE.removeNorModule());
            this.getCurrentModel().add("1");
        }
        if (M_One.isRankForPkBar()) {
            MLog.info((Object)"[channelpk_main] PkModuleManager ", (String)"rank version1 mode", (Object[])new Object[0]);
            mountList.addAll(ModuleFactory.INSTANCE.addRankVersion1Module());
            unmountList.addAll(ModuleFactory.INSTANCE.removeRankVersion1Module());
            this.getCurrentModel().add("5");
        } else if (M_Two.isRankForPkBar()) {
            MLog.info((Object)"[channelpk_main] PkModuleManager ", (String)"rank version2 mode", (Object[])new Object[0]);
            mountList.addAll(ModuleFactory.INSTANCE.addRankVersion2Module());
            unmountList.addAll(ModuleFactory.INSTANCE.removeRankVersion2Module());
            this.getCurrentModel().add("6");
        }
        if (M_One.isMvp()) {
            MLog.info((Object)"[channelpk_main] PkModuleManager ", (String)"mvp mode", (Object[])new Object[0]);
            mountList.addAll(ModuleFactory.INSTANCE.addMvpModule());
            unmountList.addAll(ModuleFactory.INSTANCE.removeMvpModule());
            this.getCurrentModel().add("3");
        }
        if (M_Two.isRevenge()) {
            MLog.info((Object)"[channelpk_main] PkModuleManager ", (String)"mvp mode", (Object[])new Object[0]);
            mountList.addAll(ModuleFactory.INSTANCE.addRevengeModule());
            unmountList.addAll(ModuleFactory.INSTANCE.removeRevengeModule());
            this.getCurrentModel().add("4");
        }
        for (String module : mountList) {
            PKModule m;
            if (unmountList.contains(module) || (m = (PKModule)this.newInstance(module)) == null) continue;
            this.getModuleMap().put(module, m);
        }
    }

    private Object newInstance(String className) {
        try {
            return Class.forName(className).newInstance();
        }
        catch (Exception e) {
            MLog.error((Object)"[channelpk_main] PkModuleManager ", (String)("module.newInstance :" + className + " " + " [ERROR] " + e.getMessage()), (Object[])new Object[0]);
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void addModel(int model) {
        if (this.activity == null || this.container == null) {
            return;
        }
        if (this.getCurrentModel().contains(model + "")) {
            return;
        }
        ArrayList<String> addModuleList = new ArrayList<String>();
        ArrayList<String> removeModuleList = new ArrayList<String>();
        MLog.info((Object)"[channelpk_main] PkModuleManager ", (String)("add mode :" + model), (Object[])new Object[0]);
        if (model == 4) {
            addModuleList.addAll(ModuleFactory.INSTANCE.addRevengeModule());
            removeModuleList.addAll(ModuleFactory.INSTANCE.removeRevengeModule());
            this.getCurrentModel().add("4");
        }
        this.onDestroy();
        for (String addModule : addModuleList) {
            PKModule m;
            if (this.getModuleMap().get(addModule) != null || (m = (PKModule)this.newInstance(addModule)) == null) continue;
            this.getModuleMap().put(addModule, m);
        }
        for (String removeModule : removeModuleList) {
            if (this.getModuleMap().get(removeModule) == null || !this.getModuleMap().containsKey(removeModule)) continue;
            this.getModuleMap().remove(removeModule);
        }
        this.attach(this.activity);
        this.create(this.container);
    }

    @Override
    public void removeModel(int model) {
        if (this.activity == null || this.container == null) {
            return;
        }
        if (!this.getCurrentModel().contains(model + "")) {
            return;
        }
        ArrayList<String> addModuleList = new ArrayList<String>();
        ArrayList<String> removeModuleList = new ArrayList<String>();
        MLog.info((Object)"[channelpk_main] PkModuleManager ", (String)("remove mode :" + model), (Object[])new Object[0]);
        if (model == 4) {
            addModuleList.addAll(ModuleFactory.INSTANCE.addRevengeModule());
            removeModuleList.addAll(ModuleFactory.INSTANCE.removeRevengeModule());
            this.getCurrentModel().remove("4");
        }
        this.onDestroy();
        for (String addModule : removeModuleList) {
            PKModule m;
            if (this.getModuleMap().get(addModule) != null || (m = (PKModule)this.newInstance(addModule)) == null) continue;
            this.getModuleMap().put(addModule, m);
        }
        for (String removeModule : addModuleList) {
            if (this.getModuleMap().get(removeModule) == null || !this.getModuleMap().containsKey(removeModule)) continue;
            this.getModuleMap().remove(removeModule);
        }
        this.attach(this.activity);
        this.create(this.container);
    }
}

