/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.channelpk.ui.pkrank.ui;

import android.content.Context;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.yy.mobile.channelpk.coremodule.M_One;
import com.yy.mobile.channelpk.coremodule.M_Two;
import com.yy.mobile.channelpk.ui.pkrank.utils.RankLevelUtils;
import com.yy.mobile.memoryrecycle.drawablerecycle.DrawableUtil;
import com.yy.mobile.plugin.pluginunionchannelpk.R;

public class RankLevelWithBgView
extends LinearLayout {
    private View rootView;
    private Context mContext;
    private LinearLayout lyStar;
    private ImageView ivRankLevelNum;
    private RelativeLayout lyRankLevel;
    private LayoutInflater mLayoutInflater;
    private int division;
    private int phase;
    private int starNum;

    public RankLevelWithBgView(Context context) {
        this(context, null);
    }

    public RankLevelWithBgView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public RankLevelWithBgView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mContext = context;
        this.mLayoutInflater = LayoutInflater.from((Context)context);
        this.initRootView();
        this.initView();
    }

    private void initRootView() {
        this.rootView = this.mLayoutInflater.inflate(R.layout.view_pk_rank_level_with_bg, null);
        this.addView(this.rootView);
    }

    private void initView() {
        this.lyRankLevel = (RelativeLayout)this.rootView.findViewById(R.id.ly_rank_level);
        this.ivRankLevelNum = (ImageView)this.rootView.findViewById(R.id.iv_rank_level_num);
        this.lyStar = (LinearLayout)this.rootView.findViewById(R.id.ly_star);
    }

    private void createRankLevelViewWithStar() {
        this.createRankLevelView(RankLevelUtils.getRankLevelWithBgResIdV1(this.division));
        this.createRankLevelStarView();
    }

    private void createRankLevelViewWithGroth() {
        this.createRankLevelView(RankLevelUtils.getRankLevelWithBgResIdV2(this.division));
    }

    private void createRankLevelViewWithRevenge() {
        this.createRankLevelView(RankLevelUtils.getRevengeLevelWithBgResId(this.division));
    }

    private void createRankLevelView(int resId) {
        if (this.division == -1) {
            this.rootView.setVisibility(4);
            return;
        }
        this.rootView.setVisibility(0);
        this.lyRankLevel.setBackgroundResource(resId);
        if (this.phase >= 1 && this.phase <= 4) {
            this.ivRankLevelNum.setVisibility(0);
            this.ivRankLevelNum.setImageDrawable(DrawableUtil.getDrawable((int)RankLevelUtils.getRankLevelNumberResId(this.phase)));
        } else {
            this.ivRankLevelNum.setVisibility(4);
        }
    }

    private void createRankLevelStarView() {
        this.lyStar.removeAllViews();
        if (this.division == 0 || this.division == -1) {
            return;
        }
        if (this.division == 5) {
            ImageView imageView = new ImageView(this.mContext);
            imageView.setImageDrawable(DrawableUtil.getDrawable((int)R.drawable.rank_level_star_0));
            imageView.setPadding(4, 0, 0, 0);
            this.lyStar.addView((View)imageView);
            TextView textView = new TextView(this.mContext);
            textView.setText((CharSequence)("x" + this.starNum));
            textView.setTextSize(10.0f);
            textView.setTextColor(-1);
            this.lyStar.addView((View)textView);
        } else {
            int tempBackGrunp = 0;
            switch (this.division) {
                case 1: {
                    tempBackGrunp = R.drawable.rank_level_star_1;
                    break;
                }
                case 2: {
                    tempBackGrunp = R.drawable.rank_level_star_2;
                    break;
                }
                case 3: {
                    tempBackGrunp = R.drawable.rank_level_star_3;
                    break;
                }
                case 4: {
                    tempBackGrunp = R.drawable.rank_level_star_4;
                    break;
                }
            }
            if (tempBackGrunp == 0) {
                return;
            }
            for (int i = 0; i < 4; ++i) {
                ImageView imageView;
                if (this.starNum >= i + 1) {
                    imageView = new ImageView(this.mContext);
                    imageView.setImageDrawable(DrawableUtil.getDrawable((int)R.drawable.rank_level_star_0));
                    imageView.setPadding(4, 0, 0, 0);
                    this.lyStar.addView((View)imageView);
                    continue;
                }
                imageView = new ImageView(this.mContext);
                imageView.setImageDrawable(DrawableUtil.getDrawable((int)tempBackGrunp));
                imageView.setPadding(4, 0, 0, 0);
                this.lyStar.addView((View)imageView);
            }
        }
    }

    public void setRankLevelData(int division, int phase, int starNum) {
        this.division = division;
        this.phase = phase;
        this.starNum = starNum;
        if (M_One.isRankForDialog()) {
            this.createRankLevelViewWithStar();
        } else if (M_Two.isRankForDialog()) {
            this.createRankLevelViewWithGroth();
        }
    }

    public void setRevengeLevelData(int division, int phase, int starNum) {
        this.division = division;
        this.phase = phase;
        this.starNum = starNum;
        this.createRankLevelViewWithRevenge();
    }
}

