/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.channelpk.ui.pkmvp.ui.ranklist;

import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Typeface;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.bumptech.glide.Glide;
import com.yy.mobile.channelpk.coremodule.model.pkmvp.PkMvpRankListItem;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.image.CircleImageView;
import com.yy.mobile.image.RecycleImageView;
import com.yy.mobile.imageloader.ImageLoader;
import com.yy.mobile.plugin.pluginunionchannelpk.R;
import java.util.ArrayList;
import java.util.List;

public class PkMvpRankListAdapter
extends RecyclerView.Adapter<PkMvpRankListViewHoler> {
    private ArrayList<PkMvpRankListItem> items = new ArrayList();
    private OnItemClickListener mListener;
    private long pkWmvp;
    private long pkTmvp;

    public PkMvpRankListViewHoler onCreateViewHolder(ViewGroup parent, int viewType) {
        View view = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.layout_pk_mvp_ranklist_item, parent, false);
        return new PkMvpRankListViewHoler(view);
    }

    public void onBindViewHolder(PkMvpRankListViewHoler holder, final int position) {
        final PkMvpRankListItem item = this.items.get(position);
        try {
            holder.tvRankNumber.setTypeface(Typeface.createFromAsset((AssetManager)BasicConfig.getInstance().getAppContext().getAssets(), (String)"fonts/DINMittelschrift_Alternate.otf"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (item.getUid() == this.pkTmvp || item.getUid() == this.pkWmvp) {
            holder.tvRankNumber.setText((CharSequence)"");
            holder.tvRankNumber.setBackgroundResource(R.drawable.icon_pk_mvp);
        } else {
            holder.tvRankNumber.setText((CharSequence)String.valueOf(item.getRank()));
            holder.tvRankNumber.setBackgroundResource(0);
        }
        if (holder.ciHead.getContext() != null) {
            Glide.with((Context)holder.ciHead.getContext()).load(item.getHeadUrl()).into((ImageView)holder.ciHead);
        } else {
            ImageLoader.loadImage((RecycleImageView)holder.ciHead, (String)item.getHeadUrl());
        }
        holder.tvNick.setText((CharSequence)item.getNick());
        try {
            holder.tvScore.setTypeface(Typeface.createFromAsset((AssetManager)BasicConfig.getInstance().getAppContext().getAssets(), (String)"fonts/DINMittelschrift_Alternate.otf"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        holder.tvScore.setText((CharSequence)String.valueOf(item.getScore()));
        holder.itemView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (PkMvpRankListAdapter.this.mListener != null) {
                    PkMvpRankListAdapter.this.mListener.onItemClick(position, item.getUid());
                }
            }
        });
    }

    public int getItemCount() {
        return this.items.size();
    }

    public void setData(List<PkMvpRankListItem> data) {
        this.items.clear();
        this.items.addAll(data);
        this.notifyDataSetChanged();
    }

    public void setListener(OnItemClickListener listener) {
        this.mListener = listener;
    }

    public void setMvps(long tMvp, long wMvp) {
        this.pkWmvp = wMvp;
        this.pkTmvp = tMvp;
    }

    public static interface OnItemClickListener {
        public void onItemClick(int var1, long var2);
    }

    public class PkMvpRankListViewHoler
    extends RecyclerView.ViewHolder {
        public TextView tvRankNumber;
        public CircleImageView ciHead;
        public TextView tvNick;
        public TextView tvScore;

        public PkMvpRankListViewHoler(View itemView) {
            super(itemView);
            this.tvRankNumber = (TextView)itemView.findViewById(R.id.tv_rank_num);
            this.ciHead = (CircleImageView)itemView.findViewById(R.id.iv_head);
            this.tvNick = (TextView)itemView.findViewById(R.id.tv_nick_name);
            this.tvScore = (TextView)itemView.findViewById(R.id.tv_score);
        }
    }
}

